/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseObjectEditor;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectDialog
extends AbstractDbRefactoringDialog<DatabaseObjectEditor> {
    private final ObjectKind myKind;
    protected ObjectEditorModel<?> myObjectModel;

    public DbObjectDialog(@NotNull DatabaseEditorContext context, @NotNull ObjectKind kind) {
        if (context == null) {
            DbObjectDialog.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            DbObjectDialog.$$$reportNull$$$0(1);
        }
        super(context);
        if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
            throw new AssertionError((Object)"Invalid kind");
        }
        this.myKind = kind;
        this.setTitle(this.getTitle(this.myRefactoring));
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = (modify ? "Modify " : "Add ") + (this.myKind == null ? "Object" : StringUtil.capitalize((String)this.myKind.code()));
        if (string == null) {
            DbObjectDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setObject(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(3);
        }
        if (object.model != this.myModel || this.myKind != object.getKind()) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.myObjectModel = this.myEditorModelsCache.get(object, ObjectEditorModel.class);
        DatabaseEditorCapabilities.ObjectEditorCaps caps = this.getObjectEditorCaps(!allowEverything && object.editedObject != null, this.myKind);
        if (caps == null) {
            throw new AssertionError((Object)"Unable to edit object");
        }
        this.setEditor(new DatabaseObjectEditor(this.myState, caps, this.myObjectModel));
    }

    @Nullable
    private DatabaseEditorCapabilities.ObjectEditorCaps getObjectEditorCaps(boolean existing, ObjectKind kind) {
        if (kind == ObjectKind.DATABASE) {
            return this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getDatabaseEditorCaps(existing);
        }
        if (kind == ObjectKind.SCHEMA) {
            return this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getSchemaEditorCaps(existing);
        }
        return null;
    }

    @Override
    protected ValidationInfo doValidate() {
        ValidationInfo info = ((DatabaseObjectEditor)this.myEditor).validate();
        return info == null ? super.doValidate() : info;
    }

    @Override
    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @NotNull
    public DeObject createEmptyTemplate(@Nullable DasObject parent, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbObjectDialog.$$$reportNull$$$0(4);
        }
        this.checkObjectInContext(parent);
        if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
            throw new AssertionError((Object)"only database and schema");
        }
        DeNamespace res = new DeNamespace("new_" + kind.code(), kind, this.myModel);
        if (parent != null) {
            res.parent = (DeNamespace)this.export(parent, false);
        }
        if (res.parent != null) {
            res.parent.addLightChild(res);
        } else {
            this.myModel.addRoot(res);
        }
        DeNamespace deNamespace = res;
        if (deNamespace == null) {
            DbObjectDialog.$$$reportNull$$$0(5);
        }
        return deNamespace;
    }

    public void configureForModification(@NotNull DasObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(6);
        }
        this.checkObjectInContext(object);
        this.configureForModification((DeObject)this.export(object, false), allowEverything);
    }

    public void configureForModification(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(7);
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setObject(object, allowEverything);
        this.setRefactoring(true);
    }

    public void configureForCreation(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            DbObjectDialog.$$$reportNull$$$0(8);
        }
        this.setObject(object, allowEverything);
    }

    @Nullable
    protected String getHelpId() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbObjectDialog";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbObjectDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setObject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTemplate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureForModification";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureForCreation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

