/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.editors.ObjectEditorWithPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDbRefactoringDialog<Ed extends DatabaseEditorBaseEx>
extends RefactoringDialog
implements ResultProcessorProvider {
    protected Ed myEditor;
    protected final ObjectEditorWithPreview myEditorPreview;
    protected final DatabaseEditorState myState;
    protected final EditorModelsCache myEditorModelsCache;
    protected final DeModel myModel;
    protected final MyOkAction myNewOkAction;
    protected final ErrorNotificationWrapperPanel myErrorPanel;
    @Nullable
    private ResultProcessor myProcessor;
    protected boolean myRefactoring;
    private final JPanel myCentralPanel;

    @NotNull
    public DatabaseEditorState getState() {
        DatabaseEditorState databaseEditorState = this.myState;
        if (databaseEditorState == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(0);
        }
        return databaseEditorState;
    }

    public AbstractDbRefactoringDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(1);
        }
        super((Project)ObjectUtils.assertNotNull((Object)context.getProject()), true);
        SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(SqlCodeStyleSettings.class);
        if (settings == null) {
            settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)context.getProject()));
        }
        this.myEditorModelsCache = new EditorModelsCache(settings);
        this.setModal(true);
        this.myModel = AbstractDbRefactoringDialog.createModel(context);
        this.myState = new DatabaseEditorState(context);
        this.myEditorPreview = new ObjectEditorWithPreview();
        this.myEditorPreview.subscribePreviewChanged(new ObjectEditorWithPreview.PreviewListener(){

            @Override
            public void changed() {
                AbstractDbRefactoringDialog.this.updateActions();
            }
        });
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.myErrorPanel = new ErrorNotificationWrapperPanel();
        this.myErrorPanel.add((Component)this.myEditorPreview.getComponent(), "Center");
        this.myCentralPanel.add((Component)this.myErrorPanel, "Center");
        this.myNewOkAction = new MyOkAction();
        this.setRefactoring(false);
        this.setResultProcessor(new GenericEditingResultProcessor(this, DbRefactoringHelper.DB_SETTINGS, null));
    }

    public void doCancelAction() {
        if (this.userCancelledCancel()) {
            return;
        }
        super.doCancelAction();
    }

    private boolean userCancelledCancel() {
        boolean confirmLoss = DatabaseSettings.getSettings().ddlConfirmLoss;
        return this.isModified() && confirmLoss && Messages.showOkCancelDialog((Project)this.myProject, (String)"You're about to lose your changes", (String)"Warning", (String)Messages.OK_BUTTON, (String)Messages.CANCEL_BUTTON, (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                DatabaseSettings.getSettings().ddlConfirmLoss = !isSelected;
                DatabaseSettings.fireSettingsChanged();
            }
        }) != 0;
    }

    private boolean isModified() {
        return !this.myEditorPreview.isInvalid() && StringUtil.isNotEmpty((String)this.myEditorPreview.getStatement());
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(2);
        }
        return deModel;
    }

    @NotNull
    protected abstract String getTitle(boolean var1);

    public void finish() {
        this.myEditorPreview.updatePreview();
        this.init();
    }

    public void finishAndShow() {
        this.finish();
        this.show();
    }

    public void setRefactoring(boolean refactoring) {
        this.myRefactoring = refactoring;
        this.setTitle(this.getTitle(refactoring));
    }

    public void setResultProcessor(@NotNull ResultProcessor proc) {
        if (proc == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(3);
        }
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myProcessor = proc;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        if (databaseEditorContext == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(4);
        }
        return databaseEditorContext;
    }

    protected void setEditor(@NotNull Ed editor) {
        JComponent settings;
        if (editor == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(5);
        }
        if (this.myEditor != null) {
            throw new AssertionError((Object)"Editor is already set");
        }
        if (this.myProcessor == null) {
            throw new AssertionError((Object)"Result processor must be set before editor");
        }
        this.myEditor = editor;
        Disposer.register((Disposable)this.getDisposable(), editor);
        this.myEditorPreview.setTrailWidget(this.myProcessor.getPreviewWidget());
        JComponent jComponent = settings = this.myProcessor == null ? null : this.myProcessor.getSettingsPanel();
        if (settings != null) {
            this.myCentralPanel.add((Component)settings, "South");
        }
        this.myEditorPreview.setEditor((DatabaseEditorBaseEx)editor, this.myProcessor.createTraverser(((DatabaseEditorBase)editor).getModel()));
        this.setTitle(this.getTitle(this.myRefactoring));
    }

    @Override
    public void settingsChanged() {
        this.myEditorPreview.updatePreview();
    }

    public boolean isValid() {
        return ((DatabaseEditorBase)this.myEditor).areEditorsValid();
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        if (!this.myRefactoring) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                AbstractDbRefactoringDialog.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        JBIterable<Pair<PsiElement, String>> jBIterable = DbRenamePsiElementProcessor.collectRenameElements(this.myModel, this.getContext().getDataSource());
        if (jBIterable == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.getContext().getProject();
    }

    @NotNull
    public static DeModel createModel(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(8);
        }
        SchemaExportHelper helper = context.getDialect().getSchemaEditor().createExportHelper(context, context.getModel());
        helper = context.getDialect().getSchemaEditor().createExportHelper(context, helper.getModel());
        DeModel deModel = helper.getModel();
        if (deModel == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(9);
        }
        return deModel;
    }

    protected boolean hasPreviewButton() {
        return this.myRefactoring;
    }

    @NotNull
    public <De extends DeObject> De export(@NotNull DasObject obj, boolean withChildren) {
        if (obj == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(10);
        }
        Object De = this.myModel.getExportHelper().exportDeep(this.getContext().getModel(), obj, withChildren);
        if (De == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(11);
        }
        return De;
    }

    @Contract(value="!null, _ -> !null")
    public <De extends DeObject> De exportOp(@Nullable DasObject obj, boolean withChildren) {
        return obj == null ? null : (De)this.export(obj, withChildren);
    }

    @NotNull
    protected <De extends DeObject> De copyExport(@NotNull De obj, boolean withChildren) {
        if (obj == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(12);
        }
        De De = DeObject.copy(obj, withChildren, DeObject.DeCopier.exportExisting(this.myModel, this.getContext().getModel()));
        if (De == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(13);
        }
        return De;
    }

    @NotNull
    protected Action[] createActions() {
        Object[] actions = super.createActions();
        int i2 = ArrayUtil.indexOf((Object[])actions, (Object)this.getRefactorAction());
        assert (i2 != -1);
        actions[i2] = this.getOKAction();
        if (actions == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(14);
        }
        return actions;
    }

    protected void updateActions() {
        boolean valid = this.isRefactoringValid();
        this.setOKActionEnabled(valid);
        this.getPreviewAction().setEnabled(valid && !this.collectRenames().isEmpty());
        this.myNewOkAction.updateText();
        if (this.myProcessor != null) {
            this.myProcessor.update();
        }
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.getOKAction().setEnabled(isEnabled);
    }

    @NotNull
    protected Action getOKAction() {
        MyOkAction myOkAction = this.myNewOkAction;
        if (myOkAction == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(15);
        }
        return myOkAction;
    }

    protected boolean isRefactoringValid() {
        return !this.myEditorPreview.isInvalid() && !StringUtil.isEmptyOrSpaces((String)this.statement());
    }

    protected void doAction() {
        this.processDoNotAskOnOk(0);
        if (this.myProcessor != null && this.getOKAction().isEnabled() && !this.myProcessor.process()) {
            this.error("Failed to process");
        }
    }

    @Override
    public void error(@NotNull String message) {
        if (message == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(16);
        }
        this.myErrorPanel.reportError(message);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return AbstractDbRefactoringDialog.class.getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCentralPanel;
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myEditorPreview.getStatement();
        if (string == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPreview.getPreferredFocusedComponent();
    }

    protected void checkObjectInContext(@Nullable DasObject object) {
        DasObject o = DbUtil.getDasObject((Object)object);
        if (object != null && ((JBTreeTraverser)this.getContext().getModel().traverser().filter(Conditions.is((Object)o))).bfsTraversal().first() == null) {
            throw new AssertionError((Object)("Object " + object.getName() + " " + object.getClass().getName() + " " + object + " not in context"));
        }
    }

    @Override
    public void success() {
        this.close(0);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info = super.doValidate();
        if (info != null || this.myProcessor == null) {
            return info;
        }
        return this.myProcessor.validate();
    }

    @NotNull
    public Ed getEditor() {
        Ed Ed = this.myEditor;
        if (Ed == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(18);
        }
        return Ed;
    }

    @NotNull
    public ResultProcessor getProcessor() {
        ResultProcessor resultProcessor = (ResultProcessor)ObjectUtils.assertNotNull((Object)this.myProcessor);
        if (resultProcessor == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(19);
        }
        return resultProcessor;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        Ed Ed = this.myEditor;
        if (Ed == null) {
            AbstractDbRefactoringDialog.$$$reportNull$$$0(20);
        }
        return Ed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/AbstractDbRefactoringDialog";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/AbstractDbRefactoringDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "export";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyExport";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "statement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setResultProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyExport";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyOkAction
    extends DialogWrapper.OkAction {
        private MyOkAction() {
            super((DialogWrapper)AbstractDbRefactoringDialog.this);
        }

        public void updateText() {
            this.putValue("Name", AbstractDbRefactoringDialog.this.myProcessor == null ? "OK" : AbstractDbRefactoringDialog.this.myProcessor.getCurrentAction());
        }

        public boolean isEnabled() {
            return super.isEnabled() && AbstractDbRefactoringDialog.this.isRefactoringValid();
        }

        protected void doAction(ActionEvent e) {
            AbstractDbRefactoringDialog.this.setPreviewResults(false);
            super.doAction(e);
        }
    }

    public static interface ResultProcessor {
        @Nullable
        public JComponent getPreviewWidget();

        public boolean process();

        @NotNull
        public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase var1);

        @Nullable
        public JComponent getSettingsPanel();

        public String getCurrentAction();

        public void update();

        public ValidationInfo validate();
    }
}

