/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EditorModelsCache {
    public final SqlCodeStyleSettings settings;
    private final Map<DasObject, ObjectEditorModel<?>> myModels;

    public EditorModelsCache(@NotNull SqlCodeStyleSettings settings) {
        if (settings == null) {
            EditorModelsCache.$$$reportNull$$$0(0);
        }
        this.myModels = ContainerUtil.createWeakValueMap();
        this.settings = settings;
    }

    @NotNull
    private <M extends ObjectEditorModel> M create(@NotNull DeObject obj, @NotNull Class<? extends M> clazz) {
        ObjectEditorModel objectEditorModel;
        if (obj == null) {
            EditorModelsCache.$$$reportNull$$$0(1);
        }
        if (clazz == null) {
            EditorModelsCache.$$$reportNull$$$0(2);
        }
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            assert (constructors.length == 1);
            objectEditorModel = (ObjectEditorModel)clazz.cast(constructors[0].newInstance(obj, this));
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.rethrowUnchecked((Throwable)e);
            throw new AssertionError((Object)"Unreachable");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error instantiating editor " + clazz.getCanonicalName() + " for " + obj.getClass().getCanonicalName(), e);
        }
        if (objectEditorModel == null) {
            EditorModelsCache.$$$reportNull$$$0(3);
        }
        return (M)objectEditorModel;
    }

    public <M extends ObjectEditorModel> M get(@NotNull DeObject obj, @NotNull Class<? extends M> clazz) {
        ObjectEditorModel<?> model;
        if (obj == null) {
            EditorModelsCache.$$$reportNull$$$0(4);
        }
        if (clazz == null) {
            EditorModelsCache.$$$reportNull$$$0(5);
        }
        if ((model = this.myModels.get(obj)) != null) {
            return (M)((ObjectEditorModel)clazz.cast(model));
        }
        M res = this.create(obj, clazz);
        this.myModels.put(obj, (ObjectEditorModel<?>)res);
        return res;
    }

    @NotNull
    public Iterable<ObjectEditorModel<?>> getModels() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myModels.values());
        if (arrayList == null) {
            EditorModelsCache.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/EditorModelsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/EditorModelsCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

