/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectEditor
extends DatabaseEditorBaseEx {
    private JTextField myNameField;
    private JPanel myPanel;
    private final ObjectEditorModel<?> myObjectModel;
    private final DatabaseEditorCapabilities.ObjectEditorCaps myCaps;
    private final EditorModelBase.Listener myChangeListener;

    public DatabaseObjectEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.ObjectEditorCaps caps, @NotNull ObjectEditorModel<?> model) {
        if (state == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(1);
        }
        if (model == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(2);
        }
        super(state);
        this.myChangeListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseObjectEditor.this.fromModelToUi();
            }
        };
        this.myObjectModel = model;
        this.myCaps = caps;
        this.$$$setupUI$$$();
        this.applyCaps();
        this.setupControls();
    }

    private void applyCaps() {
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    @Override
    @NotNull
    public ObjectEditorModel<?> getModel() {
        ObjectEditorModel<?> objectEditorModel = this.myObjectModel;
        if (objectEditorModel == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(3);
        }
        return objectEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseObjectEditor.setValue(this.myNameField, this.myObjectModel.getName());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    private void initSubscriptions() {
        this.myObjectModel.addListener(this.myChangeListener, this);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!DatabaseObjectEditor.this.myUpdating) {
                    DatabaseObjectEditor.this.myObjectModel.setName(DatabaseObjectEditor.this.myNameField.getText());
                    DatabaseObjectEditor.this.myObjectModel.commit();
                }
            }
        });
    }

    @Nullable
    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.myObjectModel.getName())) {
            return new ValidationInfo("'" + this.myObjectModel.getName() + "' is not a valid " + this.myObjectModel.getObject().getKind().code() + " name", (JComponent)this.myNameField);
        }
        return null;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(6);
        }
        return jTextField;
    }

    @NotNull
    public DatabaseEditorCapabilities.ObjectEditorCaps getCaps() {
        DatabaseEditorCapabilities.ObjectEditorCaps objectEditorCaps = this.myCaps;
        if (objectEditorCaps == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(7);
        }
        return objectEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseObjectEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseObjectEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBTextField jBTextField = new JBTextField();
        this.myNameField = jBTextField;
        jPanel.add((Component)jBTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

