/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingOption;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingSingleModelTaskBuilder;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

public class DropQueryGenerator {
    private final BasicModel myModel;
    private final CustomScriptingOptions myOptions;
    private Set<BasicElement> myItems;
    private BasicNamespace myCurrentNamespace;

    public static boolean canDeleteAnything(@NotNull BasicModel model, @NotNull Iterable<BasicElement> elements) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            DropQueryGenerator.$$$reportNull$$$0(1);
        }
        ScriptingFactory sf = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        return !JBIterable.from(elements).filter(e -> {
            if (model == null) {
                DropQueryGenerator.$$$reportNull$$$0(12);
            }
            return DropQueryGenerator.canDelete(sf, model, e);
        }).isEmpty();
    }

    private static boolean canDelete(@NotNull ScriptingFactory sf, @NotNull BasicModel model, @NotNull BasicElement element) {
        if (sf == null) {
            DropQueryGenerator.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DropQueryGenerator.$$$reportNull$$$0(4);
        }
        return sf.getScriptingService(model.getRdbms()).capabilities(element).getDrop().get(model.getRoot().getServerVersion());
    }

    public static boolean canDelete(@NotNull BasicModel model, @NotNull BasicElement element) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(5);
        }
        if (element == null) {
            DropQueryGenerator.$$$reportNull$$$0(6);
        }
        return DropQueryGenerator.canDelete((ScriptingFactory)ServiceManager.getService(ScriptingFactory.class), model, element);
    }

    public DropQueryGenerator(@NotNull BasicModel model) {
        if (model == null) {
            DropQueryGenerator.$$$reportNull$$$0(7);
        }
        this.myOptions = new CustomScriptingOptions(ContainerUtil.newHashMap());
        this.myItems = Collections.emptySet();
        this.myModel = model;
    }

    public void setItems(@NotNull Iterable<BasicElement> items) {
        if (items == null) {
            DropQueryGenerator.$$$reportNull$$$0(8);
        }
        this.myItems = JBIterable.from(items).filter(e -> e.getModel() == this.myModel).toSet();
    }

    public void setCurrentNamespace(@Nullable BasicNamespace currentNamespace) {
        this.myCurrentNamespace = currentNamespace;
    }

    @NotNull
    public Map<ScriptingOption<?>, Object> getOptions() {
        Map<ScriptingOption<?>, Object> map = this.myOptions.getOptions();
        if (map == null) {
            DropQueryGenerator.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public ScriptingResult generate() {
        ScriptingResult scriptingResult = this.generate(this.myModel.getRoot().getServerVersion());
        if (scriptingResult == null) {
            DropQueryGenerator.$$$reportNull$$$0(10);
        }
        return scriptingResult;
    }

    @NotNull
    public ScriptingResult generate(@Nullable Version version) {
        ScriptingFactory sf = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        ScriptingService service = sf.getScriptingService(this.myModel.getRdbms());
        ScriptingSingleModelTaskBuilder task = new ScriptingSingleModelTaskBuilder(this.myModel, ScriptCategory.DROP_COMPLETE);
        task.getElements().addAll(this.myItems);
        task.setCurrentNamespace(this.myCurrentNamespace);
        task.setOptions(this.myOptions);
        if (version != null) {
            task.setVersion(version);
        }
        ScriptingResult scriptingResult = service.makeScript(task.build());
        if (scriptingResult == null) {
            DropQueryGenerator.$$$reportNull$$$0(11);
        }
        return scriptingResult;
    }

    public void fillNamespacesToRemove(List<Pair<ObjectName, ObjectName>> toRemove) {
        for (BasicElement namespace : this.myItems) {
            ObjectKind kind = namespace.getKind();
            if (kind == ObjectKind.DATABASE) {
                toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)namespace.getName()), null));
                continue;
            }
            if (kind != ObjectKind.SCHEMA) continue;
            BasicElement parent = namespace.getDasParent();
            if (parent != null && parent.getKind() != ObjectKind.DATABASE) {
                parent = null;
            }
            toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)(parent == null ? null : parent.getName())), (Object)ObjectName.quoted((String)namespace.getName())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sf";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DropQueryGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DropQueryGenerator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteAnything";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canDelete";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canDeleteAnything$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

