/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class AbstractDatabaseModifier {
    @Nullable
    private final LocalDataSource myLocalDataSource;
    @NotNull
    protected DbDataSource myDataSource;
    @NotNull
    private final LoaderContext myContext;
    @NotNull
    private final String myTitle;
    @Nullable
    private final SearchPath mySearchPath;
    private final ErrorHandler myErrorHandler;

    protected AbstractDatabaseModifier(@NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull String title) {
        if (dataSource == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(0);
        }
        if (title == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(1);
        }
        this.myErrorHandler = new ErrorHandler();
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        this.myTitle = title;
        DatabaseSystem delegate = dataSource.getDelegate();
        this.myLocalDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)delegate, LocalDataSource.class);
        this.myContext = new LoaderContext(dataSource.getProject(), this.myLocalDataSource == null ? new LocalDataSource() : this.myLocalDataSource);
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(2);
        }
        return dbDataSource;
    }

    @NotNull
    public LoaderContext getContext() {
        LoaderContext loaderContext = this.myContext;
        if (loaderContext == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(3);
        }
        return loaderContext;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(4);
        }
        return errorHandler;
    }

    @NotNull
    public CompletionStage<Void> runStatements(boolean nonModalSync) {
        if (this.myLocalDataSource == null) {
            CompletableFuture<Void> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator == null) {
            ProgressIndicatorEx backgroundIndicator = AsyncUtil.createBackgroundIndicator(this.myDataSource.getProject(), this.myTitle);
            CompletionStage<Void> completionStage = AsyncUtil.runTask(() -> this.runStatementsInner(nonModalSync, (ProgressIndicator)backgroundIndicator), backgroundIndicator);
            if (completionStage == null) {
                AbstractDatabaseModifier.$$$reportNull$$$0(6);
            }
            return completionStage;
        }
        CompletionStage<Void> completionStage = this.runStatementsInner(nonModalSync, indicator);
        if (completionStage == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(7);
        }
        return completionStage;
    }

    @NotNull
    protected CompletionStage<Void> runStatementsInner(boolean nonModalSync, ProgressIndicator indicator) {
        CompletionStage<Void> completionStage;
        Project project = this.myDataSource.getProject();
        DataRequest.OwnerEx owner = DataRequest.newOwnerEx(this.myDataSource.getProject());
        try {
            JdbcEngine engine = new JdbcEngine(this.myDataSource.getProject(), DataBus.shortCircuit(owner.getMessageBus()), this.myContext.getDataSource(), null, true);
            Disposer.register((Disposable)owner, (Disposable)engine);
            owner.getMessageBus().addAuditor(new DataAuditor.Adapter(){

                @Override
                public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th1) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AbstractDatabaseModifier.this.myErrorHandler.addError(message, th1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/AbstractDatabaseModifier$1", "error"));
                }
            });
            completionStage = this.scheduleRequests(indicator, owner, engine).handleAsync((r, th) -> {
                Disposer.dispose((Disposable)owner);
                if (nonModalSync) {
                    ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.NON_MODAL);
                } else {
                    AsyncUtil.underProgress(this::runSync, indicator);
                }
                if (!this.myErrorHandler.getSummary().isEmpty()) {
                    DataSourceUiUtil.showNotification(project, "", this.myErrorHandler.getSummary(), true);
                }
                if (th != null || this.myErrorHandler.hasErrors()) {
                    throw new ProcessCanceledException();
                }
                return r;
            }, AsyncUtil.EDT_EXECUTOR);
        }
        catch (Throwable th2) {
            Disposer.dispose((Disposable)owner);
            throw th2;
        }
        if (completionStage == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    @NotNull
    private static CompletionStage<Void> wrap(@NotNull Promise<Void> res) {
        if (res == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(9);
        }
        CompletableFuture<Void> result2 = new CompletableFuture<Void>();
        res.done(x -> result2.complete((Void)x));
        res.rejected(x -> result2.completeExceptionally((Throwable)x));
        CompletableFuture<Void> completableFuture = result2;
        if (completableFuture == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    @NotNull
    public CompletionStage<Void> scheduleRequests(@NotNull ProgressIndicator indicator, @NotNull DataRequest.OwnerEx owner, @NotNull JdbcEngine engine) {
        Promise res;
        if (indicator == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(11);
        }
        if (owner == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(12);
        }
        if (engine == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(13);
        }
        if (this.mySearchPath == null) {
            res = this.getExecutor().execute(indicator, owner, engine, this.myErrorHandler);
        } else {
            DataRequest request = DataRequest.newSchemaSwitchRequest(owner, this.mySearchPath, false);
            res = request.getPromise().thenAsync(x -> {
                if (indicator == null) {
                    AbstractDatabaseModifier.$$$reportNull$$$0(15);
                }
                if (owner == null) {
                    AbstractDatabaseModifier.$$$reportNull$$$0(16);
                }
                if (engine == null) {
                    AbstractDatabaseModifier.$$$reportNull$$$0(17);
                }
                return (Promise)AsyncUtil.underProgress(() -> {
                    if (indicator == null) {
                        AbstractDatabaseModifier.$$$reportNull$$$0(18);
                    }
                    if (owner == null) {
                        AbstractDatabaseModifier.$$$reportNull$$$0(19);
                    }
                    if (engine == null) {
                        AbstractDatabaseModifier.$$$reportNull$$$0(20);
                    }
                    return this.getExecutor().execute(indicator, owner, engine, this.myErrorHandler);
                }, indicator);
            });
            engine.processRequest(request);
        }
        CompletionStage<Void> completionStage = AbstractDatabaseModifier.wrap(res);
        if (completionStage == null) {
            AbstractDatabaseModifier.$$$reportNull$$$0(14);
        }
        return completionStage;
    }

    public void runSync() {
        Project project = this.myDataSource.getProject();
        DataSourceUiUtil.performManualSyncTask(this.myContext).whenCompleteAsync((r, e) -> {
            DatabaseView view = DatabaseView.getDatabaseView(project);
            view.selectElement(this.getElement());
        }, AsyncUtil.EDT_EXECUTOR);
    }

    @Nullable
    private DbElement getElement() {
        DasObject info = AbstractDatabaseModifier.getDasObject(this.myContext.getElementToFocus());
        return info == null ? null : DbSqlUtil.findElement(this.myDataSource, ObjectPaths.of(info));
    }

    @Nullable
    private static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DasSchemaChild ? (DasObject)object : (object instanceof DasColumn ? ((DasColumn)object).getTable() : (object instanceof DasTableKey ? ((DasTableKey)object).getTable() : null));
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/AbstractDatabaseModifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runStatementsInner";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRequests";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleRequests$6";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface QueryExecutor {
        public Promise<Void> execute(@NotNull ProgressIndicator var1, @NotNull DataRequest.OwnerEx var2, @NotNull DataProducer var3, @NotNull ErrorHandler var4);
    }
}

