/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableWithText;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DbTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(1);
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode> selected, String dataName) {
        if (selected == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(3);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataName)) {
            List result2 = JBIterable.from(selected).filter(PsiFileNode.class).filterMap(AbstractTreeNode::getValue).filterMap(it -> {
                final Project project = it.getProject();
                final VirtualFile vFile = it.getVirtualFile();
                final FileType fileType = vFile.getFileType();
                if (!(fileType instanceof DbStorageFileType)) {
                    return null;
                }
                return new NavigatableWithText(){

                    public String getNavigateActionText(boolean focusEditor) {
                        return "Open " + ((DbStorageFileType)fileType).getDatabaseName() + " database";
                    }

                    public void navigate(boolean requestFocus) {
                        DbTreeStructureProvider.navigateToDataSource(project, vFile);
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public boolean canNavigateToSource() {
                        return true;
                    }
                };
            }).toList();
            return result2.isEmpty() ? null : result2.toArray(new Navigatable[0]);
        }
        return null;
    }

    private static void navigateToDataSource(@NotNull Project project, @NotNull VirtualFile file) {
        ArrayList toSelect;
        Promise<?> promise;
        DbPsiFacade facade;
        DbDataSource existing;
        if (project == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            DbTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if ((existing = DbTreeStructureProvider.findDataSourceByFile(facade = DbPsiFacade.getInstance((Project)project), file)) != null) {
            promise = Promises.resolvedPromise();
            toSelect = Collections.singletonList(existing);
        } else {
            promise = DataSourceUiUtil.promiseFacadeUpdate(facade, null);
            toSelect = ContainerUtil.newArrayList();
            for (DbPsiManager manager : facade.getDbManagers()) {
                for (DatabaseSystem system : manager.createDataSourceByFiles(Collections.singletonList(file))) {
                    ContainerUtil.addIfNotNull((Collection)toSelect, (Object)facade.findDataSource(system.getUniqueId()));
                }
            }
        }
        if (DatabaseSettings.getSettings().navigateToSchema) {
            promise.processed(o -> {
                if (project == null) {
                    DbTreeStructureProvider.$$$reportNull$$$0(6);
                }
                DatabaseView.select(project, true, toSelect);
            });
        } else {
            for (DbDataSource o2 : toSelect) {
                PsiElement element = TargetElementUtil.getInstance().getGotoDeclarationTarget((PsiElement)o2, (PsiElement)o2);
                Navigatable navigatable = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)element);
                if (navigatable == null || !navigatable.canNavigate()) continue;
                navigatable.navigate(true);
            }
        }
    }

    @Nullable
    private static DbDataSource findDataSourceByFile(DbPsiFacade facade, VirtualFile file) {
        for (DbDataSource element : facade.getDataSources()) {
            JdbcUrlParser parser;
            DatabaseDriver driver;
            LocalDataSource dataSource;
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof LocalDataSource) || StringUtil.isEmptyOrSpaces((String)(dataSource = (LocalDataSource)delegate).getUrl()) || (driver = dataSource.getDatabaseDriver()) == null || (parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), dataSource.getUrl(), StatelessJdbcUrlParser.LocationType.FILE))) == null) continue;
            parser.setUrlText(dataSource.getUrl());
            String dbFile = parser.getParameter("file");
            if (dbFile == null || !dbFile.endsWith(file.getPath())) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DbTreeStructureProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DbTreeStructureProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$navigateToDataSource$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

