/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.hsql;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class HsqlDefinitionProvider
extends DefinitionProviderImpl {
    public static final HsqlDefinitionProvider INSTANCE = new HsqlDefinitionProvider();
    private static final String ROUTINE_STMT = "SELECT ROUTINE_DEFINITION FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA=? AND ROUTINE_NAME=?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.ROUTINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            HsqlDefinitionProvider.$$$reportNull$$$0(3);
        }
        PreparedStatement routineStmt = null;
        try {
            for (DasObject dasObject : objects) {
                ObjectKind kind = dasObject.getKind();
                if (kind != ObjectKind.ROUTINE) continue;
                PreparedStatement statement = routineStmt == null ? connection.prepareStatement(ROUTINE_STMT) : routineStmt;
                statement.setString(1, DasUtil.getSchema((DasObject)dasObject));
                statement.setString(2, dasObject.getName());
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
        finally {
            JdbcUtil.closeStatementSafe(routineStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/hsql/HsqlDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

