/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrospectionScopeUpdater {
    private final Set<Pair<ObjectName, ObjectName>> mySchemasToRemove = ContainerUtil.newLinkedHashSet();
    private final Set<Pair<ObjectName, ObjectName>> mySchemasToAdd = ContainerUtil.newLinkedHashSet();

    public IntrospectionScopeUpdater addAll(IntrospectionScopeUpdater other) {
        this.mySchemasToRemove.addAll(other.mySchemasToRemove);
        this.mySchemasToAdd.addAll(other.mySchemasToAdd);
        return this;
    }

    public IntrospectionScopeUpdater toRemove(@Nullable ObjectName db, @Nullable ObjectName sc) {
        if (db != null || sc != null) {
            this.mySchemasToRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)db, (Object)sc));
        }
        return this;
    }

    public IntrospectionScopeUpdater toAdd(@Nullable ObjectName db, @Nullable ObjectName sc) {
        if (db != null || sc != null) {
            this.mySchemasToAdd.add((Pair<ObjectName, ObjectName>)Pair.create((Object)db, (Object)sc));
        }
        return this;
    }

    @NotNull
    public IntrospectionScope updateVisibleNamespaces(@NotNull IntrospectionScope introspectionScope, @NotNull BasicModel model) {
        if (introspectionScope == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(0);
        }
        if (model == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(1);
        }
        if (this.mySchemasToRemove.isEmpty() && this.mySchemasToAdd.isEmpty()) {
            IntrospectionScope introspectionScope2 = introspectionScope;
            if (introspectionScope2 == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(2);
            }
            return introspectionScope2;
        }
        HashSet toCheck = ContainerUtil.newHashSet(this.mySchemasToRemove);
        toCheck.addAll(this.mySchemasToAdd);
        HashMap matches2 = ContainerUtil.newHashMap();
        BasicRoot root2 = model.getRoot();
        if (root2 instanceof BasicSingleDatabaseRoot) {
            IntrospectionScopeUpdater.processSchemas((BasicSingleDatabaseRoot)root2, null, toCheck, matches2);
        } else if (root2 instanceof BasicMultiDatabaseRoot) {
            IntrospectionScopeUpdater.processDatabases((BasicMultiDatabaseRoot)root2, toCheck, matches2);
        }
        HashSet toAdd = ContainerUtil.newHashSet((Iterable)JBIterable.from(this.mySchemasToAdd).transform(matches2::get).filter(Conditions.notNull()));
        LinkedHashSet toRemove = ContainerUtil.newLinkedHashSet(this.mySchemasToRemove);
        toRemove.retainAll(toCheck);
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            IntrospectionScope introspectionScope3 = introspectionScope;
            if (introspectionScope3 == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(3);
            }
            return introspectionScope3;
        }
        MultiMap<String, String> map = introspectionScope.to((MultiMap<String, String>)MultiMap.createLinked());
        IntrospectionScopeUpdater.processRemove(map, toRemove);
        IntrospectionScopeUpdater.processAdd(map, toAdd);
        IntrospectionScope introspectionScope4 = IntrospectionScopes.collapse(map);
        if (introspectionScope4 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(4);
        }
        return introspectionScope4;
    }

    public void merge(@NotNull IntrospectionScopeUpdater updater) {
        if (updater == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(5);
        }
        this.mySchemasToAdd.addAll(updater.mySchemasToAdd);
        this.mySchemasToRemove.addAll(updater.mySchemasToRemove);
    }

    private static void processAdd(MultiMap<String, String> map, Set<Pair<ObjectName, ObjectName>> toAdd) {
        for (Pair<ObjectName, ObjectName> p : toAdd) {
            Collection all;
            if (p.first != null && ((all = map.get((Object)"*")).contains("*") || p.second != null && all.contains(((ObjectName)p.second).name))) continue;
            Collection schemas = map.getModifiable((Object)(p.first == null ? "*" : ((ObjectName)p.first).name));
            if (p.second == null) continue;
            schemas.add(((ObjectName)p.second).name);
        }
    }

    private static void processRemove(MultiMap<String, String> map, Set<Pair<ObjectName, ObjectName>> toRemove) {
        for (Pair<ObjectName, ObjectName> p : toRemove) {
            if (p.second == null) {
                if (p.first == null) {
                    map.remove((Object)"*");
                    continue;
                }
                map.entrySet().removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(((ObjectName)p.first).name));
                continue;
            }
            if (p.first == null) {
                Collection schs = map.get((Object)"*");
                if (schs.isEmpty()) continue;
                schs.removeIf(s -> s.equalsIgnoreCase(((ObjectName)p.second).name));
                continue;
            }
            for (Map.Entry e2 : map.entrySet()) {
                if (!((String)e2.getKey()).equalsIgnoreCase(((ObjectName)p.first).name)) continue;
                ((Collection)e2.getValue()).removeIf(s -> s.equalsIgnoreCase(((ObjectName)p.second).name));
            }
        }
    }

    private static void processSchemas(@NotNull BasicDatabase root2, @Nullable ObjectName db, @NotNull Set<Pair<ObjectName, ObjectName>> toCheck, @NotNull Map<Pair<ObjectName, ObjectName>, Pair<ObjectName, ObjectName>> matches2) {
        if (root2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(6);
        }
        if (toCheck == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(7);
        }
        if (matches2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(8);
        }
        for (BasicSchema basicSchema : root2.getSchemas()) {
            IntrospectionScopeUpdater.processSchema(db, ObjectName.quoted((String)basicSchema.getName()), toCheck, matches2, root2.getCasing(ObjectKind.SCHEMA, basicSchema));
        }
    }

    private static void processSchema(@Nullable ObjectName db, @Nullable ObjectName sc, @NotNull Set<Pair<ObjectName, ObjectName>> toCheck, @NotNull Map<Pair<ObjectName, ObjectName>, Pair<ObjectName, ObjectName>> matches2, @NotNull Casing casing) {
        if (toCheck == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(9);
        }
        if (matches2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(10);
        }
        if (casing == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(11);
        }
        toCheck.removeIf(p -> {
            boolean res;
            if (casing == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(17);
            }
            if (matches2 == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(18);
            }
            if (res = IntrospectionScopeUpdater.matches(db, sc, (Pair<ObjectName, ObjectName>)p, casing)) {
                matches2.put((Pair<ObjectName, ObjectName>)p, (Pair<ObjectName, ObjectName>)Pair.create((Object)db, (Object)sc));
            }
            return res;
        });
    }

    private static boolean matches(@Nullable ObjectName db, @Nullable ObjectName sc, @NotNull Pair<ObjectName, ObjectName> p, @NotNull Casing casing) {
        if (p == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(12);
        }
        if (casing == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(13);
        }
        boolean dbEq = db == null || ObjectName.equals((ObjectName)((ObjectName)p.first), (ObjectName)db, (Casing)casing);
        return dbEq && ObjectName.equals((ObjectName)((ObjectName)p.second), (ObjectName)sc, (Casing)casing);
    }

    private static void processDatabases(@NotNull BasicMultiDatabaseRoot root2, @NotNull Set<Pair<ObjectName, ObjectName>> toCheck, @NotNull Map<Pair<ObjectName, ObjectName>, Pair<ObjectName, ObjectName>> matches2) {
        if (root2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(14);
        }
        if (toCheck == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(15);
        }
        if (matches2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(16);
        }
        for (BasicDatabase basicDatabase : root2.getDatabases()) {
            ObjectName dbName = ObjectName.quoted((String)basicDatabase.getName());
            IntrospectionScopeUpdater.processSchema(dbName, null, toCheck, matches2, root2.getCasing(ObjectKind.DATABASE, basicDatabase));
            IntrospectionScopeUpdater.processSchemas(basicDatabase, dbName, toCheck, matches2);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntrospectionScopeUpdater updater = (IntrospectionScopeUpdater)o;
        if (!this.mySchemasToRemove.equals(updater.mySchemasToRemove)) {
            return false;
        }
        return this.mySchemasToAdd.equals(updater.mySchemasToAdd);
    }

    public int hashCode() {
        int result2 = this.mySchemasToRemove.hashCode();
        result2 = 31 * result2 + this.mySchemasToAdd.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introspectionScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/IntrospectionScopeUpdater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/IntrospectionScopeUpdater";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateVisibleNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateVisibleNamespaces";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSchemas";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSchema";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDatabases";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processSchema$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

