/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlBuilder {
    private final List<String> myResults = ContainerUtil.newSmartList();
    private final CharOut myOut;
    private boolean mySortElements;
    private boolean mySplitStatements;
    private DatabaseDialectEx myDialect = GenericDialect.INSTANCE;
    private CasingProvider myCasing = DasUtil.NO_CASING_PROVIDER;
    private Case myKeywordCase = Case.MIXED;
    private Case myTypeCase = Case.MIXED;
    private Casing myIdentCase = DasUtil.CASING_MIXED;
    private boolean myQuoteIdentifiers;
    private boolean myQualifyReferences;
    private boolean mySuppressQuoteIdentifiers;
    private boolean mySuppressQuoteConstraints;
    private boolean myJdbcOdbc;
    private final Deque<ObjectPath> myDefaultSchemas = ContainerUtil.newLinkedList();
    private final Map<DasObject, String> myRenames = ContainerUtil.newHashMap();
    private boolean mySkipExternalReferences;
    private boolean myNewName;
    private boolean myAddNewLineBeforeNewText = false;
    private Marker myMarker = null;

    public DdlBuilder(CharOut out) {
        this.myOut = out;
    }

    public DdlBuilder(StringBuilder out) {
        this(CharOut.Util.newSink(out));
    }

    public DdlBuilder() {
        this(new StringBuilder());
    }

    public DdlBuilder configureBuilder(@NotNull Project project) {
        SqlCodeStyleSettings settings;
        if (project == null) {
            DdlBuilder.$$$reportNull$$$0(0);
        }
        if ((settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class)) == null) {
            settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)project));
        }
        this.configureBuilder(settings);
        return this;
    }

    public DdlBuilder configureBuilder(@NotNull SqlCodeStyleSettings settings) {
        if (settings == null) {
            DdlBuilder.$$$reportNull$$$0(1);
        }
        this.keywordCase(SqlCodeStyleSettings.getCaseMode((int)settings.KEYWORD_CASE));
        this.typeCase(settings.getCaseModeExt(settings.TYPE_CASE));
        this.identifierCase(Casing.create((Case)SqlCodeStyleSettings.getCaseMode((int)settings.IDENTIFIER_CASE), (Case)SqlCodeStyleSettings.getCaseMode((int)settings.QUOTED_IDENTIFIER_CASE)));
        this.quoteIdentifiers(settings.QUOTE_IDENTIFIER == 0);
        return this;
    }

    @NotNull
    public DdlBuilder applyCodeStyle(@Nullable Project project) {
        if (project != null) {
            this.configureBuilder(project);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(2);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder renameObject(@NotNull DasObject obj, @Nullable String name) {
        if (obj == null) {
            DdlBuilder.$$$reportNull$$$0(3);
        }
        if (name == null) {
            this.myRenames.remove(obj);
        } else {
            this.myRenames.put(obj, name);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder configureFrom(@NotNull DdlBuilder builder) {
        if (builder == null) {
            DdlBuilder.$$$reportNull$$$0(5);
        }
        this.myDialect = builder.myDialect;
        this.myCasing = builder.myCasing;
        this.myKeywordCase = builder.myKeywordCase;
        this.myTypeCase = builder.myTypeCase;
        this.myIdentCase = builder.myIdentCase;
        this.myQuoteIdentifiers = builder.myQuoteIdentifiers;
        this.myQualifyReferences = builder.myQualifyReferences;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder copied() {
        DdlBuilder builder = new DdlBuilder().configureFrom(this);
        builder.mySuppressQuoteConstraints = this.mySuppressQuoteConstraints;
        builder.mySuppressQuoteIdentifiers = this.mySuppressQuoteIdentifiers;
        builder.myDefaultSchemas.addAll(this.myDefaultSchemas);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    public DdlBuilder configureFor(@NotNull DbElement element) {
        if (element == null) {
            DdlBuilder.$$$reportNull$$$0(8);
        }
        this.applyCodeStyle(element.getProject());
        this.myDialect = DbImplUtil.getDatabaseDialect(element);
        return this.withCasingFor(element);
    }

    public DdlBuilder withCasingFor(@NotNull DbElement element) {
        if (element == null) {
            DdlBuilder.$$$reportNull$$$0(9);
        }
        this.myCasing = element.getDataSource().getModel();
        return this;
    }

    public int length() {
        return (int)this.myOut.length() + (this.myMarker == null ? 0 : this.myMarker.length());
    }

    public <T> T cast(Class<T> c) {
        T t = this.myOut.tryCast(c);
        if (t == null) {
            throw new UnsupportedOperationException("failed to cast " + this.myOut.getClass() + " to " + c);
        }
        return t;
    }

    public DdlBuilder withCasing(@NotNull CasingProvider casing) {
        if (casing == null) {
            DdlBuilder.$$$reportNull$$$0(10);
        }
        this.myCasing = casing;
        return this;
    }

    public DdlBuilder withDialect(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DdlBuilder.$$$reportNull$$$0(11);
        }
        this.myDialect = dialect;
        this.myCasing = this.myCasing == DasUtil.NO_CASING_PROVIDER ? this.myDialect : this.myCasing;
        return this;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            DdlBuilder.$$$reportNull$$$0(12);
        }
        return databaseDialectEx;
    }

    public boolean isEmpty() {
        return this.length() == 0 && this.myResults.isEmpty();
    }

    @NotNull
    public DdlBuilder sort(boolean flag) {
        this.mySortElements = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keywordCase(Case mode) {
        this.myKeywordCase = mode;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder typeCase(Case mode) {
        this.myTypeCase = mode;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(15);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifierCase(@NotNull Casing casing) {
        if (casing == null) {
            DdlBuilder.$$$reportNull$$$0(16);
        }
        this.myIdentCase = casing;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder splitStatements(boolean flag) {
        this.mySplitStatements = flag;
        if (this.mySplitStatements) {
            this.cast(StringBuilder.class);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifyReferences(boolean flag) {
        this.myQualifyReferences = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newStatement() {
        if (this.length() != 0) {
            if (this.mySplitStatements) {
                StringBuilder builder = this.cast(StringBuilder.class);
                this.myResults.add(builder.toString());
                builder.setLength(0);
            } else {
                this.symbol(";");
                this.myAddNewLineBeforeNewText = true;
            }
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder clear() {
        StringBuilder sb = this.myOut.tryCast(StringBuilder.class);
        if (sb != null) {
            this.myAddNewLineBeforeNewText = false;
            sb.setLength(0);
        }
        this.myResults.clear();
        this.myMarker = null;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @NotNull
    public String getStatement() {
        String string = this.myMarker == null ? this.myOut.toString() : this.myMarker.toString();
        if (string == null) {
            DdlBuilder.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public List<String> getStatements() {
        if ((this.mySplitStatements || this.myResults.isEmpty()) && this.length() > 0) {
            this.newStatement();
        }
        List<String> list = this.myResults;
        if (list == null) {
            DdlBuilder.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public DdlBuilder jdbcOdbc(boolean flag) {
        this.myJdbcOdbc = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    public boolean isJdbcOdbc() {
        return this.myJdbcOdbc;
    }

    @NotNull
    public DdlBuilder skipExternalReferences(boolean flag) {
        this.mySkipExternalReferences = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    public boolean skipExternalReferences() {
        return this.mySkipExternalReferences;
    }

    @NotNull
    public DdlBuilder quoteIdentifiers(boolean quoteIdentifiers) {
        this.myQuoteIdentifiers = quoteIdentifiers;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder suppressQuoteIdentifiers(boolean flag) {
        this.mySuppressQuoteIdentifiers = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder pushDefaultSchema(@Nullable ObjectPath namespace) {
        this.myDefaultSchemas.push(namespace);
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(28);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder popDefaultSchema() {
        this.myDefaultSchemas.pop();
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder suppressQuoteConstraints(boolean flag) {
        this.mySuppressQuoteConstraints = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @NotNull
    public Marker mark() {
        StringBuilder builder = this.myOut.tryCast(StringBuilder.class);
        if (builder != null) {
            Marker marker = new Marker(builder);
            if (marker == null) {
                DdlBuilder.$$$reportNull$$$0(31);
            }
            return marker;
        }
        Marker marker = new Marker(new StringBuilder());
        if (marker == null) {
            DdlBuilder.$$$reportNull$$$0(32);
        }
        return marker;
    }

    @NotNull
    public DdlBuilder plain(@NotNull String text) {
        if (text == null) {
            DdlBuilder.$$$reportNull$$$0(33);
        }
        DdlBuilder ddlBuilder = this.append(text);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(34);
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder append(@NotNull String text) {
        if (text == null) {
            DdlBuilder.$$$reportNull$$$0(35);
        }
        if (!text.isEmpty() && this.myAddNewLineBeforeNewText) {
            this.myAddNewLineBeforeNewText = false;
            this.newLine();
        }
        if (this.myMarker == null) {
            this.myOut.append(text);
        } else {
            this.myMarker.builder.append(text);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(36);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder placeholder() {
        DdlBuilder ddlBuilder = this.symbol("?");
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keyword(@NotNull String keyword) {
        if (keyword == null) {
            DdlBuilder.$$$reportNull$$$0(38);
        }
        DdlBuilder ddlBuilder = this.plain(this.myKeywordCase.apply(keyword));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(39);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keywords(String ... keywords) {
        if (keywords == null) {
            DdlBuilder.$$$reportNull$$$0(40);
        }
        boolean first = true;
        for (String s : keywords) {
            if (first) {
                first = false;
            } else {
                this.space();
            }
            this.keyword(s);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(41);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder elements(@NotNull Iterable<? extends DasObject> elements) {
        if (elements == null) {
            DdlBuilder.$$$reportNull$$$0(42);
        }
        for (DasObject dasObject : elements) {
            int length = this.length();
            this.element(dasObject);
            if (this.length() <= length) continue;
            this.newStatement();
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder element(@NotNull DasObject element) {
        if (element == null) {
            DdlBuilder.$$$reportNull$$$0(44);
        }
        if (element instanceof DasRoutine) {
            this.procedure((DasRoutine)element);
        } else if (element instanceof DasTable) {
            this.table((DasTable)element);
        } else if (element instanceof DasColumn) {
            this.column((DasColumn)element);
        } else if (element instanceof DasForeignKey) {
            this.foreignKey((DasForeignKey)element);
        } else if (element instanceof DasTableKey) {
            this.key((DasTableKey)element);
        } else {
            this.other(element);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder procedure(@NotNull DasRoutine element) {
        if (element == null) {
            DdlBuilder.$$$reportNull$$$0(46);
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlDefineProcedure(this, element);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(47);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder other(@NotNull DasObject element) {
        if (element == null) {
            DdlBuilder.$$$reportNull$$$0(48);
        }
        int length = this.length();
        for (DasObject o : ((JBTreeTraverser)DasUtil.dasTraverser().regard(Conditions.not((Condition)DasUtil.byClass(DasNamespace.class)))).children((Object)element)) {
            if (this.length() > length) {
                length = this.newStatement().length();
            }
            this.element(o);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(49);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder key(@NotNull DasTableKey key2) {
        if (key2 == null) {
            DdlBuilder.$$$reportNull$$$0(50);
        }
        if (key2.isPrimary()) {
            DdlBuilder ddlBuilder = this.myDialect.sqlDefinePrimaryKey(this, key2);
            if (ddlBuilder == null) {
                DdlBuilder.$$$reportNull$$$0(51);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder index(@NotNull DasIndex o) {
        if (o == null) {
            DdlBuilder.$$$reportNull$$$0(53);
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlCreateIndex(this, o, "", "", "");
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(54);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder foreignKey(@NotNull DasForeignKey key2) {
        if (key2 == null) {
            DdlBuilder.$$$reportNull$$$0(55);
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlDefineForeignKey(this, key2, false);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull String type) {
        if (type == null) {
            DdlBuilder.$$$reportNull$$$0(57);
        }
        DdlBuilder ddlBuilder = this.typeInner(type);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder typeInner(@NotNull String type) {
        if (type == null) {
            DdlBuilder.$$$reportNull$$$0(59);
        }
        boolean quoted = this.myDialect.isQuotedIdentifier(type);
        Casing casing = this.myCasing.getCasing(ObjectKind.OBJECT_TYPE, null);
        Case styleMode = quoted ? this.myIdentCase.choose(false) : this.myTypeCase;
        Case caseMode = quoted ? casing.choose(false) : Case.MIXED;
        DdlBuilder ddlBuilder = this.plain(caseMode == Case.EXACT ? type : styleMode.apply(type));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull DasTypedObject typedInfo) {
        if (typedInfo == null) {
            DdlBuilder.$$$reportNull$$$0(61);
        }
        if (typedInfo instanceof DasColumn) {
            DataType type;
            try {
                type = typedInfo.getDataType();
            }
            catch (UnsupportedOperationException e) {
                if (typedInfo instanceof DeColumn) {
                    DdlBuilder ddlBuilder = this.plain(((DeColumn)typedInfo).dataType);
                    if (ddlBuilder == null) {
                        DdlBuilder.$$$reportNull$$$0(62);
                    }
                    return ddlBuilder;
                }
                throw e;
            }
            String specification = type.getSpecification();
            if (type.jdbcType == 0 && StringUtil.isNotEmpty((String)specification)) {
                DdlBuilder ddlBuilder = this.type(type);
                if (ddlBuilder == null) {
                    DdlBuilder.$$$reportNull$$$0(63);
                }
                return ddlBuilder;
            }
            DdlBuilder ddlBuilder = this.typeInner(this.myDialect.getTypeName(type));
            if (ddlBuilder == null) {
                DdlBuilder.$$$reportNull$$$0(64);
            }
            return ddlBuilder;
        }
        DataType type = typedInfo.getDataType();
        String typeName = type.getSpecification();
        typeName = StringUtil.isEmpty((String)typeName) ? this.myDialect.getTypeName(type) : typeName;
        int index2 = typeName.indexOf(40);
        typeName = index2 < 0 ? typeName : typeName.substring(0, index2).trim();
        DdlBuilder ddlBuilder = this.typeInner(typeName);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(65);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull DataType dataType) {
        if (dataType == null) {
            DdlBuilder.$$$reportNull$$$0(66);
        }
        if (dataType.schemaName != null) {
            this.ref(null, dataType.schemaName).symbol(".");
        }
        this.typeInner(dataType.typeName);
        if (dataType.vagueArg != null) {
            this.symbol("(").plain(dataType.vagueArg).symbol(")");
        } else if (dataType.enumValues != null) {
            this.symbol("(");
            this.plain(StringUtil.join((Collection)dataType.enumValues, (String)", "));
            this.symbol(")");
        } else if (dataType.size >= 0) {
            this.symbol("(");
            if (dataType.size == 0x7FFFFFFE) {
                this.symbol("*");
            } else if (dataType.size == Integer.MAX_VALUE) {
                this.keyword("max");
            } else {
                this.number(dataType.size);
            }
            if (dataType.scale != 0) {
                this.symbol(",").number(dataType.scale);
            }
            if (dataType.sizeUnit != LengthUnit.NONE && dataType.sizeUnitExplicit) {
                this.space().keyword(dataType.sizeUnit.suffix);
            }
            this.symbol(")");
        }
        if (dataType.suffix != null) {
            this.space().plain(dataType.suffix);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(67);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder number(int n) {
        DdlBuilder ddlBuilder = this.plain(String.valueOf(n));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(68);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder column(@NotNull DasColumn column2) {
        if (column2 == null) {
            DdlBuilder.$$$reportNull$$$0(69);
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlDefineColumn(this, column2, false);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder literal(@NotNull String def2) {
        if (def2 == null) {
            DdlBuilder.$$$reportNull$$$0(71);
        }
        DdlBuilder ddlBuilder = this.plain(def2);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(72);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder ref(@Nullable DasObject object, String name) {
        if (StringUtil.isEmpty((String)name)) {
            DdlBuilder ddlBuilder = this;
            if (ddlBuilder == null) {
                DdlBuilder.$$$reportNull$$$0(73);
            }
            return ddlBuilder;
        }
        boolean quoted = this.myDialect.isQuotedIdentifier(name);
        Casing casing = this.myCasing.getCasing(object == null ? ObjectKind.TABLE : object.getKind(), object);
        Case styleMode = this.myIdentCase.choose(!quoted);
        Case caseMode = casing.choose(!quoted);
        DdlBuilder ddlBuilder = this.plain(caseMode == Case.EXACT ? name : styleMode.apply(name));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder space(int count2) {
        DdlBuilder ddlBuilder = this.plain(StringUtil.repeat((String)" ", (int)count2));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(75);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder space() {
        DdlBuilder ddlBuilder = this.space(1);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(76);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder tab() {
        DdlBuilder ddlBuilder = this.space(4);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(77);
        }
        return ddlBuilder;
    }

    public DdlBuilder newLine() {
        return this.plain("\n");
    }

    @NotNull
    public DdlBuilder symbol(@NotNull String symbol) {
        if (symbol == null) {
            DdlBuilder.$$$reportNull$$$0(78);
        }
        DdlBuilder ddlBuilder = this.plain(symbol);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(79);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder comment(@NotNull String s) {
        if (s == null) {
            DdlBuilder.$$$reportNull$$$0(80);
        }
        for (String commentLine : StringUtil.splitByLinesKeepSeparators((String)s)) {
            this.plain("-- ").plain(commentLine);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(81);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder inlineComment(@NotNull String s) {
        if (s == null) {
            DdlBuilder.$$$reportNull$$$0(82);
        }
        DdlBuilder ddlBuilder = this.plain("/*").plain(s).plain("*/");
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(83);
        }
        return ddlBuilder;
    }

    private String quoteIdentifier(@NotNull String name, boolean force, boolean suppress, @NotNull Casing casing) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(84);
        }
        if (casing == null) {
            DdlBuilder.$$$reportNull$$$0(85);
        }
        boolean suppressFlag = suppress || this.mySuppressQuoteIdentifiers;
        return ((AbstractDatabaseDialect)this.myDialect).quoteIdentifier(name, force && !suppressFlag, suppressFlag, casing);
    }

    @NotNull
    public DdlBuilder identifier(@NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(86);
        }
        DdlBuilder ddlBuilder = this.identifier(null, name);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(87);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@NotNull DasObject object) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(88);
        }
        DdlBuilder ddlBuilder = this.identifier(object, this.getName(object));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(89);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(90);
        }
        Casing casing = this.myCasing.getCasing(object == null ? ObjectKind.TABLE : object.getKind(), object);
        DdlBuilder ddlBuilder = this.ref(object, this.quoteIdentifier(name, this.myQuoteIdentifiers, DdlBuilder.isPlainIdentifier(object), casing));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(91);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@NotNull ObjectName name, @Nullable ObjectKind kind) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(92);
        }
        Casing casing = this.myCasing.getCasing((ObjectKind)ObjectUtils.chooseNotNull((Object)kind, (Object)ObjectKind.TABLE), null);
        DdlBuilder ddlBuilder = this.ref(null, this.quoteIdentifier(name.name, this.myQuoteIdentifiers, !name.quoted, casing));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(93);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder alias(@NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(94);
        }
        DdlBuilder ddlBuilder = this.ref(null, name);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(95);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newName(@NotNull String newName) {
        if (newName == null) {
            DdlBuilder.$$$reportNull$$$0(96);
        }
        DdlBuilder ddlBuilder = this.identifier(newName);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(97);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newName(@NotNull String name, @Nullable DasObject info) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(98);
        }
        this.myNewName = true;
        this.qualifiedRefOpt(info, name);
        this.myNewName = false;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(99);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder formatQualification(@NotNull DasObject object, ObjectKind ... kinds) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(100);
        }
        if (kinds == null) {
            DdlBuilder.$$$reportNull$$$0(101);
        }
        boolean first = true;
        for (ObjectKind kind : kinds) {
            DasObject item = DasUtil.getParentOfKind((DasObject)object, (ObjectKind)kind, (boolean)false);
            if (item == null || StringUtil.isEmpty((String)item.getName())) continue;
            if (!first) {
                this.symbol(".");
            }
            first = false;
            this.identifier(item, item.getName());
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(102);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder columnRef(@NotNull DasObject info) {
        if (info == null) {
            DdlBuilder.$$$reportNull$$$0(103);
        }
        DdlBuilder ddlBuilder = this.identifier(info, this.getName(info));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(104);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder columnRef(@NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(105);
        }
        DdlBuilder ddlBuilder = this.identifier(null, name);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(106);
        }
        return ddlBuilder;
    }

    @NotNull
    public String getName(@NotNull DasObject object) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(107);
        }
        String string = StringUtil.notNullize((String)this.myRenames.get(object), (String)object.getName());
        if (string == null) {
            DdlBuilder.$$$reportNull$$$0(108);
        }
        return string;
    }

    @NotNull
    public DdlBuilder constraintRef(@NotNull DasObject object) {
        if (object == null) {
            DdlBuilder.$$$reportNull$$$0(109);
        }
        DdlBuilder ddlBuilder = this.constraintRef(object, object.getName());
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(110);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder constraintRef(@Nullable DasObject object, @NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(111);
        }
        Casing casing = this.myCasing.getCasing(ObjectKind.KEY, object);
        DdlBuilder ddlBuilder = this.ref(object, this.quoteIdentifier(name, this.myQuoteIdentifiers, this.mySuppressQuoteConstraints || DdlBuilder.isPlainIdentifier(object), casing));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(112);
        }
        return ddlBuilder;
    }

    private static boolean isPlainIdentifier(@Nullable DasObject object) {
        return !DbSqlUtil.isQuoted(object);
    }

    @NotNull
    public DdlBuilder qualifiedRef(@NotNull DasObject info) {
        if (info == null) {
            DdlBuilder.$$$reportNull$$$0(113);
        }
        if (this.myQualifyReferences && !this.inCurrentNamespace(info)) {
            this.myDialect.qualifiedIdentifier(this, this.getName(info), info, info);
        } else if (info instanceof DasRoutine) {
            this.qualifiedRef(info, this.getName(info), null, null, null, null, null, ((DasRoutine)info).getPackageName());
        } else {
            this.qualifiedRefLast(info, this.getName(info));
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(114);
        }
        return ddlBuilder;
    }

    protected boolean inCurrentNamespace(@NotNull DasObject info) {
        if (info == null) {
            DdlBuilder.$$$reportNull$$$0(115);
        }
        ObjectPath current = this.myDefaultSchemas.peek();
        DasObject parent = info.getDasParent();
        if (current == null) {
            return parent == null;
        }
        return current.equals((Object)ObjectPaths.of(parent));
    }

    @NotNull
    public DdlBuilder qualifiedRefOpt(@Nullable DasObject object, @NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(116);
        }
        DdlBuilder ddlBuilder = this.qualifiedRefOpt(object, object, name);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(117);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRefOpt(@Nullable DasObject object, @Nullable DasObject qualifier, @NotNull String name) {
        boolean explicitSchema;
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(118);
        }
        if (explicitSchema = qualifier != null && this.myQualifyReferences ? !this.inCurrentNamespace(qualifier) : false) {
            this.myDialect.qualifiedIdentifier(this, name, object, qualifier);
        } else {
            this.qualifiedRefLast(object, name);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(119);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRef(@Nullable DasObject object, @NotNull String name, @Nullable DasObject schemaObject, @Nullable String schema, @Nullable DasObject catalogObject, @Nullable String catalog, @Nullable DasObject packageObject, @Nullable String packageName) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(120);
        }
        if (StringUtil.isNotEmpty((String)catalog) && (object == null || object != catalogObject)) {
            this.identifier(catalogObject, catalog).symbol(".");
        }
        if (StringUtil.isNotEmpty((String)schema) && (object == null || object != schemaObject)) {
            this.identifier(schemaObject, schema).symbol(".");
        }
        if (StringUtil.isNotEmpty((String)packageName) && (object == null || object != packageObject)) {
            this.identifier(packageObject, packageName).symbol(".");
        }
        DdlBuilder ddlBuilder = this.qualifiedRefLast(object, name);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(121);
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder qualifiedRefLast(@Nullable DasObject element, @NotNull String name) {
        if (name == null) {
            DdlBuilder.$$$reportNull$$$0(122);
        }
        DdlBuilder ddlBuilder = this.myNewName ? this.newName(name) : this.identifier(element, name);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(123);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder table(@NotNull DasTable table) {
        if (table == null) {
            DdlBuilder.$$$reportNull$$$0(124);
        }
        DdlBuilder ddlBuilder = this.tables(Collections.singletonList(table));
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(125);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder tables(@NotNull Iterable<? extends DasTable> table) {
        if (table == null) {
            DdlBuilder.$$$reportNull$$$0(126);
        }
        if (Iterables.isEmpty(table)) {
            DdlBuilder ddlBuilder = this;
            if (ddlBuilder == null) {
                DdlBuilder.$$$reportNull$$$0(127);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlCreateTable(this, ContainerUtil.newArrayList(table), true, null);
        if (ddlBuilder == null) {
            DdlBuilder.$$$reportNull$$$0(128);
        }
        return ddlBuilder;
    }

    public <T extends DasObject> Iterable<T> sortKeysIfNeeded(Iterable<T> elements) {
        if (!this.mySortElements) {
            return elements;
        }
        ArrayList result2 = new ArrayList();
        Iterables.addAll(result2, elements);
        Collections.sort(result2, (o1, o2) -> Comparing.compare((Comparable)((Object)this.getName((DasObject)o1)), (Comparable)((Object)this.getName((DasObject)o2))));
        return result2;
    }

    public String toString() {
        return super.toString() + ": " + (this.myMarker == null ? this.myOut : this.myMarker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DdlBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 9: 
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 16: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedInfo";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 84: 
            case 86: 
            case 90: 
            case 92: 
            case 94: 
            case 98: 
            case 105: 
            case 111: 
            case 116: 
            case 118: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 88: 
            case 100: 
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 103: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 124: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DdlBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "applyCodeStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "renameObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "configureFrom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copied";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "keywordCase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "typeCase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "identifierCase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "splitStatements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyReferences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newStatement";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "clear";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "jdbcOdbc";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "skipExternalReferences";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteIdentifiers";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "suppressQuoteIdentifiers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "pushDefaultSchema";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "popDefaultSchema";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "suppressQuoteConstraints";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mark";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "plain";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "placeholder";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "keyword";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "keywords";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "elements";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "element";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "procedure";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "other";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "key";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "index";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "foreignKey";
                break;
            }
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "typeInner";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "number";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "column";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "literal";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "ref";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "space";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "tab";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "symbol";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "comment";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineComment";
                break;
            }
            case 87: 
            case 89: 
            case 91: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "identifier";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "alias";
                break;
            }
            case 97: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "newName";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "formatQualification";
                break;
            }
            case 104: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "columnRef";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 110: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "constraintRef";
                break;
            }
            case 114: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedRef";
                break;
            }
            case 117: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedRefOpt";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedRefLast";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "table";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureBuilder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "renameObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureFrom";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withCasingFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withCasing";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withDialect";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "identifierCase";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "plain";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "keyword";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "keywords";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "elements";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "element";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "procedure";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "other";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "key";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "foreignKey";
                break;
            }
            case 57: 
            case 61: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "typeInner";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "column";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "literal";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "symbol";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "comment";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "inlineComment";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 86: 
            case 88: 
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "identifier";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
            case 96: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "newName";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "formatQualification";
                break;
            }
            case 103: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "columnRef";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 109: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "constraintRef";
                break;
            }
            case 113: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedRef";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "inCurrentNamespace";
                break;
            }
            case 116: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedRefOpt";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedRefLast";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "table";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Colored
    extends DdlBuilder {
        protected EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        protected final LinkedList<TextAttributes> myStack = new LinkedList();
        protected boolean myQuoteState;

        public Colored(StringBuilder sb) {
            super(sb);
        }

        public Colored() {
        }

        @NotNull
        public Colored pushStyle(TextAttributesKey key2) {
            Colored colored = this.pushStyle(this.scheme.getAttributes(key2));
            if (colored == null) {
                Colored.$$$reportNull$$$0(0);
            }
            return colored;
        }

        @NotNull
        public Colored pushStyle(@Nullable TextAttributes attributes) {
            this.myStack.addLast(attributes);
            if (attributes != null) {
                this.setAttributes(attributes, true);
            }
            Colored colored = this;
            if (colored == null) {
                Colored.$$$reportNull$$$0(1);
            }
            return colored;
        }

        @NotNull
        public Colored popStyle() {
            TextAttributes attributes = this.myStack.removeLast();
            if (attributes != null) {
                this.setAttributes(attributes, false);
            }
            Colored colored = this;
            if (colored == null) {
                Colored.$$$reportNull$$$0(2);
            }
            return colored;
        }

        protected void setAttributes(@Nullable TextAttributes attributes, boolean enabled) {
            if (attributes == null) {
                return;
            }
            int fontType = attributes.getFontType();
            Color fg = attributes.getForegroundColor();
            if (enabled) {
                if (fg != null) {
                    this.append("<font").append(" color=\"#").append(ColorUtil.toHex((Color)fg)).append("\"");
                    Color bg = attributes.getBackgroundColor();
                    if (bg != null) {
                        this.append(" bgcolor=\"#").append(ColorUtil.toHex((Color)bg)).append("\"");
                    }
                    this.append(">");
                }
                if ((fontType & 2) != 0) {
                    this.append("<i>");
                }
                if ((fontType & 1) != 0) {
                    this.append("<b>");
                }
            } else {
                if ((fontType & 1) != 0) {
                    this.append("</b>");
                }
                if ((fontType & 2) != 0) {
                    this.append("</i>");
                }
                if (fg != null) {
                    this.append("</font>");
                }
            }
        }

        @Override
        @NotNull
        public Colored plain(@NotNull String text) {
            if (text == null) {
                Colored.$$$reportNull$$$0(3);
            }
            Colored colored = (Colored)super.plain(text);
            if (colored == null) {
                Colored.$$$reportNull$$$0(4);
            }
            return colored;
        }

        @NotNull
        public Colored plain(@NotNull String text, @Nullable TextAttributesKey key2) {
            if (text == null) {
                Colored.$$$reportNull$$$0(5);
            }
            Colored colored = this.pushStyle(key2).plain(text).popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(6);
            }
            return colored;
        }

        @Override
        public DdlBuilder newLine() {
            return super.newLine();
        }

        @Override
        @NotNull
        public DdlBuilder newStatement() {
            DdlBuilder ddlBuilder = super.newStatement();
            if (ddlBuilder == null) {
                Colored.$$$reportNull$$$0(7);
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        protected Colored append(@NotNull String text) {
            if (text == null) {
                Colored.$$$reportNull$$$0(8);
            }
            Colored colored = (Colored)super.append(text);
            if (colored == null) {
                Colored.$$$reportNull$$$0(9);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored keyword(@NotNull String keyword) {
            if (keyword == null) {
                Colored.$$$reportNull$$$0(10);
            }
            this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
            super.keyword(keyword);
            Colored colored = this.popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(11);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored symbol(@NotNull String symbol) {
            if (symbol == null) {
                Colored.$$$reportNull$$$0(12);
            }
            if ("'".equals(symbol)) {
                boolean bl = this.myQuoteState = !this.myQuoteState;
                if (this.myQuoteState) {
                    this.pushStyle(DefaultLanguageHighlighterColors.STRING);
                }
                super.symbol(symbol);
                if (!this.myQuoteState) {
                    this.popStyle();
                }
                Colored colored = this;
                if (colored == null) {
                    Colored.$$$reportNull$$$0(13);
                }
                return colored;
            }
            Object key2 = ".".equals(symbol) ? DefaultLanguageHighlighterColors.DOT : (",".equals(symbol) ? DefaultLanguageHighlighterColors.COMMA : ("(".equals(symbol) || ")".equals(symbol) ? DefaultLanguageHighlighterColors.PARENTHESES : (";".equals(symbol) ? DefaultLanguageHighlighterColors.SEMICOLON : null)));
            this.pushStyle((TextAttributesKey)key2);
            super.symbol(symbol);
            Colored colored = this.popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(14);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored comment(@NotNull String s) {
            if (s == null) {
                Colored.$$$reportNull$$$0(15);
            }
            this.pushStyle(DefaultLanguageHighlighterColors.LINE_COMMENT);
            super.comment(s);
            Colored colored = this.popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(16);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored type(@NotNull String type) {
            if (type == null) {
                Colored.$$$reportNull$$$0(17);
            }
            this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
            super.type(type);
            Colored colored = this.popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(18);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored type(@NotNull DasTypedObject typedInfo) {
            if (typedInfo == null) {
                Colored.$$$reportNull$$$0(19);
            }
            this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
            super.type(typedInfo);
            Colored colored = this.popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(20);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored literal(@NotNull String literal) {
            if (literal == null) {
                Colored.$$$reportNull$$$0(21);
            }
            TextAttributesKey key2 = literal.indexOf(39) > -1 || literal.indexOf(34) > -1 ? DefaultLanguageHighlighterColors.STRING : DefaultLanguageHighlighterColors.NUMBER;
            this.pushStyle(key2);
            super.literal(literal);
            Colored colored = this.popStyle();
            if (colored == null) {
                Colored.$$$reportNull$$$0(22);
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored ref(@Nullable DasObject object, String name) {
            Colored colored = (Colored)super.ref(object, name);
            if (colored == null) {
                Colored.$$$reportNull$$$0(23);
            }
            return colored;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DdlBuilder$Colored";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyword";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typedInfo";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pushStyle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "popStyle";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DdlBuilder$Colored";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plain";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "append";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keyword";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "symbol";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "comment";
                    break;
                }
                case 18: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "literal";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ref";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "plain";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "keyword";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "symbol";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "comment";
                    break;
                }
                case 17: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "type";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "literal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 12: 
                case 15: 
                case 17: 
                case 19: 
                case 21: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class Marker {
        private final int position;
        private final StringBuilder builder;

        private Marker(StringBuilder builder) {
            this.builder = builder;
            this.position = builder.length();
            if (DdlBuilder.this.myMarker != null) {
                throw new AssertionError((Object)"Marker already exists");
            }
            DdlBuilder.this.myMarker = this;
        }

        @NotNull
        public String extract() {
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Accessing invalid marker");
            }
            String string = this.builder.subSequence(this.position, this.builder.length()).toString();
            if (string == null) {
                Marker.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void replace(@NotNull String replacement) {
            if (replacement == null) {
                Marker.$$$reportNull$$$0(1);
            }
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Accessing invalid marker");
            }
            this.builder.replace(this.position, this.builder.length(), replacement);
        }

        public void finish() {
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Finishing invalid marker");
            }
            if (DdlBuilder.this.myOut.tryCast(StringBuilder.class) != this.builder) {
                DdlBuilder.this.myOut.append(this.builder);
            }
            DdlBuilder.this.myMarker = null;
        }

        public String toString() {
            if (DdlBuilder.this.myOut.tryCast(StringBuilder.class) != this.builder) {
                return DdlBuilder.this.myOut + this.builder.toString();
            }
            return this.builder.toString();
        }

        private int length() {
            return this.builder.length() - this.position;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DdlBuilder$Marker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extract";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DdlBuilder$Marker";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

