/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class GeneralSettingsComponent
implements ConfigurableUi<DatabaseSettings> {
    private JPanel myPanel;
    private JCheckBox myShowQueryResultsInCheckBox;
    private JCheckBox myShowErrorBalloonCheckbox;
    private JBCheckBox myReviewParametersCheckBox;
    private ComboBox<String> myInsideStatementCombo;
    private ComboBox<String> myOutsideStatementCombo;
    private ComboBox<String> mySelectionPresentCombo;
    private JCheckBox myPreviewRowsCheckBox;
    private JTextField myPreviewRowsTextField;
    private JBCheckBox myDdlConfirmOnClose;
    private JPanel myRunChooserPanel;
    private SwingActionLink myShortcutLink;
    private JBCheckBox myPreferSchemaNavigationCombo;
    private JBCheckBox myPreferDataNavigationCombo;
    private final List<MyAction> myRunActions;
    private MyAction mySelectedRunAction;
    private final ActionToolbar myToolbar;

    public GeneralSettingsComponent() {
        this.$$$setupUI$$$();
        this.myInsideStatementCombo.addItem((Object)"Ask what to execute");
        this.myInsideStatementCombo.addItem((Object)"Smallest statement");
        this.myInsideStatementCombo.addItem((Object)"Largest statement");
        this.myInsideStatementCombo.addItem((Object)"Largest statement or batch");
        this.myInsideStatementCombo.addItem((Object)"Whole script");
        this.myInsideStatementCombo.addItem((Object)"Everything from caret");
        this.myOutsideStatementCombo.addItem((Object)"Nothing");
        this.myOutsideStatementCombo.addItem((Object)"Whole script");
        this.myOutsideStatementCombo.addItem((Object)"Everything below caret");
        this.mySelectionPresentCombo.addItem((Object)"Exactly as one statement");
        this.mySelectionPresentCombo.addItem((Object)"Exactly as statements");
        this.mySelectionPresentCombo.addItem((Object)"Smart expand to script");
        this.myInsideStatementCombo.setMinLength(30);
        this.myOutsideStatementCombo.setMinLength(30);
        this.mySelectionPresentCombo.setMinLength(30);
        List<DatabaseSettings.ExecOption> options = DatabaseSettings.getSettings().execOptions;
        this.myRunActions = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < options.size(); ++i2) {
            this.myRunActions.add(new MyAction(i2 + 1, options.get(i2)));
        }
        DefaultActionGroup group2 = new DefaultActionGroup(JBIterable.from(this.myRunActions).join((Object)Separator.create()).toList());
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DB.RunChooser", (ActionGroup)group2, true);
        this.myRunChooserPanel.add(this.myToolbar.getComponent());
        for (MyAction action : this.myRunActions) {
            action.registerCustomShortcutSet(this.myPanel, null);
        }
        this.setSelectedRunAction(this.myRunActions.get(0));
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myShortcutLink = new SwingActionLink((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Configurable configurable;
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)GeneralSettingsComponent.this.myPanel);
                Settings settings = (Settings)dataContext.getData(Settings.KEY);
                Configurable configurable2 = configurable = settings != null ? settings.find("preferences.keymap") : null;
                if (configurable == null) {
                    this.setEnabled(false);
                    return;
                }
                settings.select(configurable).doWhenDone(() -> {
                    KeymapPanel keymap = (KeymapPanel)configurable;
                    keymap.selectAction(ActionManager.getInstance().getId(((GeneralSettingsComponent)GeneralSettingsComponent.this).mySelectedRunAction.executeAction));
                });
            }
        });
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(1);
        }
        this.myPreferSchemaNavigationCombo.setSelected(settings.navigateToSchema);
        this.myPreferDataNavigationCombo.setSelected(settings.navigateToData);
        this.myShowErrorBalloonCheckbox.setSelected(settings.isShowErrorInEditor());
        this.myReviewParametersCheckBox.setSelected(settings.alwaysReviewParameters);
        for (MyAction action : this.myRunActions) {
            action.temp.copyFrom(action.orig);
        }
        this.restoreMyAction(this.mySelectedRunAction);
        this.myPreviewRowsCheckBox.setSelected(settings.loadSlowDocumentation);
        this.myPreviewRowsTextField.setText(String.valueOf(settings.previewRows));
        this.myDdlConfirmOnClose.setSelected(settings.ddlConfirmLoss);
    }

    public void apply(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(2);
        }
        settings.navigateToSchema = this.myPreferSchemaNavigationCombo.isSelected();
        settings.navigateToData = this.myPreferDataNavigationCombo.isSelected();
        settings.setShowErrorInEditor(this.myShowErrorBalloonCheckbox.isSelected());
        settings.alwaysReviewParameters = this.myReviewParametersCheckBox.isSelected();
        this.storeMyAction(this.mySelectedRunAction);
        for (MyAction action : this.myRunActions) {
            action.orig.copyFrom(action.temp);
        }
        this.restoreMyAction(this.mySelectedRunAction);
        settings.loadSlowDocumentation = this.myPreviewRowsCheckBox.isSelected();
        settings.previewRows = StringUtil.parseInt((String)this.myPreviewRowsTextField.getText(), (int)0);
        settings.ddlConfirmLoss = this.myDdlConfirmOnClose.isSelected();
        DatabaseSettings.fireSettingsChanged();
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            GeneralSettingsComponent.$$$reportNull$$$0(3);
        }
        this.updateShortcutText();
        if (settings.navigateToSchema != this.myPreferSchemaNavigationCombo.isSelected()) {
            return true;
        }
        if (settings.navigateToData != this.myPreferDataNavigationCombo.isSelected()) {
            return true;
        }
        if (settings.isShowErrorInEditor() != this.myShowErrorBalloonCheckbox.isSelected()) {
            return true;
        }
        if (settings.alwaysReviewParameters != this.myReviewParametersCheckBox.isSelected()) {
            return true;
        }
        this.storeMyAction(this.mySelectedRunAction);
        for (MyAction action : this.myRunActions) {
            if (action.orig.equals(action.temp)) continue;
            return true;
        }
        if (settings.loadSlowDocumentation != this.myPreviewRowsCheckBox.isSelected()) {
            return true;
        }
        if (settings.previewRows != StringUtil.parseInt((String)this.myPreviewRowsTextField.getText(), (int)0)) {
            return true;
        }
        return settings.ddlConfirmLoss != this.myDdlConfirmOnClose.isSelected();
    }

    private void setSelectedRunAction(MyAction selected) {
        this.storeMyAction(this.mySelectedRunAction);
        this.mySelectedRunAction = selected;
        this.restoreMyAction(this.mySelectedRunAction);
        this.myToolbar.updateActionsImmediately();
    }

    private void updateShortcutText() {
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.mySelectedRunAction.executeAction);
        this.myShortcutLink.setText(shortcutText.isEmpty() ? "assign" : shortcutText);
    }

    private void storeMyAction(MyAction a) {
        if (a == null) {
            return;
        }
        a.temp.newTab = this.myShowQueryResultsInCheckBox.isSelected();
        a.temp.execInside = this.myInsideStatementCombo.getSelectedIndex() + 1;
        a.temp.execOutside = this.myOutsideStatementCombo.getSelectedIndex() + 1;
        a.temp.execSelection = this.mySelectionPresentCombo.getSelectedIndex() + 1;
    }

    private void restoreMyAction(MyAction a) {
        if (a == null) {
            return;
        }
        this.myInsideStatementCombo.setSelectedIndex(a.temp.execInside - 1);
        this.myOutsideStatementCombo.setSelectedIndex(a.temp.execOutside - 1);
        this.mySelectionPresentCombo.setSelectedIndex(a.temp.execSelection - 1);
        this.myShowQueryResultsInCheckBox.setSelected(a.temp.newTab);
        this.updateShortcutText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/GeneralSettingsComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/GeneralSettingsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JBCheckBox jBCheckBox4;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(15, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(14, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("otherwise execute:");
        jPanel2.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myOutsideStatementCombo = comboBox3 = new ComboBox();
        jPanel2.add((Component)comboBox3, new GridConstraints(6, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("When inside a statement execute:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        this.myInsideStatementCombo = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(5, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(5, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("for selection execute:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySelectionPresentCombo = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(7, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Other");
        jPanel2.add((Component)titledSeparator, new GridConstraints(11, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myDdlConfirmOnClose = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Confirm cancellation for dialogs that modify schema");
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(13, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBCheckBox jBCheckBox5 = new JBCheckBox();
        this.myShowQueryResultsInCheckBox = jBCheckBox5;
        jBCheckBox5.setText("Open results in new tab");
        jBCheckBox5.setMnemonic('B');
        jBCheckBox5.setDisplayedMnemonicIndex(22);
        jPanel2.add((Component)jBCheckBox5, new GridConstraints(8, 0, 1, 3, 4, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Execute in Console");
        jPanel2.add((Component)titledSeparator2, new GridConstraints(3, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myRunChooserPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        SwingActionLink swingActionLink = this.myShortcutLink;
        jPanel2.add((Component)swingActionLink, new GridConstraints(4, 2, 1, 1, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Shortcut:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Navigation");
        jPanel2.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myPreferSchemaNavigationCombo = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Prefer database view over DDL editor");
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myPreferDataNavigationCombo = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Prefer data editor over DDL editor");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBCheckBox jBCheckBox6 = new JBCheckBox();
        this.myShowErrorBalloonCheckbox = jBCheckBox6;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, ResourceBundle.getBundle("messages/DatabaseBundle").getString("jdbc.console.property.label.error.balloon"));
        jPanel2.add((Component)jBCheckBox6, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myReviewParametersCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Always review parameters before execution");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(10, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 4, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(12, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox7 = new JBCheckBox();
        this.myPreviewRowsCheckBox = jBCheckBox7;
        jBCheckBox7.setText("Show first");
        jPanel3.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBTextField jBTextField = new JBTextField();
        this.myPreviewRowsTextField = jBTextField;
        jBTextField.setColumns(4);
        jBTextField.setHorizontalAlignment(4);
        jBTextField.setText("");
        jPanel3.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("data rows in documentation");
        jPanel3.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox3);
        jBLabel5.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyAction
    extends AlignedIconWithTextAction
    implements Toggleable,
    DumbAware {
        AnAction executeAction;
        final DatabaseSettings.ExecOption orig;
        final DatabaseSettings.ExecOption temp = new DatabaseSettings.ExecOption();

        public MyAction(int index2, DatabaseSettings.ExecOption orig) {
            this.orig = orig;
            String actionId = "Console.Jdbc.Execute" + (index2 > 1 ? "." + String.valueOf(index2) : "");
            this.executeAction = ActionManager.getInstance().getAction(actionId);
            String text = this.executeAction == null ? actionId : this.executeAction.getTemplatePresentation().getText();
            this.getTemplatePresentation().setText(text);
            this.getTemplatePresentation().setDescription("Edit settings for '" + text + "'");
            this.setEnabledInModalContext(true);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke("alt " + index2), null)}));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.executeAction != null);
            e.getPresentation().putClientProperty("selected", (Object)(this == GeneralSettingsComponent.this.mySelectedRunAction ? 1 : 0));
        }

        public void actionPerformed(AnActionEvent e) {
            GeneralSettingsComponent.this.setSelectedRunAction(this);
        }
    }
}

