/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.serialization.ImportException;
import com.intellij.database.serialization.ModelExporter;
import com.intellij.database.serialization.ModelImporter;
import com.intellij.database.serialization.ModelSerializerKt;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/serialization/ModelSerializer;", "", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "(Lcom/intellij/database/model/impl/ModelFactory;)V", "exporter", "Lcom/intellij/database/serialization/ModelExporter;", "getExporter", "()Lcom/intellij/database/serialization/ModelExporter;", "importer", "Lcom/intellij/database/serialization/ModelImporter;", "getImporter", "()Lcom/intellij/database/serialization/ModelImporter;", "getModelFactory", "()Lcom/intellij/database/model/impl/ModelFactory;", "deserialize", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "serialize", "", "model", "Lcom/intellij/database/model/DasModel;", "writer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "intellij.database.introspection"})
public final class ModelSerializer {
    @NotNull
    private final ModelExporter exporter;
    @NotNull
    private final ModelImporter importer;
    @NotNull
    private final ModelFactory modelFactory;

    @NotNull
    public final ModelExporter getExporter() {
        return this.exporter;
    }

    @NotNull
    public final ModelImporter getImporter() {
        return this.importer;
    }

    public final void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        ModelSerializerKt.access$serialize(model, writer, this.exporter);
    }

    @NotNull
    public final BasicModModel deserialize(@NotNull HierarchicalStreamReader reader) throws ImportException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return ModelSerializerKt.access$deserialize(reader, this.importer);
    }

    @NotNull
    public final ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public ModelSerializer(@NotNull ModelFactory modelFactory) {
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        this.modelFactory = modelFactory;
        this.exporter = new ModelExporter();
        this.importer = new ModelImporter(this.modelFactory);
    }
}

