/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.redshift;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.properties.RedshiftExternalTableStorageType;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftExternalSchema;
import com.intellij.database.model.redshift.RedshiftExternalTable;
import com.intellij.database.model.redshift.RedshiftExternalTableColumn;
import com.intellij.database.model.redshift.RedshiftModelFunKt;
import com.intellij.database.model.redshift.RedshiftTable;
import com.intellij.database.model.redshift.RedshiftTableColumn;
import com.intellij.database.model.redshift.RedshiftUser;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.postgres.PostgresBaseCreatingGenerator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0002\b\u00030\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "elementKindNameForCreate", "", "getVolatilityKind", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "makeColumnDefinition", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "RsCreateExternalSchema", "RsCreateExternalTable", "RsCreateLikeColumn", "RsCreateTable", "RsCreateUser", "intellij.database.scripting"})
public final class RedshiftCreatingGenerator
extends PostgresBaseCreatingGenerator {
    @Override
    @NotNull
    public BaseCreatingGenerator.CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof RedshiftUser ? (BaseCreatingGenerator.CreateProducer)new RsCreateUser((RedshiftUser)element) : (basicElement instanceof RedshiftExternalSchema ? (BaseCreatingGenerator.CreateProducer)new RsCreateExternalSchema((RedshiftExternalSchema)element) : (basicElement instanceof RedshiftExternalTable ? (BaseCreatingGenerator.CreateProducer)new RsCreateExternalTable((RedshiftExternalTable)element) : (basicElement instanceof RedshiftTable ? (BaseCreatingGenerator.CreateProducer)new RsCreateTable((RedshiftTable)element) : (basicElement instanceof BasicLikeColumn ? (BaseCreatingGenerator.CreateProducer)new RsCreateLikeColumn((BasicLikeColumn)element) : super.createProducer(element)))));
    }

    @Override
    @Nullable
    protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        Object object = f.getVolatilityKind();
        if (object != null && (object = object.name()) != null) {
            Object object2;
            Object object3 = object2 = object;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object3).toLowerCase();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "external table" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.EXTERNAL_SCHEMA) ? "external schema" : super.elementKindNameForCreate(element));
    }

    @Override
    @Nullable
    protected String makeColumnDefinition(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String string = super.makeColumnDefinition(column2);
        if (string == null) {
            return null;
        }
        String def2 = string;
        StringBuilder b = new StringBuilder();
        if (!(column2 instanceof RedshiftTableColumn)) {
            return def2 + b;
        }
        if (!RedshiftModelFunKt.isDefaultEncoding((RedshiftTableColumn)column2)) {
            b.append(" encode " + ((RedshiftTableColumn)column2).getEncoding());
        }
        if (((RedshiftTableColumn)column2).isDistKey()) {
            b.append(" distkey");
        }
        return def2 + b;
    }

    public RedshiftCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(RedshiftCreatingGenerator $this) {
        return $this.getBuilder();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator$RsCreateUser;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/redshift/RedshiftUser;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;Lcom/intellij/database/model/redshift/RedshiftUser;)V", "produce", "", "intellij.database.scripting"})
    private final class RsCreateUser
    extends BaseCreatingGenerator.CreateProducer<RedshiftUser> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(RedshiftCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ RsCreateUser this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this).phrase("create", "user", RsCreateUser.access$nameScr(this.this$0), "password", "disable");
                    CodeTextBuilder this_$iv = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String validUntil;
                        if (((RedshiftUser)this.this$0.getElement()).isCreateDb()) {
                            CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this), "createdb", null, false, null, 14, null);
                        }
                        if (((RedshiftUser)this.this$0.getElement()).isSuperUser()) {
                            CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this), "createuser", null, false, null, 14, null);
                        }
                        if (((RedshiftUser)this.this$0.getElement()).getConnectionLimit() >= 0L) {
                            CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this), "connection limit " + ((RedshiftUser)this.this$0.getElement()).getConnectionLimit(), null, false, null, 14, null);
                        }
                        if ((validUntil = ((RedshiftUser)this.this$0.getElement()).getValidUntil()) != null) {
                            CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this), "valid until " + RedshiftCreatingGenerator.access$getSqlString$p(this.this$0.RedshiftCreatingGenerator.this, validUntil), null, false, null, 14, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = rsCreateUser;
                    super(0);
                }
            }, 3, null);
            for (String param : ((RedshiftUser)this.getElement()).getConfig()) {
                AbstractCodeGenerator.coding$default(RedshiftCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, param){
                    final /* synthetic */ RsCreateUser this$0;
                    final /* synthetic */ String $param;

                    public final void invoke() {
                        RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this).phrase("alter", "user", RsCreateUser.access$nameScr(this.this$0), "set", this.$param);
                    }
                    {
                        this.this$0 = rsCreateUser;
                        this.$param = string;
                        super(0);
                    }
                }, 3, null);
            }
        }

        public RsCreateUser(RedshiftUser element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)RedshiftCreatingGenerator.this, (BasicElement)element);
        }

        @Nullable
        public static final /* synthetic */ String access$nameScr(RsCreateUser $this) {
            return $this.nameScr();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator$RsCreateExternalSchema;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/redshift/RedshiftExternalSchema;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;Lcom/intellij/database/model/redshift/RedshiftExternalSchema;)V", "produce", "", "intellij.database.scripting"})
    private final class RsCreateExternalSchema
    extends BaseCreatingGenerator.CreateProducer<RedshiftExternalSchema> {
        @Override
        public void produce() {
            if (((RedshiftExternalSchema)this.getElement()).getDatabase() == null) {
                return;
            }
            if (((RedshiftExternalSchema)this.getElement()).getIamRole() == null) {
                return;
            }
            AbstractCodeGenerator.coding$default(RedshiftCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ RsCreateExternalSchema this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    charSequenceArray[0] = "create";
                    charSequenceArray[1] = this.this$0.RedshiftCreatingGenerator.this.elementKindNameForCreate((BasicElement)this.this$0.getElement());
                    RedshiftCreatingGenerator redshiftCreatingGenerator = this.this$0.RedshiftCreatingGenerator.this;
                    ObjectKind objectKind = ObjectKind.EXTERNAL_SCHEMA;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.EXTERNAL_SCHEMA");
                    charSequenceArray[2] = redshiftCreatingGenerator.ifNotExists(objectKind);
                    charSequenceArray[3] = RsCreateExternalSchema.access$nameScr(this.this$0);
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this), "from", null, ((RedshiftExternalSchema)this.this$0.getElement()).getSchemaKind() != 2, null, 10, null);
                    if (((RedshiftExternalSchema)this.this$0.getElement()).getSchemaKind() == 2) {
                        RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this).phrase(" ", "hive", "metastore");
                    }
                    CodeTextBuilder codeTextBuilder2 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                    CharSequence[] charSequenceArray2 = new CharSequence[2];
                    charSequenceArray2[0] = "database";
                    RedshiftCreatingGenerator redshiftCreatingGenerator2 = this.this$0.RedshiftCreatingGenerator.this;
                    String string = ((RedshiftExternalSchema)this.this$0.getElement()).getDatabaseName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.databaseName!!");
                    charSequenceArray2[1] = RedshiftCreatingGenerator.access$getSqlString$p(redshiftCreatingGenerator2, string);
                    codeTextBuilder2.phrase(charSequenceArray2);
                    CodeTextBuilder this_$iv = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((RedshiftExternalSchema)this.this$0.getElement()).getRegion() != null) {
                            CodeTextBuilder codeTextBuilder3 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                            CharSequence[] charSequenceArray3 = new CharSequence[2];
                            charSequenceArray3[0] = "region";
                            RedshiftCreatingGenerator redshiftCreatingGenerator3 = this.this$0.RedshiftCreatingGenerator.this;
                            String string2 = ((RedshiftExternalSchema)this.this$0.getElement()).getRegion();
                            if (string2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.region!!");
                            charSequenceArray3[1] = RedshiftCreatingGenerator.access$getSqlString$p(redshiftCreatingGenerator3, string2);
                            codeTextBuilder3.phrase(charSequenceArray3);
                        }
                        if (((RedshiftExternalSchema)this.this$0.getElement()).getUri() != null) {
                            CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this), "uri ", null, false, null, 10, null);
                            CodeTextBuilder codeTextBuilder4 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                            RedshiftCreatingGenerator redshiftCreatingGenerator4 = this.this$0.RedshiftCreatingGenerator.this;
                            String string3 = ((RedshiftExternalSchema)this.this$0.getElement()).getUri();
                            if (string3 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.uri!!");
                            CodeTextBuilder.append$default(codeTextBuilder4, RedshiftCreatingGenerator.access$getSqlString$p(redshiftCreatingGenerator4, string3), null, ((RedshiftExternalSchema)this.this$0.getElement()).getPort() == null, null, 10, null);
                            if (((RedshiftExternalSchema)this.this$0.getElement()).getPort() != null) {
                                RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this).phrase("port", ((RedshiftExternalSchema)this.this$0.getElement()).getPort());
                            }
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder codeTextBuilder5 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0.RedshiftCreatingGenerator.this);
                    CharSequence[] charSequenceArray4 = new CharSequence[2];
                    charSequenceArray4[0] = "iam_role";
                    RedshiftCreatingGenerator redshiftCreatingGenerator5 = this.this$0.RedshiftCreatingGenerator.this;
                    String string4 = ((RedshiftExternalSchema)this.this$0.getElement()).getIamRole();
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"element.iamRole!!");
                    charSequenceArray4[1] = RedshiftCreatingGenerator.access$getSqlString$p(redshiftCreatingGenerator5, string4);
                    codeTextBuilder5.phrase(charSequenceArray4);
                }
                {
                    this.this$0 = rsCreateExternalSchema;
                    super(0);
                }
            }, 3, null);
            if (((RedshiftExternalSchema)this.getElement()).getComment() != null) {
                RedshiftCreatingGenerator.this.generateComment(this.getElement());
            }
        }

        public RsCreateExternalSchema(RedshiftExternalSchema element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)RedshiftCreatingGenerator.this, (BasicElement)element);
        }

        @Nullable
        public static final /* synthetic */ String access$nameScr(RsCreateExternalSchema $this) {
            return $this.nameScr();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator$RsCreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "(Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;Lcom/intellij/database/model/basic/BasicLikeColumn;)V", "produce", "", "intellij.database.scripting"})
    private final class RsCreateLikeColumn
    extends BaseCreatingGenerator.CreateLikeColumn {
        @Override
        public void produce() {
            if (!(this.getElement() instanceof RedshiftExternalTableColumn) || ((RedshiftExternalTableColumn)this.getElement()).getPartitionKeyOrder() == 0) {
                super.produce();
            }
        }

        public RsCreateLikeColumn(BasicLikeColumn element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator$RsCreateTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTable;", "Lcom/intellij/database/model/redshift/RedshiftTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;Lcom/intellij/database/model/redshift/RedshiftTable;)V", "localTableFooter", "", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "intellij.database.scripting"})
    private final class RsCreateTable
    extends BaseCreatingGenerator.CreateTable<RedshiftTable> {
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter() {
            return new HeaderFooter(super.makeTableHeaderFooter().getHeader(), this.localTableFooter());
        }

        /*
         * WARNING - void declaration
         */
        private final String localTableFooter() {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            RedshiftTableDistStyle style;
            StringBuilder sb = new StringBuilder();
            if (Intrinsics.areEqual((Object)((Object)((RedshiftTable)this.getElement()).getBackupMode()), (Object)((Object)RedshiftTableBackupMode.ON)) ^ true) {
                sb.append("backup no\n");
            }
            if (Intrinsics.areEqual((Object)((Object)(style = ((RedshiftTable)this.getElement()).getDistStyle())), (Object)((Object)RedshiftTableDistStyle.EVEN)) ^ true) {
                String string = style.name();
                StringBuilder stringBuilder = new StringBuilder().append("diststyle ");
                StringBuilder stringBuilder2 = sb;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                stringBuilder2.append(stringBuilder.append(string4).append('\n').toString());
            }
            PositioningNamingFamily<? extends RedshiftTableColumn> positioningNamingFamily = ((RedshiftTable)this.getElement()).getColumns();
            Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
            Iterable iterable = $receiver$iv = (Iterable)positioningNamingFamily;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                RedshiftTableColumn it;
                RedshiftTableColumn redshiftTableColumn = it = (RedshiftTableColumn)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)redshiftTableColumn, (String)"it");
                if (!(redshiftTableColumn.getSortKeyOrder() != 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    RedshiftTableColumn it;
                    RedshiftTableColumn redshiftTableColumn = it = (RedshiftTableColumn)a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)redshiftTableColumn, (String)"it");
                    it = (RedshiftTableColumn)b;
                    Comparable comparable = Integer.valueOf(Math.abs(redshiftTableColumn.getSortKeyOrder()));
                    RedshiftTableColumn redshiftTableColumn2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)redshiftTableColumn2, (String)"it");
                    Integer n = Math.abs(redshiftTableColumn2.getSortKeyOrder());
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            List sortedColumns = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)comparator);
            if (sortedColumns.isEmpty()) {
                String string = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
                return string;
            }
            if (RedshiftModelFunKt.hasInterleavedSortKey((RedshiftTable)this.getElement())) {
                sb.append("interleaved ");
            }
            sb.append("sortkey(");
            $receiver$iv = sortedColumns;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void col;
                Object element$iv$iv;
                int n = index$iv++;
                element$iv$iv = (RedshiftTableColumn)item$iv;
                int idx = n;
                if (idx != 0) {
                    sb.append(", ");
                }
                void v6 = col;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"col");
                sb.append(v6.getName());
            }
            sb.append(")\n");
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        public RsCreateTable(RedshiftTable element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)RedshiftCreatingGenerator.this, (BasicTable)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J \u0010\t\u001a\u0004\u0018\u00010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator$RsCreateExternalTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTable;", "Lcom/intellij/database/model/redshift/RedshiftExternalTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;Lcom/intellij/database/model/redshift/RedshiftExternalTable;)V", "externalTableFooter", "", "externalTableHeader", "findProperty", "properties", "", "key", "generateRowFormat", "table", "fieldDelimiter", "generateSerDeRowFormat", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "intellij.database.scripting"})
    private final class RsCreateExternalTable
    extends BaseCreatingGenerator.CreateTable<RedshiftExternalTable> {
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter() {
            return new HeaderFooter(this.externalTableHeader(), this.externalTableFooter());
        }

        /*
         * WARNING - void declaration
         */
        private final String externalTableHeader() {
            void $receiver$iv;
            void this_$iv;
            String[] stringArray = new String[3];
            ObjectKind objectKind = ((RedshiftExternalTable)this.getElement()).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
            stringArray[0] = RedshiftCreatingGenerator.this.createOrReplace(objectKind);
            stringArray[1] = RedshiftCreatingGenerator.this.elementKindNameForCreate((BasicElement)this.getElement());
            StringBuilder stringBuilder = new StringBuilder().append("");
            String string = ((RedshiftExternalTable)this.getElement()).getSchemaName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.schemaName!!");
            String string2 = string;
            RedshiftCreatingGenerator redshiftCreatingGenerator = RedshiftCreatingGenerator.this;
            StringBuilder stringBuilder2 = stringBuilder;
            int n = 2;
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
            StringBuilder stringBuilder3 = stringBuilder2.append(string3).append('.');
            String string4 = this.nameScr();
            if (string4 == null) {
                string4 = "???";
            }
            stringArray2[n] = stringBuilder3.append(string4).toString();
            return ScriptingUtilsKt.phrase(stringArray3);
        }

        private final String externalTableFooter() {
            Iterable $receiver$iv;
            boolean hasNullStorageFormats;
            boolean unknownStorage;
            block10: {
                boolean bl;
                unknownStorage = Intrinsics.areEqual((Object)((Object)((RedshiftExternalTable)this.getElement()).getStorageType()), (Object)((Object)RedshiftExternalTableStorageType.UNKNOWN));
                for (String string : new String[]{((RedshiftExternalTable)this.getElement()).getInputFormat(), ((RedshiftExternalTable)this.getElement()).getOutputFormat(), ((RedshiftExternalTable)this.getElement()).getLocation()}) {
                    String it = string;
                    if (!(it == null)) continue;
                    bl = true;
                    break block10;
                }
                bl = hasNullStorageFormats = false;
            }
            if (unknownStorage && hasNullStorageFormats) {
                return "-- unable to generate footer: broken storage attributes";
            }
            StringBuilder sb = new StringBuilder();
            PositioningNamingFamily<? extends RedshiftExternalTableColumn> positioningNamingFamily = ((RedshiftExternalTable)this.getElement()).getColumns();
            Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
            Iterable iterable = $receiver$iv = (Iterable)positioningNamingFamily;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : iterable) {
                RedshiftExternalTableColumn it;
                RedshiftExternalTableColumn redshiftExternalTableColumn = it = (RedshiftExternalTableColumn)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn, (String)"it");
                if (!(redshiftExternalTableColumn.getPartitionKeyOrder() != 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Iterable iterable2 = $receiver$iv;
            Object object = new Comparator<T>(){

                public final int compare(T a, T b) {
                    RedshiftExternalTableColumn it;
                    RedshiftExternalTableColumn redshiftExternalTableColumn = it = (RedshiftExternalTableColumn)a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn, (String)"it");
                    it = (RedshiftExternalTableColumn)b;
                    Comparable comparable = Integer.valueOf(redshiftExternalTableColumn.getPartitionKeyOrder());
                    RedshiftExternalTableColumn redshiftExternalTableColumn2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn2, (String)"it");
                    Integer n = redshiftExternalTableColumn2.getPartitionKeyOrder();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            List partitionKeys = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)object);
            if (!($receiver$iv = (Collection)partitionKeys).isEmpty()) {
                sb.append("partitioned by (").append(CollectionsKt.joinToString$default((Iterable)partitionKeys, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<RedshiftExternalTableColumn, String>(this){
                    final /* synthetic */ RsCreateExternalTable this$0;

                    @NotNull
                    public final String invoke(RedshiftExternalTableColumn it) {
                        StringBuilder stringBuilder = new StringBuilder().append("");
                        RedshiftCreatingGenerator redshiftCreatingGenerator = this.this$0.RedshiftCreatingGenerator.this;
                        RedshiftExternalTableColumn redshiftExternalTableColumn = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)redshiftExternalTableColumn, (String)"it");
                        StringBuilder stringBuilder2 = stringBuilder.append(AbstractCodeGenerator.quote$default(redshiftCreatingGenerator, redshiftExternalTableColumn, null, 2, null)).append(' ');
                        RedshiftCreatingGenerator redshiftCreatingGenerator2 = this.this$0.RedshiftCreatingGenerator.this;
                        DataType dataType = it.getDataType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"it.dataType");
                        return stringBuilder2.append(redshiftCreatingGenerator2.script(dataType)).toString();
                    }
                    {
                        this.this$0 = rsCreateExternalTable;
                        super(1);
                    }
                }), (int)30, null)).append(")\n");
            }
            List<String> list = ((RedshiftExternalTable)this.getElement()).getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.serdeProperties");
            String fieldDelimiter = this.findProperty(list, "field.delim");
            List<String> list2 = ((RedshiftExternalTable)this.getElement()).getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.serdeProperties");
            String string = this.findProperty(list2, "serialization.format");
            sb.append(Intrinsics.areEqual((Object)((RedshiftExternalTable)this.getElement()).getSerializationLib(), (Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe") && fieldDelimiter != null && Intrinsics.areEqual((Object)fieldDelimiter, (Object)string) ? this.generateRowFormat((RedshiftExternalTable)this.getElement(), fieldDelimiter) : this.generateSerDeRowFormat((RedshiftExternalTable)this.getElement()));
            sb.append("stored as\n");
            if (unknownStorage) {
                StringBuilder stringBuilder = new StringBuilder().append("inputformat ");
                String string2 = ((RedshiftExternalTable)this.getElement()).getInputFormat();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.inputFormat!!");
                StringBuilder stringBuilder2 = sb.append(stringBuilder.append(RedshiftCreatingGenerator.this.getSqlString(string2)).append('\n').toString());
                StringBuilder stringBuilder3 = new StringBuilder().append("outputformat ");
                String string3 = ((RedshiftExternalTable)this.getElement()).getOutputFormat();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.outputFormat!!");
                StringBuilder stringBuilder4 = stringBuilder2.append(stringBuilder3.append(RedshiftCreatingGenerator.this.getSqlString(string3)).append('\n').toString());
                StringBuilder stringBuilder5 = new StringBuilder().append("location ");
                String string4 = ((RedshiftExternalTable)this.getElement()).getLocation();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"element.location!!");
                stringBuilder4.append(stringBuilder5.append(RedshiftCreatingGenerator.this.getSqlString(string4)).append('\n').toString());
            } else {
                sb.append("" + ((RedshiftExternalTable)this.getElement()).getStorageType().getSqlDefinition() + '\n');
            }
            List<String> list3 = ((RedshiftExternalTable)this.getElement()).getProps();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"element.props");
            object = list3;
            if (!object.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder().append("table properties (");
                List<String> list4 = ((RedshiftExternalTable)this.getElement()).getProps();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"element.props");
                sb.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null)).append(')').toString());
            }
            String string5 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sb.toString()");
            return string5;
        }

        private final String generateRowFormat(RedshiftExternalTable table, String fieldDelimiter) {
            StringBuffer sb = new StringBuffer();
            List<String> list = table.getSerdeProperties();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
            String lineDelimiter = this.findProperty(list, "line.delim");
            sb.append("row format delimited\n").append("fields terminated by '" + fieldDelimiter + "'\n");
            if (lineDelimiter != null) {
                sb.append("lines terminated by '" + fieldDelimiter + "'\n");
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private final String generateSerDeRowFormat(RedshiftExternalTable table) {
            StringBuilder sb = new StringBuilder();
            sb.append("row format serde '" + table.getSerializationLib() + "'\n");
            if (!table.getSerdeProperties().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder().append("with serdeproperties(");
                List<String> list = table.getSerdeProperties();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
                sb.append(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append(")\n").toString());
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String findProperty(List<String> properties, String key2) {
            Iterator iterator;
            block5: {
                Iterable iterable;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable2 = $receiver$iv = (Iterable)properties;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void $receiver$iv$iv2;
                    Iterable $receiver$iv2;
                    void s;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    List list = StringUtil.splitHonorQuotes((String)s, (char)'=');
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"StringUtil.splitHonorQuotes(s, '=')");
                    Iterable iterable3 = $receiver$iv2 = (Iterable)list;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (Object item$iv$iv2 : $receiver$iv$iv2) {
                        void var16_16;
                        void it;
                        String string2 = (String)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                        void v1 = var16_16;
                        if (v1 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        String string3 = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString(), (char)'\'');
                        collection2.add(string3);
                    }
                    List list2 = (List)destination$iv$iv2;
                    collection.add(list2);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    List it = (List)element$iv$iv;
                    if (!(it.size() == 2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                iterable2 = iterable = (Iterable)((List)destination$iv$iv);
                for (Iterator iterator2 : iterable2) {
                    List it = (List)((Object)iterator2);
                    if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first((List)it)), (Object)key2)) continue;
                    iterator = iterator2;
                    break block5;
                }
                iterator = null;
            }
            List list = (List)((Object)iterator);
            return list != null ? (String)CollectionsKt.last((List)list) : null;
        }

        public RsCreateExternalTable(RedshiftExternalTable element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)RedshiftCreatingGenerator.this, (BasicTable)element);
        }
    }
}

