/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresAccessMethod;
import com.intellij.database.model.postgres.PostgresAggregate;
import com.intellij.database.model.postgres.PostgresCollation;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresForeignServer;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresForeignTableColumn;
import com.intellij.database.model.postgres.PostgresIndex;
import com.intellij.database.model.postgres.PostgresLikeTrigger;
import com.intellij.database.model.postgres.PostgresLocalTable;
import com.intellij.database.model.postgres.PostgresLocalTableColumn;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRole;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.postgresbase.PostgresBaseAggregate;
import com.intellij.database.model.postgresbase.PostgresBaseDefType;
import com.intellij.database.model.postgresbase.PostgresBaseDefTypeAttribute;
import com.intellij.database.model.postgresbase.PostgresBaseOperator;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresAccessMethodType;
import com.intellij.database.model.properties.PostgresAggregateKind;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingServiceKt;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.postgres.PostgresBaseCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator$PgCreateDefType$WhenMappings;
import com.intellij.database.scripting.postgres.PostgresCreatingGeneratorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u000f789:;<=>?@ABCDEB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u0016\u001a\n\u0012\u0002\b\u00030\u0017R\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\u0015\u0010\u001a\u001a\u00070\u000b\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0019H\u0014J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u001e\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0014J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0019H\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010+\u001a\u0004\u0018\u00010\u000b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0014J\u0012\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020(H\u0014J\u0012\u0010/\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u000200H\u0002J\u001a\u00101\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u00103\u001a\u00020\u000bH\u0002J\u001e\u00104\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00105\u001a\u000206H\u0002\u00a8\u0006F"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "appendOptions", "", "options", "", "", "appendRoutineAttributes", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "appendViewOptions", "view", "Lcom/intellij/database/model/postgresbase/PostgresBaseView;", "commentOperatorStatement", "element", "Lcom/intellij/database/model/postgresbase/PostgresBaseOperator;", "comment", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "Lcom/intellij/database/model/basic/BasicElement;", "currentScopeName", "Lorg/jetbrains/annotations/NotNull;", "op", "elementKindNameForCreate", "floatAttributeName", "", "s", "gatherSequenceIdentityParameters", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateComment", "getVolatilityKind", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "maybeQualified", "schemaName", "name", "optionsToString", "wrap", "", "PgCreateAccessMethod", "PgCreateAggregate", "PgCreateCollation", "PgCreateDefType", "PgCreateDefTypeCheck", "PgCreateForeignDataWrapper", "PgCreateForeignServer", "PgCreateIndex", "PgCreateLikeColumn", "PgCreateOperator", "PgCreateRole", "PgCreateSequence", "PgCreateTable", "PgCreateTrigger", "PgCreateUserMapping", "intellij.database.scripting"})
public final class PostgresCreatingGenerator
extends PostgresBaseCreatingGenerator {
    @Override
    @NotNull
    public BaseCreatingGenerator.CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof PostgresRole ? (BaseCreatingGenerator.CreateProducer)new PgCreateRole((PostgresRole)element) : (basicElement instanceof PostgresDefType ? (BaseCreatingGenerator.CreateProducer)new PgCreateDefType((PostgresDefType)element) : (basicElement instanceof PostgresDefTypeCheck ? (BaseCreatingGenerator.CreateProducer)new PgCreateDefTypeCheck((PostgresDefTypeCheck)element) : (basicElement instanceof PostgresOperator ? (BaseCreatingGenerator.CreateProducer)new PgCreateOperator((PostgresOperator)element) : (basicElement instanceof PostgresAccessMethod ? (BaseCreatingGenerator.CreateProducer)new PgCreateAccessMethod((PostgresAccessMethod)element) : (basicElement instanceof PostgresCollation ? (BaseCreatingGenerator.CreateProducer)new PgCreateCollation((PostgresCollation)element) : (basicElement instanceof PostgresForeignDataWrapper ? (BaseCreatingGenerator.CreateProducer)new PgCreateForeignDataWrapper((PostgresForeignDataWrapper)element) : (basicElement instanceof PostgresForeignServer ? (BaseCreatingGenerator.CreateProducer)new PgCreateForeignServer((PostgresForeignServer)element) : (basicElement instanceof PostgresUserMapping ? (BaseCreatingGenerator.CreateProducer)new PgCreateUserMapping((PostgresUserMapping)element) : (basicElement instanceof PostgresTable ? (BaseCreatingGenerator.CreateProducer)new PgCreateTable((PostgresTable)element) : (basicElement instanceof PostgresIndex ? (BaseCreatingGenerator.CreateProducer)new PgCreateIndex((PostgresIndex)element) : (basicElement instanceof BasicLikeColumn ? (BaseCreatingGenerator.CreateProducer)new PgCreateLikeColumn((BasicLikeColumn)element) : (basicElement instanceof PostgresLikeTrigger ? (BaseCreatingGenerator.CreateProducer)new PgCreateTrigger((PostgresLikeTrigger)element) : (basicElement instanceof PostgresSequence ? (BaseCreatingGenerator.CreateProducer)new PgCreateSequence((PostgresSequence)element) : (basicElement instanceof PostgresAggregate ? (BaseCreatingGenerator.CreateProducer)new PgCreateAggregate((PostgresAggregate)element) : super.createProducer(element)))))))))))))));
    }

    @Override
    protected void appendViewOptions(@NotNull PostgresBaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (!(view instanceof PostgresView) || Intrinsics.areEqual((Object)((Object)((PostgresView)view).getCheckOption()), (Object)((Object)PostgresCheckOption.NONE))) {
            return;
        }
        CodeTextBuilder.ensureEoln$default(this.getBuilder(), null, 1, null);
        String string = ((PostgresView)view).getCheckOption().name();
        StringBuilder stringBuilder = new StringBuilder().append("with ");
        CodeTextBuilder codeTextBuilder = this.getBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string4).append(" check option").toString(), null, false, null, 14, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void appendOptions(List<String> options) {
        if (options.isEmpty()) {
            return;
        }
        CodeTextBuilder this_$iv = this.getBuilder();
        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
        try {
            CodeTextBuilder.append$default(this.getBuilder(), "options (", null, false, null, 10, null);
        }
        finally {
            this_$iv.unindent();
        }
        Iterable $receiver$iv = options;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void option;
            int n = index$iv++;
            String string = (String)item$iv;
            int idx = n;
            List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            CodeTextBuilder.append$default(this.getBuilder(), (CharSequence)CollectionsKt.first((List)keyValue), null, false, null, 10, null);
            CodeTextBuilder.append$default(this.getBuilder(), " ", null, false, null, 10, null);
            CodeTextBuilder.append$default(this.getBuilder(), '\'' + (String)CollectionsKt.last((List)keyValue) + '\'', null, false, null, 10, null);
            if (idx == options.size() - 1) continue;
            CodeTextBuilder.append$default(this.getBuilder(), ", ", null, false, null, 10, null);
        }
        CodeTextBuilder.append$default(this.getBuilder(), ")", null, false, null, 14, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String optionsToString(List<String> options, boolean wrap) {
        if (options.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(wrap ? "\n" : " ");
        sb.append("options (");
        Iterable $receiver$iv = options;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void option;
            int n = index$iv++;
            String string = (String)item$iv;
            int idx = n;
            List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            sb.append((String)CollectionsKt.first((List)keyValue));
            sb.append(" ");
            sb.append('\'' + (String)CollectionsKt.last((List)keyValue) + '\'');
            if (idx == options.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String maybeQualified(String schemaName, String name) {
        String string;
        String string2;
        String $receiver$iv;
        PostgresCreatingGenerator this_$iv;
        StringBuilder stringBuilder;
        if (this.useSchemaName(schemaName)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = schemaName;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = string3;
            PostgresCreatingGenerator postgresCreatingGenerator = this;
            stringBuilder = stringBuilder2;
            string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
            string = stringBuilder.append(string2).append(".").toString();
        } else {
            string = "";
        }
        String schema = string;
        $receiver$iv = name;
        this_$iv = this;
        stringBuilder = new StringBuilder().append(schema);
        string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
        return stringBuilder.append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendRoutineAttributes(@NotNull PostgresBaseRoutine f) {
        CodeTextBuilder this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        super.appendRoutineAttributes(f);
        PostgresRoutine postgresRoutine = (PostgresRoutine)f;
        if (postgresRoutine.isLeakproof()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "leakproof", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.isWindow()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "window", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.isStrict()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "strict", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (postgresRoutine.isSecurityDefiner()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "security definer", null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (Intrinsics.areEqual((Object)((Object)postgresRoutine.getConcurrencyKind()), (Object)((Object)PostgresRoutineConcurrencyKind.UNSAFE)) ^ true) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder codeTextBuilder = this.getBuilder();
                StringBuilder stringBuilder = new StringBuilder().append("parallel ");
                PostgresRoutineConcurrencyKind postgresRoutineConcurrencyKind = postgresRoutine.getConcurrencyKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)postgresRoutineConcurrencyKind), (String)"postgresRoutine.concurrencyKind");
                CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(postgresRoutineConcurrencyKind.getModifier()).toString(), null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (PostgresModelFun.isCostDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getCost(), "cost") + ' ' + PostgresModelFun.costAsString(postgresRoutine), null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        if (PostgresModelFun.isRowsDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getRows(), "rows") + ' ' + PostgresModelFun.rowsAsString(postgresRoutine), null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
        List<String> configurationParameters = postgresRoutine.getConfigurationParameters();
        for (String configurationParameter : configurationParameters) {
            CodeTextBuilder this_$iv2 = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv2, null, 1, null);
            try {
                this.getBuilder().phrase("SET", configurationParameter);
            }
            finally {
                this_$iv2.unindent();
            }
        }
    }

    private final String floatAttributeName(float f, String s) {
        float f2 = f;
        StringBuilder stringBuilder = new StringBuilder().append("");
        boolean bl = Float.isInfinite(f2);
        return stringBuilder.append(bl ? "--" : "").append("").append(s).toString();
    }

    @Override
    @Nullable
    protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        if (Intrinsics.areEqual((Object)((Object)f.getVolatilityKind()), (Object)((Object)PostgresVolatilityKind.VOLATILE))) {
            string = null;
        } else {
            Object object = f.getVolatilityKind();
            if (object != null && (object = object.name()) != null) {
                Object object2;
                Object object3 = object2 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).toLowerCase();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string = null;
            }
        }
        return string;
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "foreign table" : super.elementKindNameForCreate(element);
    }

    @Override
    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        block5: {
            PostgresSequence postgresSequence;
            PostgresSequence $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            BasicSequence basicSequence = sequence;
            if (!(basicSequence instanceof PostgresSequence)) {
                basicSequence = null;
            }
            PostgresSequence postgresSequence2 = (PostgresSequence)basicSequence;
            if (postgresSequence2 != null && !PostgresModelFun.hasDefaultType($receiver = (postgresSequence = postgresSequence2))) {
                parameters.add("as " + $receiver.getDataType());
            }
            super.gatherSequenceIdentityParameters(sequence, parameters);
            BasicSequence basicSequence2 = sequence;
            if (!(basicSequence2 instanceof PostgresSequence)) {
                basicSequence2 = null;
            }
            PostgresSequence postgresSequence3 = (PostgresSequence)basicSequence2;
            if (postgresSequence3 == null) break block5;
            postgresSequence = postgresSequence3;
            $receiver = postgresSequence;
            if (!PostgresModelFun.hasDefaultCacheSize($receiver)) {
                parameters.add("cache " + $receiver.getCacheSize());
            }
            if ($receiver.isCycled()) {
                parameters.add("cycle");
            }
        }
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return column2 instanceof PostgresLocalTableColumn && ((PostgresLocalTableColumn)column2).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column2) : super.makeNormalColumnSpecification(column2);
    }

    @Override
    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        PostgresTable table;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicElement basicElement = column2.getParent();
        if (!(basicElement instanceof PostgresTable)) {
            basicElement = null;
        }
        PostgresTable postgresTable = table = (PostgresTable)basicElement;
        if (postgresTable != null) {
            if (postgresTable.isPartition()) {
                return "";
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append(super.generalColumnSpecification(column2));
        if (column2 instanceof PostgresForeignTableColumn) {
            List<String> list = ((PostgresForeignTableColumn)column2).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"column.options");
            string = this.optionsToString(list, false);
        } else {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    private final String makeSerialColumnSpecification(PostgresTableColumn column2) {
        String specification;
        String string;
        DataType dt = column2.getDataType();
        String string2 = dt.typeName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dt.typeName");
        if (StringsKt.startsWith$default((String)string2, (String)"small", (boolean)false, (int)2, null)) {
            string = "smallserial";
        } else {
            String string3 = dt.typeName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dt.typeName");
            string = specification = StringsKt.startsWith$default((String)string3, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial";
        }
        if (column2.isNotNull()) {
            specification = specification + " not null";
        }
        return specification;
    }

    @Override
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
    }

    @Override
    protected void generateComment(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicIndex) {
            this.commentStatement(element, "index");
        } else if (basicElement instanceof PostgresAccessMethod) {
            this.commentStatement(element, "access method");
        } else if (basicElement instanceof PostgresForeignServer) {
            this.commentStatement(element, "server");
        } else if (basicElement instanceof PostgresForeignDataWrapper) {
            this.commentStatement(element, "foreign data wrapper");
        } else if (basicElement instanceof PostgresBaseOperator) {
            this.commentOperatorStatement((PostgresBaseOperator)element, ((PostgresBaseOperator)element).getComment());
        } else if (basicElement instanceof PostgresBaseDefType) {
            this.commentStatement(element, "type");
        } else if (basicElement instanceof PostgresBaseDefTypeAttribute) {
            this.commentStatement(element, "column");
        } else if (basicElement instanceof PostgresRule) {
            PostgresBaseCreatingGenerator.commentInner$default(this, (BasicNamedElement)element, "rule", null, 4, null);
        } else if (basicElement instanceof PostgresRole) {
            this.commentStatement(element, "role");
        } else if (basicElement instanceof PostgresDefTypeCheck) {
            this.commentInner((BasicNamedElement)element, "constraint", "domain");
        } else if (basicElement instanceof PostgresSequence) {
            this.commentStatement(element, "sequence");
        } else if (basicElement instanceof PostgresAggregate) {
            this.commentAggregateStatement((PostgresBaseAggregate)element);
        } else if (basicElement instanceof BasicTrigger) {
            PostgresBaseCreatingGenerator.commentInner$default(this, (BasicNamedElement)element, "trigger", null, 4, null);
        } else {
            super.generateComment(element);
        }
    }

    public final void commentOperatorStatement(@NotNull PostgresBaseOperator element, @Nullable String comment) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this, element, comment){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresBaseOperator $element;
            final /* synthetic */ String $comment;

            public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                String string;
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.minus($receiver.plus($receiver.unaryPlus("comment on operator"), PostgresCreatingGenerator.access$currentScopeName(this.this$0, this.$element)), "(");
                if (Intrinsics.areEqual((Object)this.$element.getLeftType(), (Object)DataType.UNKNOWN)) {
                    string2 = "none";
                } else {
                    DataType dataType = this.$element.getLeftType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"element.leftType");
                    string2 = this.this$0.script(dataType);
                }
                $receiver.unaryMinus(string2);
                $receiver.unaryPlus(",");
                if (Intrinsics.areEqual((Object)this.$element.getRightType(), (Object)DataType.UNKNOWN)) {
                    string = "none";
                } else {
                    DataType dataType = this.$element.getRightType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"element.rightType");
                    string = this.this$0.script(dataType);
                }
                $receiver.unaryPlus(string);
                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.plus($receiver.unaryMinus(")"), "is");
                String string3 = this.$comment;
                if (string3 == null) {
                    string3 = "";
                }
                $receiver.plus(newCodingAdapter, PostgresCreatingGenerator.access$getSqlString$p(this.this$0, string3));
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$element = postgresBaseOperator;
                this.$comment = string;
                super(1);
            }
        }));
    }

    private final String currentScopeName(PostgresBaseOperator op) {
        return op.getName();
    }

    public PostgresCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(PostgresCreatingGenerator $this, @NotNull BasicElement $receiver, @Nullable String renameScr) {
        return $this.currentScopeName($receiver, renameScr);
    }

    @NotNull
    public static final /* synthetic */ String access$getSqlString$p(PostgresCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getSqlString($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$maybeQualified(PostgresCreatingGenerator $this, @Nullable String schemaName, @NotNull String name) {
        return $this.maybeQualified(schemaName, name);
    }

    public static final /* synthetic */ void access$appendOptions(PostgresCreatingGenerator $this, @NotNull List options) {
        $this.appendOptions(options);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateAggregate;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresAggregate;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresAggregate;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateAggregate
    extends BaseCreatingGenerator.CreateProducer<PostgresAggregate> {
        @Override
        public void produce() {
            String name = AbstractCodeGenerator.currentScopeName$default(PostgresCreatingGenerator.this, this.getElement(), null, 1, null);
            String definition = PostgresCreatingGeneratorKt.aggregateArgumentsDefinition(PostgresCreatingGenerator.this, (PostgresAggregate)this.getElement());
            Function2<Long, String, String> getName$ = new Function2<Long, String, String>(this){
                final /* synthetic */ PgCreateAggregate this$0;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @Nullable
                public final String invoke(long id, @Nullable String text) {
                    block7: {
                        block6: {
                            v0 = ((PostgresAggregate)this.this$0.getElement()).getSchema();
                            if (v0 == null) break block6;
                            $receiver$iv = (BasicSchema)v0;
                            v1 /* !! */  = $receiver$iv.getDatabase();
                            if (v1 /* !! */  == null) ** GOTO lbl-1000
                            $receiver$iv$iv = v1 /* !! */ ;
                            v2 /* !! */  = $receiver$iv$iv.findIdentifiedElement(id);
                            if (!(v2 /* !! */  instanceof BasicIdentifiedElement)) {
                                v2 /* !! */  = v1 /* !! */  = null;
                            }
                            if (v2 /* !! */  != null) {
                                $receiver$iv$iv = v1 /* !! */ ;
                                v3 = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = v0 = null;
                            }
                            if (v3 != null && (v0 = AbstractCodeGenerator.currentScopeName$default(this.this$0.PostgresCreatingGenerator.this, (BasicElement)v0, null, 1, null)) != null) break block7;
                        }
                        v0 = text;
                    }
                    return v0;
                }
                {
                    this.this$0 = pgCreateAggregate;
                    super(2);
                }
            };
            PostgresCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this, name, definition, getName$){
                final /* synthetic */ PgCreateAggregate this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $definition;
                final /* synthetic */ produce.1 $getName$1;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    block21: {
                        block20: {
                            block23: {
                                block22: {
                                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                                    this_$iv = $receiver;
                                    nl$iv = true;
                                    prev$iv = this_$iv.getStartWithNewLine();
                                    this_$iv.setStartWithNewLine(nl$iv);
                                    v0 = this.this$0.PostgresCreatingGenerator.this;
                                    v1 = ((PostgresAggregate)this.this$0.getElement()).getKind();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"element.kind");
                                    $receiver.minus($receiver.minus($receiver.minus($receiver.plus($receiver.plus($receiver.unaryPlus(v0.createOrReplace(v1)), "aggregate"), this.$name), "("), this.$definition), ") (");
                                    $receiver.unaryPlus("sfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getTransitionId(), ((PostgresAggregate)this.this$0.getElement()).getTransition()));
                                    this_$iv = $receiver;
                                    separator$iv = ',';
                                    prev$iv = this_$iv.getSeparator();
                                    this_$iv.setSeparator(Character.valueOf(separator$iv));
                                    v2 = new StringBuilder().append("stype = ");
                                    v3 = this.this$0.PostgresCreatingGenerator.this;
                                    v4 = ((PostgresAggregate)this.this$0.getElement()).getTransitionDataType();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"element.transitionDataType");
                                    $receiver.unaryPlus(v2.append(v3.script(v4)).toString());
                                    if (((PostgresAggregate)this.this$0.getElement()).getStateSize() != 0L) {
                                        $receiver.unaryPlus("sspace = " + ((PostgresAggregate)this.this$0.getElement()).getStateSize());
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getFinalId() != 0L) {
                                        $receiver.unaryPlus("finalfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getFinalId(), ((PostgresAggregate)this.this$0.getElement()).getFinal()));
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).isFinalExtra()) {
                                        $receiver.unaryPlus("finalfunc_extra");
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getCombineId() != 0L) {
                                        $receiver.unaryPlus("combinefunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getCombineId(), ((PostgresAggregate)this.this$0.getElement()).getCombine()));
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getSerializationId() != 0L) {
                                        $receiver.unaryPlus("serialfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getSerializationId(), ((PostgresAggregate)this.this$0.getElement()).getSerialization()));
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getDeserializationId() != 0L) {
                                        $receiver.unaryPlus("deserialfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getDeserializationId(), ((PostgresAggregate)this.this$0.getElement()).getDeserialization()));
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getInitialValue() != null) {
                                        $receiver.unaryPlus("initcond = '" + ((PostgresAggregate)this.this$0.getElement()).getInitialValue() + '\'');
                                    }
                                    if (Intrinsics.areEqual((Object)((PostgresAggregate)this.this$0.getElement()).getConcurrencyKind(), (Object)PostgresRoutineConcurrencyKind.UNSAFE) ^ true) {
                                        v5 = new StringBuilder().append("parallel = ");
                                        v6 = ((PostgresAggregate)this.this$0.getElement()).getConcurrencyKind();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"element.concurrencyKind");
                                        $receiver.unaryPlus(v5.append(v6.getModifier()).toString());
                                    }
                                    if (!Intrinsics.areEqual((Object)((PostgresAggregate)this.this$0.getElement()).getAggregateKind(), (Object)PostgresAggregateKind.NORMAL)) break block20;
                                    if (((PostgresAggregate)this.this$0.getElement()).getMovingTransitionId() != 0L) {
                                        $receiver.unaryPlus("msfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getMovingTransitionId(), ((PostgresAggregate)this.this$0.getElement()).getMovingTransition()));
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getInverseTransitionId() != 0L) {
                                        $receiver.unaryPlus("minvfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getInverseTransitionId(), ((PostgresAggregate)this.this$0.getElement()).getInverseTransition()));
                                    }
                                    if (Intrinsics.areEqual((Object)((PostgresAggregate)this.this$0.getElement()).getMovingStateType(), (Object)DataType.UNKNOWN) ^ true) {
                                        v7 = new StringBuilder().append("mstype = ");
                                        v8 = this.this$0.PostgresCreatingGenerator.this;
                                        v9 = ((PostgresAggregate)this.this$0.getElement()).getMovingStateType();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"element.movingStateType");
                                        $receiver.unaryPlus(v7.append(v8.script(v9)).toString());
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getMovingStateSize() != 0L) {
                                        $receiver.unaryPlus("msspace = " + ((PostgresAggregate)this.this$0.getElement()).getMovingStateSize());
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getMovingFinalId() != 0L) {
                                        $receiver.unaryPlus("mfinalfunc = " + this.$getName$1.invoke(((PostgresAggregate)this.this$0.getElement()).getMovingFinalId(), ((PostgresAggregate)this.this$0.getElement()).getMovingFinal()));
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).isMovingFinalExtra()) {
                                        $receiver.unaryPlus("mfinalfunc_extra");
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getMovingInitialValue() != null) {
                                        $receiver.unaryPlus("minitcond = '" + ((PostgresAggregate)this.this$0.getElement()).getMovingInitialValue() + '\'');
                                    }
                                    if (((PostgresAggregate)this.this$0.getElement()).getSortOperatorId() == 0L) break block21;
                                    v10 = ((PostgresAggregate)this.this$0.getElement()).getSchema();
                                    if (v10 == null) break block22;
                                    var9_8 = v10;
                                    objectId$iv = ((PostgresAggregate)this.this$0.getElement()).getSortOperatorId();
                                    v11 /* !! */  = $receiver$iv.getDatabase();
                                    if (v11 /* !! */  == null) ** GOTO lbl-1000
                                    $receiver$iv$iv = v11 /* !! */ ;
                                    v12 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                                    if (!(v12 instanceof PostgresOperator)) {
                                        v12 = null;
                                    }
                                    if ((v11 /* !! */  = (PostgresOperator)v12) != null) {
                                        $receiver$iv$iv = v11 /* !! */ ;
                                        v13 = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v13 = null;
                                    }
                                    break block23;
                                }
                                v13 = null;
                            }
                            operator = v13;
                            v14 = new StringBuilder().append("sortop = operator(");
                            v15 = operator;
                            if (v15 == null || (v15 = PostgresCreatingGenerator.access$currentScopeName(this.this$0.PostgresCreatingGenerator.this, (BasicElement)v15, operator.getRealName())) == null) {
                                v15 = ((PostgresAggregate)this.this$0.getElement()).getSortOperator();
                            }
                            $receiver.unaryPlus(v14.append(v15).append(')').toString());
                            break block21;
                        }
                        if (Intrinsics.areEqual((Object)((PostgresAggregate)this.this$0.getElement()).getAggregateKind(), (Object)PostgresAggregateKind.HYPO_SET)) {
                            $receiver.unaryPlus("hypothetical");
                        }
                    }
                    this_$iv.setSeparator(prev$iv);
                    $receiver.unaryPlus(")");
                    this_$iv.setStartWithNewLine(prev$iv);
                }
                {
                    this.this$0 = pgCreateAggregate;
                    this.$name = string;
                    this.$definition = string2;
                    this.$getName$1 = var4_4;
                    super(1);
                }
            }));
            if (((PostgresAggregate)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        public PgCreateAggregate(PostgresAggregate element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateRole;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresRole;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresRole;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateRole
    extends BaseCreatingGenerator.CreateProducer<PostgresRole> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateRole this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "create " + (((PostgresRole)this.this$0.getElement()).isCanLogin() ? "user" : "role") + ' ' + PgCreateRole.access$nameScr(this.this$0), null, false, null, 14, null);
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((PostgresRole)this.this$0.getElement()).isSuperRole()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "superuser", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isCreateDb()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "createdb", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isCreateRole()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "createrole", null, false, null, 14, null);
                        }
                        if (!((PostgresRole)this.this$0.getElement()).isInherit()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "noinherit", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isReplication()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "replication", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).isBypassRls()) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "bypassrls", null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).getConnectionLimit() >= 0L) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "connection limit " + ((PostgresRole)this.this$0.getElement()).getConnectionLimit(), null, false, null, 14, null);
                        }
                        if (((PostgresRole)this.this$0.getElement()).getValidUntil() != null) {
                            CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                            StringBuilder stringBuilder = new StringBuilder().append("valid until ");
                            PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                            String string = ((PostgresRole)this.this$0.getElement()).getValidUntil();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.validUntil!!");
                            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(PostgresCreatingGenerator.access$getSqlString$p(postgresCreatingGenerator, string)).toString(), null, false, null, 14, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = pgCreateRole;
                    super(0);
                }
            }, 3, null);
            if (((PostgresRole)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        public PgCreateRole(PostgresRole element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }

        @Nullable
        public static final /* synthetic */ String access$nameScr(PgCreateRole $this) {
            return $this.nameScr();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateIndex;", "Lcom/intellij/database/model/postgres/PostgresIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresIndex;)V", "produce", "", "qualifyName", "", "intellij.database.scripting"})
    private final class PgCreateIndex
    extends BaseCreatingGenerator.CreateIndex<PostgresIndex> {
        @Override
        public boolean qualifyName() {
            return false;
        }

        @Override
        public void produce() {
            super.produce();
            if (((PostgresIndex)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        public PgCreateIndex(PostgresIndex element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicIndex)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateDefType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresDefType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresDefType;)V", "generateComposite", "", "generateDomain", "generateEnum", "produce", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class PgCreateDefType
    extends BaseCreatingGenerator.CreateProducer<PostgresDefType> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            NamingIdentifyingFamily<? extends PostgresDefTypeCheck> namingIdentifyingFamily = ((PostgresDefType)this.getElement()).getChecks();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"element.checks");
            Iterable $receiver$iv = namingIdentifyingFamily;
            for (Object element$iv : $receiver$iv) {
                PostgresDefTypeCheck it;
                PostgresDefTypeCheck postgresDefTypeCheck = it = (PostgresDefTypeCheck)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeCheck, (String)"it");
                PostgresCreatingGenerator.this.prepareElement(postgresDefTypeCheck, $receiver, true);
            }
            return operation;
        }

        @Override
        public void produce() {
            switch (PostgresCreatingGenerator$PgCreateDefType$WhenMappings.$EnumSwitchMapping$0[((PostgresDefType)this.getElement()).getSubKind().ordinal()]) {
                case 1: {
                    this.generateEnum();
                    break;
                }
                case 2: {
                    this.generateDomain();
                    break;
                }
                case 3: {
                    this.generateComposite();
                    break;
                }
                default: {
                    PostgresCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                        final /* synthetic */ PgCreateDefType this$0;

                        public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            $receiver.error("Unknown how to generate " + ((PostgresDefType)this.this$0.getElement()).getSubKind().human_readable_name() + " type");
                        }
                        {
                            this.this$0 = pgCreateDefType;
                            super(1);
                        }
                    }));
                }
            }
            if (((PostgresDefType)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
            Iterator<Object> iterator = ((PostgresDefType)this.getElement()).getAttributes().iterator();
            while (iterator.hasNext()) {
                PostgresDefTypeAttribute a;
                PostgresDefTypeAttribute postgresDefTypeAttribute = a = (PostgresDefTypeAttribute)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeAttribute, (String)"a");
                if (postgresDefTypeAttribute.getComment() == null) continue;
                PostgresCreatingGenerator.this.generateComment(a);
            }
            for (Operation op : this.getNestedOperations()) {
                BasicElement basicElement;
                if (ScenarioOperations.element(op) == null) continue;
                BasicElement it = basicElement;
                if (it.getComment() == null) continue;
                PostgresCreatingGenerator.this.generateComment(it);
            }
        }

        private final void generateEnum() {
            String name = this.fqName();
            List<String> list = ((PostgresDefType)this.getElement()).getLabels();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.labels");
            String labels2 = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                final /* synthetic */ PgCreateDefType this$0;

                @NotNull
                public final String invoke(String it) {
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    return PostgresCreatingGenerator.access$getSqlString$p(postgresCreatingGenerator, string);
                }
                {
                    this.this$0 = pgCreateDefType;
                    super(1);
                }
            }), (int)31, null);
            String cmd = "create type " + name + " as enum (" + labels2 + ')';
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreateDefType this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$cmd, null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateDefType;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateDomain() {
            PostgresDefType d = (PostgresDefType)this.getElement();
            String name = this.fqName();
            String def2 = d.getDefinition();
            String cmd = "create domain " + name + " as " + def2 + (d.isNotNull() ? " not null" : "");
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, cmd, d){
                final /* synthetic */ PgCreateDefType this$0;
                final /* synthetic */ String $cmd;
                final /* synthetic */ PostgresDefType $d;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$cmd, null, false, null, 14, null);
                    AbstractCodeGenerator.coding$default(this.this$0.PostgresCreatingGenerator.this, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateDomain.1 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $receiver$iv;
                            if (this.this$0.$d.getDefaultExpression() != null) {
                                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.this$0.PostgresCreatingGenerator.this), "default " + this.this$0.$d.getDefaultExpression(), null, false, null, 14, null);
                            }
                            Iterable iterable = this.this$0.this$0.getNestedOperations();
                            PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.this$0.PostgresCreatingGenerator.this;
                            for (T element$iv : $receiver$iv) {
                                Operation p1 = (Operation)element$iv;
                                postgresCreatingGenerator.produce(p1);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                }
                {
                    this.this$0 = pgCreateDefType;
                    this.$cmd = string;
                    this.$d = postgresDefType;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateComposite() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateDefType this$0;

                public final void invoke() {
                    String name = PgCreateDefType.access$fqName(this.this$0);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "create type " + name + " as", null, false, null, 14, null);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "(", null, false, null, 14, null);
                    CodeTextBuilder.indent$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), null, 1, null);
                    for (PostgresDefTypeAttribute postgresDefTypeAttribute : ((PostgresDefType)this.this$0.getElement()).getAttributes()) {
                        PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                        PostgresDefTypeAttribute postgresDefTypeAttribute2 = postgresDefTypeAttribute;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeAttribute2, (String)"a");
                        String n = AbstractCodeGenerator.quote$default(postgresCreatingGenerator, postgresDefTypeAttribute2, null, 2, null);
                        DataType t = postgresDefTypeAttribute.getDataType();
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "" + n + ' ' + t + ',', null, false, null, 14, null);
                    }
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).removeSuffixFromTheLastLine(',');
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).unindent();
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), ")", null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateDefType;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateDefType(PostgresDefType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(PgCreateDefType $this) {
            return $this.fqName();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateOperator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresOperator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresOperator;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateOperator
    extends BaseCreatingGenerator.CreateProducer<PostgresOperator> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void produce() {
            PostgresOperator op = (PostgresOperator)this.getElement();
            ArrayList<String> props = new ArrayList<String>(4);
            if (op.getCallRoutineName() != null) {
                void $receiver$iv;
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder().append("procedure = ");
                String string = op.getCallRoutineName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"op.callRoutineName!!");
                String string2 = string;
                PostgresCreatingGenerator postgresCreatingGenerator = PostgresCreatingGenerator.this;
                StringBuilder stringBuilder2 = stringBuilder;
                ArrayList<String> arrayList = props;
                String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
                arrayList.add(stringBuilder2.append(string3).toString());
            }
            if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("leftarg = ");
                DataType dataType = op.getLeftType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"op.leftType");
                props.add(stringBuilder.append(dataType.getSpecification()).toString());
            }
            if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("rightarg = ");
                DataType dataType = op.getRightType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"op.rightType");
                props.add(stringBuilder.append(dataType.getSpecification()).toString());
            }
            String specification = CollectionsKt.joinToString$default((Iterable)props, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String cmd = "create operator " + PostgresCreatingGenerator.this.currentScopeName(op) + " (" + specification + ')';
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreateOperator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$cmd, null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateOperator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
            if (((PostgresOperator)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        public PgCreateOperator(PostgresOperator element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateDefTypeCheck;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateDefTypeCheck
    extends BaseCreatingGenerator.CreateProducer<PostgresDefTypeCheck> {
        @Override
        public void produce() {
            String name = this.nameScr();
            String string = ((PostgresDefTypeCheck)this.getElement()).getPredicate();
            if (string == null) {
                return;
            }
            String predicate = string;
            String txt = (name != null ? "constraint " + name + ' ' : "") + "check " + predicate;
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, txt){
                final /* synthetic */ PgCreateDefTypeCheck this$0;
                final /* synthetic */ String $txt;

                public final void invoke() {
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), this.$txt, null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateDefTypeCheck;
                    this.$txt = string;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateDefTypeCheck(PostgresDefTypeCheck element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateAccessMethod;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresAccessMethod;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresAccessMethod;)V", "canComment", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "canCreate", "produce", "", "intellij.database.scripting"})
    private final class PgCreateAccessMethod
    extends BaseCreatingGenerator.CreateProducer<PostgresAccessMethod> {
        @Override
        public void produce() {
            if (((PostgresAccessMethod)this.getElement()).getHandler() == null) {
                return;
            }
            PostgresCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                final /* synthetic */ PgCreateAccessMethod this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Object object;
                    boolean prev$iv;
                    AbstractCodeGenerator.NewCodingAdapter this_$iv;
                    block6: {
                        block5: {
                            void $receiver$iv;
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            this_$iv = $receiver;
                            boolean nl$iv = true;
                            prev$iv = this_$iv.getStartWithNewLine();
                            this_$iv.setStartWithNewLine(nl$iv);
                            $receiver.plus($receiver.unaryPlus("create access method"), AbstractCodeGenerator.currentScopeName$default(this.this$0.PostgresCreatingGenerator.this, this.this$0.getElement(), null, 1, null));
                            if (Intrinsics.areEqual((Object)((Object)((PostgresAccessMethod)this.this$0.getElement()).getType()), (Object)((Object)PostgresAccessMethodType.UNKNOWN)) ^ true) {
                                StringBuilder stringBuilder = new StringBuilder().append("type ");
                                PostgresAccessMethodType postgresAccessMethodType = ((PostgresAccessMethod)this.this$0.getElement()).getType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)postgresAccessMethodType), (String)"element.type");
                                $receiver.unaryPlus(stringBuilder.append(postgresAccessMethodType.getModifier()).toString());
                            }
                            if ((object = ((PostgresAccessMethod)this.this$0.getElement()).getDatabase()) == null) break block5;
                            BasicDatabase basicDatabase = (BasicDatabase)object;
                            long objectId$iv = ((PostgresAccessMethod)this.this$0.getElement()).getHandlerId();
                            BasicIdentifiedElement basicIdentifiedElement = $receiver$iv.findIdentifiedElement(objectId$iv);
                            if (!(basicIdentifiedElement instanceof PostgresRoutine)) {
                                basicIdentifiedElement = null;
                            }
                            if ((object = (PostgresRoutine)basicIdentifiedElement) != null && (object = AbstractCodeGenerator.currentScopeName$default(this.this$0.PostgresCreatingGenerator.this, (BasicElement)object, null, 1, null)) != null) break block6;
                        }
                        object = ((PostgresAccessMethod)this.this$0.getElement()).getHandler();
                    }
                    Object name = object;
                    $receiver.plus($receiver.unaryPlus("handler"), (String)name);
                    this_$iv.setStartWithNewLine(prev$iv);
                }
                {
                    this.this$0 = pgCreateAccessMethod;
                    super(1);
                }
            }));
            if (((PostgresAccessMethod)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        @Override
        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canCreate() {
            Version version = Version.of((int[])new int[]{9, 6});
            Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.of(9, 6)");
            return AbstractScriptingServiceKt.supportedSince(version);
        }

        @Override
        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
            Version version = Version.of((int[])new int[]{9, 6});
            Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.of(9, 6)");
            return AbstractScriptingServiceKt.supportedSince(version);
        }

        public PgCreateAccessMethod(PostgresAccessMethod element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateCollation;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresCollation;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresCollation;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateCollation
    extends BaseCreatingGenerator.CreateProducer<PostgresCollation> {
        @Override
        public void produce() {
            String string = ((PostgresCollation)this.getElement()).getCType();
            if (string == null) {
                return;
            }
            String cType = string;
            String string2 = ((PostgresCollation)this.getElement()).getCollate();
            if (string2 == null) {
                return;
            }
            String collate = string2;
            boolean useLocale = Intrinsics.areEqual((Object)cType, (Object)collate);
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, useLocale, cType, collate){
                final /* synthetic */ PgCreateCollation this$0;
                final /* synthetic */ boolean $useLocale;
                final /* synthetic */ String $cType;
                final /* synthetic */ String $collate;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    charSequenceArray[0] = "create collation";
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    ObjectKind objectKind = ObjectKind.COLLATION;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.COLLATION");
                    charSequenceArray[1] = postgresCreatingGenerator.ifNotExists(objectKind);
                    charSequenceArray[2] = PgCreateCollation.access$fqName(this.this$0);
                    charSequenceArray[3] = "(";
                    codeTextBuilder.phrase(charSequenceArray);
                    if (this.$useLocale) {
                        CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("locale", "=", '\'' + this.$cType + '\'');
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("lc_collate", "=", '\'' + this.$collate + '\'');
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).addSuffixToTheLastLine(',');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("lc_ctype", "=", '\'' + this.$cType + '\'');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), ")", null, false, null, 14, null);
                }
                {
                    this.this$0 = pgCreateCollation;
                    this.$useLocale = bl;
                    this.$cType = string;
                    this.$collate = string2;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateCollation(PostgresCollation element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(PgCreateCollation $this) {
            return $this.fqName();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateForeignDataWrapper;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateForeignDataWrapper
    extends BaseCreatingGenerator.CreateProducer<PostgresForeignDataWrapper> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateForeignDataWrapper this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("create foreign data wrapper", PgCreateForeignDataWrapper.access$nameScr(this.this$0));
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((PostgresForeignDataWrapper)this.this$0.getElement()).getHandler() != null) {
                            CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                            CharSequence[] charSequenceArray = new CharSequence[2];
                            charSequenceArray[0] = "handler";
                            PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                            String string = ((PostgresForeignDataWrapper)this.this$0.getElement()).getHandlerSchema();
                            String string2 = ((PostgresForeignDataWrapper)this.this$0.getElement()).getHandler();
                            if (string2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.handler!!");
                            charSequenceArray[1] = PostgresCreatingGenerator.access$maybeQualified(postgresCreatingGenerator, string, string2);
                            codeTextBuilder.phrase(charSequenceArray);
                        }
                        if (((PostgresForeignDataWrapper)this.this$0.getElement()).getValidator() != null) {
                            CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                            CharSequence[] charSequenceArray = new CharSequence[2];
                            charSequenceArray[0] = "validator";
                            PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                            String string = ((PostgresForeignDataWrapper)this.this$0.getElement()).getValidatorSchema();
                            String string3 = ((PostgresForeignDataWrapper)this.this$0.getElement()).getValidator();
                            if (string3 == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.validator!!");
                            charSequenceArray[1] = PostgresCreatingGenerator.access$maybeQualified(postgresCreatingGenerator, string, string3);
                            codeTextBuilder.phrase(charSequenceArray);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    List<String> list = ((PostgresForeignDataWrapper)this.this$0.getElement()).getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PostgresCreatingGenerator.access$appendOptions(postgresCreatingGenerator, list);
                }
                {
                    this.this$0 = pgCreateForeignDataWrapper;
                    super(0);
                }
            }, 3, null);
            if (((PostgresForeignDataWrapper)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        public PgCreateForeignDataWrapper(PostgresForeignDataWrapper element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }

        @Nullable
        public static final /* synthetic */ String access$nameScr(PgCreateForeignDataWrapper $this) {
            return $this.nameScr();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateForeignServer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresForeignServer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresForeignServer;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateForeignServer
    extends BaseCreatingGenerator.CreateProducer<PostgresForeignServer> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateForeignServer this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("create server", PgCreateForeignServer.access$nameScr(this.this$0));
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((PostgresForeignServer)this.this$0.getElement()).getType() != null) {
                            PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("type", '\'' + ((PostgresForeignServer)this.this$0.getElement()).getType() + '\'');
                        }
                        if (((PostgresForeignServer)this.this$0.getElement()).getVersion() != null) {
                            PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("version", '\'' + ((PostgresForeignServer)this.this$0.getElement()).getVersion() + '\'');
                        }
                        CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                        CharSequence[] charSequenceArray = new CharSequence[2];
                        charSequenceArray[0] = "foreign data wrapper";
                        PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                        BasicElement basicElement = ((PostgresForeignServer)this.this$0.getElement()).getDasParent();
                        if (basicElement == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element.dasParent!!");
                        charSequenceArray[1] = AbstractCodeGenerator.quote$default(postgresCreatingGenerator, basicElement, null, 2, null);
                        codeTextBuilder.phrase(charSequenceArray);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.PostgresCreatingGenerator.this;
                    List<String> list = ((PostgresForeignServer)this.this$0.getElement()).getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                    PostgresCreatingGenerator.access$appendOptions(postgresCreatingGenerator, list);
                }
                {
                    this.this$0 = pgCreateForeignServer;
                    super(0);
                }
            }, 3, null);
            if (((PostgresForeignServer)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        public PgCreateForeignServer(PostgresForeignServer element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }

        @Nullable
        public static final /* synthetic */ String access$nameScr(PgCreateForeignServer $this) {
            return $this.nameScr();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateUserMapping;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/postgres/PostgresUserMapping;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresUserMapping;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateUserMapping
    extends BaseCreatingGenerator.CreateProducer<PostgresUserMapping> {
        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ PgCreateUserMapping this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final void invoke() {
                    v0 = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    v1 = new CharSequence[2];
                    v1[0] = "create user mapping for";
                    v2 = v1;
                    v3 = v1;
                    v4 = 1;
                    v5 = ((PostgresUserMapping)this.this$0.getElement()).getUser();
                    if (v5 == null) ** GOTO lbl-1000
                    var2_1 = v5;
                    var1_2 = this.this$0.PostgresCreatingGenerator.this;
                    var8_3 = v4;
                    var7_4 = v2;
                    var6_5 = v3;
                    var5_6 = v0;
                    var9_7 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
                    v0 = var5_6;
                    v3 = var6_5;
                    v2 = var7_4;
                    v4 = var8_3;
                    v5 = var9_7;
                    if (v5 != null) {
                        v6 = v5;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = "public";
                    }
                    v2[v4] = v6;
                    v0.phrase(v3);
                    this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        v7 = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                        v8 = new CharSequence[2];
                        v8[0] = "server";
                        v9 = this.this$0.PostgresCreatingGenerator.this;
                        v10 = ((PostgresUserMapping)this.this$0.getElement()).getDasParent();
                        if (v10 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"element.dasParent!!");
                        v8[1] = AbstractCodeGenerator.quote$default(v9, v10, null, 2, null);
                        v7.phrase(v8);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    v11 = this.this$0.PostgresCreatingGenerator.this;
                    v12 = ((PostgresUserMapping)this.this$0.getElement()).getOptions();
                    Intrinsics.checkExpressionValueIsNotNull(v12, (String)"element.options");
                    PostgresCreatingGenerator.access$appendOptions(v11, v12);
                }
                {
                    this.this$0 = pgCreateUserMapping;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateUserMapping(PostgresUserMapping element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0007H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTable;", "Lcom/intellij/database/model/postgres/PostgresTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "table", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresTable;)V", "acceptColumn", "", "column", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "findPropertyInAncestors", "condition", "Lkotlin/Function1;", "isModifiedColumnFromAncestor", "element", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "registerColumn", "", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "root", "Lcom/intellij/database/scripting/Operation;", "shouldProduceChildren", "intellij.database.scripting"})
    private final class PgCreateTable
    extends BaseCreatingGenerator.CreateTable<PostgresTable> {
        @Override
        protected void registerColumn(@NotNull BasicTableOrViewColumn column2, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            if (!(column2 instanceof PostgresTableColumn) || this.acceptColumn((PostgresTableColumn)column2)) {
                super.registerColumn(column2, root2);
            }
        }

        private final boolean acceptColumn(PostgresTableColumn column2) {
            BasicElement basicElement = column2.getParent();
            if (!(basicElement instanceof PostgresTable)) {
                basicElement = null;
            }
            PostgresTable postgresTable = (PostgresTable)basicElement;
            if (postgresTable == null) {
                return true;
            }
            PostgresTable table = postgresTable;
            return !table.isPartition() && !column2.isInherited() || table.isPartition() && this.isModifiedColumnFromAncestor(column2);
        }

        @Override
        protected boolean shouldProduceChildren() {
            return super.shouldProduceChildren() || !((PostgresTable)this.getElement()).isPartition();
        }

        private final boolean isModifiedColumnFromAncestor(PostgresTableColumn element) {
            return element.getDefaultExpression() != null && !this.findPropertyInAncestors(element, (Function1<? super PostgresTableColumn, Boolean>)((Function1)new Function1<PostgresTableColumn, Boolean>(element){
                final /* synthetic */ PostgresTableColumn $element;

                public final boolean invoke(@NotNull PostgresTableColumn it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)this.$element.getDefaultExpression(), (Object)it.getDefaultExpression());
                }
                {
                    this.$element = postgresTableColumn;
                    super(1);
                }
            })) || element.isNotNull() && !this.findPropertyInAncestors(element, (Function1<? super PostgresTableColumn, Boolean>)((Function1)isModifiedColumnFromAncestor.2.INSTANCE));
        }

        private final boolean findPropertyInAncestors(PostgresTableColumn column2, Function1<? super PostgresTableColumn, Boolean> condition) {
            BasicElement basicElement = column2.getParent();
            if (!(basicElement instanceof PostgresTable)) {
                basicElement = null;
            }
            PostgresTable postgresTable = (PostgresTable)basicElement;
            if (postgresTable == null) {
                return false;
            }
            PostgresTable parent = postgresTable;
            List<PostgresTable> ancestors = PostgresModelFun.getAncestors(parent);
            for (PostgresTable ancestor : ancestors) {
                PostgresTableColumn sameInAncestor2;
                if (ancestor.getColumns().find((Predicate<? extends PostgresTableColumn>)new Predicate<PostgresTableColumn>(column2){
                    final /* synthetic */ PostgresTableColumn $column;

                    public final boolean test(PostgresTableColumn it) {
                        PostgresTableColumn postgresTableColumn = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)postgresTableColumn, (String)"it");
                        return Intrinsics.areEqual((Object)postgresTableColumn.getName(), (Object)this.$column.getName());
                    }
                    {
                        this.$column = postgresTableColumn;
                    }
                }) == null) {
                    continue;
                }
                if (!((Boolean)condition.invoke((Object)sameInAncestor2)).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter() {
            HeaderFooter hf = super.makeTableHeaderFooter();
            PostgresTable t = (PostgresTable)this.getElement();
            String footer = null;
            String header = hf.getHeader();
            makeTableHeaderFooter.1 nextLine$ = makeTableHeaderFooter.1.INSTANCE;
            List<Long> list = t.getAncestorIds();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.ancestorIds");
            Collection collection = list;
            if (!collection.isEmpty()) {
                List<PostgresTable> ancestors = PostgresModelFun.getAncestors(t);
                if (t.isPartition()) {
                    header = nextLine$.invoke(header) + "partition of " + AbstractCodeGenerator.currentScopeName$default(PostgresCreatingGenerator.this, (BasicElement)CollectionsKt.first(ancestors), null, 1, null);
                    footer = t.getPartitionExpression();
                } else {
                    footer = "inherits (" + CollectionsKt.joinToString$default((Iterable)ancestors, null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresTable, String>(this){
                        final /* synthetic */ PgCreateTable this$0;

                        @NotNull
                        public final String invoke(@NotNull PostgresTable it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return AbstractCodeGenerator.currentScopeName$default(this.this$0.PostgresCreatingGenerator.this, it, null, 1, null);
                        }
                        {
                            this.this$0 = pgCreateTable;
                            super(1);
                        }
                    }), (int)31, null) + ")";
                }
            }
            if (t instanceof PostgresLocalTable && ((PostgresLocalTable)t).isPartitioned()) {
                footer = nextLine$.invoke(footer) + "partition by " + ((PostgresLocalTable)t).getPartitionKey();
            }
            if (t instanceof PostgresForeignTable) {
                StringBuilder stringBuilder = new StringBuilder().append(nextLine$.invoke(footer)).append("server ").append(((PostgresForeignTable)t).getServer()).append("");
                List<String> list2 = ((PostgresForeignTable)t).getOptions();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"t.options");
                footer = stringBuilder.append(PostgresCreatingGenerator.this.optionsToString(list2, true)).toString();
            }
            return new HeaderFooter(header, footer);
        }

        public PgCreateTable(PostgresTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicTable)table);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/basic/BasicLikeColumn;)V", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class PgCreateLikeColumn
    extends BaseCreatingGenerator.CreateLikeColumn {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                if (!(this.getElement() instanceof PostgresLocalTableColumn) || ((PostgresLocalTableColumn)this.getElement()).getSequenceName() == null) break block3;
                BasicNode basicNode = ((PostgresLocalTableColumn)this.getElement()).getSchema();
                if (basicNode != null && (basicNode = basicNode.getSequences()) != null) {
                    String string = ((PostgresLocalTableColumn)this.getElement()).getSequenceName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((basicNode = (PostgresSequence)basicNode.get(string)) != null) {
                        BasicNode basicNode2;
                        BasicNode it = basicNode2 = basicNode;
                        PostgresCreatingGenerator.this.prepareElement((BasicElement)it, $receiver, true);
                    }
                }
            }
            return operation;
        }

        public PgCreateLikeColumn(BasicLikeColumn element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTrigger;", "Lcom/intellij/database/model/postgres/PostgresLikeTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresLikeTrigger;)V", "generatePostgresTrigger", "", "trigger", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "produce", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class PgCreateTrigger
    extends BaseCreatingGenerator.CreateTrigger<PostgresLikeTrigger> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                if (!(this.getElement() instanceof PostgresTrigger)) break block2;
                PostgresRoutine callRoutine = PostgresModelFun.getCallRoutine((PostgresTrigger)this.getElement());
                if (Intrinsics.areEqual((Object)((Object)PostgresCreatingGenerator.this.getCategory()), (Object)((Object)ScriptCategory.CREATE_DEFINITION)) ^ true) {
                    PostgresRoutine postgresRoutine = callRoutine;
                    if (postgresRoutine != null) {
                        PostgresRoutine postgresRoutine2;
                        PostgresRoutine it = postgresRoutine2 = postgresRoutine;
                        BaseCreatingGenerator.prepareElement$default(PostgresCreatingGenerator.this, it, root2, false, 4, null);
                    }
                }
            }
            return operation;
        }

        @Override
        public void produce() {
            if (this.getElement() instanceof PostgresTrigger) {
                this.generatePostgresTrigger((PostgresTrigger)this.getElement());
            } else if (this.getElement() instanceof BasicSourceAware) {
                PostgresCreatingGenerator.this.generateUnspecificSourceAwareElement((BasicSourceAware)this.getElement());
            }
            if (((PostgresLikeTrigger)this.getElement()).getComment() != null) {
                PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
            }
        }

        private final void generatePostgresTrigger(PostgresTrigger trigger) {
            PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine(trigger);
            if (postgresRoutine == null) {
                return;
            }
            PostgresRoutine routine = postgresRoutine;
            String triggerName = this.fqName();
            Object object = trigger.getLikeTable();
            if (object == null || (object = AbstractCodeGenerator.currentScopeName$default(PostgresCreatingGenerator.this, (BasicElement)object, null, 1, null)) == null) {
                return;
            }
            Object tableName = object;
            String routineName = AbstractCodeGenerator.currentScopeName$default(PostgresCreatingGenerator.this, routine, null, 1, null);
            AbstractCodeGenerator.coding$default(PostgresCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger, (String)tableName, routineName){
                final /* synthetic */ PgCreateTrigger this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ PostgresTrigger $trigger;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $routineName;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this).phrase("create trigger", this.$triggerName);
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), ev, null, false, null, 14, null);
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "on " + this.$tableName, null, false, null, 14, null);
                        TrigTurn turn = this.$trigger.getTurn();
                        if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "for each row", null, false, null, 14, null);
                        }
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.PostgresCreatingGenerator.this), "execute procedure " + this.$routineName + "()", null, false, null, 14, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = pgCreateTrigger;
                    this.$triggerName = string;
                    this.$trigger = postgresTrigger;
                    this.$tableName = string2;
                    this.$routineName = string3;
                    super(0);
                }
            }, 3, null);
        }

        public PgCreateTrigger(PostgresLikeTrigger element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicTrigger)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PgCreateSequence;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateSequence;", "Lcom/intellij/database/model/postgres/PostgresSequence;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;Lcom/intellij/database/model/postgres/PostgresSequence;)V", "produce", "", "intellij.database.scripting"})
    private final class PgCreateSequence
    extends BaseCreatingGenerator.CreateSequence<PostgresSequence> {
        @Override
        public void produce() {
            if (!((PostgresSequence)this.getElement()).isBelongsToColumn()) {
                super.produce();
                if (((PostgresSequence)this.getElement()).getComment() != null) {
                    PostgresCreatingGenerator.this.generateComment((BasicElement)this.getElement());
                }
            }
        }

        public PgCreateSequence(PostgresSequence element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)PostgresCreatingGenerator.this, (BasicSequence)element);
        }
    }
}

