/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraMatLog;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSourceAware;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.oracle.OraCreatingGenerator;
import com.intellij.database.scripting.oracle.OraCreatingGenerator$OraCreateClusterIndex$WhenMappings;
import com.intellij.database.scripting.oracle.OraCreatingGeneratorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\f\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0002\b\u00030\bR\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "gatherSequenceIdentityParameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "", "generateSimpleSourceAwareObject", "obj", "Lcom/intellij/database/model/oracle/OraSourceAware;", "makeColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "OraCreateBody", "OraCreateCluster", "OraCreateClusterIndex", "OraCreateCollectionType", "OraCreateMatLog", "OraCreateMatView", "OraCreateModule", "OraCreateSingleRoutine", "OraCreateSynonym", "OraCreateTable", "OraCreateTrigger", "OraCreateView", "intellij.database.scripting"})
public final class OraCreatingGenerator
extends BaseCreatingGenerator {
    @Override
    @NotNull
    public BaseCreatingGenerator.CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof OraCluster ? (BaseCreatingGenerator.CreateProducer)new OraCreateCluster((OraCluster)element) : (basicElement instanceof OraClusterIndex ? (BaseCreatingGenerator.CreateProducer)new OraCreateClusterIndex((OraClusterIndex)element) : (basicElement instanceof OraCollectionType ? (BaseCreatingGenerator.CreateProducer)new OraCreateCollectionType((OraCollectionType)element) : (basicElement instanceof OraModule ? (BaseCreatingGenerator.CreateProducer)new OraCreateModule((OraModule)element) : (basicElement instanceof OraBody ? (BaseCreatingGenerator.CreateProducer)new OraCreateBody((OraBody)element) : (basicElement instanceof OraSingleRoutine ? (BaseCreatingGenerator.CreateProducer)new OraCreateSingleRoutine((OraSingleRoutine)element) : (basicElement instanceof OraMatLog ? (BaseCreatingGenerator.CreateProducer)new OraCreateMatLog((OraMatLog)element) : (basicElement instanceof OraMatView ? (BaseCreatingGenerator.CreateProducer)new OraCreateMatView((OraMatView)element) : (basicElement instanceof OraView ? (BaseCreatingGenerator.CreateProducer)new OraCreateView((OraView)element) : (basicElement instanceof OraTable ? (BaseCreatingGenerator.CreateProducer)new OraCreateTable((OraTable)element) : (basicElement instanceof BasicSynonym ? (BaseCreatingGenerator.CreateProducer)new OraCreateSynonym((BasicSynonym)element) : (basicElement instanceof OraTrigger ? (BaseCreatingGenerator.CreateProducer)new OraCreateTrigger((OraTrigger)element) : super.createProducer(element))))))))))));
    }

    @Override
    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        super.gatherSequenceIdentityParameters(sequence, parameters);
        if (sequence instanceof OraSequence) {
            if (((OraSequence)sequence).isOrdered()) {
                parameters.add("order");
            }
            if (((OraSequence)sequence).isCycled()) {
                parameters.add("cycle");
            }
            if (((OraSequence)sequence).getCacheSize() > 0) {
                parameters.add("cache " + ((OraSequence)sequence).getCacheSize());
            }
            if (((OraSequence)sequence).getCacheSize() < 0) {
                parameters.add("nocache");
            }
        }
    }

    @Override
    @Nullable
    public String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String s = super.makeColumnSpecification(column2);
        if (column2 instanceof OraTableColumn && ((OraTableColumn)column2).isAutoInc()) {
            Collection collection;
            String x = ((OraTableColumn)column2).isDefaultOnNull() ? " generated by default on null as identity" : " generated as identity";
            ArrayList parameters = new ArrayList();
            SequenceIdentity sequenceIdentity = ((OraTableColumn)column2).getSequenceIdentity();
            if (sequenceIdentity != null) {
                this.gatherSequenceIdentityParameters(sequenceIdentity, (List<String>)parameters);
            }
            if (!(collection = (Collection)parameters).isEmpty()) {
                x = x + " (" + CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ')';
            }
            s = Intrinsics.stringPlus((String)s, (Object)x);
        }
        return s;
    }

    private final void generateSimpleSourceAwareObject(OraSourceAware obj) {
        Object object = obj.getSourceText();
        if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
            return;
        }
        Object sourceText = object;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, obj, (CompositeText.Fragment)sourceText){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ OraSourceAware $obj;
            final /* synthetic */ CompositeText.Fragment $sourceText;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                StringBuilder stringBuilder = new StringBuilder();
                ObjectKind objectKind = this.$obj.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"obj.kind");
                CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(this.this$0.createOrReplace(objectKind)).append(" ").toString(), null, false, null, 10, null);
                OraCreatingGenerator.access$getBuilder$p(this.this$0).append(this.$sourceText);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$obj = oraSourceAware;
                this.$sourceText = fragment;
                super(0);
            }
        }, 3, null);
    }

    public OraCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(OraCreatingGenerator $this) {
        return $this.getBuilder();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateCluster;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraCluster;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraCluster;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class OraCreateCluster
    extends BaseCreatingGenerator.CreateProducer<OraCluster> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block0: {
                OraClusterIndex oraClusterIndex;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                OraClusterIndex oraClusterIndex2 = ((OraCluster)this.getElement()).getIndices().get();
                if (oraClusterIndex2 == null) break block0;
                OraClusterIndex it = oraClusterIndex = oraClusterIndex2;
                BaseCreatingGenerator.prepareElement$default(OraCreatingGenerator.this, it, root2, false, 4, null);
            }
            return operation;
        }

        @Override
        public void produce() {
            String name = this.fqName();
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, name){
                final /* synthetic */ OraCreateCluster this$0;
                final /* synthetic */ String $name;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "create cluster " + this.$name, null, false, null, 14, null);
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "(", null, false, null, 14, null);
                    AbstractCodeGenerator.coding$default(this.this$0.OraCreatingGenerator.this, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ produce.1 this$0;

                        public final void invoke() {
                            for (OraClusterColumn oraClusterColumn : ((OraCluster)this.this$0.this$0.getElement()).getColumns()) {
                                OraCreatingGenerator oraCreatingGenerator = this.this$0.this$0.OraCreatingGenerator.this;
                                OraClusterColumn oraClusterColumn2 = oraClusterColumn;
                                Intrinsics.checkExpressionValueIsNotNull((Object)oraClusterColumn2, (String)"column");
                                String name1 = AbstractCodeGenerator.quote$default(oraCreatingGenerator, oraClusterColumn2, null, 2, null);
                                DataType dataType = oraClusterColumn.getDataType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
                                String type1 = dataType.getSpecification();
                                String suffix = oraClusterColumn.isSorted() ? " sort" : "";
                                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.this$0.OraCreatingGenerator.this), "" + name1 + ' ' + type1 + "" + suffix + ',', null, false, null, 14, null);
                            }
                            PositioningNamingFamily<? extends OraClusterColumn> positioningNamingFamily = ((OraCluster)this.this$0.this$0.getElement()).getColumns();
                            Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
                            if (positioningNamingFamily.isEmpty()) {
                                OraCreatingGenerator.access$getBuilder$p(this.this$0.this$0.OraCreatingGenerator.this).appendErrorComment("looks like columns were not retrieved because the user had no SELECT_CATALOG_ROLE :(");
                            }
                            OraCreatingGenerator.access$getBuilder$p(this.this$0.this$0.OraCreatingGenerator.this).removeSuffixFromTheLastLine(',');
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), ")", null, false, null, 14, null);
                    CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((OraCluster)this.this$0.getElement()).getBlockSize() > 0) {
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "size " + ((OraCluster)this.this$0.getElement()).getBlockSize(), null, false, null, 14, null);
                        }
                        String singleTableClause = ((OraCluster)this.this$0.getElement()).isSingleTable() ? "single table" : null;
                        String cardinalityClause = ((OraCluster)this.this$0.getElement()).getHashCardinality() != 0 ? "hashkeys " + ((OraCluster)this.this$0.getElement()).getHashCardinality() : null;
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), ScriptingUtilsKt.concatWithSpace(singleTableClause, cardinalityClause), null, false, null, 14, null);
                        if (((OraCluster)this.this$0.getElement()).getHashExpression() != null) {
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "hash is " + ((OraCluster)this.this$0.getElement()).getHashExpression(), null, false, null, 14, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreateCluster;
                    this.$name = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateCluster(OraCluster element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateClusterIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraClusterIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraClusterIndex;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateClusterIndex
    extends BaseCreatingGenerator.CreateProducer<OraClusterIndex> {
        @Override
        public void produce() {
            OraCluster cluster;
            OraCluster oraCluster = ((OraClusterIndex)this.getElement()).getCluster();
            if (oraCluster == null) {
                return;
            }
            OraCluster oraCluster2 = cluster = oraCluster;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraCluster2, (String)"cluster");
            String clusterName = AbstractCodeGenerator.currentScopeName$default(OraCreatingGenerator.this, oraCluster2, null, 1, null);
            String indexName = this.fqName();
            ClusterType clusterType = cluster.getClusterType();
            if (clusterType != null) {
                switch (OraCreatingGenerator$OraCreateClusterIndex$WhenMappings.$EnumSwitchMapping$0[clusterType.ordinal()]) {
                    case 1: {
                        AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, indexName, clusterName){
                            final /* synthetic */ OraCreateClusterIndex this$0;
                            final /* synthetic */ String $indexName;
                            final /* synthetic */ String $clusterName;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke() {
                                CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                                CharSequence[] charSequenceArray = new CharSequence[3];
                                charSequenceArray[0] = "create index";
                                OraCreatingGenerator oraCreatingGenerator = this.this$0.OraCreatingGenerator.this;
                                ObjectKind objectKind = ObjectKind.INDEX;
                                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
                                charSequenceArray[1] = oraCreatingGenerator.ifNotExists(objectKind);
                                charSequenceArray[2] = this.$indexName;
                                codeTextBuilder.phrase(charSequenceArray);
                                CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                                try {
                                    OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this).phrase("on cluster", this.$clusterName);
                                }
                                finally {
                                    this_$iv.unindent();
                                }
                            }
                            {
                                this.this$0 = oraCreateClusterIndex;
                                this.$indexName = string;
                                this.$clusterName = string2;
                                super(0);
                            }
                        }, 3, null);
                    }
                }
            }
        }

        public OraCreateClusterIndex(OraClusterIndex element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateCollectionType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraCollectionType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraCollectionType;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateCollectionType
    extends BaseCreatingGenerator.CreateProducer<OraCollectionType> {
        @Override
        public void produce() {
            String string;
            OraCollectionType col = (OraCollectionType)this.getElement();
            String name = this.fqName();
            int n = col.getUpperBound();
            DataType dataType = col.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"col.elementType");
            String d = OraCreatingGenerator.this.script(dataType);
            if (col.isArray() && n > 0) {
                String[] stringArray = new String[4];
                ObjectKind objectKind = col.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
                stringArray[0] = OraCreatingGenerator.this.createOrReplace(objectKind);
                stringArray[1] = "type";
                stringArray[2] = name;
                stringArray[3] = "is varray(" + n + ") of " + d;
                string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                String[] stringArray = new String[5];
                ObjectKind objectKind = col.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
                stringArray[0] = OraCreatingGenerator.this.createOrReplace(objectKind);
                stringArray[1] = "type";
                stringArray[2] = name;
                stringArray[3] = "as table of";
                stringArray[4] = d;
                string = ScriptingUtilsKt.phrase(stringArray);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            }
            String s1 = string;
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, s1){
                final /* synthetic */ OraCreateCollectionType this$0;
                final /* synthetic */ String $s1;

                public final void invoke() {
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), this.$s1, null, false, null, 14, null);
                }
                {
                    this.this$0 = oraCreateCollectionType;
                    this.$s1 = string;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateCollectionType(OraCollectionType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateModule;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraModule;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraModule;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class OraCreateModule
    extends BaseCreatingGenerator.CreateProducer<OraModule> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block0: {
                OraBody oraBody;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                OraBody oraBody2 = ((OraModule)this.getElement()).getBodies().get();
                if (oraBody2 == null) break block0;
                OraBody it = oraBody = oraBody2;
                BaseCreatingGenerator.prepareElement$default(OraCreatingGenerator.this, it, root2, false, 4, null);
            }
            return operation;
        }

        @Override
        public void produce() {
            OraCreatingGenerator.this.generateSimpleSourceAwareObject((OraSourceAware)this.getElement());
        }

        public OraCreateModule(OraModule element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateBody;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraBody;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraBody;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateBody
    extends BaseCreatingGenerator.CreateProducer<OraBody> {
        @Override
        public void produce() {
            OraCreatingGenerator.this.generateSimpleSourceAwareObject((OraSourceAware)this.getElement());
        }

        public OraCreateBody(OraBody element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateSingleRoutine;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraSingleRoutine;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraSingleRoutine;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateSingleRoutine
    extends BaseCreatingGenerator.CreateProducer<OraSingleRoutine> {
        @Override
        public void produce() {
            OraCreatingGenerator.this.generateSimpleSourceAwareObject((OraSourceAware)this.getElement());
        }

        public OraCreateSingleRoutine(OraSingleRoutine element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateMatLog;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraMatLog;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraMatLog;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class OraCreateMatLog
    extends BaseCreatingGenerator.CreateProducer<OraMatLog> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            block1: {
                BasicIdentifiedElement basicIdentifiedElement;
                BasicIdentifiedElement schema;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.register(root2);
                BasicIdentifiedElement basicIdentifiedElement2 = ((OraMatLog)this.getElement()).getTable();
                if (basicIdentifiedElement2 == null || (basicIdentifiedElement2 = basicIdentifiedElement2.getSchema()) == null) break block1;
                BasicIdentifiedElement basicIdentifiedElement3 = schema = (basicIdentifiedElement = basicIdentifiedElement2);
                Intrinsics.checkExpressionValueIsNotNull((Object)basicIdentifiedElement3, (String)"schema");
                OraTable oraTable = (OraTable)basicIdentifiedElement3.getTables().get(((OraMatLog)this.getElement()).getName());
                if (oraTable != null) {
                    OraTable oraTable2;
                    OraTable it = oraTable2 = oraTable;
                    OraCreatingGenerator.this.prepareElement(it, $receiver, true);
                }
            }
            return operation;
        }

        @Override
        public void produce() {
            OraTable masterTable;
            OraTable oraTable = ((OraMatLog)this.getElement()).getTable();
            if (oraTable == null) {
                return;
            }
            OraTable oraTable2 = masterTable = oraTable;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraTable2, (String)"masterTable");
            String string = oraTable2.getRealName();
            if (string == null) {
                return;
            }
            String masterName = string;
            String withOptions = ((OraMatLog)this.getElement()).withOptions();
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, masterName, withOptions){
                final /* synthetic */ OraCreateMatLog this$0;
                final /* synthetic */ String $masterName;
                final /* synthetic */ String $withOptions;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this).phrase("create materialized view log on " + this.$masterName);
                    CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), this.$withOptions, null, false, null, 14, null);
                        if (((OraMatLog)this.this$0.getElement()).isWithNewValues()) {
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "including new values", null, false, null, 14, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = oraCreateMatLog;
                    this.$masterName = string;
                    this.$withOptions = string2;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateMatLog(OraMatLog element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateMatView;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraMatView;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraMatView;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateMatView
    extends BaseCreatingGenerator.CreateProducer<OraMatView> {
        @Override
        public void produce() {
            String name = this.fqName();
            Object object = ((OraMatView)this.getElement()).getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, name, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreateMatView this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    OraCreatingGenerator oraCreatingGenerator = this.this$0.OraCreatingGenerator.this;
                    ObjectKind objectKind = ((OraMatView)this.this$0.getElement()).getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
                    charSequenceArray[0] = oraCreatingGenerator.createOrReplace(objectKind);
                    charSequenceArray[1] = "materialized view";
                    charSequenceArray[2] = this.$name;
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (((OraMatView)this.this$0.getElement()).isPrebuilt()) {
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "on prebuilt table", null, false, null, 14, null);
                        }
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), ((OraMatView)this.this$0.getElement()).getRefreshSpecification(), null, false, null, 14, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "as", null, false, null, 14, null);
                    OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this).append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreateMatView;
                    this.$name = string;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateMatView(OraMatView element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateView;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/oracle/OraView;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraView;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateView
    extends BaseCreatingGenerator.CreateProducer<OraView> {
        @Override
        public void produce() {
            String name = this.fqName();
            Object object = ((OraView)this.getElement()).getSourceText();
            if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
                return;
            }
            Object sourceText = object;
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, name, (CompositeText.Fragment)sourceText){
                final /* synthetic */ OraCreateView this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ CompositeText.Fragment $sourceText;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    OraCreatingGenerator oraCreatingGenerator = this.this$0.OraCreatingGenerator.this;
                    ObjectKind objectKind = ((OraView)this.this$0.getElement()).getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
                    charSequenceArray[0] = oraCreatingGenerator.createOrReplace(objectKind);
                    charSequenceArray[1] = "view";
                    charSequenceArray[2] = this.$name;
                    charSequenceArray[3] = "as";
                    codeTextBuilder.phrase(charSequenceArray);
                    OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this).append(this.$sourceText);
                }
                {
                    this.this$0 = oraCreateView;
                    this.$name = string;
                    this.$sourceText = fragment;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateView(OraView element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTable;", "Lcom/intellij/database/model/oracle/OraTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraTable;)V", "generateObjectTable", "", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "produce", "intellij.database.scripting"})
    private final class OraCreateTable
    extends BaseCreatingGenerator.CreateTable<OraTable> {
        @Override
        public void produce() {
            if (((OraTable)this.getElement()).getRowTypeObjectName() != null) {
                this.generateObjectTable();
            } else {
                super.produce();
            }
        }

        private final void generateObjectTable() {
            String string;
            String $receiver$iv;
            OraCreatingGenerator this_$iv;
            String objectSchemaName = ((OraTable)this.getElement()).getRowTypeSchemaName();
            if (Intrinsics.areEqual((Object)objectSchemaName, (Object)((OraTable)this.getElement()).getSchemaName())) {
                objectSchemaName = null;
            }
            String string2 = ((OraTable)this.getElement()).getRowTypeObjectName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String objectName = string2;
            if (objectSchemaName == null) {
                String string3 = objectName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"objectName");
                String string4 = string3;
                this_$iv = OraCreatingGenerator.this;
                string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
            } else {
                $receiver$iv = objectSchemaName;
                this_$iv = OraCreatingGenerator.this;
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                StringBuilder stringBuilder2 = stringBuilder.append(string5).append('.');
                String string6 = objectName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"objectName");
                $receiver$iv = string6;
                this_$iv = OraCreatingGenerator.this;
                stringBuilder = stringBuilder2;
                string5 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                string = stringBuilder.append(string5).toString();
            }
            String n = string;
            String[] stringArray = new String[5];
            stringArray[0] = "create table";
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.TABLE");
            stringArray[1] = OraCreatingGenerator.this.ifNotExists(objectKind);
            stringArray[2] = this.fqName();
            stringArray[3] = "of";
            stringArray[4] = n;
            String s = ScriptingUtilsKt.phrase(stringArray);
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ OraCreateTable this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), this.$s, null, false, null, 14, null);
                }
                {
                    this.this$0 = oraCreateTable;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter() {
            OraTable tab = (OraTable)this.getElement();
            String name = this.fqName();
            String[] stringArray = new String[3];
            stringArray[0] = "create table";
            ObjectKind objectKind = tab.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"tab.kind");
            stringArray[1] = OraCreatingGenerator.this.ifNotExists(objectKind);
            stringArray[2] = name;
            String string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String h = string;
            String f = null;
            if (tab.getClusterName() != null) {
                void $receiver$iv;
                String string2 = tab.getClusterName();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"tab.clusterName!!");
                String string3 = string2;
                OraCreatingGenerator this_$iv = OraCreatingGenerator.this;
                String cn = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv, false);
                List<String> list = tab.getClusterColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"tab.clusterColNames");
                String cols = OraCreatingGenerator.this.getScr(list);
                f = "\tcluster " + cn + " (" + cols + ')';
            } else if (Intrinsics.areEqual((Object)((Object)tab.getOrganization()), (Object)((Object)TableOrganization.INDEX))) {
                f = "\torganization index";
            } else if (tab.isTemporary()) {
                String string4;
                String[] stringArray2 = new String[3];
                stringArray2[0] = "create global temporary table";
                ObjectKind objectKind2 = tab.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"tab.kind");
                stringArray2[1] = OraCreatingGenerator.this.ifNotExists(objectKind2);
                stringArray2[2] = name;
                String string5 = ScriptingUtilsKt.phrase(stringArray2);
                if (string5 == null) {
                    Intrinsics.throwNpe();
                }
                h = string5;
                boolean bl = tab.isTemporaryPreserve();
                if (!bl) {
                    string4 = "\ton commit delete rows";
                } else if (bl) {
                    string4 = "\ton commit preserve rows";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                f = string4;
            }
            return new HeaderFooter(h, f);
        }

        public OraCreateTable(OraTable element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicTable)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateSynonym;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateSynonym;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "Lcom/intellij/database/model/basic/BasicSynonym;", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/basic/BasicSynonym;)V", "generatePublicSynonym", "", "produce", "intellij.database.scripting"})
    private final class OraCreateSynonym
    extends BaseCreatingGenerator.CreateSynonym {
        @Override
        public void produce() {
            if (OraCreatingGeneratorKt.isPublicSynonym((BasicSynonym)this.getElement())) {
                this.generatePublicSynonym();
            } else {
                super.produce();
            }
        }

        private final void generatePublicSynonym() {
            String targetSpec = this.makeSynonymTargetSpec((BasicSynonym)this.getElement());
            String name = this.fqName();
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, name, targetSpec){
                final /* synthetic */ OraCreateSynonym this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $targetSpec;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    String[] stringArray = new String[4];
                    OraCreatingGenerator oraCreatingGenerator = this.this$0.OraCreatingGenerator.this;
                    ObjectKind objectKind = ObjectKind.SYNONYM;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SYNONYM");
                    stringArray[0] = oraCreatingGenerator.createOrReplace(objectKind);
                    stringArray[1] = "public synonym";
                    stringArray[2] = this.$name;
                    stringArray[3] = "for ";
                    CodeTextBuilder.append$default(codeTextBuilder, ScriptingUtilsKt.phrase(stringArray), null, false, null, 10, null);
                    if (this.$targetSpec != null) {
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), this.$targetSpec, null, false, null, 14, null);
                    } else {
                        void $receiver$iv;
                        CodeTextBuilder codeTextBuilder2 = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                        OraCreatingGenerator oraCreatingGenerator2 = this.this$0.OraCreatingGenerator.this;
                        String text$iv = this.$targetSpec;
                        boolean eoln$iv = true;
                        if (text$iv == null) {
                            boolean bl = eoln$iv;
                            CompositeText.Kind kind = null;
                            CharSequence charSequence = "???";
                            void var8_8 = $receiver$iv;
                            String string = "unknown what the public synonym " + this.$name + " references on :(";
                            CodeTextBuilder.append$default((CodeTextBuilder)var8_8, charSequence, kind, bl, string, 2, null);
                        } else {
                            CodeTextBuilder.append$default((CodeTextBuilder)$receiver$iv, text$iv, null, eoln$iv, null, 10, null);
                        }
                    }
                }
                {
                    this.this$0 = oraCreateSynonym;
                    this.$name = string;
                    this.$targetSpec = string2;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateSynonym(BasicSynonym element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTrigger;", "Lcom/intellij/database/model/oracle/OraTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;Lcom/intellij/database/model/oracle/OraTrigger;)V", "produce", "", "intellij.database.scripting"})
    private final class OraCreateTrigger
    extends BaseCreatingGenerator.CreateTrigger<OraTrigger> {
        @Override
        public void produce() {
            BasicLikeTable table;
            String triggerName = this.fqName();
            CharSequence charSequence = ((OraTrigger)this.getElement()).getOriginalSourceText();
            if (charSequence == null) {
                return;
            }
            CharSequence text = charSequence;
            BasicLikeTable basicLikeTable = table = ((OraTrigger)this.getElement()).getLikeTable();
            String tableName = basicLikeTable != null ? AbstractCodeGenerator.currentScopeName$default(OraCreatingGenerator.this, basicLikeTable, null, 1, null) : null;
            AbstractCodeGenerator.coding$default(OraCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, triggerName, tableName, text){
                final /* synthetic */ OraCreateTrigger this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ String $tableName;
                final /* synthetic */ CharSequence $text;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CharSequence[] charSequenceArray = new CharSequence[3];
                    OraCreatingGenerator oraCreatingGenerator = this.this$0.OraCreatingGenerator.this;
                    ObjectKind objectKind = ObjectKind.TRIGGER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.TRIGGER");
                    charSequenceArray[0] = oraCreatingGenerator.createOrReplace(objectKind);
                    charSequenceArray[1] = "trigger";
                    charSequenceArray[2] = this.$triggerName;
                    codeTextBuilder.phrase(charSequenceArray);
                    CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        void $receiver$iv;
                        String ev = ScriptingUtilsKt.makeTriggerEventString((BasicTrigger)this.this$0.getElement());
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), ev, null, false, null, 14, null);
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), "on ", null, false, null, 10, null);
                        CodeTextBuilder codeTextBuilder2 = OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this);
                        OraCreatingGenerator oraCreatingGenerator2 = this.this$0.OraCreatingGenerator.this;
                        String text$iv = this.$tableName;
                        boolean eoln$iv = true;
                        if (text$iv == null) {
                            boolean bl = eoln$iv;
                            CompositeText.Kind kind = null;
                            CharSequence charSequence = "???";
                            void var10_12 = $receiver$iv;
                            String string = "table name for trigger " + this.$triggerName + " is unknown";
                            CodeTextBuilder.append$default((CodeTextBuilder)var10_12, charSequence, kind, bl, string, 2, null);
                        } else {
                            CodeTextBuilder.append$default((CodeTextBuilder)$receiver$iv, text$iv, null, eoln$iv, null, 10, null);
                        }
                        TrigTurn turn = ((OraTrigger)this.this$0.getElement()).getTurn();
                        if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                            CharSequence charSequence;
                            String c;
                            String string;
                            String s = "for each row";
                            String string2 = ((OraTrigger)this.this$0.getElement()).getCondition();
                            if (string2 != null) {
                                String string3;
                                String string4 = string3 = string2;
                                if (string4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                            } else {
                                string = c = null;
                            }
                            if (c != null && (charSequence = (CharSequence)c).length() > 0) {
                                s = s + " when (" + c + ')';
                            }
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), s, null, false, null, 14, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.OraCreatingGenerator.this), this.$text, CompositeText.Kind.ORIGINAL_TEXT, false, null, 12, null);
                }
                {
                    this.this$0 = oraCreateTrigger;
                    this.$triggerName = string;
                    this.$tableName = string2;
                    this.$text = charSequence;
                    super(0);
                }
            }, 3, null);
        }

        public OraCreateTrigger(OraTrigger element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)OraCreatingGenerator.this, (BasicTrigger)element);
        }
    }
}

