/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mysql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mysql.MysqlArgument;
import com.intellij.database.model.mysql.MysqlCollation;
import com.intellij.database.model.mysql.MysqlEvent;
import com.intellij.database.model.mysql.MysqlIndex;
import com.intellij.database.model.mysql.MysqlKey;
import com.intellij.database.model.mysql.MysqlRoot;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTableColumn;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.model.properties.MysqlEventStatus;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingServiceKt;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.mysql.MysqlCreatingGenerator;
import com.intellij.database.scripting.mysql.MysqlCreatingGenerator$MysqlCreateEvent$WhenMappings;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 :2\u00020\u0001:\b:;<=>?@AB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0018\u0010\u0012\u001a\n\u0012\u0002\b\u00030\u0013R\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0014J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020)H\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010\n2\b\u0010+\u001a\u0004\u0018\u00010\nJ\u0010\u0010,\u001a\u00020\n2\u0006\u0010%\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0014J\u0012\u00101\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u00102\u001a\u0004\u0018\u00010\n2\b\u00103\u001a\u0004\u0018\u00010\nJ\b\u00104\u001a\u00020\bH\u0014J\u001a\u00105\u001a\u00020\u001e*\u000606R\u0002072\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u001a\u00108\u001a\u00020\u001e*\u000606R\u0002072\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u001a\u00109\u001a\u00020\u001e*\u000606R\u0002072\b\u0010%\u001a\u0004\u0018\u00010&H\u0002\u00a8\u0006B"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "allowReferenceOnPrimaryKeyWithoutColumns", "", "argDataType", "", "arg", "Lcom/intellij/database/model/basic/BasicArgument;", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "defaultCollationForCharset", "model", "Lcom/intellij/database/model/basic/BasicModel;", "name", "findCollation", "Lcom/intellij/database/model/mysql/MysqlCollation;", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateColumnComment", "", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "getSingleColumnElements", "", "isSimple", "index", "Lcom/intellij/database/model/mysql/MysqlIndex;", "makeColumnSpecification", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeEngineSpec", "engine", "makeIndexWord", "Lcom/intellij/database/model/basic/BasicIndex;", "makeKeyWord", "key", "Lcom/intellij/database/model/basic/BasicKey;", "makeNormalColumnSpecification", "makeTableCollationSpec", "collation", "shouldCollectColumnElements", "appendIndexComment", "Lcom/intellij/database/scripting/AbstractCodeGenerator$NewCodingAdapter;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "appendIndexOrKeyProps", "appendIndexType", "Companion", "MysqlCreateEvent", "MysqlCreateIndex", "MysqlCreateKey", "MysqlCreateRoutine", "MysqlCreateTable", "MysqlCreateTrigger", "MysqlCreateView", "intellij.database.scripting"})
public final class MysqlCreatingGenerator
extends BaseCreatingGenerator {
    private static final Version INDEX_COMMENT_VER;
    public static final Companion Companion;

    @Override
    protected boolean shouldCollectColumnElements() {
        return Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String s = super.generalColumnSpecification(column2);
        if (column2 instanceof MysqlTableColumn) {
            String collation = ((MysqlTableColumn)column2).getCollation();
            String charSet = this.defaultCollationForCharset(this.getContext().getModel(), collation);
            if (charSet != null) {
                void $receiver$iv;
                void this_$iv;
                String string = charSet;
                MysqlCreatingGenerator mysqlCreatingGenerator = this;
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" charset ");
                String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
                s = stringBuilder.append(string2).toString();
            } else if (collation != null) {
                String $receiver$iv = collation;
                MysqlCreatingGenerator this_$iv = this;
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" collate ");
                String string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                s = stringBuilder.append(string).toString();
            }
        }
        return s;
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String string = super.makeNormalColumnSpecification(column2);
        if (string == null) {
            return null;
        }
        String s = string;
        if (column2 instanceof MysqlTableColumn) {
            if (((MysqlTableColumn)column2).isAutoInc()) {
                s = s + " auto_increment";
            }
            if (((MysqlTableColumn)column2).getOnUpdate() != null) {
                s = s + " on update " + ((MysqlTableColumn)column2).getOnUpdate();
            }
        }
        return s;
    }

    @Override
    @NotNull
    public BaseCreatingGenerator.CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof MysqlView ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateView((MysqlView)element) : (basicElement instanceof MysqlRoutine ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateRoutine((MysqlRoutine)element) : (basicElement instanceof MysqlEvent ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateEvent((MysqlEvent)element) : (basicElement instanceof MysqlTrigger ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateTrigger((MysqlTrigger)element) : (basicElement instanceof MysqlIndex ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateIndex((MysqlIndex)element) : (basicElement instanceof MysqlKey ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateKey((MysqlKey)element) : (basicElement instanceof MysqlTable ? (BaseCreatingGenerator.CreateProducer)new MysqlCreateTable((MysqlTable)element) : super.createProducer(element)))))));
    }

    private final void appendIndexComment(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver, MysqlIndex index2) {
        Object object = index2;
        if (object == null || (object = object.getComment()) == null) {
            return;
        }
        Object comment = object;
        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.unaryPlus("comment");
        Object object2 = comment;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"comment");
        $receiver.plus(newCodingAdapter, this.getSqlString((String)object2));
    }

    private final void appendIndexType(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver, MysqlIndex index2) {
        String def2;
        Object object = index2;
        if (object == null || (object = object.getType()) == null) {
            return;
        }
        Object tp = object;
        MysqlTable mysqlTable = index2.getTable();
        String string = def2 = StringsKt.equals((String)"memory", (String)(mysqlTable != null ? mysqlTable.getEngine() : null), (boolean)true) ? "hash" : "btree";
        if (Intrinsics.areEqual((Object)tp, (Object)def2) || !this.isSimple(index2)) {
            return;
        }
        $receiver.plus($receiver.unaryPlus("using"), (String)tp);
    }

    private final void appendIndexOrKeyProps(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver, MysqlIndex index2) {
        this.appendIndexType($receiver, index2);
        this.appendIndexComment($receiver, index2);
    }

    @Override
    @NotNull
    protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column2) {
        BasicLikeTable table;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicLikeTable basicLikeTable = column2.getLikeTable();
        if (basicLikeTable == null) {
            return SetsKt.emptySet();
        }
        BasicLikeTable basicLikeTable2 = table = basicLikeTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable2, (String)"table");
        JBIterable jBIterable = basicLikeTable2.getChildren().filter(BasicKey.class).filter((Condition)new Condition<BasicKey>(this, column2){
            final /* synthetic */ MysqlCreatingGenerator this$0;
            final /* synthetic */ BasicLikeColumn $column;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(BasicKey it) {
                BasicKey basicKey = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"it");
                if (!MysqlCreatingGenerator.access$canCreateInColumn(this.this$0, basicKey)) return false;
                if (!it.isNameSurrogate()) return false;
                if (it.getColNames().size() != 1) return false;
                List<String> list = it.getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.colNames");
                if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first(list)), (Object)this.$column.getName())) return false;
                return true;
            }
            {
                this.this$0 = mysqlCreatingGenerator;
                this.$column = basicLikeColumn;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.children\n      .fi\u2026s.first() == column.name}");
        return (Iterable)jBIterable;
    }

    @Override
    protected boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        if (Intrinsics.areEqual((Object)((Object)locus), (Object)((Object)ScriptLocus.IN_COLUMN)) && element instanceof MysqlKey && ((MysqlKey)element).isPrimary()) {
            MysqlTableColumn col;
            BasicNode basicNode;
            List<String> list = ((MysqlKey)element).getColNames();
            List<String> it = list;
            MysqlTableColumn mysqlTableColumn = it.size() != 1 ? null : ((basicNode = ((MysqlKey)element).getTable()) != null && (basicNode = basicNode.getColumns()) != null ? (MysqlTableColumn)basicNode.get(it.get(0)) : (col = null));
            if (col != null && col.isAutoInc()) {
                return true;
            }
        }
        return super.canGenerateHere(locus, element);
    }

    private final String argDataType(BasicArgument arg) {
        String string;
        if (arg == null) {
            string = "/*none*/";
        } else {
            DataType dataType = arg.getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"arg.dataType");
            string = this.script(dataType);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String makeEngineSpec(@Nullable String engine) {
        String string;
        String string2 = engine;
        if (string2 != null) {
            void $receiver$iv;
            void this_$iv;
            String string3;
            String it;
            String string4 = it = (string3 = string2);
            MysqlCreatingGenerator mysqlCreatingGenerator = this;
            StringBuilder stringBuilder = new StringBuilder().append("engine=");
            String string5 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
            string = stringBuilder.append(string5).toString();
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String makeTableCollationSpec(@Nullable String collation) {
        String string;
        String charSet = this.defaultCollationForCharset(this.getContext().getModel(), collation);
        if (charSet != null) {
            void $receiver$iv;
            void this_$iv;
            String string2 = charSet;
            MysqlCreatingGenerator mysqlCreatingGenerator = this;
            StringBuilder stringBuilder = new StringBuilder().append("charset=");
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
            string = stringBuilder.append(string3).toString();
        } else if (collation != null) {
            String $receiver$iv = collation;
            MysqlCreatingGenerator this_$iv = this;
            StringBuilder stringBuilder = new StringBuilder().append("collate=");
            String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
            string = stringBuilder.append(string4).toString();
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    protected String makeIndexWord(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        MysqlIndex cfr_ignored_0 = (MysqlIndex)index2;
        return !this.isSimple((MysqlIndex)index2) ? "" + ((MysqlIndex)index2).getType() + " index" : super.makeIndexWord(index2);
    }

    @Override
    @NotNull
    protected String makeKeyWord(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        MysqlIndex index2 = (MysqlIndex)key2.getUnderlyingIndex();
        return index2 != null && !this.isSimple(index2) ? "" + index2.getType() + " key" : super.makeKeyWord(key2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSimple(MysqlIndex index2) {
        String string;
        String string2 = string = index2.getType();
        if (string2 == null) return true;
        switch (string2.hashCode()) {
            case 1331988540: {
                if (!string.equals("fulltext")) return true;
                return false;
            }
            case -2011652860: {
                if (!string.equals("spatial")) return true;
                return false;
            }
        }
        return true;
    }

    private final MysqlCollation findCollation(BasicModel model, String name) {
        BasicNode basicNode;
        if (name == null) {
            return null;
        }
        BasicModel basicModel = model;
        BasicRoot basicRoot = basicModel != null ? basicModel.getRoot() : null;
        if (!(basicRoot instanceof MysqlRoot)) {
            basicRoot = null;
        }
        return (basicNode = (MysqlRoot)basicRoot) != null && (basicNode = basicNode.getCollations()) != null ? (MysqlCollation)basicNode.get(name) : null;
    }

    private final String defaultCollationForCharset(BasicModel model, String name) {
        MysqlCollation c = this.findCollation(model, name);
        return c != null && Intrinsics.areEqual((Object)c.getDefaultForCharset(), (Object)Boolean.TRUE) ? c.getCharset() : null;
    }

    @Override
    @Nullable
    protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(column2 instanceof MysqlTableColumn)) {
            return super.makeComputedColumnSpecification(column2);
        }
        StringBuilder stringBuilder = new StringBuilder().append("");
        DataType dataType = ((MysqlTableColumn)column2).getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String res = stringBuilder.append(this.script(dataType)).append(" as (").append(((MysqlTableColumn)column2).getDefault()).append(')').toString();
        if (Intrinsics.areEqual((Object)((Object)((MysqlTableColumn)column2).getColumnKind()), (Object)((Object)MysqlColumnKind.GENERATED_STORED))) {
            res = res + " stored";
        }
        return res;
    }

    @Override
    @Nullable
    public String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        block5: {
            String spec;
            block4: {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
                spec = super.makeColumnSpecification(column2);
                string = column2.getComment();
                if (string == null) break block4;
                String it = string2 = string;
                StringBuilder stringBuilder = new StringBuilder().append("").append(spec).append(" comment ");
                String string3 = column2.getComment();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"column.comment!!");
                string = stringBuilder.append(this.getSqlString(string3)).toString();
                if (string != null) break block5;
            }
            string = spec;
        }
        return string;
    }

    @Override
    protected boolean allowReferenceOnPrimaryKeyWithoutColumns() {
        return false;
    }

    @Override
    protected void generateTableComment(@NotNull BasicTableOrView table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
    }

    @Override
    protected void generateColumnComment(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
    }

    public MysqlCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    static {
        Companion = new Companion(null);
        INDEX_COMMENT_VER = Version.of((int[])new int[]{5, 5});
    }

    public static final /* synthetic */ void access$appendIndexOrKeyProps(MysqlCreatingGenerator $this, @NotNull AbstractCodeGenerator.NewCodingAdapter $receiver, @Nullable MysqlIndex index2) {
        $this.appendIndexOrKeyProps($receiver, index2);
    }

    @NotNull
    public static final /* synthetic */ String access$argDataType(MysqlCreatingGenerator $this, @Nullable BasicArgument arg) {
        return $this.argDataType(arg);
    }

    public static final /* synthetic */ boolean access$canCreateInColumn(MysqlCreatingGenerator $this, @NotNull BasicElement element) {
        return $this.canCreateInColumn(element);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateView;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/mysql/MysqlView;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlView;)V", "produce", "", "intellij.database.scripting"})
    private final class MysqlCreateView
    extends BaseCreatingGenerator.CreateProducer<MysqlView> {
        @Override
        public void produce() {
            MysqlCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                final /* synthetic */ MysqlCreateView this$0;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    CompositeText compositeText = ((MysqlView)this.this$0.getElement()).getSourceText();
                    $receiver.plus($receiver.plus($receiver.plus($receiver.unaryPlus("create view"), MysqlCreateView.access$fqName(this.this$0)), "as"), compositeText != null ? compositeText.getContent() : null);
                }
                {
                    this.this$0 = mysqlCreateView;
                    super(1);
                }
            }));
        }

        public MysqlCreateView(MysqlView element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicElement)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(MysqlCreateView $this) {
            return $this.fqName();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateIndex;", "Lcom/intellij/database/model/mysql/MysqlIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlIndex;)V", "appendProperties", "", "canComment", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "qualifyName", "intellij.database.scripting"})
    private final class MysqlCreateIndex
    extends BaseCreatingGenerator.CreateIndex<MysqlIndex> {
        @Override
        public void appendProperties() {
            super.appendProperties();
            MysqlCreatingGenerator.this.sqlClause((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                final /* synthetic */ MysqlCreateIndex this$0;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    MysqlCreatingGenerator.access$appendIndexOrKeyProps(this.this$0.MysqlCreatingGenerator.this, $receiver, (MysqlIndex)this.this$0.getElement());
                }
                {
                    this.this$0 = mysqlCreateIndex;
                    super(1);
                }
            }));
        }

        @Override
        public boolean qualifyName() {
            return false;
        }

        @Override
        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
            Version version = Companion.getINDEX_COMMENT_VER();
            Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"INDEX_COMMENT_VER");
            return AbstractScriptingServiceKt.supportedSince(version);
        }

        public MysqlCreateIndex(MysqlIndex element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicIndex)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateKey;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateKey;", "Lcom/intellij/database/model/mysql/MysqlKey;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlKey;)V", "appendProperties", "", "intellij.database.scripting"})
    private final class MysqlCreateKey
    extends BaseCreatingGenerator.CreateKey<MysqlKey> {
        @Override
        public void appendProperties() {
            super.appendProperties();
            MysqlCreatingGenerator.this.sqlClause((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                final /* synthetic */ MysqlCreateKey this$0;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    MysqlCreatingGenerator.access$appendIndexOrKeyProps(this.this$0.MysqlCreatingGenerator.this, $receiver, (MysqlIndex)((MysqlKey)this.this$0.getElement()).getUnderlyingIndex());
                }
                {
                    this.this$0 = mysqlCreateKey;
                    super(1);
                }
            }));
        }

        public MysqlCreateKey(MysqlKey element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicKey)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateRoutine;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/mysql/MysqlRoutine;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlRoutine;)V", "produce", "", "intellij.database.scripting"})
    private final class MysqlCreateRoutine
    extends BaseCreatingGenerator.CreateProducer<MysqlRoutine> {
        @Override
        public void produce() {
            JBIterable args2 = ((MysqlRoutine)this.getElement()).getArguments().jbi().filter((Condition)produce.args.1.INSTANCE);
            MysqlCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this, args2){
                final /* synthetic */ MysqlCreateRoutine this$0;
                final /* synthetic */ JBIterable $args;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Iterable $receiver$iv;
                    AbstractCodeGenerator.NewCodingAdapter this_$iv;
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    if (((MysqlRoutine)this.this$0.getElement()).getReturnArgument() != null) {
                        $receiver.plus($receiver.unaryPlus("create function"), MysqlCreateRoutine.access$fqName(this.this$0));
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.unaryPlus("(");
                        JBIterable jBIterable = this.$args;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"args");
                        Iterable iterable = (Iterable)jBIterable;
                        object = $receiver;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter2 = newCodingAdapter;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter3 = $receiver;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter4 = $receiver;
                        String sep$iv = ", ";
                        Function0 function0 = (Function0)new Function0<Unit>(this_$iv, $receiver$iv, sep$iv, this, $receiver){
                            final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0$inline_fun;
                            final /* synthetic */ Iterable receiver$0;
                            final /* synthetic */ String $sep;
                            final /* synthetic */ produce.1 this$0;
                            final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter receiver$0$inlined;
                            {
                                this.this$0$inline_fun = newCodingAdapter;
                                this.receiver$0 = iterable;
                                this.$sep = string;
                                this.this$0 = var4_4;
                                this.receiver$0$inlined = newCodingAdapter2;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                Iterator<T> it = this.receiver$0.iterator();
                                if (it.hasNext()) {
                                    BasicElement $receiver$iv;
                                    Function0 function0;
                                    void this_$iv$iv;
                                    Function0 element$iv;
                                    AbstractCodeGenerator.NewCodingAdapter this_$iv;
                                    MysqlArgument it2 = (MysqlArgument)it.next();
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.receiver$0$inlined;
                                    MysqlArgument mysqlArgument = it2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlArgument, (String)"it");
                                    BasicElement basicElement = mysqlArgument;
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter2 = this.receiver$0$inlined;
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter3 = this.receiver$0$inlined;
                                    void var7_7 = this_$iv;
                                    String quotedName$iv$iv = this_$iv.quote((BasicElement)element$iv);
                                    void this_$iv$iv$iv = this_$iv$iv;
                                    element$iv = function0 = (Function0)new Function0<Unit>((AbstractCodeGenerator.NewCodingAdapter)this_$iv$iv$iv, quotedName$iv$iv){
                                        final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0;
                                        final /* synthetic */ String $text;
                                        {
                                            this.this$0 = newCodingAdapter;
                                            this.$text = string;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            if (this.$text != null) {
                                                AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                            } else {
                                                CompositeText.Kind kind = null;
                                                CharSequence charSequence = "???";
                                                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.this$0;
                                                String string = "unknown name";
                                                AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                            }
                                        }
                                    };
                                    this_$iv = newCodingAdapter2;
                                    this_$iv.onStart();
                                    newCodingAdapter2 = this_$iv.minus(this_$iv, (Function0<Unit>)$receiver$iv);
                                    MysqlCreatingGenerator mysqlCreatingGenerator = this.this$0.this$0.MysqlCreatingGenerator.this;
                                    DataType dataType = it2.getDataType();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"it.dataType");
                                    newCodingAdapter3.plus(newCodingAdapter2, mysqlCreatingGenerator.script(dataType));
                                    while (it.hasNext()) {
                                        this.this$0$inline_fun.setNoSpace(true);
                                        AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0$inline_fun, this.$sep, null, null, 6, null);
                                        it2 = (MysqlArgument)it.next();
                                        this_$iv = this.receiver$0$inlined;
                                        MysqlArgument mysqlArgument2 = it2;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlArgument2, (String)"it");
                                        $receiver$iv = mysqlArgument2;
                                        newCodingAdapter2 = this.receiver$0$inlined;
                                        newCodingAdapter3 = this.receiver$0$inlined;
                                        AbstractCodeGenerator.NewCodingAdapter $i$f$unaryMinus = this_$iv;
                                        quotedName$iv$iv = this_$iv.quote((BasicElement)element$iv);
                                        this_$iv$iv$iv = this_$iv$iv;
                                        element$iv = function0 = (Function0)new Function0<Unit>((AbstractCodeGenerator.NewCodingAdapter)this_$iv$iv$iv, quotedName$iv$iv){
                                            final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0;
                                            final /* synthetic */ String $text;
                                            {
                                                this.this$0 = newCodingAdapter;
                                                this.$text = string;
                                                super(0);
                                            }

                                            public final void invoke() {
                                                if (this.$text != null) {
                                                    AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                                } else {
                                                    CompositeText.Kind kind = null;
                                                    CharSequence charSequence = "???";
                                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.this$0;
                                                    String string = "unknown name";
                                                    AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                                }
                                            }
                                        };
                                        this_$iv = newCodingAdapter2;
                                        this_$iv.onStart();
                                        newCodingAdapter2 = this_$iv.minus(this_$iv, (Function0<Unit>)$receiver$iv);
                                        MysqlCreatingGenerator mysqlCreatingGenerator2 = this.this$0.this$0.MysqlCreatingGenerator.this;
                                        DataType dataType2 = it2.getDataType();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"it.dataType");
                                        newCodingAdapter3.plus(newCodingAdapter2, mysqlCreatingGenerator2.script(dataType2));
                                    }
                                }
                            }
                        };
                        newCodingAdapter4.minus(newCodingAdapter3.minus(newCodingAdapter2, (Function0<Unit>)function0), ")");
                        $receiver.plus($receiver.unaryPlus("returns"), MysqlCreatingGenerator.access$argDataType(this.this$0.MysqlCreatingGenerator.this, ((MysqlRoutine)this.this$0.getElement()).getReturnArgument()));
                    } else {
                        $receiver.plus($receiver.unaryPlus("create procedure"), MysqlCreateRoutine.access$fqName(this.this$0));
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.unaryPlus("(");
                        JBIterable jBIterable = this.$args;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"args");
                        $receiver$iv = (Iterable)jBIterable;
                        this_$iv = $receiver;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter5 = newCodingAdapter;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter6 = $receiver;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter7 = $receiver;
                        String sep$iv = ", ";
                        Function0 function0 = (Function0)new Function0<Unit>(this_$iv, $receiver$iv, sep$iv, this, $receiver){
                            final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0$inline_fun;
                            final /* synthetic */ Iterable receiver$0;
                            final /* synthetic */ String $sep;
                            final /* synthetic */ produce.1 this$0;
                            final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter receiver$0$inlined;
                            {
                                this.this$0$inline_fun = newCodingAdapter;
                                this.receiver$0 = iterable;
                                this.$sep = string;
                                this.this$0 = var4_4;
                                this.receiver$0$inlined = newCodingAdapter2;
                                super(0);
                            }

                            public final void invoke() {
                                Iterator<T> it = this.receiver$0.iterator();
                                if (it.hasNext()) {
                                    AbstractCodeGenerator.NewCodingAdapter this_$iv$iv;
                                    BasicElement element$iv;
                                    AbstractCodeGenerator.NewCodingAdapter this_$iv;
                                    MysqlArgument it2;
                                    MysqlArgument mysqlArgument = it2 = (MysqlArgument)it.next();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlArgument, (String)"it");
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.receiver$0$inlined;
                                    BasicElement basicElement = it2;
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter2 = this.receiver$0$inlined.unaryMinus(mysqlArgument.getArgumentDirection().name());
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter3 = this.receiver$0$inlined;
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter4 = this.receiver$0$inlined;
                                    void var8_8 = this_$iv;
                                    String quotedName$iv$iv = this_$iv.quote(element$iv);
                                    AbstractCodeGenerator.NewCodingAdapter this_$iv$iv$iv = this_$iv$iv;
                                    Function0 function0 = (Function0)new Function0<Unit>(this_$iv$iv$iv, quotedName$iv$iv){
                                        final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0;
                                        final /* synthetic */ String $text;
                                        {
                                            this.this$0 = newCodingAdapter;
                                            this.$text = string;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            if (this.$text != null) {
                                                AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                            } else {
                                                CompositeText.Kind kind = null;
                                                CharSequence charSequence = "???";
                                                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.this$0;
                                                String string = "unknown name";
                                                AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                            }
                                        }
                                    };
                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter5 = newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
                                    MysqlCreatingGenerator mysqlCreatingGenerator = this.this$0.this$0.MysqlCreatingGenerator.this;
                                    DataType dataType = it2.getDataType();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"it.dataType");
                                    newCodingAdapter4.plus(newCodingAdapter5, mysqlCreatingGenerator.script(dataType));
                                    while (it.hasNext()) {
                                        this.this$0$inline_fun.setNoSpace(true);
                                        AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0$inline_fun, this.$sep, null, null, 6, null);
                                        MysqlArgument mysqlArgument2 = it2 = (MysqlArgument)it.next();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)mysqlArgument2, (String)"it");
                                        this_$iv = this.receiver$0$inlined;
                                        element$iv = it2;
                                        newCodingAdapter2 = this.receiver$0$inlined.unaryMinus(mysqlArgument2.getArgumentDirection().name());
                                        newCodingAdapter3 = this.receiver$0$inlined;
                                        newCodingAdapter4 = this.receiver$0$inlined;
                                        this_$iv$iv = this_$iv;
                                        quotedName$iv$iv = this_$iv.quote(element$iv);
                                        this_$iv$iv$iv = this_$iv$iv;
                                        function0 = (Function0)new Function0<Unit>(this_$iv$iv$iv, quotedName$iv$iv){
                                            final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0;
                                            final /* synthetic */ String $text;
                                            {
                                                this.this$0 = newCodingAdapter;
                                                this.$text = string;
                                                super(0);
                                            }

                                            public final void invoke() {
                                                if (this.$text != null) {
                                                    AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                                } else {
                                                    CompositeText.Kind kind = null;
                                                    CharSequence charSequence = "???";
                                                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.this$0;
                                                    String string = "unknown name";
                                                    AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                                }
                                            }
                                        };
                                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter6 = newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
                                        MysqlCreatingGenerator mysqlCreatingGenerator2 = this.this$0.this$0.MysqlCreatingGenerator.this;
                                        DataType dataType2 = it2.getDataType();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"it.dataType");
                                        newCodingAdapter4.plus(newCodingAdapter6, mysqlCreatingGenerator2.script(dataType2));
                                    }
                                }
                            }
                        };
                        newCodingAdapter7.minus(newCodingAdapter6.minus(newCodingAdapter5, (Function0<Unit>)function0), ")");
                    }
                    String string = ((MysqlRoutine)this.this$0.getElement()).getComment();
                    if (string != null) {
                        Object it = object = string;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.unaryPlus("comment");
                        MysqlCreatingGenerator mysqlCreatingGenerator = this.this$0.MysqlCreatingGenerator.this;
                        Object object2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                        $receiver.plus(newCodingAdapter, MysqlCreatingGenerator.access$getSqlString$p(mysqlCreatingGenerator, (String)object2));
                    }
                    $receiver.newLine();
                    CompositeText compositeText = ((MysqlRoutine)this.this$0.getElement()).getSourceText();
                    $receiver.unaryPlus(compositeText != null ? compositeText.getContent() : null);
                }
                {
                    this.this$0 = mysqlCreateRoutine;
                    this.$args = jBIterable;
                    super(1);
                }
            }));
        }

        public MysqlCreateRoutine(MysqlRoutine element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicElement)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(MysqlCreateRoutine $this) {
            return $this.fqName();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\t*\u00060\u000bR\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateEvent;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/mysql/MysqlEvent;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlEvent;)V", "getStatusClause", "", "produce", "", "appendTiming", "Lcom/intellij/database/scripting/AbstractCodeGenerator$NewCodingAdapter;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "ivl", "starts", "ends", "intellij.database.scripting"})
    private final class MysqlCreateEvent
    extends BaseCreatingGenerator.CreateProducer<MysqlEvent> {
        @Override
        public void produce() {
            MysqlCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                final /* synthetic */ MysqlCreateEvent this$0;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Object it;
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Object object2 = ((MysqlEvent)this.this$0.getElement()).getDefiner();
                    String def2 = object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])new char[]{'@'}, (boolean)false, (int)0, (int)6, null)) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"@", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                        final /* synthetic */ produce.1 this$0;

                        @NotNull
                        public final String invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            String $receiver$iv = it;
                            MysqlCreatingGenerator this_$iv = this.this$0.this$0.MysqlCreatingGenerator.this;
                            return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }), (int)30, null) : null;
                    $receiver.unaryPlus("create");
                    String string = def2;
                    if (string != null) {
                        String string2;
                        String it2 = string2 = string;
                        $receiver.plus($receiver.unaryPlus("definer ="), it2);
                    }
                    $receiver.plus($receiver.plus($receiver.unaryPlus("event"), MysqlCreateEvent.access$fqName(this.this$0)), "on schedule");
                    AbstractCodeGenerator.NewCodingAdapter this_$iv = $receiver;
                    this_$iv.newLine();
                    this_$iv.indent();
                    AbstractCodeGenerator.NewCodingAdapter this_$iv2 = $receiver;
                    boolean nl$iv = true;
                    boolean prev$iv = this_$iv2.getStartWithNewLine();
                    this_$iv2.setStartWithNewLine(nl$iv);
                    MysqlCreateEvent.access$appendTiming(this.this$0, $receiver, ((MysqlEvent)this.this$0.getElement()).getInterval(), ((MysqlEvent)this.this$0.getElement()).getStarts(), ((MysqlEvent)this.this$0.getElement()).getEnds());
                    if (Intrinsics.areEqual((Object)((MysqlEvent)this.this$0.getElement()).getPreserve(), (Object)true)) {
                        $receiver.unaryPlus("on completion preserve");
                    }
                    $receiver.unaryPlus(MysqlCreateEvent.access$getStatusClause(this.this$0));
                    String string3 = ((MysqlEvent)this.this$0.getElement()).getComment();
                    if (string3 != null) {
                        it = object = string3;
                        AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.unaryPlus("comment");
                        MysqlCreatingGenerator mysqlCreatingGenerator = this.this$0.MysqlCreatingGenerator.this;
                        String string4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                        $receiver.plus(newCodingAdapter, MysqlCreatingGenerator.access$getSqlString$p(mysqlCreatingGenerator, string4));
                    }
                    $receiver.unaryPlus("do");
                    Object object3 = ((MysqlEvent)this.this$0.getElement()).getSourceText();
                    if (object3 == null || (object3 = object3.getContent()) == null || (object3 = $receiver.unaryPlus((CompositeText.Fragment)(it = (object = object3)))) == null) {
                        $receiver.error("no original text");
                        object3 = Unit.INSTANCE;
                    }
                    this_$iv2.setStartWithNewLine(prev$iv);
                    this_$iv.unindent();
                }
                {
                    this.this$0 = mysqlCreateEvent;
                    super(1);
                }
            }));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getStatusClause() {
            MysqlEventStatus mysqlEventStatus = ((MysqlEvent)this.getElement()).getStatus();
            if (mysqlEventStatus == null) return null;
            switch (MysqlCreatingGenerator$MysqlCreateEvent$WhenMappings.$EnumSwitchMapping$0[mysqlEventStatus.ordinal()]) {
                case 1: {
                    return "enable";
                }
                case 2: {
                    return "disable";
                }
                case 3: {
                    return "disable on slave";
                }
                default: {
                    return null;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void appendTiming(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver, String ivl, String starts, String ends) {
            if (ivl != null) {
                String it;
                String string;
                $receiver.plus($receiver.unaryPlus("every"), ivl);
                String string2 = starts;
                if (string2 != null) {
                    it = string = string2;
                    $receiver.plus($receiver.unaryPlus("starts"), it);
                }
                String string3 = ends;
                if (string3 != null) {
                    it = string = string3;
                    $receiver.plus($receiver.unaryPlus("ends"), it);
                }
            } else {
                void this_$iv;
                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver;
                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter2 = $receiver.unaryPlus("at");
                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter3 = $receiver;
                Function0 function0 = (Function0)new Function0<Unit>((AbstractCodeGenerator.NewCodingAdapter)this_$iv, starts){
                    final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0;
                    final /* synthetic */ String $text;
                    {
                        this.this$0 = newCodingAdapter;
                        this.$text = string;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.$text != null) {
                            AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                        } else {
                            CompositeText.Kind kind = null;
                            CharSequence charSequence = "???";
                            AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.this$0;
                            String string = "no at time";
                            AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                        }
                    }
                };
                newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
            }
        }

        public MysqlCreateEvent(MysqlEvent element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicElement)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(MysqlCreateEvent $this) {
            return $this.fqName();
        }

        public static final /* synthetic */ void access$appendTiming(MysqlCreateEvent $this, @NotNull AbstractCodeGenerator.NewCodingAdapter $receiver, @Nullable String ivl, @Nullable String starts, @Nullable String ends) {
            $this.appendTiming($receiver, ivl, starts, ends);
        }

        @Nullable
        public static final /* synthetic */ String access$getStatusClause(MysqlCreateEvent $this) {
            return $this.getStatusClause();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTrigger;", "Lcom/intellij/database/model/mysql/MysqlTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlTrigger;)V", "produce", "", "intellij.database.scripting"})
    private final class MysqlCreateTrigger
    extends BaseCreatingGenerator.CreateTrigger<MysqlTrigger> {
        @Override
        public void produce() {
            Set<TrigEvent> set = ((MysqlTrigger)this.getElement()).getEvents();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"element.events");
            String event = ((TrigEvent)CollectionsKt.first((Iterable)set)).name();
            String turn = Intrinsics.areEqual((Object)((MysqlTrigger)this.getElement()).getTurn(), (Object)TrigTurn.BEFORE_ROW) ? "before" : "after";
            MysqlCreatingGenerator.this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this, turn, event){
                final /* synthetic */ MysqlCreateTrigger this$0;
                final /* synthetic */ String $turn;
                final /* synthetic */ String $event;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Object it;
                    void text$iv;
                    void this_$iv;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    AbstractCodeGenerator.NewCodingAdapter this_$iv2 = $receiver;
                    boolean nl$iv = true;
                    boolean prev$iv = this_$iv2.getStartWithNewLine();
                    this_$iv2.setStartWithNewLine(nl$iv);
                    $receiver.plus($receiver.unaryPlus("create trigger"), MysqlCreateTrigger.access$fqName(this.this$0));
                    Object object = $receiver;
                    MysqlTable mysqlTable = ((MysqlTrigger)this.this$0.getElement()).getTable();
                    String string = mysqlTable != null ? AbstractCodeGenerator.currentScopeName$default(this.this$0.MysqlCreatingGenerator.this, mysqlTable, null, 1, null) : null;
                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = $receiver.plus($receiver.plus($receiver.unaryPlus(this.$turn), this.$event), "on");
                    AbstractCodeGenerator.NewCodingAdapter newCodingAdapter2 = $receiver;
                    Function0 function0 = (Function0)new Function0<Unit>((AbstractCodeGenerator.NewCodingAdapter)this_$iv, (String)text$iv){
                        final /* synthetic */ AbstractCodeGenerator.NewCodingAdapter this$0;
                        final /* synthetic */ String $text;
                        {
                            this.this$0 = newCodingAdapter;
                            this.$text = string;
                            super(0);
                        }

                        public final void invoke() {
                            if (this.$text != null) {
                                AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                            } else {
                                CompositeText.Kind kind = null;
                                CharSequence charSequence = "???";
                                AbstractCodeGenerator.NewCodingAdapter newCodingAdapter = this.this$0;
                                String string = "unknown table";
                                AbstractCodeGenerator.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                            }
                        }
                    };
                    newCodingAdapter2.plus(newCodingAdapter, (Function0<Unit>)function0);
                    $receiver.unaryPlus("for each row");
                    Object object2 = ((MysqlTrigger)this.this$0.getElement()).getSourceText();
                    if (object2 == null || (object2 = object2.getContent()) == null || (object2 = $receiver.unaryPlus((CompositeText.Fragment)(it = (object = object2)))) == null) {
                        $receiver.error("no source text");
                        object2 = Unit.INSTANCE;
                    }
                    this_$iv2.setStartWithNewLine(prev$iv);
                }
                {
                    this.this$0 = mysqlCreateTrigger;
                    this.$turn = string;
                    this.$event = string2;
                    super(1);
                }
            }));
        }

        public MysqlCreateTrigger(MysqlTrigger element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicTrigger)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(MysqlCreateTrigger $this) {
            return $this.fqName();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$MysqlCreateTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTable;", "Lcom/intellij/database/model/mysql/MysqlTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;Lcom/intellij/database/model/mysql/MysqlTable;)V", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "intellij.database.scripting"})
    private final class MysqlCreateTable
    extends BaseCreatingGenerator.CreateTable<MysqlTable> {
        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter() {
            String it;
            CharSequence charSequence;
            HeaderFooter hf = super.makeTableHeaderFooter();
            StringBuilder footer = new StringBuilder();
            String string = ((MysqlTable)this.getElement()).getComment();
            if (string != null) {
                charSequence = string;
                it = charSequence;
                StringBuilder stringBuilder = new StringBuilder().append(" comment ");
                String string2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                footer.append(stringBuilder.append(MysqlCreatingGenerator.this.getSqlString(string2)).toString());
            }
            String string3 = MysqlCreatingGenerator.this.makeEngineSpec(((MysqlTable)this.getElement()).getEngine());
            if (string3 != null) {
                charSequence = string3;
                it = charSequence;
                footer.append(" ").append(it);
            }
            String string4 = MysqlCreatingGenerator.this.makeTableCollationSpec(((MysqlTable)this.getElement()).getCollation());
            if (string4 != null) {
                charSequence = string4;
                it = charSequence;
                footer.append(" ").append(it);
            }
            charSequence = footer;
            if (!(charSequence.length() == 0)) {
                hf = new HeaderFooter(hf.getHeader(), footer.substring(1));
            }
            return hf;
        }

        public MysqlCreateTable(MysqlTable element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MysqlCreatingGenerator.this, (BasicTable)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator$Companion;", "", "()V", "INDEX_COMMENT_VER", "Lorg/jetbrains/dekaf/util/Version;", "kotlin.jvm.PlatformType", "getINDEX_COMMENT_VER", "()Lorg/jetbrains/dekaf/util/Version;", "intellij.database.scripting"})
    public static final class Companion {
        public final Version getINDEX_COMMENT_VER() {
            return INDEX_COMMENT_VER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

