/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mssql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.mssql.MsCheck;
import com.intellij.database.model.mssql.MsDefaultConstraint;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsSourceAware;
import com.intellij.database.model.mssql.MsStoredColumn;
import com.intellij.database.model.mssql.MsStoredTable;
import com.intellij.database.model.mssql.MsTableOrView;
import com.intellij.database.model.mssql.MsTableType;
import com.intellij.database.model.mssql.MsTableTypeColumn;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0005#$%&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0002\b\u00030\bR\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0014J\f\u0010\"\u001a\u00020\u0016*\u00020\u0016H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateColumnComment", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "makeColumnSpecification", "", "makeDefault", "makeIdentity", "q", "Lcom/intellij/database/model/SequenceIdentity;", "makeIdentity$intellij_database_scripting", "makeIndexWord", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "makeKeyWord", "key", "Lcom/intellij/database/model/basic/BasicKey;", "quoteNameAsString", "MsCreateAliasType", "MsCreateDefaultConstraint", "MsCreateIndex", "MsCreateTableType", "MsCreateTrigger", "intellij.database.scripting"})
public final class MsCreatingGenerator
extends BaseCreatingGenerator {
    @Override
    @NotNull
    public BaseCreatingGenerator.CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof MsAliasType ? (BaseCreatingGenerator.CreateProducer)new MsCreateAliasType((MsAliasType)element) : (basicElement instanceof MsTableType ? (BaseCreatingGenerator.CreateProducer)new MsCreateTableType((MsTableType)element) : (basicElement instanceof MsTrigger ? (BaseCreatingGenerator.CreateProducer)new MsCreateTrigger((MsTrigger)element) : (basicElement instanceof MsIndex ? (BaseCreatingGenerator.CreateProducer)new MsCreateIndex((MsIndex)element) : (basicElement instanceof MsSourceAware ? (BaseCreatingGenerator.CreateProducer)new BaseCreatingGenerator.CreateSourceAware((BaseCreatingGenerator)this, (BasicSourceAware)element) : (basicElement instanceof MsDefaultConstraint ? (BaseCreatingGenerator.CreateProducer)new MsCreateDefaultConstraint((MsDefaultConstraint)element) : super.createProducer(element))))));
    }

    @Override
    @Nullable
    public String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        Ref.ObjectRef s;
        block2: {
            String string;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
                s = new Ref.ObjectRef();
                if (!Intrinsics.areEqual((Object)column2.getName(), (Object)"timestamp") || !Intrinsics.areEqual((Object)column2.getDataType().typeName, (Object)"timestamp") || column2.getDataType().custom) break block1;
                s.element = column2.isNotNull() ? "not null" : "null";
                break block2;
            }
            s.element = super.makeColumnSpecification(column2);
            BasicLikeColumn basicLikeColumn = column2;
            if (!(basicLikeColumn instanceof BasicTableColumn)) {
                basicLikeColumn = null;
            }
            BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
            SequenceIdentity q = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
            String string2 = this.makeIdentity$intellij_database_scripting(q);
            if (string2 == null) break block2;
            String it = string = string2;
            s.element = Intrinsics.stringPlus((String)((String)s.element), (Object)it);
        }
        return (String)s.element;
    }

    @Override
    @NotNull
    protected String makeDefault(@NotNull BasicLikeColumn column2) {
        String constraintName;
        String string;
        MsDefaultConstraint dc;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String s = "default " + column2.getDefaultExpression();
        BasicLikeColumn basicLikeColumn = column2;
        if (!(basicLikeColumn instanceof MsStoredColumn)) {
            basicLikeColumn = null;
        }
        MsStoredColumn msStoredColumn = (MsStoredColumn)basicLikeColumn;
        MsDefaultConstraint msDefaultConstraint = dc = msStoredColumn != null ? ModelFun.getDefaultConstraint(msStoredColumn) : null;
        if (msDefaultConstraint != null) {
            MsDefaultConstraint msDefaultConstraint2;
            MsDefaultConstraint it = msDefaultConstraint2 = msDefaultConstraint;
            string = this.quote(it, ModelFun.name(it, this.getTask().getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES)));
        } else {
            string = constraintName = null;
        }
        if (constraintName != null) {
            s = "constraint " + constraintName + ' ' + s;
        }
        return s;
    }

    @Nullable
    public final String makeIdentity$intellij_database_scripting(@Nullable SequenceIdentity q) {
        return q == null ? null : (Intrinsics.areEqual((Object)q.min, (Object)BigInteger.ONE) && Intrinsics.areEqual((Object)q.increment, (Object)BigInteger.ONE) ? " identity" : " identity(" + q.min + ", " + q.increment + ')');
    }

    @Override
    @NotNull
    protected String makeKeyWord(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return key2 instanceof MsKey ? (((MsKey)key2).isPrimary() ? (((MsKey)key2).isClustering() ? "primary key" : "primary key nonclustered") : (((MsKey)key2).isClustering() ? "unique clustered" : "unique")) : super.makeKeyWord(key2);
    }

    @Override
    @NotNull
    protected String makeIndexWord(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        MsIndex i2 = (MsIndex)index2;
        if (i2.isUnique()) {
            boolean primary2;
            MsLikeTable table = ((MsIndex)index2).getLikeTable();
            boolean bl = primary2 = table instanceof MsStoredTable && ((MsStoredTable)table).getKeys().has((Predicate<? extends MsKey>)new Predicate<MsKey>(i2){
                final /* synthetic */ MsIndex $i;

                public final boolean test(MsKey it) {
                    MsKey msKey = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)msKey, (String)"it");
                    return msKey.isPrimary() && Intrinsics.areEqual((Object)it.getUnderlyingIndexName(), (Object)this.$i.getName());
                }
                {
                    this.$i = msIndex;
                }
            });
            String word = primary2 ? (i2.isClustering() ? "unique index" : "unique nonclustered index") : (i2.isClustering() ? "unique clustered index" : "unique index");
            return word;
        }
        return i2.isClustering() ? "clustered index" : "index";
    }

    @Override
    protected void generateTableComment(@NotNull BasicTableOrView table) {
        String string;
        ObjectKind kind;
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String string2 = table.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"table.name");
        String name = this.quoteNameAsString(string2);
        String string3 = table.getComment();
        if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
            return;
        }
        String comment = string3;
        ObjectKind objectKind = kind = table.getKind();
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
            string = "TABLE";
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
            string = "VIEW";
        } else {
            return;
        }
        String tableWord = string;
        String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + name + "\n              "), null, (int)1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $s;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), this.$s, null, false, null, 14, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$s = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateColumnComment(@NotNull BasicLikeColumn column2) {
        String string;
        ObjectKind kind;
        BasicLikeTable table;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicLikeTable basicLikeTable = column2.getLikeTable();
        if (basicLikeTable == null) {
            return;
        }
        BasicLikeTable basicLikeTable2 = table = basicLikeTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable2, (String)"table");
        String string2 = basicLikeTable2.getRealName();
        if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
            return;
        }
        String tableName = string2;
        String string3 = column2.getRealName();
        if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
            return;
        }
        String columnName = string3;
        String string4 = column2.getComment();
        if (string4 == null || (string4 = this.quoteNameAsString(string4)) == null) {
            return;
        }
        String comment = string4;
        ObjectKind objectKind = kind = table.getKind();
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
            string = "TABLE";
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
            string = "VIEW";
        } else {
            return;
        }
        String tableWord = string;
        String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + tableName + ", N'COLUMN', N" + columnName + "\n              "), null, (int)1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $s;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), this.$s, null, false, null, 14, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$s = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String triggerName = AbstractCodeGenerator.currentScopeName$default(this, trigger, null, 1, null);
        BasicLikeTable basicLikeTable = trigger.getLikeTable();
        if (basicLikeTable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsTableOrView");
        }
        String tableName = AbstractCodeGenerator.currentScopeName$default(this, (MsTableOrView)basicLikeTable, null, 1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, tableName){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $triggerName;
            final /* synthetic */ String $tableName;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "disable trigger " + this.$triggerName + " on " + this.$tableName, null, false, null, 14, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$triggerName = string;
                this.$tableName = string2;
                super(0);
            }
        }, 3, null);
    }

    private final String quoteNameAsString(@NotNull String $receiver) {
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    public MsCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(MsCreatingGenerator $this) {
        return $this.getBuilder();
    }

    public static final /* synthetic */ void access$setLocus$p(MsCreatingGenerator $this, @NotNull ScriptLocus scriptLocus) {
        $this.setLocus(scriptLocus);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator$MsCreateAliasType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/mssql/MsAliasType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;Lcom/intellij/database/model/mssql/MsAliasType;)V", "produce", "", "intellij.database.scripting"})
    private final class MsCreateAliasType
    extends BaseCreatingGenerator.CreateProducer<MsAliasType> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void produce() {
            void statement;
            String name = this.fqName();
            DataType dataType = ((MsAliasType)this.getElement()).getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"element.dataType");
            String type1 = dataType.getSpecification();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "create type " + name + " from " + type1;
            if (((MsAliasType)this.getElement()).isNotNull()) {
                statement.element = (String)statement.element + " not null";
            }
            AbstractCodeGenerator.coding$default(MsCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, (Ref.ObjectRef)statement){
                final /* synthetic */ MsCreateAliasType this$0;
                final /* synthetic */ Ref.ObjectRef $statement;

                public final void invoke() {
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), (String)this.$statement.element, null, false, null, 14, null);
                }
                {
                    this.this$0 = msCreateAliasType;
                    this.$statement = objectRef;
                    super(0);
                }
            }, 3, null);
        }

        public MsCreateAliasType(MsAliasType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MsCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator$MsCreateIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateIndex;", "Lcom/intellij/database/model/mssql/MsIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;Lcom/intellij/database/model/mssql/MsIndex;)V", "qualifyName", "", "intellij.database.scripting"})
    private final class MsCreateIndex
    extends BaseCreatingGenerator.CreateIndex<MsIndex> {
        @Override
        public boolean qualifyName() {
            return false;
        }

        public MsCreateIndex(MsIndex element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MsCreatingGenerator.this, (BasicIndex)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator$MsCreateTableType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/mssql/MsTableType;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;Lcom/intellij/database/model/mssql/MsTableType;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    private final class MsCreateTableType
    extends BaseCreatingGenerator.CreateProducer<MsTableType> {
        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            BasicNamedElement it;
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            PositioningNamingFamily<? extends MsTableTypeColumn> positioningNamingFamily = ((MsTableType)this.getElement()).getColumns();
            Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
            Iterable $receiver$iv = positioningNamingFamily;
            for (Object element$iv : $receiver$iv) {
                MsTableTypeColumn msTableTypeColumn = it = (MsTableTypeColumn)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)msTableTypeColumn, (String)"it");
                BaseCreatingGenerator.prepareElement$default(MsCreatingGenerator.this, msTableTypeColumn, $receiver, false, 4, null);
            }
            NamingIdentifyingFamily<? extends MsKey> namingIdentifyingFamily = ((MsTableType)this.getElement()).getKeys();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"element.keys");
            $receiver$iv = namingIdentifyingFamily;
            for (Object element$iv : $receiver$iv) {
                BasicNamedElement basicNamedElement = it = (MsKey)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
                BaseCreatingGenerator.prepareElement$default(MsCreatingGenerator.this, basicNamedElement, $receiver, false, 4, null);
            }
            NamingIdentifyingFamily<? extends MsCheck> namingIdentifyingFamily2 = ((MsTableType)this.getElement()).getChecks();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily2, (String)"element.checks");
            $receiver$iv = namingIdentifyingFamily2;
            for (Object element$iv : $receiver$iv) {
                BasicNamedElement basicNamedElement = it = (MsCheck)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
                BaseCreatingGenerator.prepareElement$default(MsCreatingGenerator.this, basicNamedElement, $receiver, false, 4, null);
            }
            return operation;
        }

        @Override
        public void produce() {
            String name = this.fqName();
            AbstractCodeGenerator.coding$default(MsCreatingGenerator.this, ScriptLocus.IN_TABLE, false, (Function0)new Function0<Unit>(this, name){
                final /* synthetic */ MsCreateTableType this$0;
                final /* synthetic */ String $name;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "create type " + this.$name + " as table", null, false, null, 14, null);
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "(", null, false, null, 14, null);
                    CodeTextBuilder this_$iv = MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        void $receiver$iv;
                        PositioningNamingFamily<? extends MsTableTypeColumn> positioningNamingFamily = ((MsTableType)this.this$0.getElement()).getColumns();
                        Intrinsics.checkExpressionValueIsNotNull(positioningNamingFamily, (String)"element.columns");
                        if (positioningNamingFamily.isEmpty()) {
                            CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "-- the table type " + ((MsTableType)this.this$0.getElement()).getName() + " has no columns", null, false, null, 14, null);
                        }
                        Iterable iterable = this.this$0.getNestedOperations();
                        MsCreatingGenerator msCreatingGenerator = this.this$0.MsCreatingGenerator.this;
                        for (T element$iv : $receiver$iv) {
                            Operation p1 = (Operation)element$iv;
                            msCreatingGenerator.produce(p1);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this).removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), ")", null, false, null, 14, null);
                }
                {
                    this.this$0 = msCreateTableType;
                    this.$name = string;
                    super(0);
                }
            }, 2, null);
        }

        public MsCreateTableType(MsTableType element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MsCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0092\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator$MsCreateDefaultConstraint;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateConstraint;", "Lcom/intellij/database/model/mssql/MsDefaultConstraint;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;Lcom/intellij/database/model/mssql/MsDefaultConstraint;)V", "produce", "", "intellij.database.scripting"})
    private class MsCreateDefaultConstraint
    extends BaseCreatingGenerator.CreateConstraint<MsDefaultConstraint> {
        @Override
        public void produce() {
            if (Intrinsics.areEqual((Object)((Object)MsCreatingGenerator.this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE))) {
                AbstractCodeGenerator.coding$default(MsCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ MsCreateDefaultConstraint this$0;

                    public final void invoke() {
                        String string;
                        MsCreateDefaultConstraint.access$alterTable(this.this$0);
                        CodeTextBuilder.ensureEoln$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), null, 1, null);
                        CodeTextBuilder.indent$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), null, 1, null);
                        String string2 = MsCreateDefaultConstraint.access$nameScr(this.this$0);
                        if (string2 != null) {
                            String string3;
                            String it = string3 = string2;
                            string = "constraint " + it;
                        } else {
                            string = null;
                        }
                        String constraintNameClause = string;
                        CodeTextBuilder codeTextBuilder = MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this);
                        CharSequence[] charSequenceArray = new CharSequence[6];
                        charSequenceArray[0] = "add";
                        charSequenceArray[1] = constraintNameClause;
                        charSequenceArray[2] = "default";
                        charSequenceArray[3] = ((MsDefaultConstraint)this.this$0.getElement()).getDefaultExpression();
                        charSequenceArray[4] = "for";
                        List<String> list = ((MsDefaultConstraint)this.this$0.getElement()).getColNames();
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                        charSequenceArray[5] = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
                        codeTextBuilder.phrase(charSequenceArray);
                    }
                    {
                        this.this$0 = msCreateDefaultConstraint;
                        super(0);
                    }
                }, 3, null);
            }
        }

        public MsCreateDefaultConstraint(MsDefaultConstraint element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MsCreatingGenerator.this, (BasicConstraint)element);
        }

        public static final /* synthetic */ void access$alterTable(MsCreateDefaultConstraint $this) {
            $this.alterTable();
        }

        @Nullable
        public static final /* synthetic */ String access$nameScr(MsCreateDefaultConstraint $this) {
            return $this.nameScr();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator$MsCreateTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTrigger;", "Lcom/intellij/database/model/mssql/MsTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;Lcom/intellij/database/model/mssql/MsTrigger;)V", "generateEncryptedTrigger", "", "produce", "intellij.database.scripting"})
    private final class MsCreateTrigger
    extends BaseCreatingGenerator.CreateTrigger<MsTrigger> {
        @Override
        public void produce() {
            if (((MsTrigger)this.getElement()).isEncrypted()) {
                this.generateEncryptedTrigger();
            } else {
                MsCreatingGenerator.this.generateSourceAwareUsingSources((BasicSourceAware)this.getElement());
            }
            if (((MsTrigger)this.getElement()).isDisabled()) {
                MsCreatingGenerator.this.generateDisableTrigger((BasicTrigger)this.getElement());
            }
        }

        private final void generateEncryptedTrigger() {
            AbstractCodeGenerator.coding$default(MsCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ MsCreateTrigger this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "create trigger " + MsCreateTrigger.access$fqName(this.this$0), null, false, null, 14, null);
                    CodeTextBuilder this_$iv = MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder codeTextBuilder = MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this);
                        StringBuilder stringBuilder = new StringBuilder().append("on ");
                        Object object = ((MsTrigger)this.this$0.getElement()).getTable();
                        if (object == null || (object = AbstractCodeGenerator.currentScopeName$default(this.this$0.MsCreatingGenerator.this, (BasicElement)object, null, 1, null)) == null) {
                            object = ((MsTrigger)this.this$0.getElement()).getTableName();
                        }
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append((String)object).toString(), null, false, null, 14, null);
                        CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "with encryption", null, false, null, 14, null);
                        CodeTextBuilder codeTextBuilder2 = MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this);
                        StringBuilder stringBuilder2 = new StringBuilder().append("for ");
                        Set<TrigEvent> set = ((MsTrigger)this.this$0.getElement()).getEvents();
                        Intrinsics.checkExpressionValueIsNotNull(set, (String)"element.events");
                        CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString(), null, false, null, 14, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "as", null, false, null, 14, null);
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0.MsCreatingGenerator.this), "select null -- the original source text was encrypted", null, false, "the original source text was encrypted", 6, null);
                }
                {
                    this.this$0 = msCreateTrigger;
                    super(0);
                }
            }, 3, null);
        }

        public MsCreateTrigger(MsTrigger element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super((BaseCreatingGenerator)MsCreatingGenerator.this, (BasicTrigger)element);
        }

        @NotNull
        public static final /* synthetic */ String access$fqName(MsCreateTrigger $this) {
            return $this.fqName();
        }
    }
}

