/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H&J\u0017\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010'R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u0082\u0001\u0002()\u00a8\u0006*"}, d2={"Lcom/intellij/database/scripting/ScriptingTaskBuilder;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/database/model/basic/BasicModel;)V", "db", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "version", "Lorg/jetbrains/dekaf/util/Version;", "getVersion", "()Lorg/jetbrains/dekaf/util/Version;", "setVersion", "(Lorg/jetbrains/dekaf/util/Version;)V", "build", "Lcom/intellij/database/scripting/ScriptingTask;", "setCurrentNamespace", "", "nsp", "Lcom/intellij/database/model/basic/BasicNamespace;", "(Lcom/intellij/database/model/basic/BasicNamespace;)Lkotlin/Unit;", "Lcom/intellij/database/scripting/ScriptingSingleModelTaskBuilderBase;", "Lcom/intellij/database/scripting/ScriptingAlterTaskBuilder;", "intellij.database.scripting"})
public abstract class ScriptingTaskBuilder {
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private Version version;
    @Nullable
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;
    @NotNull
    private final BasicModel model;

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"<set-?>");
        this.version = version;
    }

    @Nullable
    public final BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    public final void setCurrentDatabase(@Nullable BasicDatabase db) {
        if (db != null) {
            boolean bl = Intrinsics.areEqual((Object)db.getModel(), (Object)this.model);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Intrinsics.areEqual((Object)this.currentDatabase, (Object)db) ^ true) {
                this.setCurrentSchema(null);
                this.currentDatabase = db;
            }
        } else {
            this.setCurrentSchema(null);
            this.currentDatabase = null;
        }
    }

    @Nullable
    public final BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public final void setCurrentSchema(@Nullable BasicSchema s) {
        if (s != null) {
            boolean bl = Intrinsics.areEqual((Object)s.getModel(), (Object)this.model);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.setCurrentDatabase(s.getDatabase());
            this.currentSchema = s;
        } else {
            this.currentSchema = null;
        }
    }

    @Nullable
    public final Unit setCurrentNamespace(@Nullable BasicNamespace nsp) {
        Unit unit;
        BasicNamespace basicNamespace = nsp;
        if (basicNamespace instanceof BasicSchema) {
            this.setCurrentSchema((BasicSchema)nsp);
            unit = Unit.INSTANCE;
        } else if (basicNamespace instanceof BasicDatabase) {
            this.setCurrentDatabase((BasicDatabase)nsp);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @NotNull
    public abstract ScriptingTask build();

    @NotNull
    protected final BasicModel getModel() {
        return this.model;
    }

    private ScriptingTaskBuilder(BasicModel model) {
        this.model = model;
        this.options = DefaultScriptingOptions.INSTANCE;
        BasicRoot basicRoot = this.model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
        Version version = basicRoot.getServerVersion();
        if (version == null) {
            Version version2 = Version.ZERO;
            version = version2;
            Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        }
        this.version = version;
        BasicRoot basicRoot2 = this.model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot2, (String)"model.root");
        BasicDatabase basicDatabase = this.currentDatabase = basicRoot2.getCurrentDatabase();
        this.currentSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
    }

    public /* synthetic */ ScriptingTaskBuilder(@NotNull BasicModel model, DefaultConstructorMarker $constructor_marker) {
        this(model);
    }
}

