/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingTaskKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/database/scripting/ScriptingContext;", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingTask;)V", "currentDatabaseName", "", "getCurrentDatabaseName", "()Ljava/lang/String;", "setCurrentDatabaseName", "(Ljava/lang/String;)V", "currentSchemaName", "getCurrentSchemaName", "setCurrentSchemaName", "model", "Lcom/intellij/database/model/basic/BasicModel;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "getScript", "()Ljava/util/List;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "intellij.database.scripting"})
public class ScriptingContext {
    @Nullable
    private String currentDatabaseName;
    @Nullable
    private String currentSchemaName;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private final List<CompositeText> script;
    @NotNull
    private final ScriptingTask task;

    @NotNull
    public final Rdbms getRdbms() {
        return ScriptingTaskKt.getRdbms(this.task);
    }

    @NotNull
    public final BasicModel getModel() {
        BasicModel basicModel = ScriptingTaskKt.getAnyModel(this.task);
        if (basicModel == null) {
            Intrinsics.throwNpe();
        }
        return basicModel;
    }

    @Nullable
    public final String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    public final void setCurrentDatabaseName(@Nullable String string) {
        this.currentDatabaseName = string;
    }

    @Nullable
    public final String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public final void setCurrentSchemaName(@Nullable String string) {
        this.currentSchemaName = string;
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final List<CompositeText> getScript() {
        return this.script;
    }

    @NotNull
    public final ScriptingTask getTask() {
        return this.task;
    }

    public ScriptingContext(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.task = task;
        BasicDatabase basicDatabase = ScriptingTaskKt.getAnyCurrentDatabase(this.task);
        this.currentDatabaseName = basicDatabase != null ? basicDatabase.getRealName() : null;
        BasicSchema basicSchema = ScriptingTaskKt.getAnyCurrentSchema(this.task);
        this.currentSchemaName = basicSchema != null ? basicSchema.getRealName() : null;
        this.options = this.task.getOptions();
        this.script = new ArrayList();
    }
}

