/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractTransitionCodeGenerator;
import com.intellij.database.scripting.BaseNativeDefinitionsGeneratorKt$sam$Condition$974b88f6;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingNativeDefinitionTask;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0004J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/BaseNativeDefinitionsGenerator;", "Lcom/intellij/database/scripting/AbstractTransitionCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "extendDeckIncludingNestedElements", "", "generate", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "includeElement", "prepareScenario", "shouldNestedElementBeIncluded", "", "shouldNestedIndexBeIncluded", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "shouldTableOrViewBeIncluded", "tableOrView", "Lcom/intellij/database/model/basic/BasicTableOrView;", "intellij.database.scripting"})
public class BaseNativeDefinitionsGenerator
extends AbstractTransitionCodeGenerator {
    @Override
    public void prepareScenario() {
        String string = "not implemented yet";
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate() {
        Function1<List<? extends BasicElement>, Map<BasicElement, String[]>> retriever;
        if (this.getContext().getOptions().get(ScriptingOptionStatic.INCLUDE_NESTED_ELEMENTS).booleanValue()) {
            this.extendDeckIncludingNestedElements();
        }
        List elementsToRetrieve = CollectionsKt.toList((Iterable)this.getDeck());
        ScriptingTask scriptingTask = this.getTask();
        if (!(scriptingTask instanceof ScriptingNativeDefinitionTask)) {
            scriptingTask = null;
        }
        ScriptingNativeDefinitionTask scriptingNativeDefinitionTask = (ScriptingNativeDefinitionTask)scriptingTask;
        Object object = retriever = scriptingNativeDefinitionTask != null ? scriptingNativeDefinitionTask.getNativeDefinitionsRetriever() : null;
        if (retriever == null) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ BaseNativeDefinitionsGenerator this$0;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("-- The native definitions retriever is not attached :(");
                }
                {
                    this.this$0 = baseNativeDefinitionsGenerator;
                    super(0);
                }
            }, 3, null);
            return;
        }
        Map nativeDefinitions = (Map)retriever.invoke((Object)elementsToRetrieve);
        this.getDeck().clear();
        this.generateHeading();
        for (BasicElement element : elementsToRetrieve) {
            int n;
            String[] statements2 = (String[])nativeDefinitions.get(element);
            int n2 = n = statements2 != null ? ((Object[])statements2).length : 0;
            if (n == 0) {
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                    final /* synthetic */ BaseNativeDefinitionsGenerator this$0;
                    final /* synthetic */ BasicElement $element;

                    public final void invoke() {
                        this.this$0.getBuilder().phrase("-- No native definition for element: ", this.$element.toString());
                    }
                    {
                        this.this$0 = baseNativeDefinitionsGenerator;
                        this.$element = basicElement;
                        super(0);
                    }
                }, 3, null);
                continue;
            }
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element, statements2){
                final /* synthetic */ BaseNativeDefinitionsGenerator this$0;
                final /* synthetic */ BasicElement $element;
                final /* synthetic */ String[] $statements;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("--", this.$element.toString());
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    if (this.$statements == null) {
                        Intrinsics.throwNpe();
                    }
                    CodeTextBuilder.append$default(codeTextBuilder, (CharSequence)ArraysKt.first((Object[])this.$statements), CompositeText.Kind.ORIGINAL_TEXT, false, null, 12, null);
                }
                {
                    this.this$0 = baseNativeDefinitionsGenerator;
                    this.$element = basicElement;
                    this.$statements = stringArray;
                    super(0);
                }
            }, 3, null);
            if (n < 2) continue;
            int n3 = 1;
            int n4 = n;
            while (n3 < n4) {
                void i2;
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, statements2, (int)i2){
                    final /* synthetic */ BaseNativeDefinitionsGenerator this$0;
                    final /* synthetic */ String[] $statements;
                    final /* synthetic */ int $i;

                    public final void invoke() {
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        if (this.$statements == null) {
                            Intrinsics.throwNpe();
                        }
                        CodeTextBuilder.append$default(codeTextBuilder, this.$statements[this.$i], CompositeText.Kind.ORIGINAL_TEXT, false, null, 12, null);
                    }
                    {
                        this.this$0 = baseNativeDefinitionsGenerator;
                        this.$statements = stringArray;
                        this.$i = n;
                        super(0);
                    }
                }, 3, null);
                ++i2;
            }
        }
        this.generateFooting();
    }

    protected final void extendDeckIncludingNestedElements() {
        List originalList = CollectionsKt.toList((Iterable)this.getDeck());
        this.getDeck().clear();
        Iterator iterator = originalList.iterator();
        while (iterator.hasNext()) {
            BasicElement element;
            BasicElement basicElement = element = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
            this.includeElement(basicElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void includeElement(@NotNull BasicElement element) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.getDeck().offer(element);
        Object object = (Function1)new Function1<BasicElement, Boolean>(this){

            public final boolean invoke(@NotNull BasicElement p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((BaseNativeDefinitionsGenerator)this.receiver).shouldNestedElementBeIncluded(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(BaseNativeDefinitionsGenerator.class);
            }

            public final String getName() {
                return "shouldNestedElementBeIncluded";
            }

            public final String getSignature() {
                return "shouldNestedElementBeIncluded(Lcom/intellij/database/model/basic/BasicElement;)Z";
            }
        };
        JBIterable jBIterable = element.getChildren().filter((Condition)new BaseNativeDefinitionsGeneratorKt$sam$Condition$974b88f6((Function1)object));
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"element\n      .children\n\u2026dNestedElementBeIncluded)");
        object = (Iterable)jBIterable;
        BaseNativeDefinitionsGenerator baseNativeDefinitionsGenerator = this;
        for (Object element$iv : $receiver$iv) {
            BasicElement p1 = (BasicElement)element$iv;
            baseNativeDefinitionsGenerator.includeElement(p1);
        }
    }

    protected boolean shouldNestedElementBeIncluded(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element.isAutoCreated()) {
            return false;
        }
        BasicElement parent = element.getParent();
        return element instanceof BasicTableOrView ? this.shouldTableOrViewBeIncluded((BasicTableOrView)element) : (parent instanceof BasicSchema ? true : (parent instanceof BasicLikeTable && element instanceof BasicIndex ? this.shouldNestedIndexBeIncluded((BasicLikeTable)parent, (BasicIndex)element) : (parent instanceof BasicLikeTable ? Intrinsics.areEqual((Object)element.getKind(), (Object)ObjectKind.TRIGGER) || Intrinsics.areEqual((Object)element.getKind(), (Object)ObjectKind.MAT_LOG) : (parent instanceof OraCluster ? Intrinsics.areEqual((Object)element.getKind(), (Object)ObjectKind.INDEX) : Intrinsics.areEqual((Object)element.getKind(), (Object)ObjectKind.BODY)))));
    }

    protected boolean shouldTableOrViewBeIncluded(@NotNull BasicTableOrView tableOrView) {
        Intrinsics.checkParameterIsNotNull((Object)tableOrView, (String)"tableOrView");
        return true;
    }

    protected boolean shouldNestedIndexBeIncluded(@NotNull BasicLikeTable table, @NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        Family<? extends BasicElement> family = table.familyOf(ObjectKind.KEY);
        if (!(family instanceof NamingFamily)) {
            family = null;
        }
        NamingFamily namingFamily = (NamingFamily)family;
        if (namingFamily == null) {
            return true;
        }
        NamingFamily keys = namingFamily;
        return !keys.getNames().contains(index2.getName());
    }

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    public BaseNativeDefinitionsGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }
}

