/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingServiceKt;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator$CreateCheck$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator$CreateForeignKey$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator$CreateIndex$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator$CreateKey$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator$CreateLikeColumn$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0016\u0018\u0000 c2\u00020\u0001:\u000ecdefghijklmnopB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0015\u001a\u00020\bH\u0014J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fH\u0004J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fH\u0014J\u001a\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0014J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\n\u0012\u0002\b\u00030$R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\fH\u0014J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0002J\u001e\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0,H\u0014J\u001e\u0010(\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020 0,H\u0014J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020\u00112\u0006\u00106\u001a\u000207H\u0014J\u0010\u00108\u001a\u00020\u00112\u0006\u00100\u001a\u000201H\u0014J\u0010\u00109\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\fH\u0014J\u0010\u0010:\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020=H\u0014J\u001c\u0010>\u001a\u00020\u00112\u0012\u0010?\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020A0@R\u00020\u0001H\u0014J\u0010\u0010B\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020AH\u0014J\u0010\u0010C\u001a\u00020\u00112\u0006\u00103\u001a\u00020DH\u0014J\u0010\u0010E\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020AH\u0014J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GH\u0016J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\f0J2\u0006\u00100\u001a\u000201H\u0014J\u0010\u0010K\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J\u001a\u0010L\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010M\u001a\u00020NH\u0014J\u0014\u0010O\u001a\u0004\u0018\u00010 2\b\u0010P\u001a\u0004\u0018\u00010QH\u0014J\u0012\u0010R\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u000201H\u0014J\u0012\u0010S\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u000201H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u00020UH\u0014J\u0018\u0010V\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010W\u001a\u00020\rH\u0002J\u0010\u0010X\u001a\u00020 2\u0006\u00100\u001a\u000201H\u0014J\u0012\u0010Y\u001a\u0004\u0018\u00010 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010Z\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010[\u001a\u00020 2\u0006\u0010M\u001a\u00020NH\u0014J\u0012\u0010\\\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u000201H\u0014J\u0010\u0010]\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\fH\u0017J$\u0010^\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010W\u001a\u00020\r2\b\b\u0002\u0010_\u001a\u00020\bH\u0016J\b\u0010`\u001a\u00020\u0011H\u0016J\u0018\u0010a\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00100\u001a\u00020 H\u0014J\b\u0010b\u001a\u00020\bH\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006q"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "isExact", "", "()Z", "prepared", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Operation;", "getPrepared", "()Ljava/util/HashMap;", "addInnerConstraintNameAndIndent", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "addOuterConstraintNameAndIndent", "allowReferenceOnPrimaryKeyWithoutColumns", "canCreateInColumn", "element", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "createOrReplace", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "createProducer", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "elementKindNameForCreate", "elements", "", "gatherSequenceIdentityParameters", "identity", "Lcom/intellij/database/model/SequenceIdentity;", "parameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateAdditionalTableItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateCascadeRules", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateColumnComment", "generateComment", "generateDeferrability", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateSourceAwareElement", "producer", "Lcom/intellij/database/scripting/AbstractCodeGenerator$ElementProducer;", "Lcom/intellij/database/model/basic/BasicSourceAware;", "generateSourceAwareUsingSources", "generateTableComment", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateUnspecificSourceAwareElement", "getEdgeFixers", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "getSingleColumnElements", "", "ifNotExists", "isIndexExplicitFor", "key", "Lcom/intellij/database/model/basic/BasicKey;", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeColumnDefinition", "makeColumnSpecification", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeCreateOperation", "root", "makeDefault", "makeDeferrability", "makeIndexWord", "makeKeyWord", "makeNormalColumnSpecification", "makeOperation", "prepareElement", "forceRoot", "prepareScenario", "scriptIndexColumn", "shouldCollectColumnElements", "Companion", "CreateCheck", "CreateConstraint", "CreateForeignKey", "CreateIndex", "CreateKey", "CreateLikeColumn", "CreateOther", "CreateProducer", "CreateSequence", "CreateSourceAware", "CreateSynonym", "CreateTable", "CreateTrigger", "intellij.database.scripting"})
public class BaseCreatingGenerator
extends AbstractCodeGenerator {
    private final boolean isExact;
    @NotNull
    private final HashMap<BasicElement, Operation> prepared;
    @NotNull
    private static final OperationType CREATE;
    private static final Companion.CREATE_FK_FIXER.1 CREATE_FK_FIXER;
    @NotNull
    private static final List<AbstractCodeGenerator.EdgeFixer> CREATE_FIXERS;
    public static final Companion Companion;

    protected final boolean isExact() {
        return this.isExact;
    }

    @NotNull
    protected final HashMap<BasicElement, Operation> getPrepared() {
        return this.prepared;
    }

    @Override
    @NotNull
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.makeCreateOperation(element, this.getScenario().getRoot());
    }

    @Override
    public void prepareScenario() {
        Iterable $receiver$iv = this.elements();
        for (Object element$iv : $receiver$iv) {
            BasicElement it = (BasicElement)element$iv;
            if (it instanceof BasicTable && ((BasicTable)it).isSystem() || it.isAutoCreated()) continue;
            BaseCreatingGenerator.prepareElement$default(this, it, this.getScenario().getRoot(), false, 4, null);
        }
    }

    private final Collection<BasicElement> elements() {
        Object object;
        ScriptingTask scriptingTask = this.getTask();
        if (!(scriptingTask instanceof ScriptingSingleModelTask)) {
            scriptingTask = null;
        }
        if ((object = (ScriptingSingleModelTask)scriptingTask) == null || (object = ((ScriptingSingleModelTask)object).getElements()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root2, boolean forceRoot) {
        Operation operation;
        block5: {
            block4: {
                Operation operation2;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                operation = this.prepared.get(element);
                if (operation == null) break block4;
                Operation $receiver = operation2 = operation;
                if (forceRoot) {
                    $receiver.setParent((Node)root2);
                }
                if ((operation = operation2) != null) break block5;
            }
            operation = this.makeCreateOperation(element, root2);
        }
        return operation;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Operation prepareElement$default(BaseCreatingGenerator baseCreatingGenerator, BasicElement basicElement, Operation operation, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return baseCreatingGenerator.prepareElement(basicElement, operation, bl);
    }

    private final Operation makeCreateOperation(BasicElement element, Operation root2) {
        return this.createProducer(element).register(root2);
    }

    @NotNull
    public CreateProducer<?> createProducer(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        return basicElement instanceof BasicSequence ? (CreateProducer)new CreateSequence(this, (BasicSequence)element) : (basicElement instanceof BasicTable ? (CreateProducer)new CreateTable(this, (BasicTable)element) : (basicElement instanceof BasicLikeColumn ? (CreateProducer)new CreateLikeColumn((BasicLikeColumn)element) : (basicElement instanceof BasicIndex ? (CreateProducer)new CreateIndex(this, (BasicIndex)element) : (basicElement instanceof BasicKey ? (CreateProducer)new CreateKey(this, (BasicKey)element) : (basicElement instanceof BasicForeignKey ? (CreateProducer)new CreateForeignKey((BasicForeignKey)element) : (basicElement instanceof BasicCheck ? (CreateProducer)new CreateCheck((BasicCheck)element) : (basicElement instanceof BasicTrigger ? (CreateProducer)new CreateTrigger(this, (BasicTrigger)element) : (basicElement instanceof BasicSourceAware ? (CreateProducer)new CreateSourceAware(this, (BasicSourceAware)element) : (basicElement instanceof BasicSynonym ? (CreateProducer)new CreateSynonym((BasicSynonym)element) : (CreateProducer)new CreateOther(element))))))))));
    }

    protected boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
            case 1: {
                if (!(element instanceof BasicConstraint) || Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (element instanceof BasicTableOrViewColumn || element instanceof BasicConstraint && this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (element instanceof BasicConstraint && Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    protected final boolean canCreateInColumn(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.canGenerateHere(ScriptLocus.IN_COLUMN, element);
    }

    @NotNull
    protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column2) {
        BasicLikeTable table;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicLikeTable basicLikeTable = column2.getLikeTable();
        if (basicLikeTable == null) {
            return SetsKt.emptySet();
        }
        BasicLikeTable basicLikeTable2 = table = basicLikeTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable2, (String)"table");
        JBIterable jBIterable = basicLikeTable2.getChildren().filter(BasicConstraint.class).filter((Condition)new Condition<BasicConstraint>(this, column2){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicLikeColumn $column;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(BasicConstraint it) {
                BasicConstraint basicConstraint = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraint, (String)"it");
                if (!this.this$0.canCreateInColumn(basicConstraint)) return false;
                if (it.getColNames().size() != 1) return false;
                List<String> list = it.getColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"it.colNames");
                if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first(list)), (Object)this.$column.getName())) return false;
                return true;
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$column = basicLikeColumn;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.children\n      .fi\u2026.first() == column.name }");
        return (Iterable)jBIterable;
    }

    protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        return Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_STATEMENT)) || Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE));
    }

    protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof BasicMinorObject && this.getLocus().compareTo((Enum)ScriptLocus.IN_TABLE) < 0) {
            return ((BasicMinorObject)element).getMajorObject() == null;
        }
        return true;
    }

    @Override
    @NotNull
    public List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return Companion.getCREATE_FIXERS$intellij_database_scripting();
    }

    protected void generateAdditionalTableItems(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
    }

    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? "table" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE) ? "sequence" : null);
    }

    protected boolean shouldCollectColumnElements() {
        return Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN)) && Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE));
    }

    @Nullable
    protected String makeColumnDefinition(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String name = AbstractCodeGenerator.quote$default(this, column2, null, 2, null);
        String specification = this.makeColumnSpecification(column2);
        return ScriptingUtilsKt.concatWithSpace(name, specification);
    }

    @Nullable
    public String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return column2 instanceof BasicTableColumn && ((BasicTableColumn)column2).isComputed() && ((BasicTableColumn)column2).getDefaultExpression() != null ? this.makeComputedColumnSpecification((BasicTableOrViewColumn)column2) : this.makeNormalColumnSpecification(column2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        void specification;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        boolean autoInc = column2 instanceof BasicTableColumn && ((BasicTableColumn)column2).isAutoInc();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.generalColumnSpecification(column2);
        Function0<String> space$ = new Function0<String>((Ref.ObjectRef)specification){
            final /* synthetic */ Ref.ObjectRef $specification;

            @NotNull
            public final String invoke() {
                CharSequence charSequence = (String)this.$specification.element;
                return charSequence.length() == 0 || StringsKt.endsWith$default((String)((String)this.$specification.element), (String)" ", (boolean)false, (int)2, null) ? "" : " ";
            }
            {
                this.$specification = objectRef;
                super(0);
            }
        };
        if (column2.getDefaultExpression() != null) {
            specification.element = (String)specification.element + (String)space$.invoke() + this.makeDefault(column2);
        }
        if (column2.isNotNull() && !autoInc) {
            specification.element = (String)specification.element + (String)space$.invoke() + "not null";
        }
        if (!column2.isNotNull() && this.getHelper().isNullExplicit(column2) && !autoInc) {
            specification.element = (String)specification.element + (String)space$.invoke() + "null";
        }
        return (String)specification.element;
    }

    @NotNull
    protected String makeDefault(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return "default " + column2.getDefaultExpression();
    }

    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        DataType dataType = column2.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        return this.script(dataType);
    }

    @Nullable
    protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return "as " + column2.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String scriptIndexColumn(@NotNull BasicIndex index2, @NotNull String column2) {
        String s;
        String string;
        boolean dirs;
        Set<String> descendants;
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        CharSequence charSequence = column2;
        if (charSequence.length() == 0) {
            return "???";
        }
        Set<String> set = descendants = index2.getReverseColNames();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"descendants");
        Collection collection = set;
        boolean bl = dirs = !collection.isEmpty();
        if (column2.charAt(0) == '\u001b') {
            String string2 = column2;
            int n = 1;
            int n2 = column2.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            void $receiver$iv;
            String string4 = column2;
            BaseCreatingGenerator this_$iv = this;
            string = s = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv, false);
        }
        if (dirs) {
            s = s + (descendants.contains(column2) ? " desc" : " asc");
        }
        return s;
    }

    @NotNull
    protected String makeIndexWord(@NotNull BasicIndex index2) {
        Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
        return index2.isUnique() ? "unique index" : "index";
    }

    @NotNull
    protected String makeKeyWord(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return key2.isPrimary() ? "primary key" : "unique";
    }

    protected boolean isIndexExplicitFor(@Nullable BasicIndex index2, @NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return index2 != null && this.getUseName(index2) && Intrinsics.areEqual((Object)index2.getName(), (Object)key2.getName()) ^ true;
    }

    protected boolean allowReferenceOnPrimaryKeyWithoutColumns() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCascadeRules(@NotNull BasicForeignKey fk) {
        String string;
        String string2;
        String it;
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        String string3 = this.makeCascadeRuleKeyword(fk.getOnUpdate());
        if (string3 != null) {
            String string4;
            it = string4 = string3;
            string2 = "on update " + it;
        } else {
            string2 = null;
        }
        String c1 = string2;
        String string5 = this.makeCascadeRuleKeyword(fk.getOnDelete());
        if (string5 != null) {
            String it2 = it = string5;
            string = "on delete " + it2;
        } else {
            string = null;
        }
        String c2 = string;
        String c = ScriptingUtilsKt.phrase(c1, c2);
        if (c != null) {
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), c, null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        CascadeRule cascadeRule = rule;
        if (cascadeRule == null) return null;
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$1[cascadeRule.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                String string = rule.keyWord;
                return string;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDeferrability(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        String dfr = this.makeDeferrability(constraint);
        if (dfr != null) {
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), dfr, null, false, null, 14, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
    }

    @Nullable
    protected String makeDeferrability(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        return constraint.isDeferrable() ? (constraint.isInitiallyDeferred() ? "deferrable initially deferred" : "deferrable") : null;
    }

    protected void addInnerConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        if (this.getUseName(constraint)) {
            String name = AbstractCodeGenerator.quote$default(this, constraint, null, 2, null);
            CodeTextBuilder.append$default(this.getBuilder(), "constraint " + name, null, false, null, 14, null);
            CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
        }
    }

    protected void addOuterConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        if (this.getUseName(constraint)) {
            String name = AbstractCodeGenerator.quote$default(this, constraint, null, 2, null);
            CodeTextBuilder.append$default(this.getBuilder(), "add constraint " + name, null, false, null, 14, null);
            CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
        }
    }

    protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String name = AbstractCodeGenerator.currentScopeName$default(this, trigger, null, 1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $name;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter trigger " + this.$name + " disable", null, false, null, 14, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$name = string;
                super(0);
            }
        }, 3, null);
    }

    protected void generateSourceAwareElement(@NotNull AbstractCodeGenerator.ElementProducer<? extends BasicSourceAware> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicSourceAware element = producer.getElement();
        this.generateSourceAwareUsingSources(element);
        if (element.getComment() != null) {
            this.generateComment(element);
            if (element instanceof BasicView) {
                PositioningNamingFamily columns2 = ((BasicView)element).getColumns();
                Iterator iterator = columns2.iterator();
                while (iterator.hasNext()) {
                    BasicTableOrViewColumn column2;
                    BasicTableOrViewColumn basicTableOrViewColumn = column2 = (BasicTableOrViewColumn)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"column");
                    this.generateComment(basicTableOrViewColumn);
                }
            }
        }
    }

    protected void generateSourceAwareUsingSources(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.generateUnspecificSourceAwareElement(element);
    }

    protected void generateUnspecificSourceAwareElement(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        CompositeText st = element.getSourceText();
        if (st == null) {
            this.newCoding((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(element){
                final /* synthetic */ BasicSourceAware $element;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    StringBuilder stringBuilder = new StringBuilder().append("No source code for ");
                    ObjectPath objectPath = BasicPaths.of(this.$element);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"BasicPaths.of(element)");
                    $receiver.error(stringBuilder.append(objectPath.getDisplayName()).toString());
                }
                {
                    this.$element = basicSourceAware;
                    super(1);
                }
            }));
            return;
        }
        JBIterable jBIterable = JBIterable.from(st.getFragments()).split(JBIterable.Split.OFF, (Condition)generateUnspecificSourceAwareElement.statements.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(st.fragm\u2026eText.Kind.SQL_DELIMITER}");
        JBIterable statements2 = jBIterable;
        for (JBIterable statementFragments : statements2) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, statementFragments){
                final /* synthetic */ BaseCreatingGenerator this$0;
                final /* synthetic */ JBIterable $statementFragments;

                public final void invoke() {
                    for (CompositeText.Fragment fragment : this.$statementFragments) {
                        this.this$0.getBuilder().append(fragment);
                    }
                }
                {
                    this.this$0 = baseCreatingGenerator;
                    this.$statementFragments = jBIterable;
                    super(0);
                }
            }, 3, null);
        }
    }

    protected void generateComment(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicTableOrView) {
            this.generateTableComment((BasicTableOrView)element);
        } else if (basicElement instanceof BasicTableOrViewColumn) {
            this.generateColumnComment((BasicLikeColumn)element);
        }
    }

    protected void generateTableComment(@NotNull BasicTableOrView table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String string = table.getComment();
        if (string == null || (string = this.getSqlString(string)) == null) {
            return;
        }
        String comment = string;
        ObjectKind kind = table.getKind();
        String w = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : kind.code();
        String name = AbstractCodeGenerator.currentScopeName$default(this, table, null, 1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, name, comment){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $w;
            final /* synthetic */ String $name;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on " + this.$w + ' ' + this.$name + " is " + this.$comment, null, false, null, 14, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$w = string;
                this.$name = string2;
                this.$comment = string3;
                super(0);
            }
        }, 3, null);
    }

    protected void generateColumnComment(@NotNull BasicLikeColumn column2) {
        BasicSchemaObject parent;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        DasObject dasObject = column2.getDbParent();
        if (!(dasObject instanceof BasicSchemaObject)) {
            dasObject = null;
        }
        if ((object = (parent = (BasicSchemaObject)dasObject)) == null || (object = AbstractCodeGenerator.currentScopeName$default(this, (BasicElement)object, null, 1, null)) == null) {
            return;
        }
        Object parentName = object;
        String columnName = AbstractCodeGenerator.quote$default(this, column2, null, 2, null);
        String string = column2.getComment();
        if (string == null || (string = this.getSqlString(string)) == null) {
            return;
        }
        String comment = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (String)parentName, columnName, comment){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $parentName;
            final /* synthetic */ String $columnName;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on column " + this.$parentName + '.' + this.$columnName + " is " + this.$comment, null, false, null, 14, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$parentName = string;
                this.$columnName = string2;
                this.$comment = string3;
                super(0);
            }
        }, 3, null);
    }

    @NotNull
    public final String createOrReplace(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false && this.getHelper().getSupportsCreateOrReplace().contains(kind) ? "create or replace" : "create";
    }

    @Nullable
    public final String ifNotExists(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) != false && this.getHelper().getSupportsCreateIfNotExists().contains(kind) ? "if not exists" : null;
    }

    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        SequenceIdentity i2;
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        SequenceIdentity sequenceIdentity = sequence.getSequenceIdentity();
        if (sequenceIdentity == null) {
            return;
        }
        SequenceIdentity sequenceIdentity2 = i2 = sequenceIdentity;
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity2, (String)"i");
        this.gatherSequenceIdentityParameters(sequenceIdentity2, parameters);
    }

    protected void gatherSequenceIdentityParameters(@NotNull SequenceIdentity identity, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        int sign = identity.increment.signum();
        switch (sign) {
            case 1: {
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.min != null && Intrinsics.areEqual((Object)identity.min, (Object)BigInteger.ONE) ^ true) {
                    parameters.add("minvalue " + identity.min);
                }
                if (Intrinsics.areEqual((Object)identity.increment, (Object)BigInteger.ONE) ^ true) {
                    parameters.add("increment by " + identity.increment);
                }
                if (identity.max == null) break;
                parameters.add("maxvalue " + identity.max);
                break;
            }
            case -1: {
                if (identity.next != null && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.max != null) {
                    parameters.add("maxvalue " + identity.max);
                }
                parameters.add("increment by " + identity.increment);
                if (identity.min == null) break;
                parameters.add("minvalue " + identity.min);
                break;
            }
            default: {
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.min != null) {
                    parameters.add("minvalue " + identity.min);
                }
                if (identity.max == null) break;
                parameters.add("maxvalue " + identity.max);
            }
        }
    }

    public BaseCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
        this.isExact = Intrinsics.areEqual((Object)((Object)this.getCategory()), (Object)((Object)ScriptCategory.CREATE_DEFINITION));
        this.prepared = new HashMap();
    }

    static {
        Companion = new Companion(null);
        CREATE = new OperationType("create");
        CREATE_FK_FIXER = new AbstractCodeGenerator.EdgeFixer(){

            /*
             * WARNING - void declaration
             */
            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                BasicForeignKey basicForeignKey;
                void $receiver$iv;
                BasicLikeTable basicLikeTable;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                if (Intrinsics.areEqual((Object)((Operation)op2.getParent()), (Object)root2)) {
                    return false;
                }
                Operation operation = op1;
                Object t$iv = BaseCreatingGenerator.Companion.getCREATE();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
                    if (!(basicElement instanceof BasicLikeTable)) {
                        basicElement = null;
                    }
                    basicLikeTable = (BasicLikeTable)basicElement;
                } else {
                    basicLikeTable = null;
                }
                if (basicLikeTable == null) {
                    return false;
                }
                BasicLikeTable tgt = basicLikeTable;
                t$iv = op2;
                OperationType t$iv2 = BaseCreatingGenerator.Companion.getCREATE();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
                    if (!(basicElement instanceof BasicForeignKey)) {
                        basicElement = null;
                    }
                    basicForeignKey = (BasicForeignKey)basicElement;
                } else {
                    basicForeignKey = null;
                }
                if (basicForeignKey == null) {
                    return false;
                }
                BasicForeignKey fk = basicForeignKey;
                if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
                    return false;
                }
                op2.setParent((Node)root2);
                return true;
            }
        };
        CREATE_FIXERS = CollectionsKt.listOf((Object)BaseCreatingGenerator.Companion.getCREATE_FK_FIXER());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0096\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0004J\n\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0004J\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/AbstractCodeGenerator$ElementProducer;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicElement;)V", "tmpName", "", "getTmpName", "()Ljava/lang/String;", "setTmpName", "(Ljava/lang/String;)V", "canComment", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "canCreate", "canCreateAlone", "createVersion", "", "edgeVersions", "", "Lorg/jetbrains/dekaf/util/Version;", "fqName", "name", "nameScr", "register", "Lcom/intellij/database/scripting/Operation;", "root", "shortText", "intellij.database.scripting"})
    public static class CreateProducer<T extends BasicElement>
    extends AbstractCodeGenerator.ElementProducer<T> {
        @Nullable
        private String tmpName;
        final /* synthetic */ BaseCreatingGenerator this$0;

        @Nullable
        public final String getTmpName() {
            return this.tmpName;
        }

        public final void setTmpName(@Nullable String string) {
            this.tmpName = string;
        }

        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = new Operation(this);
            $receiver.setParent((Node)root2);
            Map map = this.this$0.getPrepared();
            Object t = this.getElement();
            Operation operation2 = $receiver;
            map.put(t, operation2);
            ScenarioOperations.requires($receiver, ScenarioOperations.parents(EffectType.Existent, this.getElement()));
            Iterable<? extends BasicElement> iterable = this.getElement().getPredecessors();
            Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"element.predecessors");
            JBIterable jBIterable = ScenarioOperations.matches$default(EffectType.Existent, iterable, null, 2, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"Existent.matches(element.predecessors)");
            ScenarioOperations.requires($receiver, (Iterable)jBIterable);
            ScenarioOperations.provides($receiver, ScenarioOperations.invoke(EffectType.Existent, ScenarioOperations.renamed(this.getElement(), null, this.tmpName)));
            return operation;
        }

        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canCreate() {
            return AbstractScriptingServiceKt.getSUPPORTED();
        }

        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canComment() {
            return AbstractScriptingServiceKt.getSUPPORTED();
        }

        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canCreateAlone() {
            return this.canCreate();
        }

        public int createVersion() {
            return 0;
        }

        @NotNull
        public List<Version> edgeVersions() {
            return CollectionsKt.emptyList();
        }

        @Nullable
        protected final String name() {
            String string = this.tmpName;
            if (string == null) {
                string = this.getElement().getRealName();
            }
            return string;
        }

        @Nullable
        protected final String nameScr() {
            String string;
            block3: {
                block2: {
                    string = this.tmpName;
                    if (string == null) break block2;
                    String $receiver$iv = string;
                    BaseCreatingGenerator this_$iv = this.this$0;
                    string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, true);
                    if (string != null) break block3;
                }
                string = this.this$0.quote((BasicElement)this.getElement(), ModelFun.name(this.getElement(), this.this$0.getTask().getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES)));
            }
            return string;
        }

        @NotNull
        protected final String fqName() {
            return this.this$0.currentScopeName((BasicElement)this.getElement(), this.nameScr());
        }

        @Override
        @NotNull
        public String shortText() {
            String string;
            block3: {
                block2: {
                    String string2;
                    string = this.tmpName;
                    if (string == null) break block2;
                    String it = string2 = string;
                    string = "" + super.shortText() + " (" + it + ')';
                    if (string != null) break block3;
                }
                string = super.shortText();
            }
            return string;
        }

        public CreateProducer(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super($outer, Companion.getCREATE(), (BasicElement)element, null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateSynonym;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/basic/BasicSynonym;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicSynonym;)V", "makeSynonymTargetSpec", "", "synonym", "produce", "", "intellij.database.scripting"})
    protected class CreateSynonym
    extends CreateProducer<BasicSynonym> {
        @Override
        public void produce() {
            String targetSpec = this.makeSynonymTargetSpec((BasicSynonym)this.getElement());
            String name = this.fqName();
            AbstractCodeGenerator.coding$default(BaseCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, name, targetSpec){
                final /* synthetic */ CreateSynonym this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $targetSpec;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    CodeTextBuilder codeTextBuilder = this.this$0.BaseCreatingGenerator.this.getBuilder();
                    String[] stringArray = new String[4];
                    BaseCreatingGenerator baseCreatingGenerator = this.this$0.BaseCreatingGenerator.this;
                    ObjectKind objectKind = ObjectKind.SYNONYM;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SYNONYM");
                    stringArray[0] = baseCreatingGenerator.createOrReplace(objectKind);
                    stringArray[1] = "synonym";
                    stringArray[2] = this.$name;
                    stringArray[3] = "for ";
                    CodeTextBuilder.append$default(codeTextBuilder, ScriptingUtilsKt.phrase(stringArray), null, false, null, 10, null);
                    CodeTextBuilder codeTextBuilder2 = this.this$0.BaseCreatingGenerator.this.getBuilder();
                    BaseCreatingGenerator baseCreatingGenerator2 = this.this$0.BaseCreatingGenerator.this;
                    String text$iv = this.$targetSpec;
                    boolean eoln$iv = true;
                    if (text$iv == null) {
                        boolean bl = eoln$iv;
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        void var8_8 = $receiver$iv;
                        String string = "unknown what the synonym " + this.$name + " references on :(";
                        CodeTextBuilder.append$default((CodeTextBuilder)var8_8, charSequence, kind, bl, string, 2, null);
                    } else {
                        CodeTextBuilder.append$default((CodeTextBuilder)$receiver$iv, text$iv, null, eoln$iv, null, 10, null);
                    }
                }
                {
                    this.this$0 = createSynonym;
                    this.$name = string;
                    this.$targetSpec = string2;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected String makeSynonymTargetSpec(@NotNull BasicSynonym synonym) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            BasicMajorObject targetObject = synonym.getTargetObject();
            if (targetObject != null) {
                return AbstractCodeGenerator.currentScopeName$default(BaseCreatingGenerator.this, targetObject, null, 1, null);
            }
            String schemaName = synonym.getTargetSchemaName();
            String string2 = synonym.getTargetObjectName();
            if (string2 == null) {
                return null;
            }
            String objectName = string2;
            if (schemaName == null) {
                void $receiver$iv;
                String string3 = objectName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"objectName");
                String string4 = string3;
                BaseCreatingGenerator this_$iv = BaseCreatingGenerator.this;
                string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv, false);
            } else {
                String $receiver$iv = schemaName;
                BaseCreatingGenerator this_$iv = BaseCreatingGenerator.this;
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                StringBuilder stringBuilder2 = stringBuilder.append(string5).append(".");
                String string6 = objectName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"objectName");
                $receiver$iv = string6;
                this_$iv = BaseCreatingGenerator.this;
                stringBuilder = stringBuilder2;
                string5 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                string = stringBuilder.append(string5).toString();
            }
            return string;
        }

        public CreateSynonym(BasicSynonym element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0004J\u0014\u0010\u0007\u001a\u00060\tR\u00020\n*\u00060\tR\u00020\nH\u0004\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateConstraint;", "T", "Lcom/intellij/database/model/basic/BasicConstraint;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicConstraint;)V", "alterTable", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$NewCodingAdapter;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "intellij.database.scripting"})
    protected static class CreateConstraint<T extends BasicConstraint>
    extends CreateProducer<T> {
        final /* synthetic */ BaseCreatingGenerator this$0;

        @NotNull
        protected final AbstractCodeGenerator.NewCodingAdapter alterTable(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return this.this$0.alterTable($receiver, ((BasicConstraint)this.getElement()).getLikeTable(), null);
        }

        protected final void alterTable() {
            this.this$0.sqlClause((Function1<? super AbstractCodeGenerator.NewCodingAdapter, Unit>)((Function1)new Function1<AbstractCodeGenerator.NewCodingAdapter, Unit>(this){
                final /* synthetic */ CreateConstraint this$0;

                public final void invoke(@NotNull AbstractCodeGenerator.NewCodingAdapter $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    this.this$0.alterTable($receiver);
                }
                {
                    this.this$0 = createConstraint;
                    super(1);
                }
            }));
        }

        public CreateConstraint(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateSourceAware;", "T", "Lcom/intellij/database/model/basic/BasicSourceAware;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicSourceAware;)V", "produce", "", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    protected static class CreateSourceAware<T extends BasicSourceAware>
    extends CreateProducer<T> {
        final /* synthetic */ BaseCreatingGenerator this$0;

        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            JBIterable<? extends BasicElement> jBIterable = ((BasicSourceAware)this.getElement()).getChildren();
            Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"element.children");
            Iterable $receiver$iv = (Iterable)jBIterable;
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                if (!(Intrinsics.areEqual((Object)basicElement.getKind(), (Object)ObjectKind.ARGUMENT) ^ true)) continue;
                BaseCreatingGenerator.prepareElement$default(this.this$0, it, root2, false, 4, null);
            }
            return operation;
        }

        @Override
        public void produce() {
            this.this$0.generateSourceAwareElement(this);
        }

        public CreateSourceAware(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTrigger;", "T", "Lcom/intellij/database/model/basic/BasicTrigger;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicTrigger;)V", "produce", "", "intellij.database.scripting"})
    protected static class CreateTrigger<T extends BasicTrigger>
    extends CreateProducer<T> {
        final /* synthetic */ BaseCreatingGenerator this$0;

        /*
         * WARNING - void declaration
         */
        @Override
        public void produce() {
            if (this.getElement() instanceof BasicSourceAware) {
                void this_$iv;
                void e$iv;
                CreateTrigger createTrigger = this;
                Object t = this.getElement();
                BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                boolean bl = Intrinsics.areEqual((Object)e$iv, this_$iv.getElement());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                void v0 = this_$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.AbstractCodeGenerator.ElementProducer<U>");
                }
                AbstractCodeGenerator.ElementProducer elementProducer = (AbstractCodeGenerator.ElementProducer)v0;
                baseCreatingGenerator.generateSourceAwareElement(elementProducer);
                if (((BasicTrigger)this.getElement()).isDisabled()) {
                    this.this$0.generateDisableTrigger((BasicTrigger)this.getElement());
                }
            } else {
                AbstractCodeGenerator.coding$default(this.this$0, null, false, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ CreateTrigger this$0;

                    public final void invoke() {
                        String triggerName = this.this$0.fqName();
                        this.this$0.this$0.getBuilder().appendErrorComment("Unknown how to generate trigger " + triggerName);
                    }
                    {
                        this.this$0 = createTrigger;
                        super(0);
                    }
                }, 3, null);
            }
        }

        public CreateTrigger(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateCheck;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/basic/BasicCheck;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicCheck;)V", "produce", "", "intellij.database.scripting"})
    protected class CreateCheck
    extends CreateProducer<BasicCheck> {
        /*
         * WARNING - void declaration
         */
        @Override
        public void produce() {
            void w1;
            String def2 = "check (" + ((BasicCheck)this.getElement()).getPredicate() + ")";
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            AbstractCodeGenerator.coding$default(BaseCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, (Ref.ObjectRef)w1, def2){
                final /* synthetic */ CreateCheck this$0;
                final /* synthetic */ Ref.ObjectRef $w1;
                final /* synthetic */ String $def;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    switch (BaseCreatingGenerator$CreateCheck$WhenMappings.$EnumSwitchMapping$0[this.this$0.BaseCreatingGenerator.this.getLocus().ordinal()]) {
                        case 1: 
                        case 2: {
                            this.this$0.BaseCreatingGenerator.this.addInnerConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            break;
                        }
                        default: {
                            CharSequence charSequence;
                            CodeTextBuilder codeTextBuilder = this.this$0.BaseCreatingGenerator.this.getBuilder();
                            CharSequence[] charSequenceArray = new CharSequence[2];
                            charSequenceArray[0] = "alter table";
                            CharSequence[] charSequenceArray2 = charSequenceArray;
                            CharSequence[] charSequenceArray3 = charSequenceArray;
                            int n = 1;
                            Object object = ((BasicCheck)this.this$0.getElement()).getLikeTable();
                            if (object != null && (object = AbstractCodeGenerator.currentScopeName$default(this.this$0.BaseCreatingGenerator.this, (BasicElement)object, null, 1, null)) != null) {
                                charSequence = (CharSequence)object;
                            } else {
                                String string;
                                String string2 = ((BasicCheck)this.this$0.getElement()).getTableName();
                                if (string2 != null) {
                                    void $receiver$iv;
                                    void this_$iv;
                                    String string3 = string2;
                                    BaseCreatingGenerator baseCreatingGenerator = this.this$0.BaseCreatingGenerator.this;
                                    int n2 = n;
                                    CharSequence[] charSequenceArray4 = charSequenceArray2;
                                    CharSequence[] charSequenceArray5 = charSequenceArray3;
                                    CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                                    String string4 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv, false);
                                    codeTextBuilder = codeTextBuilder2;
                                    charSequenceArray3 = charSequenceArray5;
                                    charSequenceArray2 = charSequenceArray4;
                                    n = n2;
                                    string = string4;
                                } else {
                                    string = null;
                                }
                                charSequence = string;
                            }
                            charSequenceArray2[n] = charSequence;
                            codeTextBuilder.phrase(charSequenceArray3);
                            CodeTextBuilder.indent$default(this.this$0.BaseCreatingGenerator.this.getBuilder(), null, 1, null);
                            this.this$0.BaseCreatingGenerator.this.addOuterConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            if (this.this$0.BaseCreatingGenerator.this.getUseName((BasicNamedElement)this.this$0.getElement())) break;
                            this.$w1.element = "add ";
                        }
                    }
                    this.this$0.BaseCreatingGenerator.this.generateDeferrability((BasicConstraint)this.this$0.getElement());
                    String text = (String)this.$w1.element + this.$def;
                    if (Intrinsics.areEqual((Object)((Object)this.this$0.BaseCreatingGenerator.this.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE))) {
                        text = text + ',';
                    }
                    CodeTextBuilder.append$default(this.this$0.BaseCreatingGenerator.this.getBuilder(), text, null, false, null, 14, null);
                }
                {
                    this.this$0 = createCheck;
                    this.$w1 = objectRef;
                    this.$def = string;
                    super(0);
                }
            }, 3, null);
        }

        public CreateCheck(BasicCheck element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0004J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateForeignKey;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/basic/BasicForeignKey;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicForeignKey;)V", "makeForeignKeyReference", "", "fk", "produce", "", "intellij.database.scripting"})
    protected class CreateForeignKey
    extends CreateProducer<BasicForeignKey> {
        @Override
        public void produce() {
            String reference = this.makeForeignKeyReference((BasicForeignKey)this.getElement());
            AbstractCodeGenerator.coding$default(BaseCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, reference){
                final /* synthetic */ CreateForeignKey this$0;
                final /* synthetic */ String $reference;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    switch (BaseCreatingGenerator$CreateForeignKey$WhenMappings.$EnumSwitchMapping$0[this.this$0.BaseCreatingGenerator.this.getLocus().ordinal()]) {
                        case 1: {
                            this.this$0.BaseCreatingGenerator.this.addInnerConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            CodeTextBuilder.append$default(this.this$0.BaseCreatingGenerator.this.getBuilder(), this.$reference, null, false, null, 14, null);
                            this.this$0.BaseCreatingGenerator.this.generateCascadeRules((BasicForeignKey)this.this$0.getElement());
                            this.this$0.BaseCreatingGenerator.this.generateDeferrability((BasicConstraint)this.this$0.getElement());
                            break;
                        }
                        case 2: {
                            void this_$iv;
                            void $receiver$iv;
                            this.this$0.BaseCreatingGenerator.this.addInnerConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            CodeTextBuilder codeTextBuilder = this.this$0.BaseCreatingGenerator.this.getBuilder();
                            StringBuilder stringBuilder = new StringBuilder().append("foreign key (");
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.BaseCreatingGenerator.this;
                            List<String> list = ((BasicForeignKey)this.this$0.getElement()).getColNames();
                            Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                            Iterable iterable = list;
                            BaseCreatingGenerator baseCreatingGenerator2 = baseCreatingGenerator;
                            StringBuilder stringBuilder2 = stringBuilder;
                            CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                            String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractCodeGenerator)this_$iv){
                                final /* synthetic */ AbstractCodeGenerator this$0;

                                @NotNull
                                public final String invoke(@NotNull String it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    String $receiver$iv = it;
                                    AbstractCodeGenerator this_$iv = this.this$0;
                                    return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                                }
                                {
                                    this.this$0 = abstractCodeGenerator;
                                    super(1);
                                }
                            }), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(string).append(") ").append(this.$reference).toString(), null, false, null, 14, null);
                            this.this$0.BaseCreatingGenerator.this.generateCascadeRules((BasicForeignKey)this.this$0.getElement());
                            this.this$0.BaseCreatingGenerator.this.generateDeferrability((BasicConstraint)this.this$0.getElement());
                            this.this$0.BaseCreatingGenerator.this.getBuilder().addSuffixToTheLastLine(',');
                            break;
                        }
                        default: {
                            void this_$iv;
                            void $receiver$iv;
                            Object $receiver$iv2;
                            Object object = ((BasicForeignKey)this.this$0.getElement()).getLikeTable();
                            if (object == null || (object = AbstractCodeGenerator.currentScopeName$default(this.this$0.BaseCreatingGenerator.this, (BasicElement)object, null, 1, null)) == null) {
                                String string = ((BasicForeignKey)this.this$0.getElement()).getTableName();
                                if (string != null) {
                                    $receiver$iv2 = string;
                                    BaseCreatingGenerator this_$iv2 = this.this$0.BaseCreatingGenerator.this;
                                    object = AbstractCodeGenerator.access$getNaming$p(this_$iv2).nameToScript((String)$receiver$iv2, false);
                                } else {
                                    object = null;
                                }
                            }
                            Object tableName = object;
                            CodeTextBuilder.append$default(this.this$0.BaseCreatingGenerator.this.getBuilder(), "alter table " + (String)tableName, null, false, null, 14, null);
                            CodeTextBuilder.indent$default(this.this$0.BaseCreatingGenerator.this.getBuilder(), null, 1, null);
                            this.this$0.BaseCreatingGenerator.this.addOuterConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            String w1 = !this.this$0.BaseCreatingGenerator.this.getUseName((BasicNamedElement)this.this$0.getElement()) ? "add " : "";
                            CodeTextBuilder codeTextBuilder = this.this$0.BaseCreatingGenerator.this.getBuilder();
                            StringBuilder stringBuilder = new StringBuilder().append(w1).append("foreign key (");
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.BaseCreatingGenerator.this;
                            List<String> list = ((BasicForeignKey)this.this$0.getElement()).getColNames();
                            Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                            Iterable $i$f$getScr = list;
                            $receiver$iv2 = baseCreatingGenerator;
                            StringBuilder stringBuilder3 = stringBuilder;
                            CodeTextBuilder codeTextBuilder3 = codeTextBuilder;
                            String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder3, stringBuilder3.append(string).append(") ").append(this.$reference).toString(), null, false, null, 14, null);
                            this.this$0.BaseCreatingGenerator.this.generateCascadeRules((BasicForeignKey)this.this$0.getElement());
                            this.this$0.BaseCreatingGenerator.this.generateDeferrability((BasicConstraint)this.this$0.getElement());
                        }
                    }
                }
                {
                    this.this$0 = createForeignKey;
                    this.$reference = string;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final String makeForeignKeyReference(@NotNull BasicForeignKey fk) {
            String string;
            String string2;
            CharSequence charSequence;
            String $receiver$iv;
            BaseCreatingGenerator this_$iv;
            StringBuilder stringBuilder;
            boolean toQualify;
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            String domSchemaName = ModelFun.getSchemaName(fk);
            String refSchemaName = fk.getRefSchemaName();
            boolean bl = toQualify = refSchemaName != null && (Intrinsics.areEqual((Object)refSchemaName, (Object)domSchemaName) ^ true || Intrinsics.areEqual((Object)refSchemaName, (Object)BaseCreatingGenerator.this.getContext().getCurrentSchemaName()) ^ true);
            if (toQualify) {
                String string3;
                String string4;
                StringBuilder stringBuilder2 = new StringBuilder();
                String string5 = refSchemaName;
                if (string5 != null) {
                    String string6 = string5;
                    BaseCreatingGenerator baseCreatingGenerator = BaseCreatingGenerator.this;
                    stringBuilder = stringBuilder2;
                    charSequence = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                    stringBuilder2 = stringBuilder;
                    string4 = charSequence;
                } else {
                    string4 = null;
                }
                StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(".");
                String string7 = fk.getRefTableName();
                if (string7 != null) {
                    $receiver$iv = string7;
                    this_$iv = BaseCreatingGenerator.this;
                    stringBuilder = stringBuilder3;
                    charSequence = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                    stringBuilder3 = stringBuilder;
                    string3 = charSequence;
                } else {
                    string3 = null;
                }
                string2 = stringBuilder3.append(string3).toString();
            } else {
                String string8 = fk.getRefTableName();
                if (string8 != null) {
                    $receiver$iv = string8;
                    this_$iv = BaseCreatingGenerator.this;
                    string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
                } else {
                    string2 = null;
                }
            }
            String refTableScr = string2;
            boolean omitReferencedColumns = ModelFun.getRefToPrimaryKey(fk) && BaseCreatingGenerator.this.allowReferenceOnPrimaryKeyWithoutColumns();
            StringBuilder stringBuilder4 = new StringBuilder().append("references ").append(refTableScr);
            if (omitReferencedColumns) {
                string = "";
            } else {
                void this_$iv2;
                void $receiver$iv2;
                StringBuilder stringBuilder5 = new StringBuilder().append(" (");
                List<String> list = fk.getRefColNames();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"fk.refColNames");
                Iterable iterable = list;
                BaseCreatingGenerator $i$f$getScr = BaseCreatingGenerator.this;
                charSequence = stringBuilder5;
                stringBuilder = stringBuilder4;
                String string9 = CollectionsKt.joinToString$default((Iterable)$receiver$iv2, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                stringBuilder4 = stringBuilder;
                string = ((StringBuilder)charSequence).append(string9).append(")").toString();
            }
            String reference = stringBuilder4.append(string).toString();
            return reference;
        }

        public CreateForeignKey(BasicForeignKey element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateKey;", "T", "Lcom/intellij/database/model/basic/BasicKey;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicKey;)V", "appendProperties", "", "produce", "register", "Lcom/intellij/database/scripting/Operation;", "root", "intellij.database.scripting"})
    protected static class CreateKey<T extends BasicKey>
    extends CreateProducer<T> {
        final /* synthetic */ BaseCreatingGenerator this$0;

        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            BasicIndex index2 = ((BasicKey)this.getElement()).getUnderlyingIndex();
            if (index2 != null && !this.this$0.isIndexExplicitFor(index2, (BasicKey)this.getElement())) {
                BaseCreatingGenerator.prepareElement$default(this.this$0, index2, $receiver, false, 4, null);
            }
            return operation;
        }

        @Override
        public void produce() {
            String w = this.this$0.makeKeyWord((BasicKey)this.getElement());
            AbstractCodeGenerator.coding$default(this.this$0, null, false, (Function0)new Function0<Unit>(this, w){
                final /* synthetic */ CreateKey this$0;
                final /* synthetic */ String $w;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    switch (BaseCreatingGenerator$CreateKey$WhenMappings.$EnumSwitchMapping$0[this.this$0.this$0.getLocus().ordinal()]) {
                        case 1: {
                            this.this$0.this$0.addInnerConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), this.$w, null, false, null, 10, null);
                            this.this$0.appendProperties();
                            CodeTextBuilder.ensureEoln$default(this.this$0.this$0.getBuilder(), null, 1, null);
                            break;
                        }
                        case 2: {
                            void this_$iv2;
                            void $receiver$iv2;
                            this.this$0.this$0.addInnerConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            CodeTextBuilder codeTextBuilder = this.this$0.this$0.getBuilder();
                            StringBuilder stringBuilder = new StringBuilder().append(this.$w).append(" (");
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                            List<String> list = ((BasicKey)this.this$0.getElement()).getColNames();
                            Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                            Iterable iterable = list;
                            BaseCreatingGenerator baseCreatingGenerator2 = baseCreatingGenerator;
                            StringBuilder stringBuilder2 = stringBuilder;
                            CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                            String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv2, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(string).append(")").toString(), null, false, null, 10, null);
                            this.this$0.appendProperties();
                            CodeTextBuilder.ensureEoln$default(this.this$0.this$0.getBuilder(), null, 1, null);
                            this.this$0.this$0.getBuilder().addSuffixToTheLastLine(',');
                            break;
                        }
                        default: {
                            void this_$iv;
                            void $receiver$iv;
                            String string;
                            CodeTextBuilder codeTextBuilder;
                            StringBuilder stringBuilder;
                            Object $receiver$iv2;
                            CodeTextBuilder codeTextBuilder3 = this.this$0.this$0.getBuilder();
                            StringBuilder stringBuilder3 = new StringBuilder().append("alter table ");
                            Object object = ((BasicKey)this.this$0.getElement()).getLikeTable();
                            if (object == null || (object = AbstractCodeGenerator.currentScopeName$default(this.this$0.this$0, (BasicElement)object, null, 1, null)) == null) {
                                String string2 = ((BasicKey)this.this$0.getElement()).getTableName();
                                if (string2 != null) {
                                    $receiver$iv2 = string2;
                                    BaseCreatingGenerator this_$iv2 = this.this$0.this$0;
                                    stringBuilder = stringBuilder3;
                                    codeTextBuilder = codeTextBuilder3;
                                    string = AbstractCodeGenerator.access$getNaming$p(this_$iv2).nameToScript((String)$receiver$iv2, false);
                                    codeTextBuilder3 = codeTextBuilder;
                                    stringBuilder3 = stringBuilder;
                                    object = string;
                                } else {
                                    object = null;
                                }
                            }
                            CodeTextBuilder.append$default(codeTextBuilder3, stringBuilder3.append((String)object).toString(), null, false, null, 14, null);
                            CodeTextBuilder.indent$default(this.this$0.this$0.getBuilder(), null, 1, null);
                            this.this$0.this$0.addOuterConstraintNameAndIndent((BasicConstraint)this.this$0.getElement());
                            String w1 = !this.this$0.this$0.getUseName((BasicNamedElement)this.this$0.getElement()) ? "add " : "";
                            CodeTextBuilder codeTextBuilder4 = this.this$0.this$0.getBuilder();
                            StringBuilder stringBuilder4 = new StringBuilder().append(w1).append(this.$w).append(" (");
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                            List<String> list = ((BasicKey)this.this$0.getElement()).getColNames();
                            Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.colNames");
                            Iterable $i$f$getScr = list;
                            $receiver$iv2 = baseCreatingGenerator;
                            stringBuilder = stringBuilder4;
                            codeTextBuilder = codeTextBuilder4;
                            string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(")").toString(), null, false, null, 10, null);
                            this.this$0.appendProperties();
                            CodeTextBuilder.ensureEoln$default(this.this$0.this$0.getBuilder(), null, 1, null);
                        }
                    }
                }
                {
                    this.this$0 = createKey;
                    this.$w = string;
                    super(0);
                }
            }, 3, null);
        }

        public void appendProperties() {
            this.this$0.generateDeferrability((BasicConstraint)this.getElement());
        }

        public CreateKey(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateIndex;", "T", "Lcom/intellij/database/model/basic/BasicIndex;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicIndex;)V", "appendProperties", "", "produce", "qualifyName", "", "intellij.database.scripting"})
    protected static class CreateIndex<T extends BasicIndex>
    extends CreateProducer<T> {
        final /* synthetic */ BaseCreatingGenerator this$0;

        @Override
        public void produce() {
            String w = this.this$0.makeIndexWord((BasicIndex)this.getElement());
            String condition = ((BasicIndex)this.getElement()).getCondition();
            StringBuilder b = new StringBuilder();
            for (String col : ((BasicIndex)this.getElement()).getColNames()) {
                CharSequence charSequence = b;
                if (charSequence.length() > 0) {
                    b.append(", ");
                }
                BasicIndex basicIndex = (BasicIndex)this.getElement();
                String string = col;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col");
                b.append(this.this$0.scriptIndexColumn(basicIndex, string));
            }
            AbstractCodeGenerator.coding$default(this.this$0, null, false, (Function0)new Function0<Unit>(this, w, b, condition){
                final /* synthetic */ CreateIndex this$0;
                final /* synthetic */ String $w;
                final /* synthetic */ StringBuilder $b;
                final /* synthetic */ String $condition;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    switch (BaseCreatingGenerator$CreateIndex$WhenMappings.$EnumSwitchMapping$0[this.this$0.this$0.getLocus().ordinal()]) {
                        case 1: {
                            CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), this.$w, null, false, null, 10, null);
                            this.this$0.appendProperties();
                            CodeTextBuilder.ensureEoln$default(this.this$0.this$0.getBuilder(), null, 1, null);
                            break;
                        }
                        case 2: {
                            String s = this.this$0.this$0.getUseName((BasicNamedElement)this.this$0.getElement()) ? "" + this.$w + ' ' + this.this$0.nameScr() + " (" + this.$b + ')' : "" + this.$w + " (" + this.$b + ')';
                            CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), s, null, false, null, 10, null);
                            this.this$0.appendProperties();
                            CodeTextBuilder.ensureEoln$default(this.this$0.this$0.getBuilder(), null, 1, null);
                            break;
                        }
                        default: {
                            BasicLikeTable basicLikeTable = ((BasicIndex)this.this$0.getElement()).getLikeTable();
                            String tableName = basicLikeTable != null ? AbstractCodeGenerator.currentScopeName$default(this.this$0.this$0, basicLikeTable, null, 1, null) : null;
                            String indexName = this.this$0.qualifyName() ? this.this$0.fqName() : this.this$0.nameScr();
                            CodeTextBuilder codeTextBuilder = this.this$0.this$0.getBuilder();
                            CharSequence[] charSequenceArray = new CharSequence[4];
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                            ObjectKind objectKind = ObjectKind.INDEX;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
                            charSequenceArray[0] = baseCreatingGenerator.createOrReplace(objectKind);
                            charSequenceArray[1] = this.$w;
                            BaseCreatingGenerator baseCreatingGenerator2 = this.this$0.this$0;
                            ObjectKind objectKind2 = ObjectKind.INDEX;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.INDEX");
                            charSequenceArray[2] = baseCreatingGenerator2.ifNotExists(objectKind2);
                            charSequenceArray[3] = indexName;
                            codeTextBuilder.phrase(charSequenceArray);
                            CodeTextBuilder this_$iv = this.this$0.this$0.getBuilder();
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                String string;
                                this.this$0.this$0.getBuilder().phrase("on " + tableName + " (" + this.$b + ')');
                                CodeTextBuilder codeTextBuilder2 = this.this$0.this$0.getBuilder();
                                CharSequence[] charSequenceArray2 = new CharSequence[1];
                                CharSequence[] charSequenceArray3 = charSequenceArray2;
                                CharSequence[] charSequenceArray4 = charSequenceArray2;
                                int n = 0;
                                String string2 = this.$condition;
                                if (string2 != null) {
                                    String string3 = string2;
                                    int n2 = n;
                                    CharSequence[] charSequenceArray5 = charSequenceArray3;
                                    CharSequence[] charSequenceArray6 = charSequenceArray4;
                                    CodeTextBuilder codeTextBuilder3 = codeTextBuilder2;
                                    String it = string3;
                                    String string4 = "where " + it;
                                    codeTextBuilder2 = codeTextBuilder3;
                                    charSequenceArray4 = charSequenceArray6;
                                    charSequenceArray3 = charSequenceArray5;
                                    n = n2;
                                    string = string4;
                                } else {
                                    string = null;
                                }
                                charSequenceArray3[n] = string;
                                codeTextBuilder2.phrase(charSequenceArray4);
                                this.this$0.appendProperties();
                                break;
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                    }
                }
                {
                    this.this$0 = createIndex;
                    this.$w = string;
                    this.$b = stringBuilder;
                    this.$condition = string2;
                    super(0);
                }
            }, 3, null);
        }

        public boolean qualifyName() {
            return true;
        }

        public void appendProperties() {
        }

        public CreateIndex(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicLikeColumn;)V", "appendColumnWord", "", "produce", "", "intellij.database.scripting"})
    protected class CreateLikeColumn
    extends CreateProducer<BasicLikeColumn> {
        @Override
        public void produce() {
            String string = BaseCreatingGenerator.this.makeColumnDefinition((BasicLikeColumn)this.getElement());
            if (string == null) {
                return;
            }
            String line = string;
            switch (BaseCreatingGenerator$CreateLikeColumn$WhenMappings.$EnumSwitchMapping$0[BaseCreatingGenerator.this.getLocus().ordinal()]) {
                case 1: {
                    CodeTextBuilder.append$default(BaseCreatingGenerator.this.getBuilder(), line, null, false, null, 14, null);
                    BaseCreatingGenerator.this.coding(ScriptLocus.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ CreateLikeColumn this$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $receiver$iv;
                            Iterable iterable = this.this$0.getNestedOperations();
                            BaseCreatingGenerator baseCreatingGenerator = this.this$0.BaseCreatingGenerator.this;
                            for (T element$iv : $receiver$iv) {
                                Operation p1 = (Operation)element$iv;
                                baseCreatingGenerator.produce(p1);
                            }
                        }
                        {
                            this.this$0 = createLikeColumn;
                            super(0);
                        }
                    }));
                    BaseCreatingGenerator.this.getBuilder().addSuffixToTheLastLine(',');
                    break;
                }
                case 2: {
                    BasicScriptable table;
                    BasicScriptable basicScriptable;
                    Object t = this.getElement();
                    if (!(t instanceof BasicTableColumn)) {
                        t = null;
                    }
                    if ((basicScriptable = (BasicTableColumn)t) == null || (basicScriptable = basicScriptable.getTable()) == null) {
                        return;
                    }
                    BasicScriptable basicScriptable2 = table = basicScriptable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicScriptable2, (String)"table");
                    String tableName = AbstractCodeGenerator.currentScopeName$default(BaseCreatingGenerator.this, basicScriptable2, null, 1, null);
                    AbstractCodeGenerator.coding$default(BaseCreatingGenerator.this, null, false, (Function0)new Function0<Unit>(this, tableName, line){
                        final /* synthetic */ CreateLikeColumn this$0;
                        final /* synthetic */ String $tableName;
                        final /* synthetic */ String $line;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            this.this$0.BaseCreatingGenerator.this.getBuilder().phrase("alter table", this.$tableName);
                            CodeTextBuilder this_$iv = this.this$0.BaseCreatingGenerator.this.getBuilder();
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                this.this$0.BaseCreatingGenerator.this.getBuilder().phrase("add", this.this$0.appendColumnWord() ? "column" : null, this.$line);
                                this.this$0.BaseCreatingGenerator.this.coding(ScriptLocus.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                                    final /* synthetic */ produce.2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void invoke() {
                                        void $receiver$iv;
                                        Iterable iterable = this.this$0.this$0.getNestedOperations();
                                        BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0.BaseCreatingGenerator.this;
                                        for (T element$iv : $receiver$iv) {
                                            Operation p1 = (Operation)element$iv;
                                            baseCreatingGenerator.produce(p1);
                                        }
                                    }
                                }));
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                        {
                            this.this$0 = createLikeColumn;
                            this.$tableName = string;
                            this.$line = string2;
                            super(0);
                        }
                    }, 3, null);
                    if (((BasicTableColumn)this.getElement()).getComment() == null) break;
                    BaseCreatingGenerator.this.generateColumnComment((BasicLikeColumn)this.getElement());
                    break;
                }
                default: {
                    BaseCreatingGenerator.this.getBuilder().phrase("Here should be column", line);
                }
            }
        }

        protected boolean appendColumnWord() {
            return false;
        }

        public CreateLikeColumn(BasicLikeColumn element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseCreatingGenerator.this, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\b\u0010\u001a\u001a\u00020\rH\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateTable;", "T", "Lcom/intellij/database/model/basic/BasicTable;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicTable;)V", "tableElementsApplicableInExactTask", "", "Lcom/intellij/database/model/ObjectKind;", "getTableElementsApplicableInExactTask", "()Ljava/util/Set;", "canCreateInTable", "", "Lcom/intellij/database/model/basic/BasicElement;", "generateTableOutsideStuff", "", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "produce", "register", "Lcom/intellij/database/scripting/Operation;", "root", "registerColumn", "column", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "shouldProduceChildren", "intellij.database.scripting"})
    protected static class CreateTable<T extends BasicTable>
    extends CreateProducer<T> {
        @NotNull
        private final Set<ObjectKind> tableElementsApplicableInExactTask;
        final /* synthetic */ BaseCreatingGenerator this$0;

        @Override
        @NotNull
        public Operation register(@NotNull Operation root2) {
            BasicNamedElement it;
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = super.register(root2);
            Family family = ((BasicTable)this.getElement()).getKeys();
            Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"element.keys");
            Iterable iterable = family;
            for (Object element$iv : iterable) {
                BasicKey key2;
                BasicKey basicKey = key2 = (BasicKey)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"key");
                if (!this.this$0.isIndexExplicitFor(basicKey.getUnderlyingIndex(), key2)) continue;
                BaseCreatingGenerator.prepareElement$default(this.this$0, key2, root2, false, 4, null);
            }
            PositioningNamingFamily positioningNamingFamily = ((BasicTable)this.getElement()).getColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"element.columns");
            Iterable iterable2 = positioningNamingFamily;
            for (Object element$iv : iterable2) {
                BasicTableOrViewColumn basicTableOrViewColumn = it = (BasicTableOrViewColumn)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"it");
                this.registerColumn(basicTableOrViewColumn, $receiver);
            }
            Family family2 = ((BasicTable)this.getElement()).getKeys();
            Intrinsics.checkExpressionValueIsNotNull((Object)family2, (String)"element.keys");
            Iterable iterable3 = family2;
            for (Object element$iv : iterable3) {
                BasicNamedElement basicNamedElement = it = (BasicKey)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
                BaseCreatingGenerator.prepareElement$default(this.this$0, basicNamedElement, $receiver, false, 4, null);
            }
            block3: for (Family family3 : ((BasicTable)this.getElement()).getFamilies()) {
                if (family3 == ((BasicTable)this.getElement()).getColumns()) continue;
                Iterator iterator = family3.iterator();
                while (iterator.hasNext()) {
                    BasicElement child;
                    BasicElement basicElement = child = (BasicElement)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                    if (!this.tableElementsApplicableInExactTask.contains(basicElement.getKind()) && this.this$0.isExact()) continue block3;
                    if (this.canCreateInTable(child)) {
                        BaseCreatingGenerator.prepareElement$default(this.this$0, child, $receiver, false, 4, null);
                        continue;
                    }
                    BaseCreatingGenerator.prepareElement$default(this.this$0, child, root2, false, 4, null);
                }
            }
            return operation;
        }

        protected void registerColumn(@NotNull BasicTableOrViewColumn column2, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation operation = BaseCreatingGenerator.prepareElement$default(this.this$0, column2, root2, false, 4, null);
            if (operation != null) {
                Operation operation2;
                Operation $receiver = operation2 = operation;
                Iterable<BasicElement> $receiver$iv = this.this$0.getSingleColumnElements(column2);
                Iterator<BasicElement> iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    BasicElement element$iv;
                    BasicElement it = element$iv = iterator.next();
                    BaseCreatingGenerator.prepareElement$default(this.this$0, it, $receiver, false, 4, null);
                }
            }
        }

        @Override
        public void produce() {
            AbstractCodeGenerator.coding$default(this.this$0, null, false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ CreateTable this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void header;
                    HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter();
                    String string = headerFooter.component1();
                    String footer = headerFooter.component2();
                    CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), (CharSequence)header, null, false, null, 14, null);
                    if (this.this$0.shouldProduceChildren()) {
                        CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "(", null, false, null, 14, null);
                        this.this$0.this$0.coding(ScriptLocus.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ produce.1 this$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                void $receiver$iv;
                                Iterable iterable = this.this$0.this$0.getNestedOperations();
                                BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0.this$0;
                                for (T element$iv : $receiver$iv) {
                                    Operation p1 = (Operation)element$iv;
                                    baseCreatingGenerator.produce(p1);
                                }
                                this.this$0.this$0.this$0.generateAdditionalTableItems((BasicTable)this.this$0.this$0.getElement());
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                        this.this$0.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                        CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), ")", null, false, null, 14, null);
                    }
                    CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), footer, null, false, null, 14, null);
                }
                {
                    this.this$0 = createTable;
                    super(0);
                }
            }, 3, null);
            if (Intrinsics.areEqual((Object)((Object)this.this$0.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE)) || Intrinsics.areEqual((Object)((Object)this.this$0.getLocus()), (Object)((Object)ScriptLocus.IN_STATEMENT))) {
                this.generateTableOutsideStuff();
            }
        }

        protected void generateTableOutsideStuff() {
            if (((BasicTable)this.getElement()).getComment() != null) {
                this.this$0.generateComment((BasicElement)this.getElement());
            }
            FilteredTraverserBase filteredTraverserBase = new JBTreeTraverser((Function)generateTableOutsideStuff.1.INSTANCE).withRoots((Iterable)this.getNestedOperations());
            Intrinsics.checkExpressionValueIsNotNull((Object)filteredTraverserBase, (String)"JBTreeTraverser<Operatio\u2026thRoots(nestedOperations)");
            Iterable $receiver$iv = (Iterable)filteredTraverserBase;
            for (Object element$iv : $receiver$iv) {
                BasicElement basicElement;
                Operation it;
                Operation operation = it = (Operation)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"it");
                if (ScenarioOperations.element(operation) == null) continue;
                BasicElement it2 = basicElement;
                if (it2.getComment() == null) continue;
                this.this$0.generateComment(it2);
            }
        }

        @NotNull
        protected HeaderFooter makeTableHeaderFooter() {
            String name = this.fqName();
            String temporary = ((BasicTable)this.getElement()).isTemporary() ? "temporary" : null;
            String[] stringArray = new String[5];
            ObjectKind objectKind = ((BasicTable)this.getElement()).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
            stringArray[0] = this.this$0.createOrReplace(objectKind);
            stringArray[1] = temporary;
            String string = this.this$0.elementKindNameForCreate((BasicElement)this.getElement());
            if (string == null) {
                string = "table";
            }
            stringArray[2] = string;
            ObjectKind objectKind2 = ((BasicTable)this.getElement()).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"element.kind");
            stringArray[3] = this.this$0.ifNotExists(objectKind2);
            stringArray[4] = name;
            String h = ScriptingUtilsKt.phrase(stringArray);
            return new HeaderFooter(h, null);
        }

        @NotNull
        protected final Set<ObjectKind> getTableElementsApplicableInExactTask() {
            return this.tableElementsApplicableInExactTask;
        }

        protected boolean canCreateInTable(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return this.this$0.canGenerateHere(ScriptLocus.IN_TABLE, element);
        }

        protected boolean shouldProduceChildren() {
            Collection collection = this.getNestedOperations();
            return !collection.isEmpty();
        }

        public CreateTable(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
            this.tableElementsApplicableInExactTask = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK});
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0012\u0004\u0012\u0002H\u00010\u0003R\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateSequence;", "T", "Lcom/intellij/database/model/basic/BasicSequence;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicSequence;)V", "produce", "", "intellij.database.scripting"})
    protected static class CreateSequence<T extends BasicSequence>
    extends CreateProducer<T> {
        final /* synthetic */ BaseCreatingGenerator this$0;

        @Override
        public void produce() {
            if (this.getElement() instanceof BasicNamedElement && ((BasicNamedElement)this.getElement()).isNameSurrogate()) {
                return;
            }
            String name = this.fqName();
            ArrayList parameters = new ArrayList();
            this.this$0.gatherSequenceIdentityParameters((BasicSequence)this.getElement(), (List<String>)parameters);
            AbstractCodeGenerator.coding$default(this.this$0, null, false, (Function0)new Function0<Unit>(this, name, parameters){
                final /* synthetic */ CreateSequence this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ ArrayList $parameters;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = this.this$0.this$0.getBuilder();
                    CharSequence[] charSequenceArray = new CharSequence[4];
                    BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                    ObjectKind objectKind = ObjectKind.SEQUENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SEQUENCE");
                    charSequenceArray[0] = baseCreatingGenerator.createOrReplace(objectKind);
                    String string = this.this$0.this$0.elementKindNameForCreate((BasicElement)this.this$0.getElement());
                    charSequenceArray[1] = string != null ? (CharSequence)string : (CharSequence)"sequence";
                    BaseCreatingGenerator baseCreatingGenerator2 = this.this$0.this$0;
                    ObjectKind objectKind2 = ObjectKind.SEQUENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.SEQUENCE");
                    charSequenceArray[2] = baseCreatingGenerator2.ifNotExists(objectKind2);
                    charSequenceArray[3] = this.$name;
                    codeTextBuilder.phrase(charSequenceArray);
                    Collection collection = this.$parameters;
                    if (!collection.isEmpty()) {
                        AbstractCodeGenerator.coding$default(this.this$0.this$0, null, true, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ produce.1 this$0;

                            public final void invoke() {
                                for (String p : this.this$0.$parameters) {
                                    CodeTextBuilder.append$default(this.this$0.this$0.this$0.getBuilder(), p, null, false, null, 14, null);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, 1, null);
                    }
                }
                {
                    this.this$0 = createSequence;
                    this.$name = string;
                    this.$parameters = arrayList;
                    super(0);
                }
            }, 3, null);
        }

        public CreateSequence(T element) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super((BaseCreatingGenerator)$outer, (BasicElement)element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateOther;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateProducer;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "element", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;Lcom/intellij/database/model/basic/BasicElement;)V", "canCreate", "Lcom/intellij/database/scripting/ScriptingCapabilities$VersionedCapability;", "", "produce", "", "intellij.database.scripting"})
    protected class CreateOther
    extends CreateProducer<BasicElement> {
        @Override
        public void produce() {
            CodeTextBuilder codeTextBuilder = BaseCreatingGenerator.this.getBuilder();
            StringBuilder stringBuilder = new StringBuilder().append("we don't know how to generate ").append(this.getElement().getKind().code()).append(' ');
            String string = this.getElement().getRealName();
            if (string == null) {
                string = "<with-no-name>";
            }
            codeTextBuilder.appendErrorComment(stringBuilder.append(string).append(" (class ").append(this.getElement().getClass().getSimpleName()).append(") :(").toString());
        }

        @Override
        @NotNull
        public ScriptingCapabilities.VersionedCapability<Boolean> canCreate() {
            return AbstractScriptingServiceKt.getUNSUPPORTED();
        }

        public CreateOther(BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            super(BaseCreatingGenerator.this, element);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005*\u0001\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$Companion;", "", "()V", "CREATE", "Lcom/intellij/database/scripting/OperationType;", "getCREATE", "()Lcom/intellij/database/scripting/OperationType;", "CREATE_FIXERS", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "getCREATE_FIXERS$intellij_database_scripting", "()Ljava/util/List;", "CREATE_FK_FIXER", "com/intellij/database/scripting/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1", "getCREATE_FK_FIXER", "()Lcom/intellij/database/scripting/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getCREATE() {
            return CREATE;
        }

        private final CREATE_FK_FIXER.1 getCREATE_FK_FIXER() {
            return CREATE_FK_FIXER;
        }

        @NotNull
        public final List<AbstractCodeGenerator.EdgeFixer> getCREATE_FIXERS$intellij_database_scripting() {
            return CREATE_FIXERS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

