/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingAlterTask;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingInternalTask;
import com.intellij.database.scripting.ScriptingNativeDefinitionTask;
import com.intellij.database.scripting.ScriptingOrder;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0014J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH$J\b\u0010\u0019\u001a\u00020\u0015H\u0014J\b\u0010\u001a\u001a\u00020\u0015H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0004J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0004J)\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"H\u0014\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0&H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/intellij/database/scripting/AbstractTransitionCodeGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "generated", "", "getGenerated", "()Ljava/util/Set;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "getPostponed", "()Lcom/intellij/util/containers/MultiMap;", "finishElement", "", "element", "generate", "generateElement", "generateFooting", "generateHeading", "isNewCodeGen", "", "process", "processElement", "processInnerElements", "kinds", "", "Lcom/intellij/database/model/ObjectKind;", "(Lcom/intellij/database/model/basic/BasicElement;[Lcom/intellij/database/model/ObjectKind;)V", "setElementsToGenerate", "elements", "", "intellij.database.scripting"})
public abstract class AbstractTransitionCodeGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final Deque<BasicElement> deck;
    @NotNull
    private final MultiMap<BasicElement, BasicElement> postponed;
    @NotNull
    private final Set<BasicElement> generated;

    @NotNull
    protected final Deque<BasicElement> getDeck() {
        return this.deck;
    }

    @NotNull
    protected final MultiMap<BasicElement, BasicElement> getPostponed() {
        return this.postponed;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    @Override
    protected boolean isNewCodeGen() {
        return false;
    }

    private final void setElementsToGenerate(Iterable<? extends BasicElement> elements) {
        TreeMap sorted = new TreeMap();
        for (BasicElement basicElement : elements) {
            Map map = sorted;
            String string = this.getHelper().getObjectPreliminaryOrder(basicElement);
            BasicElement basicElement2 = basicElement;
            map.put(string, basicElement2);
        }
        for (BasicElement basicElement : sorted.values()) {
            this.deck.offer(basicElement);
        }
    }

    public void generate() {
        this.generateHeading();
        while ((Intrinsics.areEqual((Object)((Object)this.getCategory().getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER)) ? this.deck.pollLast() : this.deck.poll()) != null) {
            BasicElement element;
            element = element;
            if (element.isAutoCreated()) continue;
            this.process(element);
        }
        this.generateFooting();
    }

    protected void generateHeading() {
    }

    protected void generateFooting() {
    }

    protected final void process(@NotNull BasicElement element) {
        boolean postpone;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!this.generated.contains(element)) {
            if (Intrinsics.areEqual((Object)((Object)this.getCategory().getOrder()), (Object)((Object)ScriptingOrder.NORMAL_ORDER)) && !this.isNewCodeGen()) {
                Iterable<? extends BasicElement> predecessors = element.getPredecessors();
                postpone = false;
                for (BasicElement string : predecessors) {
                    if (this.generated.contains(string) || !this.deck.contains(string)) continue;
                    this.postponed.putValue((Object)string, (Object)element);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
            }
            this.processElement(element);
            if (!this.generated.contains(element)) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_SCHEMA)) || Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE))) {
            Collection collection = this.postponed.get((Object)element);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"postponed[element]");
            Iterable pendingElements = collection;
            boolean bl = postpone = !this.isNewCodeGen() || this.postponed.isEmpty();
            if (_Assertions.ENABLED && !postpone) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            for (BasicElement pendingElement : pendingElements) {
                this.process(pendingElement);
            }
        }
    }

    protected final void processElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.generateElement(element);
        this.finishElement(element);
    }

    protected abstract void generateElement(@NotNull BasicElement var1);

    protected void finishElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.generated.add(element);
    }

    protected void processInnerElements(@NotNull BasicElement element, ObjectKind ... kinds) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)kinds, (String)"kinds");
        ArrayList innerElements = new ArrayList();
        for (ObjectKind kind : kinds) {
            Family<? extends BasicElement> f = element.familyOf(kind);
            if (f == null) continue;
            CollectionsKt.addAll((Collection)innerElements, (Iterable)f);
        }
        int n = innerElements.size();
        if (n == 0) {
            return;
        }
        if (n >= 2 && Intrinsics.areEqual((Object)((Object)this.getCategory().getOrder()), (Object)((Object)ScriptingOrder.REVERS_ORDER))) {
            Collections.reverse(innerElements);
        }
        Iterator iterator = innerElements.iterator();
        while (iterator.hasNext()) {
            BasicElement innerElement;
            BasicElement basicElement = innerElement = (BasicElement)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"innerElement");
            this.process(basicElement);
        }
    }

    public AbstractTransitionCodeGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
        this.deck = new ArrayDeque();
        this.postponed = new MultiMap();
        this.generated = new HashSet();
        ScriptingTask scriptingTask = task;
        if (scriptingTask instanceof ScriptingSingleModelTask) {
            collection = ((ScriptingSingleModelTask)task).getElements();
        } else if (scriptingTask instanceof ScriptingNativeDefinitionTask) {
            collection = ((ScriptingNativeDefinitionTask)task).getElements();
        } else if (scriptingTask instanceof ScriptingAlterTask) {
            collection = CollectionsKt.emptyList();
        } else if (scriptingTask instanceof ScriptingInternalTask) {
            collection = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.setElementsToGenerate(collection);
    }
}

