/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.ScriptingUtilsKt;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/scripting/AbstractNamingService;", "Lcom/intellij/database/scripting/NamingService;", "()V", "aptNamePattern", "Ljava/util/regex/Pattern;", "getAptNamePattern", "()Ljava/util/regex/Pattern;", "aptPlainNamePattern", "getAptPlainNamePattern", "reservedWords", "Ljava/util/NavigableSet;", "", "getReservedWords", "()Ljava/util/NavigableSet;", "aptPattern", "plain", "", "enquoteName", "name", "nameToScript", "intellij.database.scripting"})
public abstract class AbstractNamingService
implements NamingService {
    @NotNull
    private final NavigableSet<String> reservedWords;

    @NotNull
    public NavigableSet<String> getReservedWords() {
        return this.reservedWords;
    }

    @Override
    @NotNull
    public String nameToScript(@NotNull String name, boolean plain) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return ScriptingUtilsKt.matches(name, this.aptPattern(plain)) && !this.getReservedWords().contains(name) ? name : this.enquoteName(name);
    }

    @NotNull
    public String enquoteName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        char c = '\"';
        String string = StringsKt.replace$default((String)name, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    @NotNull
    public final Pattern aptPattern(boolean plain) {
        return plain ? this.getAptPlainNamePattern() : this.getAptNamePattern();
    }

    @NotNull
    public abstract Pattern getAptNamePattern();

    @NotNull
    public abstract Pattern getAptPlainNamePattern();

    public AbstractNamingService() {
        NavigableSet navigableSet = Collections.emptyNavigableSet();
        Intrinsics.checkExpressionValueIsNotNull(navigableSet, (String)"Collections.emptyNavigableSet()");
        this.reservedWords = navigableSet;
    }
}

