/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.scripting.AbstractCodeGenerator$WhenMappings;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.Effect;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.NamingServices;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.RequiredEffect;
import com.intellij.database.scripting.Scenario;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingHelper;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingTaskKt;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.scripting.SimpleProducer;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0007\b&\u0018\u0000 \u008c\u00012\u00020\u0001:\n\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u00109\u001a\u0002052\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J\u0016\u0010=\u001a\u0002052\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0014J\b\u0010>\u001a\u00020?H\u0002J\n\u0010@\u001a\u0004\u0018\u00010+H\u0004J\n\u0010A\u001a\u0004\u0018\u00010+H\u0004J,\u0010B\u001a\u00020?2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010C\u001a\u0002052\f\u0010D\u001a\b\u0012\u0004\u0012\u00020?0EH\u0004J\u001c\u0010F\u001a\b\u0012\u0004\u0012\u00020<0G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020<0IH\u0014J\b\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010;H\u0002J\u0016\u0010M\u001a\u00020N2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J3\u0010O\u001a\u00020?2\u0006\u0010P\u001a\u00020<2\u0006\u0010Q\u001a\u00020<2\u0018\u0010R\u001a\u0014\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020?0SH\u0082\bJ\"\u0010T\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<0U2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020<0VH\u0002J\u000e\u0010W\u001a\b\u0012\u0004\u0012\u00020X0;H\u0016J\b\u0010Y\u001a\u00020%H\u0007J\n\u0010Z\u001a\u0004\u0018\u00010+H\u0004J\b\u0010[\u001a\u000205H\u0014J\u0010\u0010\\\u001a\u00020<2\u0006\u0010]\u001a\u00020+H\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010<2\u0006\u0010_\u001a\u00020`H\u0017J\b\u0010a\u001a\u00020<H\u0002J%\u0010b\u001a\u00020?2\u001b\u0010D\u001a\u0017\u0012\b\u0012\u00060\bR\u00020\u0000\u0012\u0004\u0012\u00020?0c\u00a2\u0006\u0002\bdH\u0004J\b\u0010e\u001a\u00020?H\u0002J\u0010\u0010e\u001a\u00020?2\u0006\u0010f\u001a\u00020gH\u0002J\b\u0010h\u001a\u000205H\u0014J\b\u0010i\u001a\u00020?H\u0002J\b\u0010j\u001a\u00020?H&J(\u0010k\u001a\u00020?2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020<0V2\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020?0cJ\u0006\u0010m\u001a\u00020?J\u0010\u0010m\u001a\u00020?2\u0006\u0010n\u001a\u00020<H\u0016J\u001c\u0010o\u001a\u0004\u0018\u00010+2\u0006\u0010p\u001a\u00020`2\n\b\u0002\u0010q\u001a\u0004\u0018\u00010+J\b\u0010r\u001a\u00020?H\u0016J\n\u0010s\u001a\u0004\u0018\u00010+H\u0004J\u0010\u0010t\u001a\u00020+2\u0006\u0010u\u001a\u00020vH\u0016J%\u0010w\u001a\u00020?2\u001b\u0010D\u001a\u0017\u0012\b\u0012\u00060\bR\u00020\u0000\u0012\u0004\u0012\u00020?0c\u00a2\u0006\u0002\bdH\u0004J\b\u0010x\u001a\u00020?H\u0016J\u0012\u0010y\u001a\u0002052\b\u0010z\u001a\u0004\u0018\u00010+H\u0014J(\u0010{\u001a\u00060\bR\u00020\u0000*\u00060\bR\u00020\u00002\b\u0010|\u001a\u0004\u0018\u00010}2\b\u0010~\u001a\u0004\u0018\u00010+H\u0004J*\u0010\u007f\u001a\u00060\bR\u00020\u0000*\u00060\bR\u00020\u00002\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u00012\b\u0010~\u001a\u0004\u0018\u00010+H\u0004J3\u0010\u0082\u0001\u001a\u00020?*\u00020\f2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010+2\t\b\u0002\u0010\u0084\u0001\u001a\u0002052\r\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020+0EH\u0084\bJ\u001a\u0010\u0086\u0001\u001a\u00020+*\u00020`2\u000b\b\u0002\u0010\u0087\u0001\u001a\u0004\u0018\u00010+H\u0014J\u0010\u0010\u0088\u0001\u001a\u00020+*\u0005\u0018\u00010\u0081\u0001H\u0016J-\u0010\u0089\u0001\u001a\u00020?*\u00020\f2\u0018\u0010\u0089\u0001\u001a\r\u0012\b\b\u0001\u0012\u0004\u0018\u00010+0\u008a\u0001\"\u0004\u0018\u00010+H\u0004\u00a2\u0006\u0003\u0010\u008b\u0001R\u0018\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020+*\u00020+8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020+*\u00020+8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u001f\u0010.\u001a\u00020+*\b\u0012\u0004\u0012\u00020+008\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00101R\u0018\u00102\u001a\u00020+*\u00020+8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010-R\u0018\u00104\u001a\u000205*\u0002068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006\u0091\u0001"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator;", "", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "adapter", "Lcom/intellij/database/scripting/AbstractCodeGenerator$NewCodingAdapter;", "getAdapter", "()Lcom/intellij/database/scripting/AbstractCodeGenerator$NewCodingAdapter;", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "getCategory", "()Lcom/intellij/database/scripting/ScriptCategory;", "getContext", "()Lcom/intellij/database/scripting/ScriptingContext;", "helper", "Lcom/intellij/database/scripting/ScriptingHelper;", "getHelper", "()Lcom/intellij/database/scripting/ScriptingHelper;", "<set-?>", "Lcom/intellij/database/scripting/ScriptLocus;", "locus", "getLocus", "()Lcom/intellij/database/scripting/ScriptLocus;", "setLocus", "(Lcom/intellij/database/scripting/ScriptLocus;)V", "naming", "Lcom/intellij/database/scripting/NamingService;", "getNaming", "()Lcom/intellij/database/scripting/NamingService;", "scenario", "Lcom/intellij/database/scripting/Scenario;", "getScenario", "()Lcom/intellij/database/scripting/Scenario;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "plain", "", "getPlain", "(Ljava/lang/String;)Ljava/lang/String;", "scr", "getScr", "", "(Ljava/lang/Iterable;)Ljava/lang/String;", "sqlString", "getSqlString", "useName", "", "Lcom/intellij/database/model/basic/BasicNamedElement;", "getUseName", "(Lcom/intellij/database/model/basic/BasicNamedElement;)Z", "breakByEdge", "cycle", "", "Lcom/intellij/database/scripting/Operation;", "breakCycle", "breakCycles", "", "cascade", "cascadeConstraints", "coding", "indent", "block", "Lkotlin/Function0;", "createPreOrderComparator", "Ljava/util/Comparator;", "operations", "", "createRootProducer", "Lcom/intellij/database/scripting/Producer;", "findCycle", "findCycleMin", "", "forEachEdge", "op1", "op2", "action", "Lkotlin/Function2;", "generateSuccessors", "Lcom/intellij/util/containers/MultiMap;", "", "getEdgeFixers", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "getInternalScenario", "ifExists", "isNewCodeGen", "makeFileSink", "file", "makeOperation", "element", "Lcom/intellij/database/model/basic/BasicElement;", "makeTextSink", "newCoding", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "postStatement", "statement", "Lcom/intellij/database/scripting/CompositeText;", "preferForward", "prepareOutput", "prepareScenario", "processOperations", "processor", "produce", "op", "quote", "e", "name", "resolve", "restrictCascade", "script", "d", "Lcom/intellij/database/model/DataType;", "sqlClause", "transform", "useSchemaName", "schemaName", "alterColumn", "c", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "scrName", "alterTable", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "appendOrErr", "text", "eoln", "error", "currentScopeName", "renameScr", "getTableTerm", "words", "", "(Lcom/intellij/database/scripting/CodeTextBuilder;[Ljava/lang/String;)V", "Companion", "EdgeFixer", "ElementProducer", "NewCodingAdapter", "PreOrderComparator", "intellij.database.scripting"})
public abstract class AbstractCodeGenerator {
    @NotNull
    private final NamingService naming;
    @NotNull
    private final ScriptingHelper helper;
    @NotNull
    private final Scenario scenario;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private ScriptLocus locus;
    @NotNull
    private final NewCodingAdapter adapter;
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private final ScriptingTask task;
    @NotNull
    private static final OperationType ROOT;
    @NotNull
    private static final OperationType TEXT_SINK;
    @NotNull
    private static final OperationType FILE_SINK;
    public static final Companion Companion;

    @NotNull
    protected final ScriptCategory getCategory() {
        return this.task.getCategory();
    }

    @NotNull
    protected final NamingService getNaming() {
        return this.naming;
    }

    @NotNull
    protected final ScriptingHelper getHelper() {
        return this.helper;
    }

    @NotNull
    protected final Scenario getScenario() {
        return this.scenario;
    }

    @NotNull
    protected final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    protected final ScriptLocus getLocus() {
        return this.locus;
    }

    private final void setLocus(ScriptLocus scriptLocus) {
        this.locus = scriptLocus;
    }

    @NotNull
    protected final NewCodingAdapter getAdapter() {
        return this.adapter;
    }

    @NotNull
    protected Comparator<Operation> createPreOrderComparator(@NotNull Collection<Operation> operations) {
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        return new PreOrderComparator();
    }

    public abstract void prepareScenario();

    private final Producer createRootProducer() {
        return new SimpleProducer(Companion.getROOT(), (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }));
    }

    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    public void resolve() {
        Operation it;
        JBIterable operations;
        LinkedHashMap<Effect, Operation> effects = new LinkedHashMap<Effect, Operation>();
        JBIterable jBIterable = operations = this.scenario.traverse().bfsTraversal();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"operations");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            it = (Operation)element$iv;
            Iterable $receiver$iv2 = it.getEffects();
            for (Object element$iv2 : $receiver$iv2) {
                boolean bl;
                Effect e = (Effect)element$iv2;
                Operation prev = effects.put(e, it);
                boolean bl2 = bl = prev == null;
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Effect " + e + " provided by " + it + " and " + prev;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        $receiver$iv = (Iterable)operations;
        for (Object element$iv : $receiver$iv) {
            it = (Operation)element$iv;
            it.unlinkAll();
            JBIterable jBIterable2 = JBIterable.from((Iterable)it.getRequires()).flatten(new Function<E, Iterable<? extends T>>(effects){
                final /* synthetic */ LinkedHashMap $effects$inlined;
                {
                    this.$effects$inlined = linkedHashMap;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Operation> fun(RequiredEffect it) {
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    RequiredEffect requiredEffect = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)requiredEffect, (String)"it");
                    Set<K> set = this.$effects$inlined.keySet();
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"effects.keys");
                    Iterable iterable = (Iterable)ScenarioOperations.expand(requiredEffect, (Iterable<Effect>)set);
                    LinkedHashMap linkedHashMap = this.$effects$inlined;
                    void var4_4 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        Operation operation;
                        T element$iv$iv = element$iv$iv$iv;
                        Effect p1 = (Effect)element$iv$iv;
                        if ((Operation)linkedHashMap.get(p1) == null) continue;
                        Operation it$iv$iv = operation;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.from(it.requi\u2026apNotNull(effects::get) }");
            it.link((Iterable)jBIterable2);
        }
    }

    public void transform() {
        this.breakCycles();
        this.prepareOutput();
    }

    private final void breakCycles() {
        List<Operation> cycle;
        do {
            if (this.findCycle() != null) continue;
            return;
        } while (this.breakCycle(cycle));
    }

    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkParameterIsNotNull(cycle, (String)"cycle");
        return this.breakByEdge(cycle);
    }

    protected boolean preferForward() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByEdge(List<Operation> cycle) {
        int size;
        int s = this.findCycleMin(cycle);
        int i2 = size = cycle.size();
        Object t = ((Operation)CollectionsKt.first(cycle)).getParent();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Operation root2 = (Operation)t;
        List<EdgeFixer> fixers = this.getEdgeFixers();
        if (fixers.isEmpty()) {
            return false;
        }
        while (i2 >= 0) {
            int p = s + i2 + size;
            Operation cur = cycle.get(p % size);
            Operation next = cycle.get((p + 1) % size);
            boolean fwOnly = i2 == 0;
            boolean bkOnly = i2 == size;
            AbstractCodeGenerator this_$iv = this;
            HashSet targets$iv = (HashSet)ScenarioOperations.traverse(cur).traverse().addAllTo((Collection)new HashSet());
            JBTreeTraverser<Operation> jBTreeTraverser = ScenarioOperations.traverse(next);
            Intrinsics.checkExpressionValueIsNotNull(jBTreeTraverser, (String)"op2.traverse()");
            Iterable $receiver$iv$iv = (Iterable)jBTreeTraverser;
            for (Object element$iv$iv : $receiver$iv$iv) {
                Operation so2$iv = (Operation)element$iv$iv;
                Iterable $receiver$iv$iv2 = so2$iv.getPreceders();
                for (Object element$iv$iv2 : $receiver$iv$iv2) {
                    Operation so1$iv = (Operation)element$iv$iv2;
                    if (!targets$iv.contains(so1$iv)) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)so2$iv, (String)"so2");
                    Operation so1 = so1$iv;
                    Iterable $receiver$iv = fixers;
                    for (Object element$iv : $receiver$iv) {
                        void so2;
                        EdgeFixer it = (EdgeFixer)element$iv;
                        if (fwOnly && it.isBackward() || bkOnly && !it.isBackward() || !it.fix(root2, so1, (Operation)so2)) continue;
                        if (it.requiresResolve()) {
                            this.resolve();
                        }
                        return true;
                    }
                }
            }
            --i2;
        }
        return false;
    }

    private final int findCycleMin(List<Operation> cycle) {
        Comparator<Operation> cmp = this.createPreOrderComparator((Collection<Operation>)cycle);
        int mini = 0;
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)1, (int)cycle.size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            if (cmp.compare(cycle.get(mini), cycle.get(it)) <= 0) continue;
            mini = it;
        }
        return mini;
    }

    private final void forEachEdge(Operation op1, Operation op2, Function2<? super Operation, ? super Operation, Unit> action) {
        HashSet targets = (HashSet)ScenarioOperations.traverse(op1).traverse().addAllTo((Collection)new HashSet());
        JBTreeTraverser<Operation> jBTreeTraverser = ScenarioOperations.traverse(op2);
        Intrinsics.checkExpressionValueIsNotNull(jBTreeTraverser, (String)"op2.traverse()");
        Iterable $receiver$iv = (Iterable)jBTreeTraverser;
        for (Object element$iv : $receiver$iv) {
            Operation so2 = (Operation)element$iv;
            Iterable $receiver$iv2 = so2.getPreceders();
            for (Object element$iv2 : $receiver$iv2) {
                Operation so1 = (Operation)element$iv2;
                if (!targets.contains(so1)) continue;
                Operation operation = so2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"so2");
                action.invoke((Object)so1, (Object)operation);
            }
        }
    }

    @NotNull
    public List<EdgeFixer> getEdgeFixers() {
        return CollectionsKt.emptyList();
    }

    private final List<Operation> findCycle() {
        HashSet<Operation> visited = new HashSet<Operation>();
        JBTreeTraverser traverser2 = (JBTreeTraverser)ScenarioOperations.traversePreceders().expandAndFilter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal().filter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"scenario.traverse().bfsT\u2026.filter{ it !in visited }");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            Operation root2 = (Operation)element$iv;
            TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)traverser2.withRoot((Object)root2)).biOrderDfsTraversal().typedIterator();
            while (it.advance()) {
                Operation op;
                Operation operation = op = (Operation)it.current();
                int n = operation.getIncidence();
                TreeTraversal.TracingIt tracingIt = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)tracingIt, (String)"it");
                operation.setIncidence(n + (tracingIt.isDescending() ? 1 : -1));
                if (!it.isDescending()) {
                    visited.add(op);
                }
                if (op.getIncidence() < 2) continue;
                LinkedList<Operation> res = new LinkedList<Operation>();
                boolean add = true;
                JBIterable jBIterable2 = it.backtrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"it.backtrace()");
                Iterable $receiver$iv2 = (Iterable)jBIterable2;
                for (Object element$iv2 : $receiver$iv2) {
                    Operation it2 = (Operation)element$iv2;
                    it2.setIncidence(0);
                    if (add) {
                        boolean bl = add = res.isEmpty() || Intrinsics.areEqual((Object)it2, (Object)op) ^ true;
                    }
                    if (!add) continue;
                    res.add(it2);
                }
                return res;
            }
        }
        return null;
    }

    private final void prepareOutput() {
        Operation sink = this.makeTextSink();
        sink.stealChildrenFrom((Node)this.scenario.getRoot());
        sink.setParent((Node)this.scenario.getRoot());
    }

    public final void processOperations(@NotNull Set<Operation> operations, @NotNull Function1<? super Operation, Unit> processor) {
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Comparator<Operation> cmp = this.createPreOrderComparator((Collection<Operation>)operations);
        MultiMap<Operation, Operation> successors = this.generateSuccessors(operations);
        TreeSet<Operation> queue = new TreeSet<Operation>(cmp);
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation it = (Operation)element$iv;
            if (it.getIncidence() != 0) continue;
            queue.add(it);
        }
        while (!queue.isEmpty()) {
            Operation op = queue.pollFirst();
            Collection rev = successors.remove((Object)op);
            if (rev == null) continue;
            Operation operation = op;
            Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"op");
            processor.invoke((Object)operation);
            Iterable $receiver$iv2 = rev;
            for (Object element$iv : $receiver$iv2) {
                Operation it;
                Operation operation2 = it = (Operation)element$iv;
                operation2.setIncidence(operation2.getIncidence() + -1);
                operation2.getIncidence();
                if (it.getIncidence() != 0) continue;
                queue.add(it);
            }
        }
        boolean bl = successors.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Found cycle";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final MultiMap<Operation, Operation> generateSuccessors(Set<Operation> operations) {
        MultiMap successors = MultiMap.createSet();
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation op = (Operation)element$iv;
            Set<Operation> flatPreceders = op.getFlatPreceders();
            successors.getModifiable((Object)op);
            Iterable $receiver$iv2 = flatPreceders;
            for (Object element$iv2 : $receiver$iv2) {
                Operation p = (Operation)element$iv2;
                successors.putValue((Object)p, (Object)op);
            }
            op.setIncidence(flatPreceders.size());
        }
        MultiMap multiMap = successors;
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"successors");
        return multiMap;
    }

    public void produce(@NotNull Operation op) {
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        op.getProducer().produce();
    }

    public final void produce() {
        this.produce(this.scenario.getRoot());
    }

    private final Operation makeTextSink() {
        return new Operation(new SimpleProducer(Companion.getTEXT_SINK(), (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        })));
    }

    private final Operation makeFileSink(String file) {
        return new Operation(new SimpleProducer(Companion.getFILE_SINK(), (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.this$0.processOperations($receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/scripting/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        })));
    }

    protected boolean isNewCodeGen() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ScriptLocus oldContext = this.locus;
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
        try {
            this.locus = newContext;
            if (indent) {
                CodeTextBuilder.indent$default(this.builder, null, 1, null);
            }
            block.invoke();
            this.builder.returnToIndentation(savedIndentation);
            this.locus = oldContext;
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.builder.returnToIndentation(savedIndentation);
            this.locus = oldContext;
            boolean bl = complete2 = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptLocus.OUTSIDE)) ^ true && this.builder.isNotEmpty();
            if (complete2) {
                this.postStatement();
            }
            throw throwable;
        }
        boolean bl = complete = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptLocus.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptLocus.OUTSIDE)) ^ true && this.builder.isNotEmpty();
        if (complete) {
            this.postStatement();
        }
    }

    public static /* bridge */ /* synthetic */ void coding$default(AbstractCodeGenerator abstractCodeGenerator, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractCodeGenerator.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    protected final void newCoding(@NotNull Function1<? super NewCodingAdapter, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, block){
            final /* synthetic */ AbstractCodeGenerator this$0;
            final /* synthetic */ Function1 $block;

            public final void invoke() {
                this.$block.invoke((Object)this.this$0.getAdapter());
                CodeTextBuilder.ensureEoln$default(this.this$0.getBuilder(), null, 1, null);
            }
            {
                this.this$0 = abstractCodeGenerator;
                this.$block = function1;
                super(0);
            }
        }, 3, null);
    }

    protected final void sqlClause(@NotNull Function1<? super NewCodingAdapter, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        block.invoke((Object)this.adapter);
    }

    private final void postStatement() {
        if (this.builder.isNotEmpty()) {
            this.postStatement(new SimpleCompositeText(this.builder));
        }
        this.builder.clearAll();
    }

    private final void postStatement(CompositeText statement) {
        this.context.getScript().add(statement);
    }

    @Nullable
    public final String quote(@NotNull BasicElement e, @Nullable String name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string2 = name;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = this.naming.nameToScript(it, e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted());
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String quote$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quote");
        }
        if ((n & 2) != 0) {
            string = basicElement.getRealName();
        }
        return abstractCodeGenerator.quote(basicElement, string);
    }

    @NotNull
    public final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.naming.nameToScript($receiver, false);
    }

    @NotNull
    public final String getPlain(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.naming.nameToScript($receiver, true);
    }

    @NotNull
    protected final String getScr(@NotNull Iterable<String> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return CollectionsKt.joinToString$default($receiver, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String $receiver$iv = it;
                AbstractCodeGenerator this_$iv = this.this$0;
                return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv, false);
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }), (int)31, null);
    }

    protected final boolean getUseName(@NotNull BasicNamedElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)ModelConsts.NO_NAME) ^ true && (!$receiver.isNameSurrogate() || this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES) != false);
    }

    @NotNull
    protected String currentScopeName(@NotNull BasicElement $receiver, @Nullable String renameScr) {
        String string;
        BasicElement q;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string3 = renameScr;
        if (string3 == null) {
            string3 = string2 = AbstractCodeGenerator.quote$default(this, $receiver, null, 2, null);
        }
        if (string3 == null) {
            string2 = "???";
        }
        String name = string2;
        BasicElement basicElement = this.helper.qualifier($receiver);
        if (basicElement == null) {
            return name;
        }
        BasicElement basicElement2 = q = basicElement;
        if (basicElement2 instanceof BasicSchema) {
            String schemaName = ((BasicSchema)q).getRealName();
            String prefix = schemaName != null && this.useSchemaName(schemaName) ? Intrinsics.stringPlus((String)this.quote(q, schemaName), (Object)".") : "";
            string = prefix + name;
        } else {
            string = AbstractCodeGenerator.currentScopeName$default(this, q, null, 1, null) + "." + name;
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String currentScopeName$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: currentScopeName");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return abstractCodeGenerator.currentScopeName(basicElement, string);
    }

    protected final void words(@NotNull CodeTextBuilder $receiver, String ... words) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        CodeTextBuilder.append$default($receiver, ScriptingUtilsKt.phrase(Arrays.copyOf(words, words.length)), null, false, null, 10, null);
    }

    protected final void appendOrErr(@NotNull CodeTextBuilder $receiver, @Nullable String text, boolean eoln, @NotNull Function0<String> error2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(error2, (String)"error");
        if (text == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text, null, eoln, null, 10, null);
        }
    }

    public static /* bridge */ /* synthetic */ void appendOrErr$default(AbstractCodeGenerator this_, CodeTextBuilder $receiver, String text, boolean eoln, Function0 error2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendOrErr");
        }
        if ((n & 2) != 0) {
            eoln = true;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)error2, (String)"error");
        if (text == null) {
            CodeTextBuilder.append$default($receiver, "???", null, eoln, (String)error2.invoke(), 2, null);
        } else {
            CodeTextBuilder.append$default($receiver, text, null, eoln, null, 10, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean useSchemaName(@Nullable String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (AbstractCodeGenerator$WhenMappings.$EnumSwitchMapping$0[this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME).ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)schemaName, (Object)this.context.getCurrentSchemaName()) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    public String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return this.helper.script(d, this.context.getOptions());
    }

    @NotNull
    protected final String getSqlString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    @NotNull
    public final Scenario getInternalScenario() {
        return this.scenario;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final NewCodingAdapter alterTable(@NotNull NewCodingAdapter $receiver, @Nullable BasicLikeTable table, @Nullable String scrName) {
        void text$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        NewCodingAdapter newCodingAdapter = $receiver;
        BasicLikeTable basicLikeTable = table;
        String string = basicLikeTable != null ? this.currentScopeName(basicLikeTable, scrName) : null;
        NewCodingAdapter newCodingAdapter2 = $receiver.plus($receiver.unaryPlus("alter"), this.getTableTerm(table));
        NewCodingAdapter newCodingAdapter3 = $receiver;
        Function0 function0 = (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv, (String)text$iv){
            final /* synthetic */ NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    NewCodingAdapter newCodingAdapter = this.this$0;
                    String string = "table is unknown";
                    NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final NewCodingAdapter alterColumn(@NotNull NewCodingAdapter $receiver, @Nullable BasicLikeColumn c, @Nullable String scrName) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicLikeColumn basicLikeColumn = c;
        NewCodingAdapter newCodingAdapter = $receiver;
        NewCodingAdapter newCodingAdapter2 = $receiver.plus(this.alterTable($receiver, basicLikeColumn != null ? basicLikeColumn.getLikeTable() : null, null), "alter column");
        NewCodingAdapter newCodingAdapter3 = $receiver;
        void this_$iv$iv = this_$iv;
        Function0 function0 = (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, scrName){
            final /* synthetic */ NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    NewCodingAdapter newCodingAdapter = this.this$0;
                    String string = "unknown name";
                    NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<Unit>)function0);
    }

    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable $receiver) {
        return "table";
    }

    @Nullable
    protected final String ifExists() {
        return this.context.getOptions().get(ScriptingOptionStatic.IF_EXISTS) != false ? "if exists" : null;
    }

    @Nullable
    protected final String cascade() {
        return this.context.getOptions().get(ScriptingOptionStatic.DROP_CASCADE) != false ? "cascade" : null;
    }

    @Nullable
    protected final String restrictCascade() {
        return this.cascade();
    }

    @Nullable
    protected final String cascadeConstraints() {
        String string;
        String string2 = this.cascade();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = "cascade constraints";
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    protected final ScriptingContext getContext() {
        return this.context;
    }

    @NotNull
    protected final ScriptingTask getTask() {
        return this.task;
    }

    public AbstractCodeGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.context = context;
        this.task = task;
        this.naming = NamingServices.INSTANCE.getNamingService(ScriptingTaskKt.getAnyModel(this.task), ScriptingTaskKt.getAnyCurrentDatabase(this.task));
        this.helper = ScriptingHelper.Companion.get(this.context.getRdbms());
        this.scenario = new Scenario(this.createRootProducer());
        this.builder = new CodeTextBuilder(0, 1, null);
        this.adapter = new NewCodingAdapter();
        this.locus = ScriptLocus.OUTSIDE;
    }

    static {
        Companion = new Companion(null);
        ROOT = new OperationType("root");
        TEXT_SINK = new OperationType("text sink");
        FILE_SINK = new OperationType("file sink");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0014\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0016RO\u0010\u0004\u001a@\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006*\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$PreOrderComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/scripting/Operation;", "()V", "cache", "", "kotlin.jvm.PlatformType", "", "", "getCache", "()Ljava/util/Map;", "compare", "", "o1", "o2", "getPreliminaryOrder", "op", "intellij.database.scripting"})
    protected static class PreOrderComparator
    implements Comparator<Operation> {
        @NotNull
        private final Map<Operation, String> cache = FactoryMap.create((Function)new Function<K, V>(this){
            final /* synthetic */ PreOrderComparator this$0;

            @NotNull
            public final String fun(Operation it) {
                Operation operation = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"it");
                return this.this$0.getPreliminaryOrder(operation);
            }
            {
                this.this$0 = preOrderComparator;
            }
        });

        @NotNull
        public final Map<Operation, String> getCache() {
            return this.cache;
        }

        @Override
        public int compare(@Nullable Operation o1, @Nullable Operation o2) {
            int res = Comparing.compare((Comparable)((Comparable)((Object)this.cache.get(o1))), (Comparable)((Comparable)((Object)this.cache.get(o2))));
            if (res != 0) {
                return res;
            }
            return Comparing.compare((int)Comparing.hashcode((Object)o1), (int)Comparing.hashcode((Object)o2));
        }

        @NotNull
        public String getPreliminaryOrder(@NotNull Operation op) {
            Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
            return op.getProducer().getPreliminaryOrder();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H&J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "", "()V", "fix", "", "root", "Lcom/intellij/database/scripting/Operation;", "op1", "op2", "isBackward", "requiresResolve", "intellij.database.scripting"})
    public static abstract class EdgeFixer {
        public abstract boolean fix(@NotNull Operation var1, @NotNull Operation var2, @NotNull Operation var3);

        public boolean isBackward() {
            return false;
        }

        public boolean requiresResolve() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0096\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B<\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012%\b\u0002\u0010\u0007\u001a\u001f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ,\u0010\u0012\u001a\f\u0012\u0004\u0012\u0002H\u00130\u0000R\u00020\t\"\n\b\u0001\u0010\u0013\u0018\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u0002H\u0013H\u0087\b\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016R.\u0010\u0007\u001a\u001f\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u00000\u0000R\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$ElementProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Producer;", "type", "Lcom/intellij/database/scripting/OperationType;", "element", "delegate", "Lkotlin/Function1;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/scripting/AbstractCodeGenerator;Lcom/intellij/database/scripting/OperationType;Lcom/intellij/database/model/basic/BasicElement;Lkotlin/jvm/functions/Function1;)V", "getDelegate", "()Lkotlin/jvm/functions/Function1;", "getElement", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "cast", "U", "e", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/scripting/AbstractCodeGenerator$ElementProducer;", "getPreliminaryOrder", "", "produce", "shortText", "toString", "intellij.database.scripting"})
    public class ElementProducer<T extends BasicElement>
    extends Producer {
        @NotNull
        private final T element;
        @Nullable
        private final Function1<ElementProducer<T>, Unit> delegate;
        final /* synthetic */ AbstractCodeGenerator this$0;

        private final <U extends BasicElement> ElementProducer<U> cast(U e) {
            boolean bl = Intrinsics.areEqual(e, this.getElement());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ElementProducer elementProducer = this;
            if (elementProducer == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.AbstractCodeGenerator.ElementProducer<U>");
            }
            return elementProducer;
        }

        @Override
        public void produce() {
            block0: {
                Function1<ElementProducer<T>, Unit> function1;
                Function1<ElementProducer<T>, Unit> function12 = this.delegate;
                if (function12 == null) break block0;
                Function1<ElementProducer<T>, Unit> it = function1 = function12;
                it.invoke((Object)this);
            }
        }

        @Override
        @NotNull
        public String getPreliminaryOrder() {
            return this.this$0.getHelper().getObjectPreliminaryOrder((BasicElement)this.element);
        }

        @Override
        @NotNull
        public String shortText() {
            return "" + this.getType().getDebugName() + ' ' + this.element.getKind().code();
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("").append(this.shortText()).append(' ');
            ObjectPath objectPath = BasicPaths.of(this.element);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"BasicPaths.of(element)");
            return stringBuilder.append(objectPath.getDisplayName()).toString();
        }

        @NotNull
        public final T getElement() {
            return this.element;
        }

        @Nullable
        public final Function1<ElementProducer<T>, Unit> getDelegate() {
            return this.delegate;
        }

        public ElementProducer(@NotNull OperationType type, @Nullable T element, Function1<? super ElementProducer<T>, Unit> delegate) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            this.this$0 = $outer;
            super(type);
            this.element = element;
            this.delegate = delegate;
        }

        public /* synthetic */ ElementProducer(AbstractCodeGenerator abstractCodeGenerator, OperationType operationType, BasicElement basicElement, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function1 = null;
            }
            this(abstractCodeGenerator, operationType, basicElement, function1);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u0005J\u0019\u0010!\u001a\u00020\u00052\u000e\b\u0004\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ\u0019\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010$\u001a\u0004\u0018\u00010\u001eH\u0086\bJ\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0005J)\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001e2\u000e\b\u0004\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004H\u0086\bJ\u0010\u0010)\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020+J\u001a\u0010)\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u00020\tJ\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010*\u001a\u00020+H\u0086\bJ!\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001e2\u0006\u0010,\u001a\u00020\tH\u0086\bJ!\u0010.\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u00020\u0005J!\u00101\u001a\u00020\u00052\b\b\u0002\u00102\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\bJ?\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u00104*\b\u0012\u0004\u0012\u0002H4052\b\b\u0002\u00106\u001a\u00020\u001e2\u0014\b\u0004\u00107\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u00020\u000508H\u0086\bJ#\u00109\u001a\u00060\u0000R\u00020:*\u00060\u0000R\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\u0002J\u001f\u00109\u001a\u00060\u0000R\u00020:*\u00060\u0000R\u00020:2\b\u00107\u001a\u0004\u0018\u00010<H\u0086\u0002J\u001f\u00109\u001a\u00060\u0000R\u00020:*\u00060\u0000R\u00020:2\b\u0010=\u001a\u0004\u0018\u00010\u001eH\u0086\u0002J#\u0010>\u001a\u00060\u0000R\u00020:*\u00060\u0000R\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\u0002J\u001f\u0010>\u001a\u00060\u0000R\u00020:*\u00060\u0000R\u00020:2\b\u00107\u001a\u0004\u0018\u00010<H\u0086\u0002J\u001f\u0010>\u001a\u00060\u0000R\u00020:*\u00060\u0000R\u00020:2\b\u0010=\u001a\u0004\u0018\u00010\u001eH\u0086\u0002J\u0017\u0010?\u001a\u00060\u0000R\u00020:*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\nJ\u0013\u0010?\u001a\u00060\u0000R\u00020:*\u0004\u0018\u00010<H\u0086\u0002J\u0013\u0010?\u001a\u00060\u0000R\u00020:*\u0004\u0018\u00010\u001eH\u0086\u0002J\u0017\u0010@\u001a\u00060\u0000R\u00020:*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0086\nJ\u0013\u0010@\u001a\u00060\u0000R\u00020:*\u0004\u0018\u00010<H\u0086\u0002J\u0013\u0010@\u001a\u00060\u0000R\u00020:*\u0004\u0018\u00010\u001eH\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u0006A"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$NewCodingAdapter;", "", "(Lcom/intellij/database/scripting/AbstractCodeGenerator;)V", "EOLN", "Lkotlin/Function0;", "", "getEOLN", "()Lkotlin/jvm/functions/Function0;", "noSpace", "", "getNoSpace", "()Z", "setNoSpace", "(Z)V", "separator", "", "getSeparator", "()Ljava/lang/Character;", "setSeparator", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "startWithNewLine", "getStartWithNewLine", "setStartWithNewLine", "appendSimple", "text", "", "kind", "Lcom/intellij/database/scripting/CompositeText$Kind;", "error", "", "msg", "indent", "indenting", "block", "name", "quotedName", "newLine", "onStart", "orError", "err", "quote", "element", "Lcom/intellij/database/model/basic/BasicElement;", "plain", "scr", "separated", "space", "unindent", "withNewLines", "nl", "joined", "T", "", "sep", "t", "Lkotlin/Function1;", "minus", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "op", "Lcom/intellij/database/scripting/CompositeText$Fragment;", "s", "plus", "unaryMinus", "unaryPlus", "intellij.database.scripting"})
    public final class NewCodingAdapter {
        @NotNull
        private final Function0<Unit> EOLN = (Function0)new Function0<Unit>(this){
            final /* synthetic */ NewCodingAdapter this$0;

            public final void invoke() {
                this.this$0.newLine();
            }
            {
                this.this$0 = newCodingAdapter;
                super(0);
            }
        };
        private boolean noSpace;
        private boolean startWithNewLine;
        @Nullable
        private Character separator;

        @NotNull
        public final Function0<Unit> getEOLN() {
            return this.EOLN;
        }

        public final boolean getNoSpace() {
            return this.noSpace;
        }

        public final void setNoSpace(boolean bl) {
            this.noSpace = bl;
        }

        public final boolean getStartWithNewLine() {
            return this.startWithNewLine;
        }

        public final void setStartWithNewLine(boolean bl) {
            this.startWithNewLine = bl;
        }

        @Nullable
        public final Character getSeparator() {
            return this.separator;
        }

        public final void setSeparator(@Nullable Character c) {
            this.separator = c;
        }

        public final void withNewLines(boolean nl, @NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            boolean prev = this.getStartWithNewLine();
            this.setStartWithNewLine(nl);
            block.invoke();
            this.setStartWithNewLine(prev);
        }

        public static /* bridge */ /* synthetic */ void withNewLines$default(NewCodingAdapter this_, boolean nl, Function0 block, int n, Object object) {
            if ((n & 1) != 0) {
                nl = true;
            }
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            boolean prev = this_.getStartWithNewLine();
            this_.setStartWithNewLine(nl);
            block.invoke();
            this_.setStartWithNewLine(prev);
        }

        public final void separated(char separator, @NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            Character prev = this.getSeparator();
            this.setSeparator(Character.valueOf(separator));
            block.invoke();
            this.setSeparator(prev);
        }

        public static /* bridge */ /* synthetic */ void separated$default(NewCodingAdapter this_, char separator, Function0 block, int n, Object object) {
            if ((n & 1) != 0) {
                separator = (char)44;
            }
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            Character prev = this_.getSeparator();
            this_.setSeparator(Character.valueOf(separator));
            block.invoke();
            this_.setSeparator(prev);
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $receiver, @Nullable CompositeText.Fragment t) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.plus($receiver, (Function0<Unit>)((Function0)new Function0<Unit>($receiver, t){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ CompositeText.Fragment $t;

                public final void invoke() {
                    block0: {
                        CompositeText.Fragment fragment;
                        CompositeText.Fragment fragment2 = this.$t;
                        if (fragment2 == null) break block0;
                        CompositeText.Fragment $receiver = fragment = fragment2;
                        this.receiver$0.appendSimple($receiver.getText(), $receiver.getKind(), $receiver.getError());
                    }
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$t = fragment;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $receiver, @Nullable CompositeText.Fragment t) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.minus($receiver, (Function0<Unit>)((Function0)new Function0<Unit>($receiver, t){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ CompositeText.Fragment $t;

                public final void invoke() {
                    block0: {
                        CompositeText.Fragment fragment;
                        CompositeText.Fragment fragment2 = this.$t;
                        if (fragment2 == null) break block0;
                        CompositeText.Fragment $receiver = fragment = fragment2;
                        this.receiver$0.appendSimple($receiver.getText(), $receiver.getKind(), $receiver.getError());
                    }
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$t = fragment;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $receiver, @Nullable String s) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.plus($receiver, (Function0<Unit>)((Function0)new Function0<Unit>($receiver, s){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    block0: {
                        String string;
                        String string2 = this.$s;
                        if (string2 == null) break block0;
                        String it = string = string2;
                        NewCodingAdapter.appendSimple$default(this.receiver$0, it, null, null, 6, null);
                    }
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$s = string;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $receiver, @Nullable String s) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.minus($receiver, (Function0<Unit>)((Function0)new Function0<Unit>($receiver, s){
                final /* synthetic */ NewCodingAdapter receiver$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    block0: {
                        String string;
                        String string2 = this.$s;
                        if (string2 == null) break block0;
                        String it = string = string2;
                        NewCodingAdapter.appendSimple$default(this.receiver$0, it, null, null, 6, null);
                    }
                }
                {
                    this.receiver$0 = newCodingAdapter;
                    this.$s = string;
                    super(0);
                }
            }));
        }

        @NotNull
        public final NewCodingAdapter plus(@NotNull NewCodingAdapter $receiver, @NotNull Function0<Unit> op) {
            NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(op, (String)"op");
            NewCodingAdapter $receiver2 = newCodingAdapter = $receiver;
            op.invoke();
            return newCodingAdapter;
        }

        @NotNull
        public final NewCodingAdapter minus(@NotNull NewCodingAdapter $receiver, @NotNull Function0<Unit> op) {
            NewCodingAdapter newCodingAdapter;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(op, (String)"op");
            NewCodingAdapter $receiver2 = newCodingAdapter = $receiver;
            $receiver2.noSpace = true;
            op.invoke();
            return newCodingAdapter;
        }

        @NotNull
        public final NewCodingAdapter unaryPlus(@Nullable String $receiver) {
            this.onStart();
            return this.plus(this, $receiver);
        }

        @NotNull
        public final NewCodingAdapter unaryMinus(@Nullable String $receiver) {
            this.onStart();
            return this.minus(this, $receiver);
        }

        @NotNull
        public final NewCodingAdapter unaryPlus(@Nullable CompositeText.Fragment $receiver) {
            this.onStart();
            return this.plus(this, $receiver);
        }

        @NotNull
        public final NewCodingAdapter unaryMinus(@Nullable CompositeText.Fragment $receiver) {
            this.onStart();
            return this.minus(this, $receiver);
        }

        @NotNull
        public final NewCodingAdapter unaryPlus(@NotNull Function0<Unit> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            this.onStart();
            return this.plus(this, $receiver);
        }

        @NotNull
        public final NewCodingAdapter unaryMinus(@NotNull Function0<Unit> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            this.onStart();
            return this.minus(this, $receiver);
        }

        @NotNull
        public final <T> Function0<Unit> joined(@NotNull Iterable<? extends T> $receiver, @NotNull String sep, @NotNull Function1<? super T, Unit> t) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)sep, (String)"sep");
            Intrinsics.checkParameterIsNotNull(t, (String)"t");
            return (Function0)new Function0<Unit>(this, $receiver, t, sep){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ Iterable receiver$0;
                final /* synthetic */ Function1 $t;
                final /* synthetic */ String $sep;

                public final void invoke() {
                    Iterator<T> it = this.receiver$0.iterator();
                    if (it.hasNext()) {
                        this.$t.invoke(it.next());
                        while (it.hasNext()) {
                            this.this$0.setNoSpace(true);
                            NewCodingAdapter.appendSimple$default(this.this$0, this.$sep, null, null, 6, null);
                            this.$t.invoke(it.next());
                        }
                    }
                }
                {
                    this.this$0 = newCodingAdapter;
                    this.receiver$0 = iterable;
                    this.$t = function1;
                    this.$sep = string;
                    super(0);
                }
            };
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Function0 joined$default(NewCodingAdapter this_, Iterable $receiver, String sep, Function1 t, int n, Object object) {
            if ((n & 1) != 0) {
                sep = ", ";
            }
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)sep, (String)"sep");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            return (Function0)new /* invalid duplicate definition of identical inner class */;
        }

        public final void appendSimple(@NotNull CharSequence text, @NotNull CompositeText.Kind kind, @Nullable String error2) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            CharSequence charSequence = text;
            if (!(charSequence.length() == 0)) {
                if (!this.noSpace) {
                    this.space();
                } else {
                    this.noSpace = false;
                }
            }
            AbstractCodeGenerator.this.getBuilder().appendSimple(text, kind, error2);
        }

        public static /* bridge */ /* synthetic */ void appendSimple$default(NewCodingAdapter newCodingAdapter, CharSequence charSequence, CompositeText.Kind kind, String string, int n, Object object) {
            if ((n & 2) != 0) {
                kind = CompositeText.Kind.PLAIN_TEXT;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            newCodingAdapter.appendSimple(charSequence, kind, string);
        }

        public final void space() {
            char last;
            CharSequence text = AbstractCodeGenerator.this.getBuilder().getText();
            Character c = StringsKt.lastOrNull((CharSequence)text);
            char c2 = last = c != null ? c.charValue() : (char)'\n';
            if (last == '\n') {
                AbstractCodeGenerator.this.getBuilder().appendIndent();
            }
            if (CharsKt.isWhitespace((char)last)) {
                return;
            }
            CodeTextBuilder.appendSimple$default(AbstractCodeGenerator.this.getBuilder(), " ", null, null, 6, null);
        }

        public final void onStart() {
            if (this.separator != null) {
                CodeTextBuilder codeTextBuilder = AbstractCodeGenerator.this.getBuilder();
                Character c = this.separator;
                if (c == null) {
                    Intrinsics.throwNpe();
                }
                if (!codeTextBuilder.endsWithIgnoreSpace(String.valueOf(c.charValue()))) {
                    CodeTextBuilder codeTextBuilder2 = AbstractCodeGenerator.this.getBuilder();
                    Character c2 = this.separator;
                    if (c2 == null) {
                        Intrinsics.throwNpe();
                    }
                    codeTextBuilder2.addSuffixToTheLastLine(c2.charValue());
                }
            }
            if (this.startWithNewLine) {
                CodeTextBuilder.ensureEoln$default(AbstractCodeGenerator.this.getBuilder(), null, 1, null);
            }
        }

        public final void newLine() {
            CodeTextBuilder.ensureEoln$default(AbstractCodeGenerator.this.getBuilder(), null, 1, null);
        }

        public final void error(@NotNull String msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            NewCodingAdapter.appendSimple$default(this, "-- " + msg, null, msg, 2, null);
            this.newLine();
        }

        public final void indenting(@NotNull Function0<Unit> block) {
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            this.newLine();
            this.indent();
            block.invoke();
            this.unindent();
        }

        public final void indent() {
            CodeTextBuilder.indent$default(AbstractCodeGenerator.this.getBuilder(), null, 1, null);
        }

        public final void unindent() {
            AbstractCodeGenerator.this.getBuilder().unindent();
        }

        @NotNull
        public final Function0<Unit> orError(@Nullable String text, @NotNull Function0<String> err) {
            Intrinsics.checkParameterIsNotNull(err, (String)"err");
            return (Function0)new Function0<Unit>(this, text, err){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                final /* synthetic */ Function0 $err;

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        NewCodingAdapter.appendSimple$default(this.this$0, "???", null, (String)this.$err.invoke(), 2, null);
                    }
                }
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    this.$err = function0;
                    super(0);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function0<Unit> scr(@NotNull BasicElement element) {
            void this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            NewCodingAdapter newCodingAdapter = this;
            String quotedName$iv = this.quote(element);
            void this_$iv$iv = this_$iv;
            return (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, quotedName$iv){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Function0<Unit> scr(@Nullable String text, boolean plain) {
            void this_$iv;
            NewCodingAdapter newCodingAdapter = this;
            String quotedName$iv = this.quote(text, plain);
            void this_$iv$iv = this_$iv;
            return (Function0)new Function0<Unit>((NewCodingAdapter)this_$iv$iv, quotedName$iv){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        @NotNull
        public final Function0<Unit> name(@Nullable String quotedName) {
            NewCodingAdapter this_$iv = this;
            return (Function0)new Function0<Unit>(this_$iv, quotedName){
                final /* synthetic */ NewCodingAdapter this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = newCodingAdapter;
                    this.$text = string;
                    super(0);
                }

                public final void invoke() {
                    if (this.$text != null) {
                        NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                    } else {
                        CompositeText.Kind kind = null;
                        CharSequence charSequence = "???";
                        NewCodingAdapter newCodingAdapter = this.this$0;
                        String string = "unknown name";
                        NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                    }
                }
            };
        }

        @Nullable
        public final String quote(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return AbstractCodeGenerator.quote$default(AbstractCodeGenerator.this, element, null, 2, null);
        }

        @Nullable
        public final String quote(@Nullable String text, boolean plain) {
            String string;
            String string2 = text;
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                string = AbstractCodeGenerator.this.getNaming().nameToScript(it, plain);
            } else {
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/AbstractCodeGenerator$Companion;", "", "()V", "FILE_SINK", "Lcom/intellij/database/scripting/OperationType;", "getFILE_SINK", "()Lcom/intellij/database/scripting/OperationType;", "ROOT", "getROOT", "TEXT_SINK", "getTEXT_SINK", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        protected final OperationType getROOT() {
            return ROOT;
        }

        @NotNull
        protected final OperationType getTEXT_SINK() {
            return TEXT_SINK;
        }

        @NotNull
        protected final OperationType getFILE_SINK() {
            return FILE_SINK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

