/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptModelUtil {
    public static final Key<Long> PART_OFFSET = Key.create((String)"PART_OFFSET");
    public static final Key<Integer> PART_INDEX = Key.create((String)"PART_INDEX");
    public static final Key<Integer> PART_ERRORS = Key.create((String)"PART_ERRORS");
    public static final Function<ScriptModel.ModelIt<?>, TextRange> TO_RANGE = it -> it.range().shiftRight((int)it.rangeOffset());
    public static final Function<ScriptModel.ModelIt<?>, String> TO_TEXT = it -> it.text();
    public static final Function<ScriptModel.ModelIt<?>, IElementType> TO_TYPE = it -> it.type();
    public static final Function<ScriptModel.ModelIt<?>, Object> TO_OBJECT = it -> it.object();
    public static final Function<ScriptModel.ParamIt<?>, String> TO_NAME = it -> it.name();

    private ScriptModelUtil() {
    }

    @NotNull
    public static Condition<TextRange> INTERSECTS_RANGE(TextRange range) {
        Condition condition = r -> {
            int e;
            int s = Math.max(r.getStartOffset(), range.getStartOffset());
            if (s == (e = Math.min(r.getEndOffset(), range.getEndOffset()))) {
                return s == r.getEndOffset() || range.getLength() == 0;
            }
            return s < e;
        };
        if (condition == null) {
            ScriptModelUtil.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> CONTAINS_RANGE(TextRange range) {
        Condition condition = r -> r.equals((Object)range) || r.contains(range);
        if (condition == null) {
            ScriptModelUtil.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static Condition<TextRange> IN_RANGE(TextRange range) {
        Condition condition = r -> range.contains(r);
        if (condition == null) {
            ScriptModelUtil.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    public static Condition<ScriptModel.ModelIt<?>> AT_OFFSET2(int offset) {
        Condition condition = o -> o.range().contains(offset);
        if (condition == null) {
            ScriptModelUtil.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @NotNull
    public static <V> Function<SyntaxTraverser<V>, SyntaxTraverser<V>> LIMIT_TO_RANGE(final TextRange range) {
        Function.Mono mono = new Function.Mono<SyntaxTraverser<V>>(){

            public SyntaxTraverser<V> fun(SyntaxTraverser<V> vs) {
                return ScriptModelUtil.inRange(vs, range);
            }
        };
        if (mono == null) {
            ScriptModelUtil.$$$reportNull$$$0(4);
        }
        return mono;
    }

    @NotNull
    public static <T> ScriptModel<T> adjustModelForSelection(@NotNull ScriptModel<T> model, @NotNull Document document, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        TextRange adjustedRange;
        if (model == null) {
            ScriptModelUtil.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ScriptModelUtil.$$$reportNull$$$0(6);
        }
        if (selectionRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(7);
        }
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(8);
        }
        int fixedOffset = (adjustedRange = ScriptModelUtil.adjustSelectionRange(model, document, selectionRange, execOption)).contains(selectionRange.getStartOffset()) ? selectionRange.getStartOffset() : adjustedRange.getStartOffset();
        ScriptModel scriptModel = selectionRange.getLength() == 0 ? model.subModel((TextRange)new ScriptModel.PositionRange(fixedOffset)) : model.subModel(adjustedRange);
        if (scriptModel == null) {
            ScriptModelUtil.$$$reportNull$$$0(9);
        }
        return scriptModel;
    }

    @NotNull
    public static TextRange getSelectedStatementsRange(@NotNull AbstractQueryLanguageConsole console, @NotNull DatabaseSettings.ExecOption execOption) {
        if (console == null) {
            ScriptModelUtil.$$$reportNull$$$0(10);
        }
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(11);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)console.getLanguageConsole().getCurrentEditor(), execOption);
        TextRange textRange = ScriptModelUtil.adjustSelectionRange(console.getScriptModel(), console.getLanguageConsole().getEditorDocument(), range, execOption);
        if (textRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getSelectionForConsole(@Nullable Editor editor, @NotNull DatabaseSettings.ExecOption execOption) {
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(14);
            }
            return textRange;
        }
        if (execOption.execSelection == 3) {
            TextRange textRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(15);
            }
            return textRange;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        TextRange textRange = TextRange.create((int)caret.getSelectionStart(), (int)caret.getSelectionEnd());
        if (textRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(16);
        }
        return textRange;
    }

    @NotNull
    public static TextRange adjustSelectionRange(@NotNull ScriptModel<?> model, @NotNull Document document, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        if (model == null) {
            ScriptModelUtil.$$$reportNull$$$0(17);
        }
        if (document == null) {
            ScriptModelUtil.$$$reportNull$$$0(18);
        }
        if (selectionRange == null) {
            ScriptModelUtil.$$$reportNull$$$0(19);
        }
        if (execOption == null) {
            ScriptModelUtil.$$$reportNull$$$0(20);
        }
        if (selectionRange.isEmpty()) {
            TextRange subRange;
            TextRange r;
            int lineEnd;
            int lineNumber;
            int lineStart;
            int lineStartFixed;
            CharSequence sequence = document.getCharsSequence();
            int sequenceLength = sequence.length();
            if (sequenceLength == 0) {
                TextRange textRange = selectionRange;
                if (textRange == null) {
                    ScriptModelUtil.$$$reportNull$$$0(21);
                }
                return textRange;
            }
            int offset = Math.min(sequenceLength - 1, selectionRange.getStartOffset());
            if (!Character.isWhitespace(sequence.charAt(offset))) {
                ++offset;
            }
            if ((lineStartFixed = EditorActionUtil.findFirstNonSpaceOffsetInRange((CharSequence)sequence, (int)(lineStart = document.getLineStartOffset(lineNumber = document.getLineNumber(offset))), (int)(lineEnd = document.getLineEndOffset(lineNumber)))) >= 0 && (r = (TextRange)model.subModel((TextRange)new ScriptModel.PositionRange(subRange = TextRange.create((int)lineStartFixed, (int)(lineStartFixed < offset ? offset : lineStartFixed)))).statements().filter(Conditions.compose(TO_OBJECT, (Condition)Conditions.instanceOf(SqlStatement.class))).transform(TO_RANGE).last()) != null) {
                TextRange textRange = r;
                if (textRange == null) {
                    ScriptModelUtil.$$$reportNull$$$0(22);
                }
                return textRange;
            }
            TextRange textRange = selectionRange;
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(23);
            }
            return textRange;
        }
        if (execOption.execSelection == 1) {
            ScriptModel.StrictRange strictRange = new ScriptModel.StrictRange(selectionRange);
            if (strictRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(24);
            }
            return strictRange;
        }
        if (execOption.execSelection == 2) {
            TextRange textRange = selectionRange;
            if (textRange == null) {
                ScriptModelUtil.$$$reportNull$$$0(25);
            }
            return textRange;
        }
        if (execOption.execSelection == 3) {
            ScriptModel.SmartRange smartRange = new ScriptModel.SmartRange(selectionRange);
            ScriptModel m = model.subModel((TextRange)smartRange);
            if (m.statements().take(2).size() > 1) {
                TextRange r = selectionRange;
                for (TextRange range : m.statements().transform(TO_RANGE)) {
                    r = r.union(range);
                }
                ScriptModel.SmartRange smartRange2 = new ScriptModel.SmartRange(r);
                if (smartRange2 == null) {
                    ScriptModelUtil.$$$reportNull$$$0(26);
                }
                return smartRange2;
            }
            ScriptModel.SmartRange smartRange3 = smartRange;
            if (smartRange3 == null) {
                ScriptModelUtil.$$$reportNull$$$0(27);
            }
            return smartRange3;
        }
        throw new AssertionError(execOption.execSelection);
    }

    @NotNull
    public static <V> SyntaxTraverser<V> inRange(@NotNull SyntaxTraverser<V> s, @NotNull TextRange range) {
        if (s == null) {
            ScriptModelUtil.$$$reportNull$$$0(28);
        }
        if (range == null) {
            ScriptModelUtil.$$$reportNull$$$0(29);
        }
        int partOffset = ScriptModelUtil.getPartOffsetAsInt(s);
        if (range.getStartOffset() < partOffset) {
            SyntaxTraverser syntaxTraverser = (SyntaxTraverser)s.expandAndFilter(Conditions.alwaysFalse());
            if (syntaxTraverser == null) {
                ScriptModelUtil.$$$reportNull$$$0(30);
            }
            return syntaxTraverser;
        }
        TextRange adjusted = range.shiftRight(-partOffset);
        Condition c = Conditions.compose((Function)s.api.TO_RANGE, ScriptModelUtil.INTERSECTS_RANGE(adjusted));
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)s.onRange(c);
        if (syntaxTraverser == null) {
            ScriptModelUtil.$$$reportNull$$$0(31);
        }
        return syntaxTraverser;
    }

    public static int getPartOffsetAsInt(SyntaxTraverser<?> s) {
        return (int)ScriptModelUtil.getPartOffset(s);
    }

    public static long getPartOffset(SyntaxTraverser<?> s) {
        Long o = (Long)s.getUserData(PART_OFFSET);
        return o == null ? 0L : o;
    }

    public static <V> String statementText(ScriptModel.StatementIt<V> st, ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<V>> paramCondition) {
        JBIterable params2 = st.parameters().filter(Conditions.not(paramCondition));
        return ScriptModelUtil.statementText(storage, params2, st.text(), st.range().getStartOffset());
    }

    @NotNull
    public static String statementText(@NotNull ScriptModel.PStorage storage, @NotNull JBIterable<? extends ScriptModel.ParamIt<?>> params2, @NotNull String text, int offset) {
        if (storage == null) {
            ScriptModelUtil.$$$reportNull$$$0(32);
        }
        if (params2 == null) {
            ScriptModelUtil.$$$reportNull$$$0(33);
        }
        if (text == null) {
            ScriptModelUtil.$$$reportNull$$$0(34);
        }
        int curIndex = 0;
        StringBuilder sb = null;
        for (ScriptModel.ParamIt it : params2) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            TextRange r = it.range();
            Object v = storage.getValue((Object)it.name());
            if (v == null) {
                sb.append(text, curIndex, r.getEndOffset() - offset);
            } else {
                sb.append(text, curIndex, r.getStartOffset() - offset);
                sb.append(v);
            }
            curIndex = r.getEndOffset() - offset;
        }
        String string = sb == null ? text : sb.append(text, curIndex, text.length()).toString();
        if (string == null) {
            ScriptModelUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static <V> Iterable<String> getRelativeSnippet(V current, SyntaxTraverser.Api<V> api) {
        Object parent = api.parent(current);
        if (parent == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ScriptModelUtil.$$$reportNull$$$0(36);
            }
            return jBIterable;
        }
        TextRange pr = api.rangeOf(parent);
        TextRange cr = api.rangeOf(current);
        int delta = 15;
        int a2 = cr.getStartOffset() - pr.getStartOffset();
        int b2 = cr.getEndOffset() - pr.getStartOffset();
        int s = Math.max(a2 - delta, 0);
        int e = Math.min(b2 + delta, pr.getLength());
        int a1 = s < delta ? 0 : s;
        int b1 = pr.getLength() - e < delta ? pr.getLength() : e;
        CharSequence t = api.textOf(parent);
        JBIterable jBIterable = JBIterable.of((Object[])new String[]{(a1 > 0 ? "..." : "") + t.subSequence(a1, a2), t.subSequence(a2, b2).toString(), t.subSequence(b2, b1) + (b1 < pr.getLength() ? "..." : "")});
        if (jBIterable == null) {
            ScriptModelUtil.$$$reportNull$$$0(37);
        }
        return jBIterable;
    }

    @NotNull
    public static <V> Condition<V> wholeFileCondition(SyntaxTraverser<V> s, TextRange scriptRange, Condition<IElementType> wsOrComment, Class<? extends V> statementClass) {
        Condition condition = v -> {
            if (!(s.api.typeOf(v) instanceof IFileElementType)) {
                return false;
            }
            JBIterable it = ((SyntaxTraverser)((SyntaxTraverser)s.withRoot(v)).reset()).preOrderDfsTraversal().skip(1);
            Object st = it.filter(Conditions.instanceOf((Class)statementClass)).first();
            if (st == null) {
                return s.api.rangeOf(v).getLength() > 256 || !StringUtil.isEmptyOrSpaces((CharSequence)s.api.textOf(v));
            }
            if (!(scriptRange instanceof ScriptModel.PositionRange) && scriptRange.getLength() > 0) {
                if (scriptRange instanceof ScriptModel.StrictRange) {
                    return !Comparing.equal((Object)s.api.rangeOf(v), (Object)s.api.rangeOf(st));
                }
                return s.api.rangeOf(st).getStartOffset() > 0 && it.takeWhile(Conditions.notEqualTo((Object)st)).filter(o -> !wsOrComment.value((Object)s.api.typeOf(o))).isNotEmpty();
            }
            return ((SyntaxTraverser)s.withRoot(v)).preOrderDfsTraversal().take(3).size() > 2;
        };
        if (condition == null) {
            ScriptModelUtil.$$$reportNull$$$0(38);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/ScriptModelUtil";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "INTERSECTS_RANGE";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "CONTAINS_RANGE";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "IN_RANGE";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "AT_OFFSET2";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "LIMIT_TO_RANGE";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/ScriptModelUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModelForSelection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedStatementsRange";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForConsole";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectionRange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "inRange";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "statementText";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeSnippet";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "wholeFileCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustModelForSelection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedStatementsRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionForConsole";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectionRange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "inRange";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "statementText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParamHelper
    implements DocumentListener {
        private static final Key<ParamHelper> PARAM_NAMES = Key.create((String)"PARAM_NAMES");
        private final AtomicInteger counter = new AtomicInteger();
        private final ConcurrentMap<Segment, String> map = ContainerUtil.newConcurrentMap();

        private ParamHelper() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            if (this.map.size() < 100) {
                return;
            }
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                if (((RangeMarker)it.next()).isValid()) continue;
                it.remove();
            }
        }

        @Nullable
        public static String getParameterId(@NotNull ScriptModel.ParamIt<?> it, String baseName, @Nullable UserDataHolder userDataHolder) {
            TextRange segment;
            if (it == null) {
                ParamHelper.$$$reportNull$$$0(0);
            }
            if (userDataHolder == null) {
                return null;
            }
            ParamHelper names = (ParamHelper)PARAM_NAMES.get(userDataHolder);
            if (names == null) {
                names = new ParamHelper();
                PARAM_NAMES.set(userDataHolder, (Object)names);
                if (userDataHolder instanceof Document) {
                    ((Document)userDataHolder).addDocumentListener((DocumentListener)names);
                }
            }
            TextRange r = it.range().shiftRight((int)it.rangeOffset());
            if (userDataHolder instanceof DocumentEx) {
                DocumentEx document = (DocumentEx)userDataHolder;
                Ref found = Ref.create();
                document.processRangeMarkersOverlappingWith(r.getStartOffset(), r.getEndOffset(), marker -> {
                    if (!r.equalsToRange(marker.getStartOffset(), marker.getEndOffset())) {
                        return true;
                    }
                    if (marker.isGreedyToLeft() || baseName == null && marker.isGreedyToRight()) {
                        return true;
                    }
                    found.set(marker);
                    return false;
                });
                RangeMarker marker2 = (RangeMarker)found.get();
                if (marker2 == null || !marker2.isValid()) {
                    marker2 = document.createRangeMarker(r);
                    if (baseName != null) {
                        marker2.setGreedyToRight(true);
                    }
                }
                segment = marker2;
            } else {
                segment = r;
            }
            String name = (String)names.map.get(segment);
            return name != null ? name : (String)ConcurrencyUtil.cacheOrGet(names.map, (Object)segment, (Object)(baseName != null ? baseName : "#" + names.counter.incrementAndGet()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/database/script/ScriptModelUtil$ParamHelper", "getParameterId"));
        }
    }
}

