/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.sqlite;

import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteReplaceTableOperation
extends DasDdlOperations.CreateTableOperation {
    public static final DdlOperation SQLITE_REPLACE_TABLE = new DdlOperation("sqlite-replace-table", DasDdlOperations.CREATE_TABLE);
    private static final Key<DeTable> TMP_VIEW = Key.create((String)"SqliteReplaceTableOperation.TMP_NAME");

    public SqliteReplaceTableOperation() {
        super(SQLITE_REPLACE_TABLE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable table, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(0);
        }
        if (table == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(2);
        }
        DeTable from = (DeTable)DasDdlOperations.getAlterFrom(table, data);
        assert (from != table);
        for (DeIndex index2 : from.indices) {
            builder.getDialect().sqlDropIndex(builder, from, index2, index2.getName(), true).newStatement();
        }
        super.generate(builder, table, data, context);
        DeTable tmpView = (DeTable)TMP_VIEW.get(data);
        String tmpName = ((DeTable)ObjectUtils.chooseNotNull((Object)tmpView, (Object)table)).name;
        builder.keywords("INSERT", "INTO").space().identifier(table, tmpName).symbol("(");
        boolean first = true;
        for (DeColumn column2 : table.columns) {
            if (column2.editedObject == null) continue;
            if (!first) {
                builder.symbol(",").space();
            }
            first = false;
            builder.identifier(column2, column2.name);
        }
        builder.symbol(")").space().keyword("SELECT").space();
        first = true;
        for (DeColumn column2 : table.columns) {
            if (column2.editedObject == null) continue;
            if (!first) {
                builder.symbol(",").space();
            }
            first = false;
            builder.identifier(column2.editedObject, column2.editedObject.getName());
        }
        builder.space().keyword("FROM").space().identifier(from, from.name).newStatement();
        builder.getDialect().sqlDropTable(builder, from, true, false, from.model).newStatement();
        if (tmpView != null) {
            builder.getDialect().sqlRenameTable(builder, tmpView, table.name).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(3);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DeTable getView(@NotNull DeTable table, @Nullable UserDataHolder data) {
        DeObject from;
        if (table == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(4);
        }
        if ((from = DasDdlOperations.getAlterFrom(table, data)) == table || !Comparing.equal((String)from.name, (String)table.name)) {
            DeTable deTable = super.getView(table, data);
            if (deTable == null) {
                SqliteReplaceTableOperation.$$$reportNull$$$0(5);
            }
            return deTable;
        }
        DeTable tmp = (DeTable)TMP_VIEW.get(data);
        if (tmp != null) {
            DeTable deTable = tmp;
            if (deTable == null) {
                SqliteReplaceTableOperation.$$$reportNull$$$0(6);
            }
            return deTable;
        }
        tmp = DeObject.copy(table, true, DeObject.DeCopier.deepSubTree(table));
        Application application = ApplicationManager.getApplication();
        String uuid = application == null || application.isUnitTestMode() ? "_tmp" : UUID.randomUUID().toString().substring(0, 4);
        tmp.name = tmp.name + uuid;
        TMP_VIEW.set(data, (Object)tmp);
        DeTable deTable = tmp;
        if (deTable == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(7);
        }
        return deTable;
    }

    @Override
    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable das, @Nullable UserDataHolder data) {
        if (generator == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(9);
        }
        if (das == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(10);
        }
        generator.addOperation(builder, DdlOperation.BEGIN_TRANSACTION, DeTable.STUB, null);
        generator.addOperation(builder, DdlOperation.COMMIT, DeTable.STUB, null);
        DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
        if (ddlGenerator == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(11);
        }
        return ddlGenerator;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = super.getDependencies(object, data).append((Object)new DdlOperationKey(DeTable.STUB, DdlOperation.BEGIN_TRANSACTION));
        if (jBIterable == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getDependants(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(14);
        }
        JBIterable jBIterable = super.getDependants(object, data).append((Object)new DdlOperationKey(DeTable.STUB, DdlOperation.COMMIT));
        if (jBIterable == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
        if (object == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(16);
        }
        JBIterable tree = ((JBTreeTraverser)object.model.traverser().withRoot((Object)object)).filter(DeObject.class);
        JBIterable jBIterable = super.getImplemented(object, data).append(DasDdlOperations.getObjectsCreateKeys((Iterable<? extends DeObject>)tree)).append(DasDdlOperations.getObjectsDropKeys((Iterable<? extends DeObject>)tree));
        if (jBIterable == null) {
            SqliteReplaceTableOperation.$$$reportNull$$$0(17);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "das";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/operations/sqlite/SqliteReplaceTableOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addToBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplemented";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getView";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToBuilder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDependants";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getImplemented";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

