/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.fix.DdlGraphFixing;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaEditorHelper {
    public static final Condition<DasObject> LIGHT_EXPORTED = object -> {
        DeObject de = (DeObject)object;
        return de.lightExported;
    };
    private final SchemaEditor mySchemaEditor;
    private final DdlGenerator myDdlGenerator;
    private DdlGraphBuilder myDdlGraphBuilder;

    public SchemaEditorHelper(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            SchemaEditorHelper.$$$reportNull$$$0(0);
        }
        this.myDdlGraphBuilder = null;
        this.mySchemaEditor = context.getDialect().getSchemaEditor();
        this.myDdlGenerator = this.mySchemaEditor.createGenerator(context);
    }

    @NotNull
    public static JBIterable<ObjectAction> basicTraversal(@NotNull DeModel model) {
        if (model == null) {
            SchemaEditorHelper.$$$reportNull$$$0(1);
        }
        JBIterable jBIterable = ((JBTreeTraverser)model.traverser().expandAndSkip(LIGHT_EXPORTED)).bfsTraversal().filter(DeObject.class).transform(object -> new ObjectAction(object.editedObject == null ? ObjectAction.Action.CREATE : ObjectAction.Action.ALTER, (DeObject)object));
        if (jBIterable == null) {
            SchemaEditorHelper.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public SchemaEditor getSchemaEditor() {
        SchemaEditor schemaEditor = this.mySchemaEditor;
        if (schemaEditor == null) {
            SchemaEditorHelper.$$$reportNull$$$0(3);
        }
        return schemaEditor;
    }

    @NotNull
    public SchemaExportHelper createExportHelper(@NotNull DasModel model) {
        if (model == null) {
            SchemaEditorHelper.$$$reportNull$$$0(4);
        }
        SchemaExportHelper schemaExportHelper = this.mySchemaEditor.createExportHelper(this.myDdlGenerator.getContext(), model);
        if (schemaExportHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(5);
        }
        return schemaExportHelper;
    }

    @NotNull
    public DdlGenerator getDdlGenerator() {
        DdlGenerator ddlGenerator = this.myDdlGenerator;
        if (ddlGenerator == null) {
            SchemaEditorHelper.$$$reportNull$$$0(6);
        }
        return ddlGenerator;
    }

    @NotNull
    public DdlGraphBuilder getDdlGraphBuilder() {
        if (this.myDdlGraphBuilder == null) {
            this.myDdlGraphBuilder = new DdlGraphBuilder(this.myDdlGenerator.getContext().getDialect());
        }
        DdlGraphBuilder ddlGraphBuilder = this.myDdlGraphBuilder;
        if (ddlGraphBuilder == null) {
            SchemaEditorHelper.$$$reportNull$$$0(7);
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public List<DdlGraph> getGraphComponents() {
        List<DdlGraph> list = this.getDdlGraphBuilder().buildComponents();
        if (list == null) {
            SchemaEditorHelper.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public SchemaEditorHelper create(@NotNull DeObject object, @Nullable UserDataHolder data) {
        if (object == null) {
            SchemaEditorHelper.$$$reportNull$$$0(9);
        }
        this.getDdlGenerator().addOperation(this.getDdlGraphBuilder(), DdlOperation.CREATE, object, data);
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(10);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper alter(@NotNull DeModel model) {
        if (model == null) {
            SchemaEditorHelper.$$$reportNull$$$0(11);
        }
        SchemaEditorHelper schemaEditorHelper = this.alter(model, SchemaEditorHelper.basicTraversal(model));
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(12);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper alter(@NotNull DeModel model, @NotNull JBIterable<ObjectAction> actions) {
        if (model == null) {
            SchemaEditorHelper.$$$reportNull$$$0(13);
        }
        if (actions == null) {
            SchemaEditorHelper.$$$reportNull$$$0(14);
        }
        for (ObjectAction action : actions.toList()) {
            if (action.action == ObjectAction.Action.DROP) {
                model.getExportHelper().pullDependencies(action.object);
                continue;
            }
            if (action.action != ObjectAction.Action.ALTER) continue;
            model.getExportHelper().pullDependencies(action.object.editedObject);
        }
        for (ObjectAction action : actions) {
            if (action.action == ObjectAction.Action.DROP) {
                this.drop(action.object, null);
                continue;
            }
            if (action.action == ObjectAction.Action.CREATE) {
                this.create(action.object, null);
                continue;
            }
            if (action.action != ObjectAction.Action.ALTER) continue;
            DeObject object = (DeObject)ObjectUtils.tryCast((Object)action.object.editedObject, DeObject.class);
            this.alter((DeObject)ObjectUtils.assertNotNull((Object)object), action.object, null);
        }
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(15);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper drop(@NotNull DeObject object, @Nullable UserDataHolder data) {
        if (object == null) {
            SchemaEditorHelper.$$$reportNull$$$0(16);
        }
        this.getDdlGenerator().addOperation(this.getDdlGraphBuilder(), DdlOperation.DROP, object, data);
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(17);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper alter(@NotNull DeObject object, @NotNull DeObject modified, @Nullable UserDataHolder data) {
        if (object == null) {
            SchemaEditorHelper.$$$reportNull$$$0(18);
        }
        if (modified == null) {
            SchemaEditorHelper.$$$reportNull$$$0(19);
        }
        if (data == null) {
            data = this.getDdlGraphBuilder().newData(null);
        }
        DasDdlOperations.set(data, DdlGraph.ALTER_TO, modified);
        this.getDdlGenerator().addOperation(this.getDdlGraphBuilder(), DdlOperation.ALTER, object, data);
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(20);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper fix() {
        DdlGraphFixing.fix(this.getDdlGenerator(), this.getDdlGraphBuilder());
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(21);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public SchemaEditorHelper clear() {
        this.myDdlGraphBuilder = null;
        SchemaEditorHelper schemaEditorHelper = this;
        if (schemaEditorHelper == null) {
            SchemaEditorHelper.$$$reportNull$$$0(22);
        }
        return schemaEditorHelper;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeModel editedModel, @NotNull Function<Runnable, ActionCallback> asyncProcessor) {
        if (builder == null) {
            SchemaEditorHelper.$$$reportNull$$$0(23);
        }
        if (editedModel == null) {
            SchemaEditorHelper.$$$reportNull$$$0(24);
        }
        if (asyncProcessor == null) {
            SchemaEditorHelper.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = this.getDdlGenerator().generate(builder, this.getDdlGraphBuilder(), new DdlBuildingContext(this.getDdlGenerator().buildState(editedModel), asyncProcessor, this.getDdlGenerator().getContext()));
        if (ddlBuilder == null) {
            SchemaEditorHelper.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeModel editedModel) {
        if (builder == null) {
            SchemaEditorHelper.$$$reportNull$$$0(27);
        }
        if (editedModel == null) {
            SchemaEditorHelper.$$$reportNull$$$0(28);
        }
        DdlBuilder ddlBuilder = this.generate(builder, editedModel, (Function<Runnable, ActionCallback>)((Function)runnable -> {
            runnable.run();
            return ActionCallback.DONE;
        }));
        if (ddlBuilder == null) {
            SchemaEditorHelper.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaEditorHelper";
                break;
            }
            case 9: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedModel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaEditorHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "basicTraversal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExportHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlGraphBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: 
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "alter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "drop";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fix";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "clear";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "basicTraversal";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExportHelper";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "alter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ObjectAction {
        public final Action action;
        public final DeObject object;

        public ObjectAction(Action action, DeObject object) {
            this.action = action;
            this.object = object;
        }

        public static enum Action {
            CREATE,
            ALTER,
            DROP;

        }
    }
}

