/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.ChangeCellEditorLanguageAction;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.grid.editors.CellEditorScratchRootType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorTextField
extends EditorTextField
implements Disposable {
    private final DataGrid myGrid;

    public GridCellEditorTextField(Project project, @NotNull DataGrid grid, @NotNull Language language, @Nullable String text, @Nullable byte[] bytes, boolean multiline, EventObject initiator, TextCompletionProvider provider) {
        if (grid == null) {
            GridCellEditorTextField.$$$reportNull$$$0(0);
        }
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(1);
        }
        super(GridCellEditorTextField.createDocument(project, language, text, bytes, initiator instanceof KeyEvent && grid.isEditable()), project, (FileType)FileTypes.PLAIN_TEXT);
        this.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        this.myGrid = grid;
        this.installEditorSettingsProvider(multiline);
        GridCellEditorTextField.installCompletion(project, this.getDocument(), provider);
    }

    @NotNull
    public String getText() {
        String lineSeparator;
        Document document = this.getDocument();
        String text = document.getText();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile file = documentManager.getFile(document);
        if (file != null && !(lineSeparator = documentManager.getLineSeparator(file, this.getProject())).equals("\n")) {
            text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
        }
        String string = text;
        if (string == null) {
            GridCellEditorTextField.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean shouldHaveBorder() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Editor editor = this.getEditor();
        if (editor instanceof EditorEx && !editor.isOneLineMode()) {
            JScrollBar horizontalScrollBar;
            JScrollPane scrollPane = ((EditorEx)editor).getScrollPane();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                size.width += verticalScrollBar.getWidth();
            }
            if ((horizontalScrollBar = scrollPane.getHorizontalScrollBar()) != null) {
                size.height += horizontalScrollBar.getHeight();
            }
        }
        return size;
    }

    public Object getData(String dataId) {
        if (ChangeCellEditorLanguageAction.ACTION_HANDLER_KEY.is(dataId)) {
            return new ChangeCellEditorLanguageAction.Handler(){

                @Override
                public void changeLanguage(AnActionEvent e) {
                    Consumer chosenLanguageConsumer = language -> {
                        VirtualFile scratch;
                        Document document = language != null ? GridCellEditorTextField.this.getDocument() : null;
                        VirtualFile virtualFile = scratch = document != null ? FileDocumentManager.getInstance().getFile(document) : null;
                        if (scratch != null) {
                            CellEditorScratchRootType.setLanguage(GridCellEditorTextField.this.getProject(), scratch, language);
                            GridCellEditorTextField.this.setDocument(document);
                            IdeFocusManager.getInstance((Project)GridCellEditorTextField.this.getProject()).requestFocus((Component)((Object)GridCellEditorTextField.this), true);
                        }
                    };
                    LRUPopupBuilder.forFileLanguages((Project)GridCellEditorTextField.this.getProject(), (String)"Edit As Language", null, (Consumer)chosenLanguageConsumer).showInBestPositionFor(e.getDataContext());
                }
            };
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return FileDocumentManager.getInstance().getFile(this.getDocument());
        }
        return super.getData(dataId);
    }

    public void dispose() {
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    file.delete((Object)this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        });
    }

    protected boolean isEditable() {
        return this.myGrid.isEditable();
    }

    private void registerEnterAction(@NotNull Editor editor, final boolean multiline) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(3);
        }
        CustomShortcutSet enterAndControlEnter = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"ENTER"), KeyboardShortcut.fromString((String)"control ENTER")});
        DumbAwareAction action = new DumbAwareAction("insertNewLineOrStopEditing1"){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                InputEvent inputEvent;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean isCtrlEnter = (inputEvent = e.getInputEvent()) instanceof KeyEvent && inputEvent.isControlDown();
                boolean commitOnCtrlEnter = GridCellEditorTextField.this.myGrid.isEditingCellMaximized();
                if (!multiline || commitOnCtrlEnter == isCtrlEnter) {
                    GridCellEditorTextField.this.myGrid.stopEditing();
                } else {
                    this.performEditorEnter(e);
                }
            }

            private void performEditorEnter(@NotNull AnActionEvent e) {
                AnAction action;
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((action = ActionManager.getInstance().getAction("EditorEnter")) != null) {
                    action.beforeActionPerformedUpdate(e);
                    if (e.getPresentation().isEnabled()) {
                        action.actionPerformed(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performEditorEnter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GridCellEditorTextField.registerAction(editor, (AnAction)action, (ShortcutSet)enterAndControlEnter);
    }

    private void registerTabAction(@NotNull EditorEx editor) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(4);
        }
        CustomShortcutSet tabAndShiftTab = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"TAB"), KeyboardShortcut.fromString((String)"shift TAB")});
        DumbAwareAction action = new DumbAwareAction("insertTabOrStopEditing"){

            public void update(AnActionEvent e) {
                KeyEvent keyEvent = !GridCellEditorTextField.this.myGrid.isEditingCellMaximized() ? (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class) : null;
                e.getPresentation().setEnabledAndVisible(keyEvent != null);
            }

            public void actionPerformed(AnActionEvent e) {
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                KeyStroke stroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                Object actionKey = gridComponent.getInputMap(1).get(stroke);
                Action tabAction = gridComponent.getActionMap().get(actionKey);
                if (tabAction != null) {
                    tabAction.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, (AnAction)action, (ShortcutSet)tabAndShiftTab);
    }

    private static void registerAction(@NotNull Editor editor, @NotNull AnAction action, @NotNull ShortcutSet shortcutSet) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(5);
        }
        if (action == null) {
            GridCellEditorTextField.$$$reportNull$$$0(6);
        }
        if (shortcutSet == null) {
            GridCellEditorTextField.$$$reportNull$$$0(7);
        }
        action.registerCustomShortcutSet(shortcutSet, editor.getComponent());
    }

    private void installEditorSettingsProvider(boolean multiline) {
        this.addSettingsProvider(editor -> {
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file != null) {
                EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file, editor.getColorsScheme(), this.getProject());
                editor.setHighlighter(highlighter);
            }
            editor.setRendererMode(!this.isEditable());
            EditorColorsScheme scheme = editor.createBoundColorSchemeDelegate((EditorColorsScheme)this.myGrid.getColorsScheme());
            if (UISettings.getInstance().getPresentationMode()) {
                scheme.setEditorFontSize(UISettings.getInstance().getPresentationModeFontSize());
            }
            editor.setColorsScheme(scheme);
            editor.setOneLineMode(!multiline);
            editor.setVerticalScrollbarVisible(multiline);
            editor.setHorizontalScrollbarVisible(multiline);
            editor.getSettings().setAdditionalColumnsCount(2);
            editor.getCaretModel().moveToOffset(0);
            if (this.isEditable() && (!multiline || this.getDocument().getLineCount() == 1)) {
                editor.getSelectionModel().setSelection(0, this.getDocument().getTextLength());
            }
            this.putReadOnlyText(editor);
            editor.setContextMenuGroupId(null);
            editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

                public void invokePopup(EditorMouseEvent event) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Component component = (Component)mouseEvent.getSource();
                    int x = mouseEvent.getX();
                    int y = mouseEvent.getY();
                    GridCellEditorsUtil.showCellEditorPopup(GridCellEditorTextField.this.myGrid, component, x, y);
                }
            });
            this.registerEnterAction((Editor)editor, multiline);
            this.registerTabAction(editor);
        });
    }

    private void putReadOnlyText(@NotNull EditorEx editor) {
        GridEditGuard guard;
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(8);
        }
        if ((guard = GridEditGuard.get(this.myGrid)) == null) {
            return;
        }
        EditorModificationUtil.READ_ONLY_VIEW_MESSAGE_KEY.set((UserDataHolder)editor, (Object)guard.getReasonText(this.myGrid));
    }

    @NotNull
    private static Document createDocument(@NotNull Project project, @NotNull Language language, @Nullable String text, @Nullable byte[] bytes, boolean clear2) {
        Document document;
        if (project == null) {
            GridCellEditorTextField.$$$reportNull$$$0(9);
        }
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(10);
        }
        Document document2 = (document = (Document)WriteAction.compute(() -> {
            if (project == null) {
                GridCellEditorTextField.$$$reportNull$$$0(13);
            }
            if (language == null) {
                GridCellEditorTextField.$$$reportNull$$$0(14);
            }
            try {
                VirtualFile scratchFile = CellEditorScratchRootType.newScratch(project);
                if (bytes != null) {
                    scratchFile.setBinaryContent(bytes);
                } else if (text != null) {
                    VfsUtil.saveText((VirtualFile)scratchFile, (String)text);
                }
                VfsUtilCore.virtualToIoFile((VirtualFile)scratchFile).deleteOnExit();
                CellEditorScratchRootType.setLanguage(project, scratchFile, language);
                Document doc = FileDocumentManager.getInstance().getDocument(scratchFile);
                if (doc != null && clear2) {
                    doc.setText((CharSequence)"");
                }
                return doc;
            }
            catch (IOException ignore) {
                return null;
            }
        })) != null ? document : EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)(clear2 ? null : text)));
        if (document2 == null) {
            GridCellEditorTextField.$$$reportNull$$$0(11);
        }
        return document2;
    }

    private static void installCompletion(@NotNull Project project, @Nullable Document document, @Nullable TextCompletionProvider provider) {
        if (project == null) {
            GridCellEditorTextField.$$$reportNull$$$0(12);
        }
        if (document == null || provider == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile != null) {
            psiFile.putUserData(TextCompletionUtil.COMPLETING_TEXT_FIELD_KEY, (Object)provider);
            psiFile.putUserData(TextCompletionUtil.AUTO_POPUP_KEY, (Object)false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerEnterAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerTabAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putReadOnlyText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installCompletion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createDocument$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

