/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.util.Range;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public abstract class GridTableModel
extends AbstractTableModel
implements GridModel.Listener<DataConsumer.Row, DataConsumer.Column> {
    protected final DataGrid myGrid;

    private GridTableModel(DataGrid grid) {
        this.myGrid = grid;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myGrid.isEditable() && !DataGridUtil.isFailedToLoad(this.getValueAt(rowIndex, columnIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new AssertionError((Object)"Modification is not supported!");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModelIndex<DataConsumer.Row> row = ModelIndex.forRow(this.myGrid, this.row(rowIndex, columnIndex));
        ModelIndex<DataConsumer.Column> column2 = ModelIndex.forColumn(this.myGrid, this.col(rowIndex, columnIndex));
        return this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column2);
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns2) {
        if (columns2.size() == 1 && rows.size() == 1) {
            int rowIndex = rows.asArray()[0];
            int colIndex = columns2.asArray()[0];
            this.fireTableCellUpdated(this.row(rowIndex, colIndex), this.col(rowIndex, colIndex));
        } else {
            Range<Integer> range = this.rowRange(rows, columns2);
            this.fireTableRowsUpdated((Integer)range.getFrom(), (Integer)range.getTo());
        }
    }

    protected abstract int row(int var1, int var2);

    protected abstract int col(int var1, int var2);

    protected abstract Range<Integer> rowRange(ModelIndexSet<DataConsumer.Row> var1, ModelIndexSet<DataConsumer.Column> var2);

    private static Range<Integer> getSmallestCoveringRange(ModelIndexSet<?> indexSet) {
        assert (indexSet.size() > 0);
        int[] indices = indexSet.asArray();
        Arrays.sort(indices);
        return new Range((Comparable)Integer.valueOf(indices[0]), (Comparable)Integer.valueOf(indices[indices.length - 1]));
    }

    public static class Transposed
    extends GridTableModel {
        public Transposed(DataGrid grid) {
            super(grid);
        }

        @Override
        protected int row(int rowIndex, int columnIndex) {
            return columnIndex;
        }

        @Override
        protected int col(int rowIndex, int columnIndex) {
            return rowIndex;
        }

        @Override
        protected Range<Integer> rowRange(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns2) {
            return GridTableModel.getSmallestCoveringRange(columns2);
        }

        @Override
        public int getRowCount() {
            return this.myGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount();
        }

        @Override
        public int getColumnCount() {
            return this.myGrid.getDataModel(DataAccessType.DATABASE_DATA).getRowCount();
        }

        @Override
        public void columnsAdded(ModelIndexSet<DataConsumer.Column> columns2) {
            Range range = GridTableModel.getSmallestCoveringRange(columns2);
            this.fireTableRowsInserted((Integer)range.getFrom(), (Integer)range.getTo());
        }

        @Override
        public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns2) {
            Range range = GridTableModel.getSmallestCoveringRange(columns2);
            this.fireTableRowsDeleted((Integer)range.getFrom(), (Integer)range.getTo());
        }

        @Override
        public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
            this.fireTableStructureChanged();
        }

        @Override
        public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
            this.fireTableStructureChanged();
        }
    }

    public static class Regular
    extends GridTableModel {
        public Regular(DataGrid grid) {
            super(grid);
        }

        @Override
        protected int row(int rowIndex, int columnIndex) {
            return rowIndex;
        }

        @Override
        protected int col(int rowIndex, int columnIndex) {
            return columnIndex;
        }

        @Override
        protected Range<Integer> rowRange(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns2) {
            return GridTableModel.getSmallestCoveringRange(rows);
        }

        @Override
        public int getRowCount() {
            return this.myGrid.getDataModel(DataAccessType.DATABASE_DATA).getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.myGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount();
        }

        @Override
        public void columnsAdded(ModelIndexSet<DataConsumer.Column> columns2) {
            this.fireTableStructureChanged();
        }

        @Override
        public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns2) {
            this.fireTableStructureChanged();
        }

        @Override
        public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
            Range rowRange = GridTableModel.getSmallestCoveringRange(rows);
            this.fireTableRowsInserted((Integer)rowRange.getFrom(), (Integer)rowRange.getTo());
        }

        @Override
        public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
            Range rowRange = GridTableModel.getSmallestCoveringRange(rows);
            this.fireTableRowsDeleted((Integer)rowRange.getFrom(), (Integer)rowRange.getTo());
        }
    }
}

