/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationColumn;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.openapi.Disposable;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMutationModel
implements GridModel<DataConsumer.Row, DataConsumer.Column>,
GridDataSupport {
    private final GridMutator<DataConsumer.Row, DataConsumer.Column> myMutator;
    private final TableResultPanel myGrid;
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final TableResultView myView;
    private final Map<DataConsumer.Column, DataConsumer.Column> myCache;

    public GridMutationModel(@Nullable GridMutator<DataConsumer.Row, DataConsumer.Column> mutator, @NotNull TableResultPanel grid, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, @NotNull TableResultView view) {
        if (grid == null) {
            GridMutationModel.$$$reportNull$$$0(0);
        }
        if (model == null) {
            GridMutationModel.$$$reportNull$$$0(1);
        }
        if (view == null) {
            GridMutationModel.$$$reportNull$$$0(2);
        }
        this.myMutator = mutator;
        this.myGrid = grid;
        this.myModel = model;
        this.myView = view;
        this.myCache = ContainerUtil.newConcurrentMap();
    }

    @Override
    public void revert(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(3);
        }
        if (columns2 == null) {
            GridMutationModel.$$$reportNull$$$0(4);
        }
        if (this.getDatabaseMutator() == null) {
            return;
        }
        DataGridRequestSource requestSource = new DataGridRequestSource(rows, columns2);
        GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = GridRequestSource.create(this.myGrid, (Object)requestSource);
        GridSelection selection = GridSelection.store((JTable)((Object)this.myView));
        this.getDatabaseMutator().revert(source, rows, columns2);
        this.myGrid.getAutoscrollLocker().runWithLock(() -> selection.fit((JTable)((Object)this.myView)).restore((JTable)((Object)this.myView)));
    }

    @Override
    public void finishBuildingAndApply(@NotNull List<CellMutation.Builder> builders) {
        if (builders == null) {
            GridMutationModel.$$$reportNull$$$0(5);
        }
        if (this.myMutator == null) {
            return;
        }
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        List<CellMutation> mutations = mutator == null ? ContainerUtil.map(builders, CellMutation.Builder::build) : builders.stream().map(builder -> builder.type(builder.getRow() != null && mutator.isInsertedRow(builder.getRow()) ? MutationType.INSERT : MutationType.MODIFY)).map(CellMutation.Builder::build).collect(Collectors.toList());
        ModelIndexSet<DataConsumer.Row> rows = ModelIndexSet.forRows(this.myGrid, GridMutationModel.uniqueIndices(mutations, Mutation::getRow));
        ModelIndexSet<DataConsumer.Column> columns2 = ModelIndexSet.forColumns(this.myGrid, GridMutationModel.uniqueIndices(mutations, CellMutation::getColumn));
        this.myMutator.mutate(GridRequestSource.create(this.myGrid, (Object)new DataGridRequestSource(rows, columns2)), mutations);
    }

    @Override
    public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(6);
        }
        return this.getRowsMutator() != null && this.getRowsMutator().isDeletedRows(rows);
    }

    @Override
    public boolean isModified(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (row == null) {
            GridMutationModel.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            GridMutationModel.$$$reportNull$$$0(8);
        }
        if ((mutator = this.getDatabaseMutator()) == null) {
            return false;
        }
        MutationData mutation = mutator.getMutation(row, column2);
        return mutation != null && mutation.getType() == MutationType.MODIFY;
    }

    @Override
    public boolean hasPendingChanges() {
        return this.hasMutator() && ((GridMutator)ObjectUtils.assertNotNull(this.myMutator)).hasPendingChanges();
    }

    @Override
    public boolean hasMutator() {
        return this.myMutator != null;
    }

    @Override
    public boolean hasRowMutator() {
        return this.getRowsMutator() != null;
    }

    @Override
    public boolean canRevert() {
        return this.getDatabaseMutator() != null;
    }

    @Override
    public boolean isSubmitImmediately() {
        return this.myMutator != null && this.myMutator.isUpdateImmediately();
    }

    @Override
    @NotNull
    public List<DataConsumer.Column> getColumns() {
        List<DataConsumer.Column> list = this.wrap(this.myModel.getColumns());
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public List<DataConsumer.Column> getColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnsIdxs) {
        if (columnsIdxs == null) {
            GridMutationModel.$$$reportNull$$$0(10);
        }
        List<DataConsumer.Column> list = this.wrap(this.myModel.getColumns(columnsIdxs));
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @Nullable
    public DataConsumer.Column getColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(12);
        }
        return this.wrap(this.myModel.getColumn(columnIdx));
    }

    @Override
    @NotNull
    public List<DataConsumer.Row> getRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(13);
        }
        List<DataConsumer.Row> list = this.myModel.getRows(rows);
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column2) {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        MutationData value = mutator == null ? null : mutator.getMutation(row, column2);
        return value == null ? this.myModel.getValueAt(row, column2) : value.getValue();
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, Object what) {
        ModelIndexSet<DataConsumer.Column> realColumns;
        ModelIndexSet<DataConsumer.Row> realRows;
        if (rowIndices == null) {
            GridMutationModel.$$$reportNull$$$0(15);
        }
        if (columnIndices == null) {
            GridMutationModel.$$$reportNull$$$0(16);
        }
        return this.myModel.allValuesEqualTo(realRows = this.getRealRows(rowIndices), realColumns = this.getRealColumns(columnIndices), what) && (this.getDatabaseMutator() == null || !this.getDatabaseMutator().hasMutatedRows(realRows, realColumns));
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            GridMutationModel.$$$reportNull$$$0(17);
        }
        return this.myModel.allValuesEqualTo(mutations);
    }

    @Override
    @Nullable
    public DataConsumer.Row getRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            GridMutationModel.$$$reportNull$$$0(18);
        }
        return this.myModel.getRow(row);
    }

    @Override
    @NotNull
    public List<DataConsumer.Row> getRows() {
        List<DataConsumer.Row> list = this.myModel.getRows();
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getColumnIndices() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myModel.getColumnIndices();
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(20);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getRowIndices() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myModel.getRowIndices();
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(21);
        }
        return modelIndexSet;
    }

    @Override
    public int getColumnCount() {
        return this.myModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.myModel.getRowCount();
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            GridMutationModel.$$$reportNull$$$0(22);
        }
        return this.myModel.isValidRowIdx(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            GridMutationModel.$$$reportNull$$$0(23);
        }
        return this.myModel.isValidColumnIdx(columnIdx);
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myModel.isUpdatingNow();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<DataConsumer.Row, DataConsumer.Column> l, @NotNull Disposable disposable) {
        if (l == null) {
            GridMutationModel.$$$reportNull$$$0(24);
        }
        if (disposable == null) {
            GridMutationModel.$$$reportNull$$$0(25);
        }
        this.myModel.addListener(l, disposable);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.DatabaseMutator.class);
    }

    @NotNull
    private ModelIndexSet<DataConsumer.Row> getRealRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            GridMutationModel.$$$reportNull$$$0(26);
        }
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myView.isMultiEditingAllowed() ? this.myGrid.getSelectionModel().getSelectedRows() : rows;
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(27);
        }
        return modelIndexSet;
    }

    @NotNull
    private ModelIndexSet<DataConsumer.Column> getRealColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns2) {
        if (columns2 == null) {
            GridMutationModel.$$$reportNull$$$0(28);
        }
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myView.isMultiEditingAllowed() ? this.myGrid.getSelectionModel().getSelectedColumns() : columns2;
        if (modelIndexSet == null) {
            GridMutationModel.$$$reportNull$$$0(29);
        }
        return modelIndexSet;
    }

    @NotNull
    private List<DataConsumer.Column> wrap(@NotNull List<DataConsumer.Column> columns2) {
        if (columns2 == null) {
            GridMutationModel.$$$reportNull$$$0(30);
        }
        List list = this.getDatabaseMutator() == null ? columns2 : ContainerUtil.map(columns2, this::wrap);
        if (list == null) {
            GridMutationModel.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Nullable
    private DataConsumer.Column wrap(@Nullable DataConsumer.Column column2) {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        return mutator == null || column2 == null ? column2 : this.myCache.computeIfAbsent(column2, c -> new MutationColumn(column2, mutator, this.myGrid));
    }

    private static int[] uniqueIndices(@NotNull List<CellMutation> mutations, @NotNull Function<CellMutation, ModelIndex<?>> function) {
        if (mutations == null) {
            GridMutationModel.$$$reportNull$$$0(32);
        }
        if (function == null) {
            GridMutationModel.$$$reportNull$$$0(33);
        }
        return mutations.stream().mapToInt(mutation -> {
            if (function == null) {
                GridMutationModel.$$$reportNull$$$0(34);
            }
            return ((ModelIndex)function.fun(mutation)).asInteger();
        }).distinct().toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 4: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridMutationModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridMutationModel";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 14: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnIndices";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowIndices";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealRows";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealColumns";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "finishBuildingAndApply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRows";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 31: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "allValuesEqualTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRealRows";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRealColumns";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "uniqueIndices";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uniqueIndices$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

