/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;

public class ToggleSortingModeAction
extends ToggleAction
implements DumbAware,
GridAction {
    public ToggleSortingModeAction() {
        super("Sort via ORDER BY");
    }

    public boolean isSelected(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(dataGrid != null && dataGrid.isSortViaOrderBySupported());
        return dataGrid != null && dataGrid.isSortViaOrderBy();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid != null && dataGrid.isSortViaOrderBySupported()) {
            dataGrid.setSortViaOrderBy(state);
        }
    }
}

