/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.util.DasUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction
extends DumbAwareAction
implements GridAction {
    public NavigateAction() {
        super("Navigate to Data");
    }

    protected boolean hasKeysToNavigate(DbDataSource databaseSystem, DasTable table) {
        return DataGridDocumentationProvider.hasNavigatableKeys((DatabaseSystem)databaseSystem, table);
    }

    @NotNull
    protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
        EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
        if (enumSet == null) {
            NavigateAction.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    private List<DataGridDocumentationProvider.QueryInfo> getQueries(@NotNull DatabaseSystem dataSource, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow) {
        EnumSet<DataGridDocumentationProvider.KeyType> types;
        List<DataGridDocumentationProvider.QueryInfo> queries;
        if (dataSource == null) {
            NavigateAction.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(2);
        }
        if (selectedRow == null) {
            NavigateAction.$$$reportNull$$$0(3);
        }
        return (queries = DataGridDocumentationProvider.buildQueries(dataSource, dataGrid, selectedRow, types = this.getKeyTypes())).isEmpty() && types.remove((Object)DataGridDocumentationProvider.KeyType.SELECTED) ? DataGridDocumentationProvider.buildQueries(dataSource, dataGrid, selectedRow, types) : queries;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(4);
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        boolean visible = e.getProject() != null && table != null && dataSource != null;
        boolean enabled = visible && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && this.hasKeysToNavigate(dataSource, table);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataGrid == null || dataSource == null || project == null) {
            return;
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        if (!selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1) {
            return;
        }
        List<DataGridDocumentationProvider.QueryInfo> queries = this.getQueries((DatabaseSystem)dataSource, dataGrid, selectedRow);
        final ArrayList descriptors = ContainerUtil.newArrayList();
        final int[] separatorIdx = new int[]{-1, 0};
        int preselectedIndex = 0;
        for (DataGridDocumentationProvider.QueryInfo info : queries) {
            String path = DatabaseElementVirtualFileImpl.getPath(project, (DatabaseSystem)dataSource, (DasObject)info.table, false);
            VirtualFile file = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
            if (file == null) continue;
            int n = separatorIdx[1];
            separatorIdx[1] = n + 1;
            descriptors.add(n, new OpenDataFileDescriptor(project, file, info.columnNames, info.values, false, info.keysAndColumns));
            if (!info.exported) continue;
            if (separatorIdx[0] < 0) {
                separatorIdx[0] = separatorIdx[1] - 1;
            }
            descriptors.add(new OpenDataFileDescriptor(project, file, info.columnNames, info.values, true, info.keysAndColumns));
        }
        if (descriptors.size() == 1) {
            ((OpenDataFileDescriptor)((Object)descriptors.get(0))).navigate(true);
        } else {
            BaseListPopupStep<OpenDataFileDescriptor> step = new BaseListPopupStep<OpenDataFileDescriptor>("Choose target", (List)descriptors){

                public PopupStep onChosen(OpenDataFileDescriptor selectedValue, boolean finalChoice) {
                    selectedValue.navigate(true);
                    return FINAL_CHOICE;
                }

                @Nullable
                public ListSeparator getSeparatorAbove(OpenDataFileDescriptor value) {
                    int idx = descriptors.indexOf((Object)value);
                    if (idx == separatorIdx[0]) {
                        return new ListSeparator("First Referencing Row");
                    }
                    if (idx == separatorIdx[1]) {
                        return new ListSeparator("Referencing Rows Only");
                    }
                    return super.getSeparatorAbove((Object)value);
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(OpenDataFileDescriptor value) {
                    String string = value.getFile().getName() + ": " + value.getDescription();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$1", "getTextFor"));
                }
            };
            step.setDefaultOptionIndex(preselectedIndex);
            ColoredListCellRendererWrapper<OpenDataFileDescriptor> wrapper = new ColoredListCellRendererWrapper<OpenDataFileDescriptor>(){

                protected void doCustomize(JList list, OpenDataFileDescriptor value, int index2, boolean selected, boolean hasFocus) {
                    this.clear();
                    this.setIcon(DatabaseIcons.Table);
                    this.append(value.getFile().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append(value.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            };
            ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step, (ColoredListCellRendererWrapper)wrapper, descriptors){
                final /* synthetic */ ColoredListCellRendererWrapper val$wrapper;
                final /* synthetic */ List val$descriptors;
                {
                    this.val$wrapper = coloredListCellRendererWrapper;
                    this.val$descriptors = list;
                    super(arg0);
                }

                protected ListCellRenderer getListElementRenderer() {
                    return new PopupListElementRenderer<OpenDataFileDescriptor>((ListPopupImpl)this){

                        protected JComponent createItemComponent() {
                            this.myTextLabel = new ErrorLabel();
                            return val$wrapper;
                        }

                        protected void customizeComponent(JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value, boolean isSelected) {
                            val$wrapper.getListCellRendererComponent(list, (Object)value, val$descriptors.indexOf((Object)value), isSelected, true);
                        }
                    };
                }
            };
            ActionManager actionManager = ActionManager.getInstance();
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("QuickJavaDoc"));
            if (StringUtil.isEmpty((String)shortcutText)) {
                popup.setAdText("Use " + shortcutText + " in table to quickly view related data for selected row");
            }
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExportedAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource, DasTable table) {
            return !dataSource.getModel().getExportedKeys(table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                ExportedAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ExportedAction", "getKeyTypes"));
        }
    }

    public static class ForeignAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource, DasTable table) {
            return !DasUtil.getForeignKeys((DasTable)table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                ForeignAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ForeignAction", "getKeyTypes"));
        }
    }
}

