/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.GridAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeleteActionBase
extends DeleteAction
implements DeleteProvider,
GridAction {
    protected DeleteActionBase() {
        super(null, null, DatabaseIcons.RemoveRow);
    }

    public void update(AnActionEvent event) {
        super.update(event);
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(event.getDataContext());
        if (grid == null) {
            event.getPresentation().setText(this.getTemplatePresentation().getText());
        } else {
            String itemName = this.itemName();
            int itemsCount = this.itemsCount(grid);
            String text = "Delete " + StringUtil.capitalizeWords((String)(itemsCount == 1 ? itemName : StringUtil.pluralize((String)itemName)), (boolean)true);
            event.getPresentation().setText(text);
        }
        event.getPresentation().setEnabled(grid != null && this.isEnabled(grid));
        event.getPresentation().setVisible(this.isVisible(grid));
    }

    @NotNull
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        DeleteActionBase deleteActionBase = this;
        if (deleteActionBase == null) {
            DeleteActionBase.$$$reportNull$$$0(0);
        }
        return deleteActionBase;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        DataGrid grid;
        if (dataContext == null) {
            DeleteActionBase.$$$reportNull$$$0(1);
        }
        return this.isVisible(grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext)) && this.itemsCount(grid) > 0;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        DataGrid grid;
        if (dataContext == null) {
            DeleteActionBase.$$$reportNull$$$0(2);
        }
        if ((grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext)) == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && grid.getDataSupport().isSubmitImmediately()) {
            int itemsCount = this.itemsCount(grid);
            String itemName = itemsCount == 1 ? this.itemName() : StringUtil.pluralize((String)this.itemName());
            String title = DatabaseMessages.message((String)"table.result.confirm.delete.title", (Object[])new Object[]{StringUtil.capitalizeWords((String)itemName, (boolean)true)});
            String message = DatabaseMessages.message((String)"table.result.confirm.delete.message", (Object[])new Object[]{itemsCount, itemName});
            if (Messages.showOkCancelDialog((Component)grid.getComponent(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
        }
        this.doDelete(grid);
    }

    protected abstract boolean isEnabled(@NotNull DataGrid var1);

    protected abstract void doDelete(@NotNull DataGrid var1);

    protected abstract int itemsCount(@NotNull DataGrid var1);

    protected abstract String itemName();

    protected boolean isVisible(@Nullable DataGrid grid) {
        return grid != null && grid.isEditable() && grid.isReady();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DeleteActionBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DeleteActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

