/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorScripts;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorAction
extends AlignedIconWithTextAction
implements DumbAware,
GridAction {
    public static final String CSV_FORMAT_SETTINGS_ACTION = "Console.TableResult.Copy.Csv.Settings";

    public void update(AnActionEvent e) {
        Project project = ChooseExtractorAction.getEventProject((AnActionEvent)e);
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean enabled = project != null && dataGrid != null;
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
        if (enabled) {
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(project), presentation, "");
            presentation.setDisabledIcon(EmptyIcon.ICON_0);
            presentation.setIcon(EmptyIcon.ICON_0);
        }
    }

    @NotNull
    private static String getCurrentExtractorName(@Nullable Project project) {
        String string = DataExtractorProperties.getCurrentExtractorFactory(project).getName();
        if (string == null) {
            ChooseExtractorAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void updateText(@NotNull String name, @NotNull Presentation presentation, @NotNull String prefix) {
        if (name == null) {
            ChooseExtractorAction.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            ChooseExtractorAction.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            ChooseExtractorAction.$$$reportNull$$$0(3);
        }
        String adjusted = prefix.isEmpty() ? StringUtil.trimExtensions((String)name) : name;
        String newText = prefix + StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)adjusted, (int)12));
        presentation.setText(newText);
        Object c = presentation.getClientProperty("customComponent");
        if (c instanceof JComponent) {
            ((JComponent)c).setToolTipText(name);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = ChooseExtractorAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        final Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty("customComponent");
        if (dataGrid == null) {
            return;
        }
        ChooserGroup actionGroup = new ChooserGroup(){

            @Override
            protected void extractorSelected(@NotNull Project project, @NotNull DataExtractorFactory factory) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (factory == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.extractorSelected(project, factory);
                ChooseExtractorAction.updateText(factory.getName(), presentation, "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "factory";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/actions/ChooseExtractorAction$1";
                objectArray[2] = "extractorSelected";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        if (button != null) {
            popup.showUnderneathOf((Component)button);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChooserGroup
    extends ActionGroup
    implements DumbAware {
        public void update(AnActionEvent e) {
            Project project = ChooserGroup.getEventProject((AnActionEvent)e);
            if (project == null) {
                return;
            }
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(project), e.getPresentation(), this.getTemplatePresentation().getText() + ": ");
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            final Project project = ChooserGroup.getEventProject((AnActionEvent)e);
            if (project == null) {
                if (EMPTY_ARRAY == null) {
                    ChooserGroup.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }
            AnAction[] anActionArray = ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)new Function<DataExtractorFactory, AnAction>(){
                private final String mySelectedName;
                private boolean mySelectionIsSet;
                {
                    this.mySelectedName = ChooseExtractorAction.getCurrentExtractorName(project);
                }

                public AnAction fun(DataExtractorFactory factory) {
                    String name = factory.getName();
                    boolean selected = !this.mySelectionIsSet && name.equals(this.mySelectedName);
                    this.mySelectionIsSet |= selected;
                    return new SelectExtractorFactoryAction(factory, selected);
                }
            });
            if (anActionArray == null) {
                ChooserGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        protected void extractorSelected(@NotNull Project project, @NotNull DataExtractorFactory factory) {
            if (project == null) {
                ChooserGroup.$$$reportNull$$$0(2);
            }
            if (factory == null) {
                ChooserGroup.$$$reportNull$$$0(3);
            }
            DataExtractorProperties.setCurrentExtractorFactory(project, factory);
        }

        @NotNull
        public static AnAction[] getActions(@NotNull Function<DataExtractorFactory, ? extends AnAction> wrapExtractorToAction) {
            if (wrapExtractorToAction == null) {
                ChooserGroup.$$$reportNull$$$0(4);
            }
            ArrayList actions = ContainerUtil.newArrayList();
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getLegacy(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getCsvFormats(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getScripts(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.add(DataExtractorProperties.getSkipComputedColumnsAction());
            actions.add(DataExtractorProperties.getSkipGeneratedColumnsAction());
            actions.add(DataExtractorProperties.getAddCreateTableAction());
            actions.add(DataExtractorProperties.getOverwriteExistingFilesAction());
            actions.add(DataExtractorProperties.getSingleFileAction());
            actions.add(Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction(ChooseExtractorAction.CSV_FORMAT_SETTINGS_ACTION));
            actions.add(new GoToScriptsDirectoryAction());
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooserGroup.$$$reportNull$$$0(5);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapExtractorToAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "extractorSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class GoToScriptsDirectoryAction
        extends DumbAwareAction {
            public GoToScriptsDirectoryAction() {
                super("Go to Scripts Directory");
            }

            public void update(AnActionEvent e) {
                Project project = e.getProject();
                e.getPresentation().setEnabledAndVisible(project != null);
            }

            public void actionPerformed(AnActionEvent e) {
                Project project = e.getProject();
                File scriptsDir = ExtractorScripts.getScriptsDirectory();
                if (project == null || scriptsDir == null) {
                    return;
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
                if (virtualFile == null) {
                    return;
                }
                new OpenFileDescriptor(project, virtualFile).navigate(true);
            }
        }

        private class SelectExtractorFactoryAction
        extends ToggleAction
        implements DumbAware {
            private final DataExtractorFactory myExtractorFactory;
            private final boolean mySelected;

            private SelectExtractorFactoryAction(DataExtractorFactory factory, boolean selected) {
                if (ChooserGroup.this == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(0);
                }
                if (factory == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(1);
                }
                super(factory.getName());
                this.myExtractorFactory = factory;
                this.mySelected = selected;
            }

            public boolean isSelected(AnActionEvent e) {
                return this.mySelected;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Project project = e.getProject();
                if (project != null) {
                    ChooserGroup.this.extractorSelected(project, this.myExtractorFactory);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "0";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "factory";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup$SelectExtractorFactoryAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
        }
    }
}

