/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingSessionDataConsumer;
import com.intellij.database.run.session.BaseSessionView;
import com.intellij.database.run.session.ScriptingSessionView;
import com.intellij.database.run.session.SessionToolWindowHelper;
import com.intellij.database.run.ui.ParametersPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaConsoleAdapter<T>
extends AbstractQueryLanguageConsole<T, AdaptingView> {
    protected static final String ID_CONSOLE = "Input";
    protected final ScriptingSessionDataConsumer myDataConsumer;
    protected final ScriptModel.PStorage myPStorage;
    protected final ParametersPanel myParamPanel;

    public JpaConsoleAdapter(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull T target, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(1);
        }
        if (target == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(2);
        }
        if (title == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(3);
        }
        if (language == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(4);
        }
        super(project, messageBus, target, title, language);
        this.myDataConsumer = ((AdaptingView)this.getView()).getDataConsumer();
        ParametersHolder holder = ((AdaptingView)this.getView()).getParametersHolder();
        this.myPStorage = holder.getPStorage();
        this.myParamPanel = holder.getParamPanel();
    }

    @Override
    @NotNull
    protected AdaptingView createSessionView(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull ScriptModel<?> scriptModel) {
        if (languageConsole == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(5);
        }
        if (messageBus == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(6);
        }
        if (scriptModel == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(7);
        }
        AdaptingView adaptingView = new AdaptingView(languageConsole.getProject(), this, messageBus, languageConsole, scriptModel);
        if (adaptingView == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(8);
        }
        return adaptingView;
    }

    @NotNull
    public abstract GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable var1);

    @NotNull
    public abstract String getToolWindowId();

    @NotNull
    public abstract Icon getToolWindowIcon();

    protected abstract void buildConsoleUi(boolean var1);

    @NotNull
    protected AnAction initParameterView() {
        AnAction anAction = ((AdaptingView)this.getView()).getParametersHolder().initParameterView();
        if (anAction == null) {
            JpaConsoleAdapter.$$$reportNull$$$0(9);
        }
        return anAction;
    }

    @NotNull
    protected abstract DataAuditor.ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/JpaConsoleAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/JpaConsoleAdapter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "initParameterView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSessionView";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AdaptingView
    extends BaseSessionView<JpaConsoleAdapter<?>>
    implements ScriptingSessionView<JpaConsoleAdapter<?>> {
        private final ScriptingSessionDataConsumer myDataConsumer;
        private final ParametersHolder myParametersHolder;

        public AdaptingView(@NotNull Project project, @NotNull JpaConsoleAdapter<?> console, @NotNull DataBus.Consuming messageBus, @NotNull LanguageConsoleView consoleView, @NotNull ScriptModel<?> scriptModel) {
            if (project == null) {
                AdaptingView.$$$reportNull$$$0(0);
            }
            if (console == null) {
                AdaptingView.$$$reportNull$$$0(1);
            }
            if (messageBus == null) {
                AdaptingView.$$$reportNull$$$0(2);
            }
            if (consoleView == null) {
                AdaptingView.$$$reportNull$$$0(3);
            }
            if (scriptModel == null) {
                AdaptingView.$$$reportNull$$$0(4);
            }
            super(project, messageBus, consoleView, new SessionToolWindowHelper(console.getToolWindowId(), console.getToolWindowIcon()), console);
            this.myDataConsumer = ScriptingSessionDataConsumer.install(this.getProject(), this);
            this.myParametersHolder = new ParametersHolder(this.getProject(), this, scriptModel);
        }

        @Override
        @NotNull
        public ParametersHolder getParametersHolder() {
            ParametersHolder parametersHolder = this.myParametersHolder;
            if (parametersHolder == null) {
                AdaptingView.$$$reportNull$$$0(5);
            }
            return parametersHolder;
        }

        @Override
        @NotNull
        public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
            if (parent == null) {
                AdaptingView.$$$reportNull$$$0(6);
            }
            GridDataHookUp<DataConsumer.Row, DataConsumer.Column> gridDataHookUp = ((JpaConsoleAdapter)this.getSession()).createGridDataHookUp(parent);
            if (gridDataHookUp == null) {
                AdaptingView.$$$reportNull$$$0(7);
            }
            return gridDataHookUp;
        }

        @Override
        @Nullable
        public Object getData(String dataId) {
            Object result2 = super.getData(dataId);
            if (result2 != null) {
                return result2;
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                LanguageConsoleView console = this.getConsoleView();
                return console.isConsoleEditorEnabled() ? console.getVirtualFile() : null;
            }
            return null;
        }

        @NotNull
        public ScriptingSessionDataConsumer getDataConsumer() {
            ScriptingSessionDataConsumer scriptingSessionDataConsumer = this.myDataConsumer;
            if (scriptingSessionDataConsumer == null) {
                AdaptingView.$$$reportNull$$$0(8);
            }
            return scriptingSessionDataConsumer;
        }

        @Override
        protected void buildConsoleUi(boolean focused) {
            ((JpaConsoleAdapter)this.getSession()).buildConsoleUi(focused);
        }

        @Override
        @NotNull
        protected DataAuditor.ConsoleLogger createHistoryLogger(@NotNull LanguageConsoleView consoleView) {
            if (consoleView == null) {
                AdaptingView.$$$reportNull$$$0(9);
            }
            DataAuditor.ConsoleLogger consoleLogger = ((JpaConsoleAdapter)this.getSession()).createHistoryLogger(consoleView);
            if (consoleLogger == null) {
                AdaptingView.$$$reportNull$$$0(10);
            }
            return consoleLogger;
        }

        @Override
        public void addRequestToHistory(@NotNull DataRequest.Context context) {
            Object params2;
            if (context == null) {
                AdaptingView.$$$reportNull$$$0(11);
            }
            super.addRequestToHistory(context);
            Object object = params2 = context.request instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)context.request).params : null;
            if (!(params2 instanceof Map) || ((Map)params2).isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder("(");
            boolean first = true;
            for (Map.Entry e : ((Map)params2).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append("=").append(e.getValue());
            }
            sb.append(")\n");
            this.getConsoleView().print(sb.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBus";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleView";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptModel";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/JpaConsoleAdapter$AdaptingView";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/JpaConsoleAdapter$AdaptingView";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersHolder";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGridDataHookUp";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataConsumer";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHistoryLogger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createGridDataHookUp";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createHistoryLogger";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addRequestToHistory";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

