/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleRunConfiguration
extends RunConfigurationBase
implements RunProfile {
    private static final ConfigurationType TYPE = new UnknownConfigurationType(){

        public Icon getIcon() {
            return AllIcons.RunConfigurations.Ql_console;
        }
    };
    public static final ConfigurationFactory FACTORY = new ConfigurationFactory(TYPE){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                2.$$$reportNull$$$0(0);
            }
            ConsoleRunConfiguration consoleRunConfiguration = new ConsoleRunConfiguration(project, "Default");
            if (consoleRunConfiguration == null) {
                2.$$$reportNull$$$0(1);
            }
            return consoleRunConfiguration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleRunConfiguration$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTemplateConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final String PREFER_IPV4 = "java.net.preferIPv4Stack";
    public String VM_PARAMETERS;
    public Map<String, String> VM_ENV;

    @NotNull
    public static ConsoleRunConfiguration newConfiguration(@NotNull Project project) {
        if (project == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(0);
        }
        ConsoleRunConfiguration consoleRunConfiguration = (ConsoleRunConfiguration)FACTORY.createTemplateConfiguration(project);
        if (consoleRunConfiguration == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(1);
        }
        return consoleRunConfiguration;
    }

    public ConsoleRunConfiguration(Project project, String name) {
        super(project, FACTORY, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        throw new UnsupportedOperationException();
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(3);
        }
        if (!(env.getRunnerSettings() instanceof RunContext)) {
            throw new ExecutionException(DatabaseMessages.message((String)"console.run.configuration.no.context.specified", (Object[])new Object[0]));
        }
        return new CommandLineState(env){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                RunContext runContext = (RunContext)ObjectUtils.notNull((Object)this.getEnvironment().getRunnerSettings());
                Project project = ConsoleRunConfiguration.this.getProject();
                if (!project.isOpen()) {
                    throw new ExecutionException("Execution cancelled");
                }
                SimpleJavaParameters params2 = new SimpleJavaParameters();
                params2.setCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ParametersList vm = params2.getVMParametersList();
                vm.addParametersString(ConsoleRunConfiguration.this.VM_PARAMETERS);
                boolean idePreferIPv4 = Boolean.TRUE.equals(Boolean.valueOf(System.getProperty(ConsoleRunConfiguration.PREFER_IPV4, "false")));
                boolean forced = vm.hasProperty(ConsoleRunConfiguration.PREFER_IPV4);
                if (idePreferIPv4 && !forced) {
                    vm.addProperty(ConsoleRunConfiguration.PREFER_IPV4, "true");
                }
                String hostName = System.getProperty("java.rmi.server.hostname");
                if (!vm.hasProperty("java.rmi.server.hostname") && hostName != null) {
                    vm.addProperty("java.rmi.server.hostname", hostName);
                }
                if (ConsoleRunConfiguration.this.VM_ENV != null) {
                    for (Map.Entry<String, String> entry : ConsoleRunConfiguration.this.VM_ENV.entrySet()) {
                        params2.addEnv(entry.getKey(), entry.getValue());
                    }
                }
                runContext.collectClassPath(params2.getClassPath());
                Sdk sdk = runContext.getSdk();
                if (sdk != null) {
                    params2.setJdk(sdk);
                } else {
                    params2.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                }
                params2.setWorkingDirectory(PathManager.getBinPath());
                params2.setMainClass(runContext.getMainClassName());
                runContext.tuneParams(params2);
                params2.setUseDynamicClasspath(project);
                return params2;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (runner == null) {
                    3.$$$reportNull$$$0(1);
                }
                OSProcessHandler processHandler = this.startProcess();
                DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ProcessHandler)processHandler);
                if (defaultExecutionResult == null) {
                    3.$$$reportNull$$$0(2);
                }
                return defaultExecutionResult;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler oSProcessHandler = ((SimpleJavaParameters)ReadAction.compute(() -> this.createJavaParameters())).createOSProcessHandler();
                if (oSProcessHandler == null) {
                    3.$$$reportNull$$$0(3);
                }
                return oSProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ConsoleRunConfiguration$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void setOptionsFromDataSource(LocalDataSource dataSource) {
        ParametersList params2 = new ParametersList();
        params2.addParametersString(dataSource.getVmOptions());
        String tns_admin = dataSource.getAdditionalJdbcProperties().get("TNSADMIN_DIR");
        if (tns_admin != null) {
            params2.replaceOrAppend("-Doracle.net.tns_admin=", "-Doracle.net.tns_admin=" + tns_admin);
        }
        this.VM_PARAMETERS = params2.getParametersString();
        this.VM_ENV = ContainerUtil.newLinkedHashMap(dataSource.getVmEnv());
    }

    public ConsoleRunConfiguration clone() {
        ConsoleRunConfiguration result2 = (ConsoleRunConfiguration)super.clone();
        result2.VM_PARAMETERS = this.VM_PARAMETERS;
        result2.VM_ENV = this.VM_ENV == null ? null : ContainerUtil.newLinkedHashMap(this.VM_ENV);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConfiguration";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RunContext
    extends RunnerSettings {
        public String getMainClassName();

        @Nullable
        default public Sdk getSdk() throws ExecutionException {
            return null;
        }

        public void collectClassPath(PathsList var1) throws ExecutionException;

        default public void tuneParams(@NotNull SimpleJavaParameters params2) throws ExecutionException {
            if (params2 == null) {
                RunContext.$$$reportNull$$$0(0);
            }
        }

        default public void readExternal(Element element) throws InvalidDataException {
        }

        default public void writeExternal(Element element) throws WriteExternalException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/run/ConsoleRunConfiguration$RunContext", "tuneParams"));
        }
    }
}

