/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.session.ScriptingSessionView;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.SessionStateWatcher;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQueryLanguageConsole<T, V extends ScriptingSessionView<?>>
implements DataProvider,
DataRequest.OwnerEx,
Disposable.Parent,
TxMarkerAuditor.TxMarkerHolder,
Session<T, V> {
    protected static final Logger LOG = Logger.getInstance((String)"com.intellij.database.run.AbstractQueryLanguageConsole");
    protected boolean myDisposed;
    private final AtomicReference<DataRequest.TxMarker> myCurrentTx;
    private final T myTarget;
    private final ScriptModel<?> myScriptModel;
    private final SessionStateWatcher myStateWatcher;
    private final DataBus.Consuming myMessageBus;
    private final V myView;

    public AbstractQueryLanguageConsole(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull T target, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(1);
        }
        if (target == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(2);
        }
        if (title == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(3);
        }
        if (language == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(4);
        }
        this((LanguageConsoleView)new LanguageConsoleImpl(project, title, language), messageBus, target);
    }

    public AbstractQueryLanguageConsole(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull T target) {
        if (languageConsole == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(5);
        }
        if (messageBus == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(6);
        }
        if (target == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(7);
        }
        this.myCurrentTx = new AtomicReference<DataRequest.TxMarker>(DataRequest.NONE);
        this.myMessageBus = messageBus.filterFor(this);
        this.myTarget = target;
        this.myMessageBus.addAuditor(new TxMarkerAuditor(this));
        this.myScriptModel = this.createScriptModel(languageConsole);
        this.myView = this.createSessionView(languageConsole, this.myMessageBus, this.myScriptModel);
        this.myView.getUi().getContentManager().addDataProvider((DataProvider)this);
        this.myStateWatcher = new SessionStateWatcher(this);
        Disposer.register((Disposable)this, this.myScriptModel);
        Disposer.register((Disposable)this, this.myView);
        Disposer.register((Disposable)this.getProject(), (Disposable)this);
    }

    @Override
    @NotNull
    public V getView() {
        V v = this.myView;
        if (v == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(8);
        }
        return v;
    }

    @Override
    public DataBus.Consuming getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.myCurrentTx.get();
        if (txMarker == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(9);
        }
        return txMarker;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = "console:" + this.getTitle();
        if (string == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker currentTx) {
        if (currentTx == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(11);
        }
        this.myCurrentTx.set(currentTx);
    }

    @Override
    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(12);
        }
        return t;
    }

    @NotNull
    public DataAuditor.ConsoleLogger getHistoryLogger() {
        DataAuditor.ConsoleLogger consoleLogger = this.myView.getHistoryLogger();
        if (consoleLogger == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(13);
        }
        return consoleLogger;
    }

    @NotNull
    public LanguageConsoleView getLanguageConsole() {
        LanguageConsoleView languageConsoleView = this.myView.getConsoleView();
        if (languageConsoleView == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(14);
        }
        return languageConsoleView;
    }

    @Override
    public boolean isValid() {
        return !this.myDisposed && this.myView.isValid() && this.isTargetValid();
    }

    protected boolean isTargetValid() {
        return true;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myView.getUi();
        if (runnerLayoutUi == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(15);
        }
        return runnerLayoutUi;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myView.getContent();
        if (content == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(16);
        }
        return content;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myView.getProject();
        if (project == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(17);
        }
        return project;
    }

    @NotNull
    public String getTitle() {
        String string = this.myView.getTitle();
        if (string == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> scriptModel) {
        if (scriptModel == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(19);
        }
        return this.myView.getParametersHolder().beforeExecuteQueries(scriptModel);
    }

    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> scriptModel = this.myScriptModel;
        if (scriptModel == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(20);
        }
        return scriptModel;
    }

    public void showConsole(boolean focused) {
        this.myView.show(focused, focused);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        return null;
    }

    @Override
    public boolean isIdle() {
        return this.myStateWatcher.isIdle();
    }

    public void beforeTreeDispose() {
        this.myDisposed = true;
    }

    public void dispose() {
    }

    @Nullable
    protected abstract String getHelpID();

    @NotNull
    protected abstract V createSessionView(@NotNull LanguageConsoleView var1, @NotNull DataBus.Consuming var2, @NotNull ScriptModel<?> var3);

    @NotNull
    protected abstract ScriptModel<?> createScriptModel(@NotNull LanguageConsoleView var1);

    @NotNull
    public static <T extends Session> List<T> getActiveSessions(Project project, String toolwindowId) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            List list = Collections.emptyList();
            if (list == null) {
                AbstractQueryLanguageConsole.$$$reportNull$$$0(21);
            }
            return list;
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
        if (window == null) {
            List list = Collections.emptyList();
            if (list == null) {
                AbstractQueryLanguageConsole.$$$reportNull$$$0(22);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        for (Content content : window.getContentManager().getContents()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)AbstractQueryLanguageConsole.getSession(content));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(23);
        }
        return smartList;
    }

    @NotNull
    public static Session getSession(@NotNull Content content) {
        if (content == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(24);
        }
        Session session = (Session)ObjectUtils.notNull((Object)AbstractQueryLanguageConsole.getSessionIfPresent(content));
        if (session == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(25);
        }
        return session;
    }

    @Nullable
    public static Session getSessionIfPresent(@NotNull Content content) {
        if (content == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(26);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)content.getComponent());
        return (Session)dataContext.getData(SESSION_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/AbstractQueryLanguageConsole";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTx";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/AbstractQueryLanguageConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryLogger";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageConsole";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSessions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSessionIfPresent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

