/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.oracle;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.plan.oracle.OracleExplainPlanProvider;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class OracleExplainPlanComponent
implements ConfigurableUi<LocalDataSource> {
    private final JPanel myPanel;
    private final JTextField myPlanTable = new JBTextField();

    public OracleExplainPlanComponent() {
        JBLabel label = new JBLabel("Plan table:");
        this.myPlanTable.setColumns(20);
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 2));
        GridConstraints gc = new GridConstraints();
        gc.setUseParentLayout(true);
        gc.setAnchor(8);
        gc.setFill(1);
        this.myPanel.add((Component)label, gc);
        gc.setColumn(1);
        this.myPanel.add((Component)this.myPlanTable, gc);
    }

    public void apply(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            OracleExplainPlanComponent.$$$reportNull$$$0(0);
        }
        OracleExplainPlanProvider.setExplainPlanTable(dataSource, StringUtil.nullize((String)this.myPlanTable.getText()));
    }

    public void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            OracleExplainPlanComponent.$$$reportNull$$$0(1);
        }
        this.myPlanTable.setText(OracleExplainPlanProvider.getExplainPlanTable(dataSource));
    }

    public boolean isModified(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            OracleExplainPlanComponent.$$$reportNull$$$0(2);
        }
        return !Comparing.equal((String)OracleExplainPlanProvider.getExplainPlanTable(dataSource), (String)StringUtil.nullize((String)this.myPlanTable.getText()));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            OracleExplainPlanComponent.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/oracle/OracleExplainPlanComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/oracle/OracleExplainPlanComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

