/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.openapi.util.text.StringUtil;
import java.math.BigDecimal;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanModel {
    private final GenericNode myRoot;
    private final EnumSet<Feature> myUnsupported;

    public PlanModel(@NotNull GenericNode root2, @NotNull EnumSet<Feature> unsupported) {
        if (root2 == null) {
            PlanModel.$$$reportNull$$$0(0);
        }
        if (unsupported == null) {
            PlanModel.$$$reportNull$$$0(1);
        }
        this.myRoot = root2;
        this.myUnsupported = unsupported;
    }

    @NotNull
    public EnumSet<Feature> getUnsupported() {
        EnumSet<Feature> enumSet = this.myUnsupported;
        if (enumSet == null) {
            PlanModel.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    @NotNull
    public GenericNode getRoot() {
        GenericNode genericNode = this.myRoot;
        if (genericNode == null) {
            PlanModel.$$$reportNull$$$0(3);
        }
        return genericNode;
    }

    public String dump() {
        return this.dump(false);
    }

    private static <E> String valueOf(E v) {
        return v == null ? null : v.toString();
    }

    public String dump(final boolean skeleton) {
        return new PlanVisitor(){
            int depth = 0;
            StringBuilder sb = new StringBuilder();
            {
                this.dump(PlanModel.this.getRoot());
            }

            private void appendProp(@NotNull String name, @Nullable String val) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.sb.append("<").append(name).append(" = ").append(skeleton ? (val == null ? "N" : "*") : String.valueOf(val)).append(">");
            }

            @Override
            public void visit(@NotNull GenericNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.sb.append(node.getType().toString());
                this.appendProp("title", node.getTitle());
                this.appendProp("row_num", PlanModel.valueOf(node.getPlanNumRows()));
                this.appendProp("cost", PlanModel.valueOf(node.getTotalCost()));
                this.appendProp("startup_cost", PlanModel.valueOf(node.getStartupCost()));
            }

            @Override
            public void visit(@NotNull GenericAccessNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.visit((GenericNode)node);
                this.appendProp("relation", node.getRelation());
            }

            @Override
            public void visit(@NotNull IndexScanNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.visit((GenericAccessNode)node);
                this.appendProp("index", node.getIndex());
            }

            @Override
            public void visit(@NotNull SubQueryNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.visit((GenericNode)node);
                this.appendProp("scalar", PlanModel.valueOf(node.isScalar()));
                this.appendProp("correlated", PlanModel.valueOf(node.isCorrelated()));
            }

            public void dump(@NotNull GenericNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                for (int i2 = 0; i2 < this.depth; ++i2) {
                    this.sb.append("  ");
                }
                node.accept(this);
                if (!skeleton) {
                    this.sb.append("[").append(node.getRawDescription()).append("]");
                }
                this.sb.append("\n");
                ++this.depth;
                for (GenericNode c : node.getChildren()) {
                    this.dump(c);
                }
                --this.depth;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/plan/PlanModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendProp";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dump";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.sb.toString();
    }

    @NotNull
    public static GenericNode createNode(@NotNull NodeType type, @Nullable String title) {
        if (type == null) {
            PlanModel.$$$reportNull$$$0(4);
        }
        if (type.isKindOf(NodeType.SUBQUERY)) {
            SubQueryNode subQueryNode = new SubQueryNode(type, title);
            if (subQueryNode == null) {
                PlanModel.$$$reportNull$$$0(5);
            }
            return subQueryNode;
        }
        if (type.isKindOf(NodeType.INDEX_SCAN)) {
            IndexScanNode indexScanNode = new IndexScanNode(type, title);
            if (indexScanNode == null) {
                PlanModel.$$$reportNull$$$0(6);
            }
            return indexScanNode;
        }
        if (type.isKindOf(NodeType.ACCESS)) {
            GenericAccessNode genericAccessNode = new GenericAccessNode(type, title);
            if (genericAccessNode == null) {
                PlanModel.$$$reportNull$$$0(7);
            }
            return genericAccessNode;
        }
        GenericNode genericNode = new GenericNode(type, title);
        if (genericNode == null) {
            PlanModel.$$$reportNull$$$0(8);
        }
        return genericNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsupported";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/PlanModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/PlanModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsupported";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PlanVisitor {
        public void visit(@NotNull GenericNode var1);

        public void visit(@NotNull GenericAccessNode var1);

        public void visit(@NotNull IndexScanNode var1);

        public void visit(@NotNull SubQueryNode var1);
    }

    public static class IndexScanNode
    extends GenericAccessNode {
        private String myIndex;

        public IndexScanNode(@NotNull NodeType type, @Nullable String title) {
            if (type == null) {
                IndexScanNode.$$$reportNull$$$0(0);
            }
            super(type, title);
        }

        @Nullable
        public String getIndex() {
            return this.myIndex;
        }

        public void setIndex(@Nullable String index2) {
            this.myIndex = index2;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                IndexScanNode.$$$reportNull$$$0(1);
            }
            visitor.visit(this);
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myIndex == null ? "" : " index: " + this.myIndex + ";");
            if (string == null) {
                IndexScanNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$IndexScanNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$IndexScanNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GenericAccessNode
    extends GenericNode {
        private String myRelation;

        public GenericAccessNode(@NotNull NodeType type, @Nullable String title) {
            if (type == null) {
                GenericAccessNode.$$$reportNull$$$0(0);
            }
            super(type, title);
        }

        @Nullable
        public String getRelation() {
            return this.myRelation;
        }

        public void setRelation(@Nullable String relation) {
            this.myRelation = relation;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                GenericAccessNode.$$$reportNull$$$0(1);
            }
            visitor.visit(this);
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myRelation == null ? "" : " table: " + this.myRelation + ";");
            if (string == null) {
                GenericAccessNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$GenericAccessNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$GenericAccessNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SubQueryNode
    extends GenericNode {
        private boolean myScalar;
        private boolean myCorrelated;

        public SubQueryNode(@NotNull NodeType type, @Nullable String altTitle) {
            if (type == null) {
                SubQueryNode.$$$reportNull$$$0(0);
            }
            super(type, altTitle);
        }

        public boolean isScalar() {
            return this.myScalar;
        }

        public void setScalar(boolean scalar) {
            this.myScalar = scalar;
        }

        public boolean isCorrelated() {
            return this.myCorrelated;
        }

        public void setCorrelated(boolean correlated) {
            this.myCorrelated = correlated;
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myScalar ? " Scalar;" : "") + (this.myCorrelated ? " Correlated;" : "");
            if (string == null) {
                SubQueryNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                SubQueryNode.$$$reportNull$$$0(2);
            }
            visitor.visit(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$SubQueryNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$SubQueryNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GenericNode {
        protected static final GenericNode[] NO_CHILDREN = new GenericNode[0];
        private final NodeType myType;
        private final String myTitle;
        private String myRawDescription;
        private GenericNode[] myChildren;
        private BigDecimal myNumRows;
        private Double myTotalCost;
        private Double myStartupCost;

        public GenericNode(@NotNull NodeType type, @Nullable String altTitle) {
            if (type == null) {
                GenericNode.$$$reportNull$$$0(0);
            }
            this.myRawDescription = "";
            this.myChildren = NO_CHILDREN;
            this.myType = type;
            this.myTitle = altTitle;
        }

        @NotNull
        public GenericNode[] getChildren() {
            if (this.myChildren == null) {
                GenericNode.$$$reportNull$$$0(1);
            }
            return this.myChildren;
        }

        @Nullable
        public BigDecimal getPlanNumRows() {
            return this.myNumRows;
        }

        public void setPlanNumRows(@Nullable BigDecimal numRows) {
            this.myNumRows = numRows;
        }

        public Double getTotalCost() {
            return this.myTotalCost;
        }

        public void setTotalCost(Double totalCost) {
            this.myTotalCost = totalCost;
        }

        public Double getStartupCost() {
            return this.myStartupCost;
        }

        public void setStartupCost(Double startupCost) {
            this.myStartupCost = startupCost;
        }

        @NotNull
        public String getRawDescription() {
            String string = this.myRawDescription;
            if (string == null) {
                GenericNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setRawDescription(@NotNull String rawDescription) {
            if (rawDescription == null) {
                GenericNode.$$$reportNull$$$0(3);
            }
            this.myRawDescription = rawDescription;
        }

        public void setChildren(@NotNull GenericNode[] children) {
            if (children == null) {
                GenericNode.$$$reportNull$$$0(4);
            }
            this.myChildren = children;
        }

        @NotNull
        public String getTitle() {
            String string = StringUtil.notNullize((String)this.myTitle, (String)this.myType.display);
            if (string == null) {
                GenericNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public NodeType getType() {
            NodeType nodeType = this.myType;
            if (nodeType == null) {
                GenericNode.$$$reportNull$$$0(6);
            }
            return nodeType;
        }

        @NotNull
        protected String getDisplayTitleSuffix() {
            String string = this.myTitle == null ? "" : " (" + this.myTitle + ")";
            if (string == null) {
                GenericNode.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public String getDisplayTitle() {
            String string = StringUtil.capitalize((String)this.getType().display) + this.getDisplayTitleSuffix();
            if (string == null) {
                GenericNode.$$$reportNull$$$0(8);
            }
            return string;
        }

        @NotNull
        public String getExtraInfo() {
            if ("" == null) {
                GenericNode.$$$reportNull$$$0(9);
            }
            return "";
        }

        public void accept(@NotNull PlanVisitor visitor) {
            if (visitor == null) {
                GenericNode.$$$reportNull$$$0(10);
            }
            visitor.visit(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$GenericNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawDescription";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$GenericNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawDescription";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayTitleSuffix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayTitle";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setRawDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum NodeType {
        ROOT("root", null),
        UNKNOWN("unknown", null),
        OPERATION("operation", UNKNOWN),
        LOCK_ROWS("lock rows", OPERATION),
        SEQUENTIALLY("sequentially", OPERATION),
        DATA("data", UNKNOWN),
        VALUE("value", DATA),
        TABLE_FUNCTION("table function", DATA),
        ACCESS("access", DATA),
        ROWID_ACCESS("row id access", ACCESS),
        SEQ_SCAN("full scan", ACCESS),
        INDEX_SCAN("index scan", ACCESS),
        FULL_INDEX_SCAN("full index scan", INDEX_SCAN),
        UNIQUE_INDEX_SCAN("unique index scan", INDEX_SCAN),
        BITMAP_INDEX_SCAN("bitmap index scan", INDEX_SCAN),
        TEMPORARY("temporary", UNKNOWN),
        TRANSFORM("transformation", UNKNOWN),
        AGGREGATE("aggregate", TRANSFORM),
        FILTER("filter", TRANSFORM),
        GROUP_BY("group by", TRANSFORM),
        ORDER_BY("order by", TRANSFORM),
        SORT("sort", TRANSFORM),
        UNIQUE("unique", TRANSFORM),
        HASH_UNIQUE("hash unique", UNIQUE),
        SORT_UNIQUE("sort unique", UNIQUE),
        SET_OP("set operation", UNKNOWN),
        JOIN("join", SET_OP),
        NESTED_LOOPS("nested loops", SET_OP),
        MERGE_JOIN("merge join", SET_OP),
        HASH_JOIN("hash join", SET_OP),
        UNION_ALL("union all", SET_OP),
        UNION("union", SET_OP),
        EXCEPT("except", SET_OP),
        INTERSECT("intersection", SET_OP),
        SUBQUERY("subquery", UNKNOWN),
        DIRECT_LOAD("direct load", UNKNOWN),
        NETWORK("network", UNKNOWN),
        STATEMENT("statement", null),
        SELECT("select", STATEMENT),
        MERGE("merge", STATEMENT),
        INSERT("insert", STATEMENT),
        UPDATE("update", STATEMENT),
        DELETE("delete", STATEMENT);

        public final String display;
        private final NodeType myParent;

        private NodeType(String display, NodeType parent) {
            this.display = display;
            this.myParent = parent;
        }

        public boolean isKindOf(@NotNull NodeType type) {
            if (type == null) {
                NodeType.$$$reportNull$$$0(0);
            }
            if (type == this) {
                return true;
            }
            if (this.myParent == null) {
                return false;
            }
            return this.myParent.isKindOf(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$NodeType", "isKindOf"));
        }
    }

    public static enum Feature {
        NUM_ROWS,
        TOTAL_COST,
        STARTUP_COST;

    }
}

