/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.oracle.OraModCheck;
import com.intellij.database.model.oracle.OraModForeignKey;
import com.intellij.database.model.oracle.OraModIndex;
import com.intellij.database.model.oracle.OraModKey;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModMajorObject;
import com.intellij.database.model.oracle.OraModMatLog;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModStoredSchemaObject;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.model.oracle.OraModTableTrigger;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TableOrganization;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModTable
extends OraTable,
OraModMajorObject,
OraModLikeTable,
OraModStoredSchemaObject {
    @Override
    @NotNull
    public OraModSchema getSchema();

    @Override
    @NotNull
    default public OraModSchema getParent() {
        OraModSchema oraModSchema = this.getSchema();
        if (oraModSchema == null) {
            OraModTable.$$$reportNull$$$0(0);
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends OraModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModKey> getKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModCheck> getChecks();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModTableTrigger> getTriggers();

    @NotNull
    public ModSingletonFamily<? extends OraModMatLog> getMatLogs();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers(), this.getMatLogs());
        if (list == null) {
            OraModTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setRowTypeSchemaName(@Nullable String var1);

    @Override
    public void setRowTypeObjectName(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setTablespaceName(@Nullable String var1);

    public void setTableType(@NotNull OraTableType var1);

    public void setMasterTableName(@Nullable String var1);

    public void setTemporary(boolean var1);

    public void setTemporaryPreserve(boolean var1);

    public void setOrganization(@NotNull TableOrganization var1);

    public void setClusterName(@Nullable String var1);

    public void setClusterColNames(@NotNull List<String> var1);

    default public void setClusterColNames(String ... clusterColNames) {
        this.setClusterColNames(Arrays.asList(clusterColNames));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraModTable.$$$reportNull$$$0(2);
        }
        String objectId = _properties.get("ObjectId");
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String rowTypeSchemaName = _properties.get("RowTypeSchemaName");
        String rowTypeObjectName = _properties.get("RowTypeObjectName");
        String system = _properties.get("System");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String tablespaceName = _properties.get("TablespaceName");
        String tableType = _properties.get("TableType");
        String masterTableName = _properties.get("MasterTableName");
        String temporary = _properties.get("Temporary");
        String temporaryPreserve = _properties.get("TemporaryPreserve");
        String organization = _properties.get("Organization");
        String clusterName = _properties.get("ClusterName");
        String clusterColNames = _properties.get("ClusterColNames");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setRowTypeSchemaName(rowTypeSchemaName != null ? PropertyConverter.importString(rowTypeSchemaName) : null);
        this.setRowTypeObjectName(rowTypeObjectName != null ? PropertyConverter.importString(rowTypeObjectName) : null);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate(createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate(modifiedTimestamp) : null);
        this.setTablespaceName(tablespaceName != null ? PropertyConverter.importString(tablespaceName) : null);
        this.setTableType(tableType != null ? PropertyConverter.importOraTableType(tableType) : OraTableType.BASIC);
        this.setMasterTableName(masterTableName != null ? PropertyConverter.importString(masterTableName) : null);
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean(temporary) : false);
        this.setTemporaryPreserve(temporaryPreserve != null ? PropertyConverter.importBoolean(temporaryPreserve) : false);
        this.setOrganization(organization != null ? PropertyConverter.importTableOrganization(organization) : TableOrganization.DEFAULT);
        this.setClusterName(clusterName != null ? PropertyConverter.importString(clusterName) : null);
        this.setClusterColNames(clusterColNames != null ? PropertyConverter.importListOfString(clusterColNames) : Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/oracle/OraModTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/oracle/OraModTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

