/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntHashSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDefinedTypeAttributeIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> {
    private final DatabaseFamilyId myFamilyId;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final TIntHashSet myPositions;
    private String myPrevName;

    public UserDefinedTypeAttributeIt(@Nullable ResultSet rs, @NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (familyId == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(1);
        }
        super(rs);
        this.myPositions = new TIntHashSet();
        this.myFamilyId = familyId;
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.UserDefinedTypeAttribute createStorage() {
        DatabaseMetaDataWrapper.UserDefinedTypeAttribute userDefinedTypeAttribute = new DatabaseMetaDataWrapper.UserDefinedTypeAttribute(new DatabaseMetaDataWrapper.UserDefinedType(this.mySchema));
        if (userDefinedTypeAttribute == null) {
            UserDefinedTypeAttributeIt.$$$reportNull$$$0(2);
        }
        return userDefinedTypeAttribute;
    }

    @Override
    protected DatabaseMetaDataWrapper.UserDefinedTypeAttribute calcValue() throws SQLException {
        DatabaseMetaDataWrapper.UserDefinedTypeAttribute res = (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.getStorageToFill();
        try {
            String type = this.myRs.getString("TYPE_NAME", 3);
            String cat = this.myRs.getString("TYPE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TYPE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Comparing.equal((String)this.mySchema.schema, (String)schema)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            if (StringUtil.isEmpty((String)type)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            if (!Comparing.equal((String)this.myPrevName, (String)type)) {
                this.myPositions.clear();
                this.myPrevName = type;
            }
            res.userDefinedType.name = type;
            res.name = this.myRs.getString("ATTR_NAME", 4);
            if (StringUtil.isEmpty((String)res.name)) {
                return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
            }
            res.type = this.myRs.getInt("DATA_TYPE", 5, 0);
            res.typeName = StringUtil.notNullize((String)this.myRs.getString("ATTR_TYPE_NAME", 6));
            res.length = this.myRs.getInt("ATTR_SIZE", 7, 0);
            res.scale = this.myRs.getInt("DECIMAL_DIGITS", 8, 0);
            if (this.myFamilyId.isSqlite()) {
                res.length = 0;
                res.scale = -1;
            }
            res.nullable = "yes".equalsIgnoreCase(this.myRs.getString("IS_NULLABLE", 17));
            res.def = this.myRs.getString("ATTR_DEF", 12);
            res.position = this.myRs.getInt("ORDINAL_POSITION", 16, 0);
            if (res.position == -1) {
                res.position = 0;
            }
            while (this.myPositions.contains(res.position)) {
                ++res.position;
            }
            this.myPositions.add(res.position);
            res.comment = this.myRs.getString("REMARKS", 11);
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.UserDefinedTypeAttribute)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.UserDefinedTypeAttribute cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(StringUtil.notNullize((String)cur.userDefinedType.schema.database), cur.userDefinedType.schema.schema, StringUtil.notNullize((String)cur.userDefinedType.name));
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeAttributeIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeAttributeIt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> delegate) {
            if (delegate == null) {
                Grouping.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> it) {
            final String tableName = ((DatabaseMetaDataWrapper.UserDefinedTypeAttribute)it.current()).userDefinedType.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.UserDefinedTypeAttribute item) {
                    return Comparing.equal((String)tableName, (String)item.userDefinedType.name);
                }
            };
            if (groupIt == null) {
                Grouping.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.UserDefinedType getItem(ClosableIt<DatabaseMetaDataWrapper.UserDefinedTypeAttribute> it) {
            return ((DatabaseMetaDataWrapper.UserDefinedTypeAttribute)it.current()).userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeAttributeIt$Grouping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeAttributeIt$Grouping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGroupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

