/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.ReverseCharSequence;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class MetaDataUtil {
    private static final Set<String> DEFAULT_UNLIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"integer", "clob", "blob"});
    private static final Set<String> H2_UNLIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"uuid", "geometry", "other", "array", "timestamp with time zone", "null", "result_set"});
    private static final Set<String> H2_LIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"varchar", "varchar_ignorecase", "char", "tid"});
    private static final Set<String> DB2_UNLIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"integer", "smallint", "boolean", "bigint", "double", "real", "date", "time", "xml"});
    private static final Set<String> HSQLDB_UNLIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"integer", "smallint", "bigint", "tinyint", "double", "uuid", "date"});
    private static final Set<String> DERBY_UNLIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"integer", "smallint", "bigint", "date", "time", "xml", "timestamp", "boolean", "double", "real", "float", "long varchar", "long varchar for bit data"});
    private static final Set<String> DB2_TWICE_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"graphic", "vargraphic", "dbclob"});
    private static final Set<String> SYBASE_UNLIMITED_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"int"});

    @NotNull
    private static String getSpecificName(@Nullable String specificName, @NotNull String curName, @Nullable String pack) {
        if (curName == null) {
            MetaDataUtil.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)specificName)) {
            specificName = curName;
        }
        String string = specificName = MetaDataUtil.getProcName(specificName, pack);
        if (string == null) {
            MetaDataUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getProcName(@NotNull String name, @Nullable String packageName) {
        if (name == null) {
            MetaDataUtil.$$$reportNull$$$0(2);
        }
        String string = packageName == null ? name : packageName + "/" + name;
        if (string == null) {
            MetaDataUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String qName(@Nullable BasicElement obj) {
        StringBuilder res = new StringBuilder();
        while (obj != null && obj.getKind() != ObjectKind.ROOT) {
            if (res.length() != 0) {
                res.append(".");
            }
            res.append((CharSequence)new ReverseCharSequence((CharSequence)obj.getName()));
            obj = obj.getParent();
        }
        String string = res.reverse().toString();
        if (string == null) {
            MetaDataUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String qName(String ... s) {
        if (s == null) {
            MetaDataUtil.$$$reportNull$$$0(5);
        }
        String string = StringUtil.join((String[])s, (String)".");
        if (string == null) {
            MetaDataUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    static void processForBitData(@NotNull String typeName, @NotNull DatabaseMetaDataWrapper.TypedElement e) {
        String forBitData;
        if (typeName == null) {
            MetaDataUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            MetaDataUtil.$$$reportNull$$$0(8);
        }
        if (typeName.endsWith(forBitData = " () for bit data")) {
            int end = e.typeName.length() - forBitData.length();
            e.typeSuffix = e.typeName.substring(end + 4);
            e.typeName = e.typeName.substring(0, end);
        }
    }

    static void adjustType(@NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaDataWrapper.TypedElement e) {
        String t;
        if (familyId == null) {
            MetaDataUtil.$$$reportNull$$$0(9);
        }
        if (e == null) {
            MetaDataUtil.$$$reportNull$$$0(10);
        }
        if ((t = e.typeName) == null) {
            return;
        }
        t = StringUtil.toLowerCase((String)t);
        int n = e.length;
        if (familyId.isDb2()) {
            if (DB2_UNLIMITED_TYPES.contains(t) || e.length == 0) {
                e.length = -1;
            } else if (t.equals("timestamp")) {
                e.length = e.scale;
                e.scale = 0;
            } else if (DB2_TWICE_TYPES.contains(t)) {
                e.length /= 2;
            }
            MetaDataUtil.processForBitData(t, e);
        } else if (familyId.isHsqldb()) {
            long oneGb = 0x40000000L;
            long sixteenMb = 0x1000000L;
            if (HSQLDB_UNLIMITED_TYPES.contains(t) || e.length == 0) {
                e.length = -1;
            }
            if (t.startsWith("time") || t.startsWith("timestamp") || t.startsWith("interval")) {
                e.length = -1;
            }
            if ((t.equals("clob") || t.equals("blob")) && (long)e.length == oneGb) {
                e.length = -1;
            }
            if (t.equals("varbinary") && (long)e.length == sixteenMb) {
                e.length = -1;
            }
            if ((t.equals("numeric") || t.equals("decimal")) && e.length == 128) {
                e.length = -1;
            }
        } else if (familyId.isDerby()) {
            if (DERBY_UNLIMITED_TYPES.contains(t) || DEFAULT_UNLIMITED_TYPES.contains(t) && n == Integer.MAX_VALUE) {
                e.length = -1;
            }
            MetaDataUtil.processForBitData(t, e);
        } else if (familyId.isSybase()) {
            if (SYBASE_UNLIMITED_TYPES.contains(t)) {
                e.length = -1;
            }
        } else if (familyId.isMysql()) {
            String us = " unsigned";
            if (StringUtil.endsWithIgnoreCase((String)e.typeName, (String)us)) {
                int end = e.typeName.length() - us.length();
                e.typeSuffix = e.typeName.substring(end + 1);
                e.typeName = e.typeName.substring(0, end);
            }
        } else if (familyId.isSqlite()) {
            e.length = -1;
            e.scale = 0;
        } else if (familyId.isH2()) {
            if (n == 1 && "boolean".equals(t)) {
                e.length = -1;
            } else if (n == 0x7FFFFFFE) {
                e.length = Integer.MAX_VALUE;
            } else if (H2_UNLIMITED_TYPES.contains(t) || t.equals("decimal") && e.scale == Short.MAX_VALUE && e.length == 65535) {
                e.length = -1;
            } else if (t.equals("varbinary")) {
                e.typeName = "binary";
                if (e.length == Integer.MAX_VALUE) {
                    e.length = -1;
                }
            } else if (H2_LIMITED_TYPES.contains(t) && e.length == Integer.MAX_VALUE) {
                e.length = -1;
            }
        } else if (DEFAULT_UNLIMITED_TYPES.contains(t)) {
            e.length = -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecificName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcName";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProcName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processForBitData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RemoteResultSetWrapper
    extends ResultSetWrapper {
        private final RemoteResultSet myResultSet;
        @Nullable
        private List<Object[]> myRows;
        private int myPosition;
        private boolean myFinished;

        public RemoteResultSetWrapper(@NotNull ResultSet rs, @NotNull RemoteResultSet remoteResultSet) throws SQLException {
            if (rs == null) {
                RemoteResultSetWrapper.$$$reportNull$$$0(0);
            }
            if (remoteResultSet == null) {
                RemoteResultSetWrapper.$$$reportNull$$$0(1);
            }
            super(rs);
            this.myResultSet = remoteResultSet;
        }

        @Override
        public boolean next() throws SQLException {
            if (this.myFinished) {
                return false;
            }
            ++this.myPosition;
            if (this.myRows == null || this.myPosition == this.myRows.size()) {
                this.myFinished = this.myRows != null && this.myRows.size() < 100;
                try {
                    RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(UnknownDatabase.RDBMS, Calendar.getInstance(), 100, 204800, false);
                    this.myRows = this.myFinished ? null : this.myResultSet.getObjects(options);
                }
                catch (RemoteException e) {
                    this.myRows = null;
                    throw new SQLException(e);
                }
                this.myPosition = 0;
            }
            return this.myRows != null && !this.myRows.isEmpty();
        }

        @Override
        @Nullable
        public Object getObject(String column2, int colNum) {
            int i2 = this.getColumnIndex(column2, colNum);
            return i2 == 0 ? null : ((Object[])((List)ObjectUtils.assertNotNull(this.myRows)).get(this.myPosition))[i2 - 1];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "remoteResultSet";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$RemoteResultSetWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class LocalResultSetWrapper
    extends ResultSetWrapper {
        public LocalResultSetWrapper(@NotNull ResultSet rs) throws SQLException {
            if (rs == null) {
                LocalResultSetWrapper.$$$reportNull$$$0(0);
            }
            super(rs);
        }

        @Override
        public boolean next() throws SQLException {
            return this.myDelegate.next();
        }

        @Override
        @Nullable
        public Object getObject(String column2, int colNum) throws SQLException {
            int i2 = this.getColumnIndex(column2, colNum);
            return i2 == 0 ? null : this.myDelegate.getObject(i2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$LocalResultSetWrapper", "<init>"));
        }
    }

    public static abstract class ResultSetWrapper {
        protected final ResultSet myDelegate;
        protected final TObjectIntHashMap<String> myColumnMap;
        protected final int myColumnCount;

        public ResultSetWrapper(ResultSet rs) throws SQLException {
            this.myDelegate = rs;
            this.myColumnMap = new TObjectIntHashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ResultSetMetaData metaData = rs == null ? null : rs.getMetaData();
            this.myColumnCount = metaData == null ? 0 : metaData.getColumnCount();
            for (int i2 = 0; i2 < this.myColumnCount; ++i2) {
                this.myColumnMap.put((Object)metaData.getColumnName(i2 + 1), i2 + 1);
                this.myColumnMap.put((Object)metaData.getColumnLabel(i2 + 1), i2 + 1);
            }
        }

        @Contract(value="!null->!null")
        public static ResultSetWrapper wrap(@Nullable ResultSet rs) throws SQLException {
            if (rs == null) {
                return ResultSetWrapper.createEmpty();
            }
            RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemote((Object)rs, RemoteResultSet.class);
            if (remoteResultSet != null) {
                return new RemoteResultSetWrapper(rs, remoteResultSet);
            }
            return new LocalResultSetWrapper(rs);
        }

        @NotNull
        private static ResultSetWrapper createEmpty() throws SQLException {
            ResultSetWrapper resultSetWrapper = new ResultSetWrapper(null){

                @Override
                public boolean next() throws SQLException {
                    return false;
                }

                @Override
                @NotNull
                public Object getObject(String column2, int colNum) throws SQLException {
                    throw new IllegalStateException();
                }
            };
            if (resultSetWrapper == null) {
                ResultSetWrapper.$$$reportNull$$$0(0);
            }
            return resultSetWrapper;
        }

        public static void close(@Nullable ResultSetWrapper wrapper) {
            try {
                ResultSet delegate;
                ResultSet resultSet = delegate = wrapper == null ? null : wrapper.myDelegate;
                if (delegate != null) {
                    delegate.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public abstract boolean next() throws SQLException;

        @Nullable
        public abstract Object getObject(String var1, int var2) throws SQLException;

        public boolean getBoolean(String column2, int colNum) throws SQLException {
            return Boolean.TRUE.equals(this.getObject(column2, colNum));
        }

        public int getInt(String column2, int colNum, int def2) throws SQLException {
            Object o = this.getObject(column2, colNum);
            return o instanceof Number ? ((Number)o).intValue() : (o instanceof String ? StringUtil.parseInt((String)((String)o), (int)def2) : def2);
        }

        public short getShort(String column2, int colNum) throws SQLException {
            Object o = this.getObject(column2, colNum);
            return o instanceof Number ? ((Number)o).shortValue() : (short)0;
        }

        @Nullable
        public String getString(String column2, int colNum) throws SQLException {
            Object o = this.getObject(column2, colNum);
            return o instanceof String ? (String)o : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <T> List<T> list(@NotNull String columnName, int colNum, @Nullable PairConsumer<String, Throwable> errorSink2) throws SQLException {
            if (columnName == null) {
                ResultSetWrapper.$$$reportNull$$$0(1);
            }
            ArrayList<Object> retVal = new ArrayList<Object>();
            try {
                while (this.next()) {
                    retVal.add(this.getObject(columnName, colNum));
                }
            }
            catch (SQLException sQLException) {
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (errorSink2 != null) {
                    errorSink2.consume(message.contains(columnName) ? null : columnName + " unavailable", (Object)e);
                }
            }
            finally {
                JdbcUtil.closeResultSetSafe((ResultSet)this.myDelegate);
            }
            ArrayList<Object> arrayList = retVal;
            if (arrayList == null) {
                ResultSetWrapper.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        protected int getColumnIndex(String column2, int colNum) {
            int i2 = this.myColumnMap.get((Object)column2);
            if (i2 == 0) {
                i2 = colNum;
            } else if (i2 != colNum) {
                // empty if block
            }
            return i2 < 1 || i2 > this.myColumnCount ? 0 : i2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$ResultSetWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEmpty";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$ResultSetWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "list";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SpecNamer {
        TObjectIntHashMap<String> counts = new TObjectIntHashMap();

        @NotNull
        public String getSpecName(@Nullable String spec, @NotNull String name, @Nullable String cat) {
            if (name == null) {
                SpecNamer.$$$reportNull$$$0(0);
            }
            if (spec == null || Comparing.equal((String)spec, (String)name)) {
                String nonSpec = MetaDataUtil.getSpecificName(name, name, cat);
                int cnt = 0;
                if (this.counts.containsKey((Object)nonSpec)) {
                    cnt = this.counts.get((Object)nonSpec);
                }
                this.counts.put((Object)nonSpec, cnt);
                spec = name + "&&DG_" + cnt;
            }
            String string = (String)ObjectUtils.assertNotNull((Object)MetaDataUtil.getSpecificName(spec, name, cat));
            if (string == null) {
                SpecNamer.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void finish(@Nullable String spec, @NotNull String name, @Nullable String cat) {
            if (name == null) {
                SpecNamer.$$$reportNull$$$0(2);
            }
            if (spec == null || Comparing.equal((String)spec, (String)name)) {
                String nonSpec = MetaDataUtil.getSpecificName(name, name, cat);
                int cnt = 0;
                if (this.counts.containsKey((Object)nonSpec)) {
                    cnt = this.counts.get((Object)nonSpec);
                }
                this.counts.put((Object)nonSpec, ++cnt);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$SpecNamer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/MetaDataUtil$SpecNamer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpecName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpecName";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "finish";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

