/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.queryRewriting.CommonPreprocessor;
import com.intellij.database.queryRewriting.Evaluator;
import com.intellij.database.queryRewriting.MapEvaluator;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b6\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b*\b\b\u0004\u0010\t*\u00020\n*\b\b\u0005\u0010\u000b*\u00020\f*\b\b\u0006\u0010\r*\u00020\f2\u00020\u000e:\u0006\u00cf\u0001\u00d0\u0001\u00d1\u0001BG\b\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00040\u0012\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00060\u0012\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020 H\u0016J\u0016\u0010i\u001a\u00028\u00002\u0006\u0010?\u001a\u00020\u0002H\u0083\b\u00a2\u0006\u0002\u0010jJK\u0010k\u001a00lR,\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u00060\u00002\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00028\u0003H$\u00a2\u0006\u0002\u0010pJ\r\u0010q\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010AJK\u0010r\u001a00sR,\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u00060\u00002\u0006\u0010m\u001a\u00020n2\u0006\u0010t\u001a\u00028\u0005H$\u00a2\u0006\u0002\u0010uJ\b\u0010v\u001a\u00020gH\u0016J!\u0010w\u001a\u00020g2\u0006\u0010x\u001a\u00020.2\u000e\b\u0004\u0010y\u001a\b\u0012\u0004\u0012\u00020g0zH\u0084\bJ=\u0010{\u001a\u0002H|\"\u0004\b\u0007\u0010|2&\b\u0004\u0010}\u001a \u0012\u0016\u0012\u00140\u007f\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0082\u0001\u0012\u0004\u0012\u0002H|0~H\u0084\b\u00a2\u0006\u0003\u0010\u0083\u0001J7\u0010{\u001a\u00020g2&\b\u0004\u0010}\u001a \u0012\u0016\u0012\u00140\u007f\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0082\u0001\u0012\u0004\u0012\u00020g0~H\u0085\b\u00a2\u0006\u0003\b\u0084\u0001J>\u0010\u0085\u0001\u001a\u0002H|\"\u0004\b\u0007\u0010|2&\b\u0004\u0010}\u001a \u0012\u0016\u0012\u00140n\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0086\u0001\u0012\u0004\u0012\u0002H|0~H\u0084\b\u00a2\u0006\u0003\u0010\u0083\u0001J8\u0010\u0085\u0001\u001a\u00020g2&\b\u0004\u0010}\u001a \u0012\u0016\u0012\u00140n\u00a2\u0006\u000f\b\u0080\u0001\u0012\n\b\u0081\u0001\u0012\u0005\b\b(\u0086\u0001\u0012\u0004\u0012\u00020g0~H\u0085\b\u00a2\u0006\u0003\b\u0087\u0001J\u0013\u0010\u0088\u0001\u001a\u00020g2\b\u0010?\u001a\u0004\u0018\u00010\u0002H\u0016J\t\u0010\u0089\u0001\u001a\u00020gH\u0014J\t\u0010\u008a\u0001\u001a\u00020gH\u0014J'\u0010\u008b\u0001\u001a\u00020g2\u0016\u0010\u008c\u0001\u001a\f\u0012\u0007\b\u0001\u0012\u00030\u008e\u00010\u008d\u0001\"\u00030\u008e\u0001H\u0016\u00a2\u0006\u0003\u0010\u008f\u0001J%\u0010\u0090\u0001\u001a\u00020g2\u0007\u0010\u0086\u0001\u001a\u00020n2\u0011\u0010\u008c\u0001\u001a\f\u0012\u0005\u0012\u00030\u008e\u0001\u0018\u00010\u0091\u0001H$JB\u0010\u0092\u0001\u001a\u00020g2\b\u0010\u0093\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u0094\u0001\u001a\u00020\u00182\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0014\u0010\u0097\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020.0\u008d\u0001\"\u00020.H\u0016\u00a2\u0006\u0003\u0010\u0098\u0001J\t\u0010\u0099\u0001\u001a\u00020gH\u0016J\u0012\u0010\u009a\u0001\u001a\u00020g2\u0007\u0010\u0086\u0001\u001a\u00020nH$J8\u0010\u009b\u0001\u001a\u0017\u0012\u0005\u0012\u00030\u009d\u0001\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020.0\u008d\u00010\u009c\u00012\u000f\u0010\u009e\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009f\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u0018H\u0016J@\u0010\u009b\u0001\u001a\u00020g2\u000f\u0010\u009e\u0001\u001a\n\u0012\u0005\u0012\u00030\u009d\u00010\u009f\u00012\u0007\u0010\u00a0\u0001\u001a\u00020\u00182\u001b\u0010\u00a1\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u009d\u0001\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020.0\u008d\u00010_H&J\t\u0010\u00a2\u0001\u001a\u00020gH\u0004J \u0010\u00a2\u0001\u001a\u00020g2\u0007\u0010\u00a3\u0001\u001a\u00028\u00022\u0006\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0003\u0010\u00a4\u0001J\t\u0010\u00a5\u0001\u001a\u00020gH\u0016J\t\u0010\u00a6\u0001\u001a\u00020gH\u0016J\u0012\u0010\u00a6\u0001\u001a\u00020g2\u0007\u0010\u0086\u0001\u001a\u00020nH\u0014J \u0010\u00a7\u0001\u001a\u00020\u00182\u0007\u0010\u0086\u0001\u001a\u00020n2\u0006\u0010t\u001a\u00028\u0005H\u0014\u00a2\u0006\u0003\u0010\u00a8\u0001J1\u0010\u00a9\u0001\u001a\u00020g2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\u0007\u0010\u00ac\u0001\u001a\u00020.2\u0013\b\u0002\u0010\u00ad\u0001\u001a\f\u0018\u00010\u00ae\u0001j\u0005\u0018\u0001`\u00af\u0001H\u0002J\u0011\u0010\u00b0\u0001\u001a\u00020\u00182\u0006\u0010?\u001a\u00020\u0002H\u0014J-\u0010\u00b1\u0001\u001a\u0002H\u0003\"\u0004\b\u0007\u0010\u00032\u0006\u0010m\u001a\u00020n2\u000e\u0010\u00b2\u0001\u001a\t\u0012\u0004\u0012\u0002H\u00030\u00b3\u0001H\u0004\u00a2\u0006\u0003\u0010\u00b4\u0001J%\u0010\u00b1\u0001\u001a\u0002H\u0003\"\u0004\b\u0007\u0010\u00032\u000e\u0010\u00b2\u0001\u001a\t\u0012\u0004\u0012\u0002H\u00030\u00b3\u0001H\u0004\u00a2\u0006\u0003\u0010\u00b5\u0001JC\u0010\u00b6\u0001\u001a\u0002H\u0003\"\u0004\b\u0007\u0010\u00032\u0006\u0010m\u001a\u00020n2\u000e\u0010\u00b2\u0001\u001a\t\u0012\u0004\u0012\u0002H\u00030\u00b3\u00012\u0014\b\u0002\u0010\u00b7\u0001\u001a\r\u0012\u0006\b\u0001\u0012\u00020`\u0018\u00010\u008d\u0001H\u0002\u00a2\u0006\u0003\u0010\u00b8\u0001J\t\u0010\u00b9\u0001\u001a\u00020gH\u0004J\u0012\u0010\u00ba\u0001\u001a\u00020g2\u0007\u0010\u00a3\u0001\u001a\u00020\u0006H\u0004J\u001d\u0010\u00bb\u0001\u001a\u00020g2\u0007\u0010\u0081\u0001\u001a\u00020.2\t\u0010\u00bc\u0001\u001a\u0004\u0018\u00010`H\u0004J\u0012\u0010\u00bd\u0001\u001a\u00020g2\u0007\u0010\u00be\u0001\u001a\u00020.H\u0004J\u001b\u0010\u00bf\u0001\u001a\u00020g2\u0007\u0010\u00c0\u0001\u001a\u00020.2\u0007\u0010\u00be\u0001\u001a\u00020.H\u0004J\u0017\u0010\u00c1\u0001\u001a\u00020\u00182\u0006\u0010t\u001a\u00028\u0005H\u0014\u00a2\u0006\u0003\u0010\u00c2\u0001J\u001b\u0010\u00c3\u0001\u001a\u00020g2\u000f\b\u0004\u0010\u00c4\u0001\u001a\b\u0012\u0004\u0012\u00020g0zH\u0084\bJ\r\u0010\u00c5\u0001\u001a\u00020.*\u00020.H\u0004JC\u0010\u00c6\u0001\u001a\u00020g\"\u0004\b\u0007\u0010\u000b*\u0012\u0012\r\b\u0001\u0012\t\u0012\u0004\u0012\u0002H\u000b0\u009f\u00010\u00c7\u00012\b\u0010\u00c8\u0001\u001a\u00030\u00c9\u00012\u0013\u0010\u00ca\u0001\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020g0~H\u0084\bJ=\u0010\u00cb\u0001\u001a\t\u0012\u0004\u0012\u0002H|0\u008d\u0001\"\u0004\b\u0007\u0010|*\t\u0012\u0004\u0012\u0002H|0\u008d\u00012\u0013\u0010\u00cc\u0001\u001a\u000e\u0012\u0004\u0012\u0002H|\u0012\u0004\u0012\u0002H|0~H\u0084\b\u00a2\u0006\u0003\u0010\u00cd\u0001J7\u0010\u00cb\u0001\u001a\t\u0012\u0004\u0012\u0002H|0\u00ce\u0001\"\u0004\b\u0007\u0010|*\t\u0012\u0004\u0012\u0002H|0\u00ce\u00012\u0013\u0010\u00cc\u0001\u001a\u000e\u0012\u0004\u0012\u0002H|\u0012\u0004\u0012\u0002H|0~H\u0084\bR\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 @BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010'\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020&@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R&\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u00188DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u001aR\u0014\u00106\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00040\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010;R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010;R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00060\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010;R\u0014\u0010?\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u0014\u0010H\u001a\u00028\u00018EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR*\u0010K\u001a\u0004\u0018\u00018\u00002\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000@BX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010O\u001a\u0004\bL\u0010A\"\u0004\bM\u0010NR\u001a\u0010P\u001a\u00020QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u0010\u0010V\u001a\u00020W8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010X\u001a\u0004\u0018\u00010YX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001c\u0010^\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020`0_8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010bR$\u0010c\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020&@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010)\"\u0004\be\u0010+\u00a8\u0006\u00d2\u0001"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector;", "MM", "Lcom/intellij/database/model/basic/BasicModModel;", "R", "Lcom/intellij/database/model/basic/BasicRoot;", "MR", "Lcom/intellij/database/model/basic/BasicModRoot;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "MD", "Lcom/intellij/database/model/basic/BasicModDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "MS", "Lcom/intellij/database/introspection/DBIntrospector;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "modModelClass", "Ljava/lang/Class;", "modRootClass", "modDatabaseClass", "modSchemaClass", "(Lorg/jetbrains/dekaf/Rdbms;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)V", "considerSystemSchemasReinstrospection", "", "getConsiderSystemSchemasReinstrospection", "()Z", "dbConnectionInfo", "Lorg/jetbrains/dekaf/core/ConnectionInfo;", "getDbConnectionInfo", "()Lorg/jetbrains/dekaf/core/ConnectionInfo;", "<set-?>", "Lorg/jetbrains/dekaf/core/DBFacade;", "dbFacade", "getDbFacade", "()Lorg/jetbrains/dekaf/core/DBFacade;", "setDbFacade", "(Lorg/jetbrains/dekaf/core/DBFacade;)V", "Lorg/jetbrains/dekaf/util/Version;", "driverVersion", "getDriverVersion", "()Lorg/jetbrains/dekaf/util/Version;", "setDriverVersion", "(Lorg/jetbrains/dekaf/util/Version;)V", "errorSink", "Lcom/intellij/util/PairConsumer;", "", "", "getErrorSink", "()Lcom/intellij/util/PairConsumer;", "setErrorSink", "(Lcom/intellij/util/PairConsumer;)V", "initialized", "getInitialized", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "getModDatabaseClass", "()Ljava/lang/Class;", "getModModelClass", "getModRootClass", "getModSchemaClass", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "getModelFactory$intellij_database_introspection", "()Lcom/intellij/database/model/impl/ModelFactory;", "setModelFactory$intellij_database_introspection", "(Lcom/intellij/database/model/impl/ModelFactory;)V", "modelRoot", "getModelRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "myModel", "getMyModel", "setMyModel", "(Lcom/intellij/database/model/basic/BasicModModel;)V", "Lcom/intellij/database/model/basic/BasicModModel;", "options", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "getOptions", "()Lcom/intellij/database/introspection/DBIntrospectionOptions;", "setOptions", "(Lcom/intellij/database/introspection/DBIntrospectionOptions;)V", "preprocessor", "Lcom/intellij/database/queryRewriting/CommonPreprocessor;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "queryParameters", "", "", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "serverVersion", "getServerVersion", "setServerVersion", "attachToDB", "", "db", "castModel", "(Lcom/intellij/database/model/basic/BasicModModel;)Lcom/intellij/database/model/basic/BasicModModel;", "createDatabaseRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicDatabase;)Lcom/intellij/database/introspection/BaseIntrospector$AbstractDatabaseRetriever;", "createNewModel", "createSchemaRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "schema", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;)Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "detachFromDB", "handleErrors", "operationName", "operation", "Lkotlin/Function0;", "inSession", "T", "block", "Lkotlin/Function1;", "Lorg/jetbrains/dekaf/core/DBSession;", "Lkotlin/ParameterName;", "name", "session", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inSessionUnit", "inTransaction", "tran", "inTransactionUnit", "init", "initConnectionRelatedState", "initModelRelatedState", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectAutoInTran", "", "introspectFragment", "namespace", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespaces", "introspectNamespacesInTran", "introspectNativeDefinitions", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "withNestedElements", "result", "introspectServerInfo", "root", "(Lcom/intellij/database/model/basic/BasicModRoot;Lorg/jetbrains/dekaf/core/DBFacade;)V", "introspectServerObjects", "introspectSessionState", "isPossibleToIntrospectSchemaIncrementally", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;)Z", "logQueryDebugInfo", "time1", "", "queryDisplayName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "modelCanBeAccepted", "performQuery", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "performTheQuery", "parameters", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lorg/jetbrains/dekaf/sql/SqlQuery;[Ljava/lang/Object;)Ljava/lang/Object;", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "setQueryParameter", "value", "updateDetails", "details", "updateStatus", "status", "whetherSourcesActual", "(Lcom/intellij/database/model/basic/BasicSchema;)Z", "writeSources", "r", "dbIntern", "forEachByPack", "Lorg/jetbrains/dekaf/core/DBQueryRunner;", "limit", "", "action", "inplace", "t", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "", "AbstractDatabaseRetriever", "AbstractRetriever", "AbstractSchemaRetriever", "intellij.database.introspection"})
public abstract class BaseIntrospector<MM extends BasicModModel, R extends BasicRoot, MR extends BasicModRoot, D extends BasicDatabase, MD extends BasicModDatabase, S extends BasicSchema, MS extends BasicSchema>
implements DBIntrospector {
    @Nullable
    private ModelFactory modelFactory;
    @NotNull
    private PairConsumer<String, Throwable> errorSink;
    private final boolean considerSystemSchemasReinstrospection;
    @NotNull
    private final Logger log;
    @Nullable
    private MM myModel;
    @NotNull
    private DBIntrospectionOptions options;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private DBFacade dbFacade;
    @NotNull
    private Version serverVersion;
    @NotNull
    private Version driverVersion;
    @JvmField
    @NotNull
    protected final Map<String, Object> queryParameters;
    @JvmField
    @NotNull
    protected final CommonPreprocessor preprocessor;
    @NotNull
    private final Rdbms rdbms;
    @NotNull
    private final Class<MM> modModelClass;
    @NotNull
    private final Class<MR> modRootClass;
    @NotNull
    private final Class<MD> modDatabaseClass;
    @NotNull
    private final Class<MS> modSchemaClass;

    @Nullable
    public final ModelFactory getModelFactory$intellij_database_introspection() {
        return this.modelFactory;
    }

    public final void setModelFactory$intellij_database_introspection(@Nullable ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Override
    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.errorSink;
    }

    @Override
    public void setErrorSink(@NotNull PairConsumer<String, Throwable> pairConsumer) {
        Intrinsics.checkParameterIsNotNull(pairConsumer, (String)"<set-?>");
        this.errorSink = pairConsumer;
    }

    protected final boolean getConsiderSystemSchemasReinstrospection() {
        return this.considerSystemSchemasReinstrospection;
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    @Nullable
    protected final MM getMyModel() {
        return this.myModel;
    }

    private final void setMyModel(MM MM) {
        this.myModel = MM;
    }

    @NotNull
    protected final R getModelRoot() {
        BasicRoot basicRoot = this.getModel().getRoot();
        if (basicRoot == null) {
            throw new TypeCastException("null cannot be cast to non-null type R");
        }
        return (R)basicRoot;
    }

    @Override
    @NotNull
    public final DBIntrospectionOptions getOptions() {
        return this.options;
    }

    @Override
    public final void setOptions(@NotNull DBIntrospectionOptions dBIntrospectionOptions) {
        Intrinsics.checkParameterIsNotNull((Object)dBIntrospectionOptions, (String)"<set-?>");
        this.options = dBIntrospectionOptions;
    }

    @Override
    @Nullable
    public final ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    @Override
    public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    @Nullable
    protected final DBFacade getDbFacade() {
        return this.dbFacade;
    }

    private final void setDbFacade(DBFacade dBFacade) {
        this.dbFacade = dBFacade;
    }

    @NotNull
    protected final Version getServerVersion() {
        return this.serverVersion;
    }

    private final void setServerVersion(Version version) {
        this.serverVersion = version;
    }

    @NotNull
    protected final Version getDriverVersion() {
        return this.driverVersion;
    }

    private final void setDriverVersion(Version version) {
        this.driverVersion = version;
    }

    protected final boolean getInitialized() {
        return this.myModel != null && this.dbFacade != null;
    }

    @Override
    public void init(@Nullable BasicModModel model) {
        Object object;
        if (this.myModel != null) {
            throw (Throwable)new IllegalStateException("" + this.getClass().getSimpleName() + " is already initialized");
        }
        BaseIntrospector baseIntrospector = this;
        if (model != null && this.modelCanBeAccepted(model)) {
            BaseIntrospector baseIntrospector2 = this;
            BaseIntrospector baseIntrospector3 = baseIntrospector;
            BasicModModel basicModModel = model;
            baseIntrospector = baseIntrospector3;
            object = basicModModel;
        } else {
            object = this.createNewModel();
        }
        baseIntrospector.myModel = object;
        this.initModelRelatedState();
    }

    private final MM castModel(BasicModModel model) {
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type MM");
        }
        return (MM)basicModModel;
    }

    protected boolean modelCanBeAccepted(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return this.modModelClass.isAssignableFrom(model.getClass());
    }

    protected void initModelRelatedState() {
    }

    protected void initConnectionRelatedState() {
    }

    @NotNull
    protected MM createNewModel() {
        Object object = this.modelFactory;
        if (object == null || (object = (BasicModModel)((ModelFactory)object).createModel(this.rdbms, this.modModelClass)) == null) {
            throw (Throwable)new IllegalStateException("Model Factory is not specified");
        }
        return (MM)object;
    }

    @NotNull
    public MM getModel() {
        MM MM;
        if (this.myModel != null) {
            MM = this.myModel;
            if (MM == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new IllegalStateException("The introspector is not initialized yet: model is not created");
        }
        return MM;
    }

    @Override
    public void attachToDB(@NotNull DBFacade db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        boolean bl = Intrinsics.areEqual((Object)db.rdbms(), (Object)this.rdbms);
        if (_Assertions.ENABLED && !bl) {
            String string = "" + this.getClass().getSimpleName() + " expects a connection to " + this.rdbms + " but got to " + db.rdbms() + " that is not good";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.dbFacade != null) {
            this.detachFromDB();
        }
        this.dbFacade = db;
        ConnectionInfo connectionInfo = db.getConnectionInfo();
        Version version = connectionInfo.serverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"connectionInfo.serverVersion");
        this.serverVersion = version;
        Version version2 = connectionInfo.driverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"connectionInfo.driverVersion");
        this.driverVersion = version2;
        this.initConnectionRelatedState();
    }

    @Override
    public void detachFromDB() {
        this.dbFacade = null;
        Version version = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
    }

    @NotNull
    protected final ConnectionInfo getDbConnectionInfo() {
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        ConnectionInfo connectionInfo = dbf.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionInfo, (String)"dbf.connectionInfo");
        return connectionInfo;
    }

    protected final <T> T inSession(@NotNull Function1<? super DBSession, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        Object result2 = dbf.inSession(new InSession<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                return (T)this.$block.invoke((Object)session);
            }
            {
                this.$block = function1;
            }
        });
        return (T)result2;
    }

    @JvmName(name="inSessionUnit")
    protected final void inSessionUnit(@NotNull Function1<? super DBSession, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        dbf.inSession(new InSessionNoResult(block){
            final /* synthetic */ Function1 $block;

            public final void run(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                this.$block.invoke((Object)session);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final <T> T inTransaction(@NotNull Function1<? super DBTransaction, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        Object result2 = dbf.inTransaction(new InTransaction<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                return (T)this.$block.invoke((Object)tran);
            }
            {
                this.$block = function1;
            }
        });
        return (T)result2;
    }

    @JvmName(name="inTransactionUnit")
    protected final void inTransactionUnit(@NotNull Function1<? super DBTransaction, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        dbf.inTransaction(new InTransactionNoResult(block){
            final /* synthetic */ Function1 $block;

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                this.$block.invoke((Object)tran);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final void setQueryParameter(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (value != null) {
            Map<String, Object> map = this.queryParameters;
            Object object = value;
            map.put(name, object);
        } else {
            this.queryParameters.remove(name);
        }
    }

    protected final <R> R performQuery(@NotNull SqlQuery<R> query) {
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        SqlQuery preprocessedQuery = query.rewrite((StringOperator)this.preprocessor);
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        Object result$iv = dbf$iv.inTransaction(new InTransaction<R>(this, preprocessedQuery){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ SqlQuery $preprocessedQuery$inlined;
            {
                this.this$0 = baseIntrospector;
                this.$preprocessedQuery$inlined = sqlQuery;
            }

            public final R run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction transaction = tran;
                SqlQuery sqlQuery = this.$preprocessedQuery$inlined;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"preprocessedQuery");
                return (R)BaseIntrospector.access$performTheQuery(this.this$0, transaction, sqlQuery, this.this$0.preprocessor.getBindableParameters());
            }
        });
        return (R)result$iv;
    }

    protected final <R> R performQuery(@NotNull DBTransaction transaction, @NotNull SqlQuery<R> query) {
        SqlQuery preprocessedQuery;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        SqlQuery sqlQuery = preprocessedQuery = query.rewrite((StringOperator)this.preprocessor);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"preprocessedQuery");
        return this.performTheQuery(transaction, sqlQuery, this.preprocessor.getBindableParameters());
    }

    private final <R> R performTheQuery(DBTransaction transaction, SqlQuery<R> query, Object[] parameters) {
        Object result2;
        String string = query.getDisplayName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String queryDisplayName = string;
        this.log.debug("Query " + queryDisplayName + " started");
        DBQueryRunner queryRunner = transaction.query(query);
        if (parameters != null) {
            queryRunner.withParams(Arrays.copyOf(parameters, parameters.length));
        }
        long time1 = System.currentTimeMillis();
        try {
            result2 = queryRunner.run();
            BaseIntrospector.logQueryDebugInfo$default(this, time1, queryDisplayName, null, 4, null);
        }
        catch (DBException e) {
            this.logQueryDebugInfo(time1, queryDisplayName, (Exception)((Object)e));
            throw (Throwable)e;
        }
        return (R)result2;
    }

    static /* bridge */ /* synthetic */ Object performTheQuery$default(BaseIntrospector baseIntrospector, DBTransaction dBTransaction, SqlQuery sqlQuery, Object[] objectArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performTheQuery");
        }
        if ((n & 4) != 0) {
            objectArray = null;
        }
        return baseIntrospector.performTheQuery(dBTransaction, sqlQuery, objectArray);
    }

    private final void logQueryDebugInfo(long time1, String queryDisplayName, Exception e) {
        long time2 = System.currentTimeMillis();
        double delta = (double)(time2 - time1) / 1000.0;
        Exception exception = e;
        String message = exception == null ? "Query " + queryDisplayName + " completed in " + delta + " s." : (exception instanceof DBException ? "Query " + queryDisplayName + " failed in " + delta + " s. with DB exception: " + e.getMessage() : "Query " + queryDisplayName + " failed in " + delta + " s. with exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
        this.log.debug(message);
    }

    static /* bridge */ /* synthetic */ void logQueryDebugInfo$default(BaseIntrospector baseIntrospector, long l, String string, Exception exception, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logQueryDebugInfo");
        }
        if ((n & 4) != 0) {
            exception = null;
        }
        baseIntrospector.logQueryDebugInfo(l, string, exception);
    }

    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        return schema.getIntrospectionTimestamp() != null && (Intrinsics.areEqual((Object)((Object)this.options.getSources()), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES)) || this.whetherSourcesActual(schema));
    }

    protected boolean whetherSourcesActual(@NotNull S schema) {
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        Date date = schema.getIntrospectionTimestamp();
        return Intrinsics.areEqual((Object)this.getModel().getSchemaSourcesVersion((BasicSchema)schema), (Object)(date != null ? Long.valueOf(date.getTime()) : null));
    }

    protected final void introspectServerInfo() {
        if (!this.getInitialized()) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Database is not attached yet.");
        }
        DBFacade dbFacade = dBFacade;
        this.getModel().modify(this.modRootClass, new ModelModifier<MR>(this, dbFacade){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ DBFacade $dbFacade;

            public final void perform(MR root2) {
                MR MR = root2;
                Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                this.this$0.introspectServerInfo(MR, this.$dbFacade);
            }
            {
                this.this$0 = baseIntrospector;
                this.$dbFacade = dBFacade;
            }
        });
    }

    protected void introspectServerInfo(@NotNull MR root2, @NotNull DBFacade dbFacade) {
        Intrinsics.checkParameterIsNotNull(root2, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)dbFacade, (String)"dbFacade");
        root2.setServerVersion(dbFacade.getConnectionInfo().serverVersion);
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        Intrinsics.checkParameterIsNotNull((Object)namespaces, (String)"namespaces");
        this.introspectServerInfo();
        int n = ((Object[])namespaces).length;
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (BasicNamespace ns : namespaces) {
                boolean bl;
                boolean bl2 = bl = ns.getModel() == this.getModel();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Namespaces must be from this model";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                theNamespaces.add(ns);
            }
        }
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this, theNamespaces){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ ArrayList $theNamespaces$inlined;
            {
                this.this$0 = baseIntrospector;
                this.$theNamespaces$inlined = arrayList;
            }

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction tran2 = tran;
                this.this$0.introspectAutoInTran(tran2, this.$theNamespaces$inlined);
            }
        });
    }

    protected abstract void introspectAutoInTran(@NotNull DBTransaction var1, @Nullable Collection<? extends BasicNamespace> var2);

    @Override
    public void introspectNamespaces() {
        this.introspectServerInfo();
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ BaseIntrospector this$0;
            {
                this.this$0 = baseIntrospector;
            }

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction it = tran;
                this.this$0.introspectNamespacesInTran(it);
            }
        });
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        this.introspectServerInfo();
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ BaseIntrospector this$0;
            {
                this.this$0 = baseIntrospector;
            }

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction it = tran;
                this.this$0.introspectSessionState(it);
            }
        });
    }

    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
    }

    @Override
    public void introspectServerObjects() {
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
    }

    @Override
    @NotNull
    public Map<BasicElement, String[]> introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Map result2 = new LinkedHashMap();
        this.introspectNativeDefinitions(elements, withNestedElements, result2);
        return result2;
    }

    public abstract void introspectNativeDefinitions(@NotNull Iterable<? extends BasicElement> var1, boolean var2, @NotNull Map<BasicElement, String[]> var3);

    @NotNull
    protected abstract AbstractDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction var1, @NotNull D var2);

    @NotNull
    protected abstract AbstractSchemaRetriever createSchemaRetriever(@NotNull DBTransaction var1, @NotNull S var2);

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void perform(BasicModRoot r) {
                BasicModRoot basicModRoot = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModRoot, (String)"r");
                this.this$0.postIntrospectionProcessWithModel(basicModRoot);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected final void postIntrospectionProcessWithModel(@NotNull BasicModRoot root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        Iterator<? extends BasicModSchema> iterator = root2.getAllSchemas().iterator();
        while (iterator.hasNext()) {
            BasicModSchema schema;
            BasicModSchema basicModSchema = schema = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModSchema, (String)"schema");
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    protected final void updateStatus(@NotNull String status, @NotNull String details) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            this.log.debug("Working on: " + status + " (" + details + ')');
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(status);
            }
            ProgressIndicator progressIndicator3 = this.progressIndicator;
            if (progressIndicator3 == null) break block2;
            progressIndicator3.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void updateDetails(@NotNull String details) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 == null) break block1;
            progressIndicator2.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void writeSources(@NotNull Function0<Unit> r) {
        Intrinsics.checkParameterIsNotNull(r, (String)"r");
        this.getModel().writeSources(new Runnable(r){
            final /* synthetic */ Function0 $r;

            public final void run() {
                this.$r.invoke();
            }
            {
                this.$r = function0;
            }
        });
    }

    protected final void handleErrors(@NotNull String operationName, @NotNull Function0<Unit> operation) {
        Intrinsics.checkParameterIsNotNull((Object)operationName, (String)"operationName");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        try {
            operation.invoke();
        }
        catch (InterruptedException ie) {
            throw (Throwable)ie;
        }
        catch (DBException d) {
            String message = "Error encountered when performing " + operationName + ": " + d.getMessage();
            this.getErrorSink().consume((Object)message, (Object)d);
        }
        catch (NullPointerException npe) {
            String message = "NPE encountered when performing " + operationName;
            this.getErrorSink().consume((Object)message, (Object)npe);
            this.log.error(message, (Throwable)npe);
        }
        catch (Exception e) {
            String message = "Unexpected error (" + e.getClass().getSimpleName() + ") encountered when performing " + operationName + ": " + e.getMessage();
            this.getErrorSink().consume((Object)message, (Object)e);
        }
    }

    protected final <S> void forEachByPack(@NotNull DBQueryRunner<? extends Iterable<? extends S>> $receiver, int limit, @NotNull Function1<? super S, Unit> action) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBQueryRunner r = $receiver.packBy(limit);
        Iterable pack = (Iterable)r.run();
        while (pack != null) {
            Iterable $receiver$iv = pack;
            for (Object element$iv : $receiver$iv) {
                action.invoke(element$iv);
            }
            pack = (Iterable)r.nextPack();
        }
    }

    @NotNull
    protected final String dbIntern(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DbUtil.intern((String)$receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> T[] inplace(@NotNull T[] $receiver, @NotNull Function1<? super T, ? extends T> t) {
        T[] TArray;
        T[] $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        T[] $receiver$iv = $receiver2 = (TArray = $receiver);
        int index$iv = 0;
        for (T item$iv : $receiver$iv) {
            void s;
            int n = index$iv++;
            T t2 = item$iv;
            int i2 = n;
            $receiver2[i2] = t.invoke((Object)s);
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <T> List<T> inplace(@NotNull List<T> $receiver, @NotNull Function1<? super T, ? extends T> t) {
        List<T> list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        List<T> $receiver2 = list = $receiver;
        Iterable $receiver$iv = $receiver2;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void s;
            int n = index$iv++;
            Object t2 = item$iv;
            int i2 = n;
            $receiver2.set(i2, t.invoke((Object)s));
        }
        return list;
    }

    @NotNull
    public final Rdbms getRdbms() {
        return this.rdbms;
    }

    @NotNull
    protected final Class<MM> getModModelClass() {
        return this.modModelClass;
    }

    @NotNull
    protected final Class<MR> getModRootClass() {
        return this.modRootClass;
    }

    @NotNull
    protected final Class<MD> getModDatabaseClass() {
        return this.modDatabaseClass;
    }

    @NotNull
    protected final Class<MS> getModSchemaClass() {
        return this.modSchemaClass;
    }

    protected BaseIntrospector(@NotNull Rdbms rdbms, @NotNull Class<MM> modModelClass, @NotNull Class<MR> modRootClass, @NotNull Class<MD> modDatabaseClass, @NotNull Class<MS> modSchemaClass) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull(modModelClass, (String)"modModelClass");
        Intrinsics.checkParameterIsNotNull(modRootClass, (String)"modRootClass");
        Intrinsics.checkParameterIsNotNull(modDatabaseClass, (String)"modDatabaseClass");
        Intrinsics.checkParameterIsNotNull(modSchemaClass, (String)"modSchemaClass");
        this.rdbms = rdbms;
        this.modModelClass = modModelClass;
        this.modRootClass = modRootClass;
        this.modDatabaseClass = modDatabaseClass;
        this.modSchemaClass = modSchemaClass;
        this.errorSink = errorSink.1.INSTANCE;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(this.javaClass)");
        this.log = logger;
        Version version = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
        this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        this.preprocessor = new CommonPreprocessor(true, new MapEvaluator(this.queryParameters));
        this.dbFacade = this.dbFacade;
        this.options = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        Version version3 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version3, (String)"Version.ZERO");
        this.serverVersion = version3;
        Version version4 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version4, (String)"Version.ZERO");
        this.driverVersion = version4;
        this.considerSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
    }

    public static final /* synthetic */ void access$setDbFacade$p(BaseIntrospector $this, @Nullable DBFacade dBFacade) {
        $this.dbFacade = dBFacade;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u001f\u0010\u0019\u001a\u00020\u001a2\u0014\b\u0004\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u001a0\u001cH\u0084\bJ!\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0007\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 H\u0004\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001aH&J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0011H\u0014J\u001a\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010\u0012H\u0004R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/queryRewriting/Evaluator;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "Lcom/intellij/database/model/basic/BasicModModel;", "preprocessor", "Lcom/intellij/database/queryRewriting/CommonPreprocessor;", "getPreprocessor", "()Lcom/intellij/database/queryRewriting/CommonPreprocessor;", "setPreprocessor", "(Lcom/intellij/database/queryRewriting/CommonPreprocessor;)V", "queryParameters", "", "", "", "getQueryParameters", "()Ljava/util/Map;", "getTransaction", "()Lorg/jetbrains/dekaf/core/DBTransaction;", "evaluate", "expression", "inModel", "", "modifier", "Lkotlin/Function1;", "performQuery", "X", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "process", "reportRetrieving", "what", "setQueryParameter", "name", "value", "intellij.database.introspection"})
    protected abstract class AbstractRetriever
    implements Evaluator {
        @NotNull
        private final MM model;
        @NotNull
        private final Map<String, Object> queryParameters;
        @NotNull
        private CommonPreprocessor preprocessor;
        @NotNull
        private final DBTransaction transaction;

        @NotNull
        protected final MM getModel() {
            return this.model;
        }

        @NotNull
        protected final Map<String, Object> getQueryParameters() {
            return this.queryParameters;
        }

        @NotNull
        protected final CommonPreprocessor getPreprocessor() {
            return this.preprocessor;
        }

        protected final void setPreprocessor(@NotNull CommonPreprocessor commonPreprocessor) {
            Intrinsics.checkParameterIsNotNull((Object)commonPreprocessor, (String)"<set-?>");
            this.preprocessor = commonPreprocessor;
        }

        protected final void inModel(@NotNull Function1<? super MR, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.model.modify(BaseIntrospector.this.modRootClass, new ModelModifier<MR>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    this.$modifier.invoke(MR);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        public abstract void process();

        protected final void setQueryParameter(@NotNull String name, @Nullable Object value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (value != null) {
                this.queryParameters.put(name, value);
            } else {
                this.queryParameters.remove(name);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            return this.queryParameters.get(expression);
        }

        protected final <X> X performQuery(@NotNull SqlQuery<X> query) {
            SqlQuery preprocessedQuery;
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            SqlQuery sqlQuery = preprocessedQuery = query.rewrite((StringOperator)this.preprocessor);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlQuery, (String)"preprocessedQuery");
            return (X)BaseIntrospector.this.performTheQuery(this.transaction, sqlQuery, this.preprocessor.getBindableParameters());
        }

        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            BaseIntrospector.this.updateStatus("Introspecting database", what);
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.transaction = transaction;
            this.model = BaseIntrospector.this.getModel();
            this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            this.preprocessor = new CommonPreprocessor(true, this);
            this.queryParameters.putAll(BaseIntrospector.this.queryParameters);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a4\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u00060\u0002B\u000f\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J8\u0010\r\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0016J0\u0010\r\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0014J8\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0014J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u0012\u0010\u0006\u001a\u00028\u0003X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "database", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "expandElementsBeforeRetrievingNativeDefinitions", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "retrieveNativeDefinitions", "", "withNestedElements", "", "result", "", "", "", "retrieveNativeDefinitionsFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "retrieveObjects", "retrieveSchemas", "intellij.database.introspection"})
    protected abstract class AbstractDatabaseRetriever
    extends AbstractRetriever {
        @NotNull
        protected abstract D getDatabase();

        public void retrieveSchemas() {
        }

        public void retrieveObjects() {
        }

        public void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, boolean withNestedElements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Iterable<? extends BasicElement> elementsToProcess = withNestedElements ? this.expandElementsBeforeRetrievingNativeDefinitions(elements) : elements;
            this.retrieveNativeDefinitions(elementsToProcess, result2);
        }

        @NotNull
        protected Iterable<BasicElement> expandElementsBeforeRetrievingNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return CollectionsKt.toList(elements);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Map groups;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Iterable<? extends BasicElement> $receiver$iv = elements;
            Object object = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                Object element$iv$iv = iterator.next();
                BasicElement it = (BasicElement)element$iv$iv;
                ObjectKind key$iv$iv = it.getKind();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv = groups = destination$iv$iv;
            object = destination$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)object.next();
                ObjectKind kind = (ObjectKind)entry2.getKey();
                entry2 = entry;
                List kindElements = (List)entry2.getValue();
                ObjectKind objectKind = kind;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"kind");
                this.retrieveNativeDefinitionsFor(objectKind, kindElements, result2);
            }
        }

        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        }

        protected AbstractDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u0005\u0012\u0004\u0012\u00028\u00060\u0002B\u0017\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u00102\u001a\u000203H\u0014J\b\u00104\u001a\u000203H\u0014J\b\u00105\u001a\u000203H\u0014J\b\u00106\u001a\u000203H\u0014J\b\u00107\u001a\u000208H\u0014J\u001f\u00109\u001a\u0002032\u0014\b\u0004\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u0002030;H\u0084\bJ\b\u0010<\u001a\u000203H\u0014J\b\u0010=\u001a\u000203H\u0016J\u0006\u0010>\u001a\u000203J\u0006\u0010?\u001a\u000203J\b\u0010@\u001a\u000203H\u0014J\b\u0010A\u001a\u000203H\u0014J\u0010\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020DH\u0015J\u0010\u0010B\u001a\u0002032\u0006\u0010E\u001a\u00020FH\u0005R\u0013\u0010\n\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0013\u0010\u0005\u001a\u00028\u0005\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006G"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "database", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/model/basic/BasicDatabase;", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind$intellij_database_introspection", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind$intellij_database_introspection", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames$intellij_database_introspection", "()[Ljava/lang/String;", "setFragmentNames$intellij_database_introspection", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "fromTimestamp", "Ljava/sql/Timestamp;", "getFromTimestamp$intellij_database_introspection", "()Ljava/sql/Timestamp;", "setFromTimestamp$intellij_database_introspection", "(Ljava/sql/Timestamp;)V", "introspectionBeginTimestamp", "getIntrospectionBeginTimestamp$intellij_database_introspection", "setIntrospectionBeginTimestamp$intellij_database_introspection", "getMode$intellij_database_introspection", "()Lcom/intellij/database/introspection/IntrospectionMode;", "setMode$intellij_database_introspection", "(Lcom/intellij/database/introspection/IntrospectionMode;)V", "getSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/model/basic/BasicSchema;", "withSources", "", "getWithSources$intellij_database_introspection", "()Z", "setWithSources$intellij_database_introspection", "(Z)V", "analyzeBriefInfo", "", "analyzeCurrentContent", "clearSchema", "finishSchema", "getSchemaStateNumber", "", "inSchema", "modifier", "Lkotlin/Function1;", "prepareParameters", "process", "processMainPhase", "processPreliminaryPhase", "retrieveMainContent", "retrieveMajorNames", "work", "runnable", "Ljava/lang/Runnable;", "block", "Lorg/jetbrains/dekaf/core/InTransactionNoResult;", "intellij.database.introspection"})
    protected abstract class AbstractSchemaRetriever
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private final D database;
        @NotNull
        private IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Timestamp fromTimestamp;
        @Nullable
        private Timestamp introspectionBeginTimestamp;
        final /* synthetic */ BaseIntrospector this$0;

        @NotNull
        public final S getSchema() {
            return this.schema;
        }

        @NotNull
        public final D getDatabase() {
            return this.database;
        }

        @NotNull
        public final IntrospectionMode getMode$intellij_database_introspection() {
            return this.mode;
        }

        public final void setMode$intellij_database_introspection(@NotNull IntrospectionMode introspectionMode) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)introspectionMode), (String)"<set-?>");
            this.mode = introspectionMode;
        }

        public final boolean getWithSources$intellij_database_introspection() {
            return this.withSources;
        }

        public final void setWithSources$intellij_database_introspection(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        public final ObjectKind getFragmentKind$intellij_database_introspection() {
            return this.fragmentKind;
        }

        public final void setFragmentKind$intellij_database_introspection(@NotNull ObjectKind objectKind) {
            Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        public final String[] getFragmentNames$intellij_database_introspection() {
            return this.fragmentNames;
        }

        public final void setFragmentNames$intellij_database_introspection(@NotNull String[] stringArray) {
            Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        public final Timestamp getFromTimestamp$intellij_database_introspection() {
            return this.fromTimestamp;
        }

        public final void setFromTimestamp$intellij_database_introspection(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.fromTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getIntrospectionBeginTimestamp$intellij_database_introspection() {
            return this.introspectionBeginTimestamp;
        }

        public final void setIntrospectionBeginTimestamp$intellij_database_introspection(@Nullable Timestamp timestamp) {
            this.introspectionBeginTimestamp = timestamp;
        }

        protected void prepareParameters() {
            this.getQueryParameters().putAll(this.this$0.queryParameters);
            this.setQueryParameter("SCHEMA_NAME", this.schema.getRealName());
            this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != Long.MIN_VALUE ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : null);
            String string = this.mode.code;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mode.code");
            this.setQueryParameter(string, Boolean.TRUE);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        protected final void inSchema(@NotNull Function1<? super MS, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.getSchema(), this.this$0.modSchemaClass, new ModelModifier<MS>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    this.$modifier.invoke(MS);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public final void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected void work(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(runnable){
                final /* synthetic */ Runnable $runnable;

                public final void perform(BasicModRoot it) {
                    this.$runnable.run();
                }
                {
                    this.$runnable = runnable;
                }
            });
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected final void work(@NotNull InTransactionNoResult block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(this, block){
                final /* synthetic */ AbstractSchemaRetriever this$0;
                final /* synthetic */ InTransactionNoResult $block;

                public final void perform(BasicModRoot it) {
                    this.$block.run(this.this$0.getTransaction());
                }
                {
                    this.this$0 = abstractSchemaRetriever;
                    this.$block = inTransactionNoResult;
                }
            });
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            if (this.withSources && Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)IntrospectionMode.FRAGMENT)) ^ true) {
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, this.getSchemaStateNumber());
            }
        }

        protected long getSchemaStateNumber() {
            Timestamp timestamp = this.introspectionBeginTimestamp;
            return timestamp != null ? timestamp.getTime() : 0L;
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)((BasicElement)this.schema), BasicModSchema.class, clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            this($outer, transaction, (BasicSchema)schema, null);
        }

        protected AbstractSchemaRetriever(@NotNull DBTransaction transaction, @Nullable S schema, IntrospectionMode mode) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            super(transaction);
            this.this$0 = $outer;
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                Intrinsics.throwNpe();
            }
            this.fragmentKind = objectKind;
            AbstractSchemaRetriever abstractSchemaRetriever = this;
            String[] stringArray = new String[]{};
            abstractSchemaRetriever.fragmentNames = stringArray;
            this.fromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.schema = schema;
            BasicDatabase basicDatabase = schema.getDatabase();
            if (basicDatabase == null) {
                throw (Throwable)new IllegalArgumentException("The schema to introspect must be in a database");
            }
            if (basicDatabase == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            this.database = basicDatabase;
            IntrospectionMode introspectionMode = mode;
            if (introspectionMode == null) {
                introspectionMode = schema.hasChildren() && $outer.isPossibleToIntrospectSchemaIncrementally(transaction, schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
            }
            this.mode = introspectionMode;
            this.withSources = $outer.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = this.mode.increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
        }
    }
}

