/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SqlUpdateValuesExtractor
extends SqlValuesExtractor {
    public SqlUpdateValuesExtractor(ObjectFormatter converter, @Nullable DasTable databaseTable) {
        super(converter, databaseTable);
    }

    @Override
    public DataExtractor.Extraction startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new SqlUpdateExtraction(out, dialect, forceSkipHeader, allColumns, selectedColumns);
    }

    @Nullable
    private static DataConsumer.Column getColumnByName(String name, List<DataConsumer.Column> columns2) {
        for (DataConsumer.Column column2 : columns2) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)column2.name, (CharSequence)name)) continue;
            return column2;
        }
        return null;
    }

    private class SqlUpdateExtraction
    extends SqlValuesExtractor.SqlExtractionBase {
        public SqlUpdateExtraction(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(SqlUpdateValuesExtractor.this, output, dialect, forceSkipHeader, allColumns, selectedColumnIndices);
        }

        @Override
        protected void appendData(List<DataConsumer.Row> rows) {
            DasTableKey key2;
            LinkedHashSet pkColumns = ContainerUtil.newLinkedHashSet();
            DasTableKey dasTableKey = key2 = SqlUpdateValuesExtractor.this.myDatabaseTable == null ? null : DasUtil.getPrimaryKey((DasTable)SqlUpdateValuesExtractor.this.myDatabaseTable);
            if (key2 != null) {
                for (String pkName : key2.getColumnsRef().names()) {
                    ContainerUtil.addIfNotNull((Collection)pkColumns, (Object)SqlUpdateValuesExtractor.getColumnByName(pkName, this.myAllColumns));
                }
            }
            if (pkColumns.isEmpty()) {
                for (DataConsumer.Column column2 : this.myAllColumns) {
                    if (!DbImplUtil.isRowId(column2)) continue;
                    pkColumns.add(column2);
                }
            }
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            for (DataConsumer.Column column3 : this.myAllColumns) {
                if (!DbImplUtil.isRowId(column3)) continue;
                columnsMap.remove(column3.columnNum);
            }
            for (DataConsumer.Row row : rows) {
                this.myDdlBuilder.keyword("UPDATE").space();
                if (SqlUpdateValuesExtractor.this.myDatabaseTable != null) {
                    this.myDdlBuilder.qualifiedRef((DasObject)SqlUpdateValuesExtractor.this.myDatabaseTable);
                } else {
                    this.myDdlBuilder.identifier("MY_TABLE");
                }
                this.myDdlBuilder.space().keyword("SET").space();
                boolean first = true;
                for (int selectedColumn : selectedColumns) {
                    DataConsumer.Column column4 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column4 == null || pkColumns.contains(column4)) continue;
                    if (first) {
                        first = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.columnRef(column4.name).space().symbol("=").space().literal(SqlUpdateValuesExtractor.this.getValueLiteral(row, column4, this.myDialect));
                }
                if (!pkColumns.isEmpty()) {
                    this.myDdlBuilder.space().keyword("WHERE").space();
                    first = true;
                    Object object = pkColumns.iterator();
                    while (object.hasNext()) {
                        DataConsumer.Column column5 = (DataConsumer.Column)object.next();
                        if (first) {
                            first = false;
                        } else {
                            this.myDdlBuilder.space().keyword("AND").space();
                        }
                        this.myDdlBuilder.columnRef(column5.name).space().symbol("=").space().literal(SqlUpdateValuesExtractor.this.getValueLiteral(row, column5, this.myDialect));
                    }
                }
                this.myDdlBuilder.newStatement();
            }
        }
    }
}

