/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.google.common.collect.Iterables;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.awt.Component;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenDataFileDescriptor
extends OpenFileDescriptor {
    private final String[] myColumnNames;
    private final Object[] myValues;
    private final boolean mySelectedOnly;
    private final String myDescription;

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, @Nullable String[] columnNames, @Nullable Object[] values2, boolean selectedOnly, @Nullable String description) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(1);
        }
        super(project, file);
        this.myColumnNames = columnNames;
        this.myValues = values2;
        this.mySelectedOnly = selectedOnly;
        this.myDescription = description;
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        List editors;
        FileEditor editor;
        JComponent component;
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(2);
        }
        JComponent jComponent = component = (editor = (FileEditor)ContainerUtil.getFirstItem((List)(editors = FileEditorManager.getInstance((Project)project).openEditor((OpenFileDescriptor)this, requestFocus)))) != null ? editor.getPreferredFocusedComponent() : null;
        if (component != null) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)component, true);
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void navigateTo(@NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(3);
        }
        if (this.myColumnNames != null && this.myColumnNames.length != 0) {
            if (this.myValues == null) {
                DasTable table = DataGridUtil.getDatabaseTable(resultPanel);
                int[] indices = new int[this.myColumnNames.length];
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    indices[i2] = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class).indexOf(DasUtil.byName((String)this.myColumnNames[i2]));
                }
                resultPanel.getSelectionModel().setColumnSelection(ModelIndexSet.forColumns(resultPanel, indices));
            } else if (this.mySelectedOnly) {
                this.navigateToSelectedOnly(resultPanel);
            } else {
                this.navigateToFirstMatched(resultPanel);
            }
        }
    }

    private void navigateToSelectedOnly(@NotNull DataGrid dataGrid) {
        List<DataConsumer.Column> columns2;
        if (dataGrid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(4);
        }
        if ((columns2 = this.getColumns(dataGrid)) == null) {
            return;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)DataGridUtil.getDatabaseTable(dataGrid));
        DbImplUtil.composeWhereCondition(builder, columns2, ContainerUtil.list((Object[])this.myValues), dialect, null);
        String whereCondition = builder.getStatement();
        dataGrid.setFilterText(whereCondition, -1);
        dataGrid.applyFilter();
    }

    private void navigateToFirstMatched(final @NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(5);
        }
        final QueryWithParameters existsQuery = this.buildSelectQuery(resultPanel);
        final QueryWithParameters countQuery = this.buildCountQuery(resultPanel);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
        if (existsQuery == null || countQuery == null || hookup == null) {
            return;
        }
        DasTable table = DataGridUtil.getDatabaseTable(resultPanel);
        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)table);
        LinkedHashSet orderBy = ContainerUtil.newLinkedHashSet();
        Collections.addAll(orderBy, this.myColumnNames);
        if (primaryKey != null) {
            Iterables.addAll((Collection)orderBy, (Iterable)primaryKey.getColumnsRef().names());
        }
        ArrayList ordering = ContainerUtil.newArrayListWithCapacity((int)orderBy.size());
        for (String columnName : orderBy) {
            ModelIndex<DataConsumer.Column> column2 = DataGridUtil.findColumn(resultPanel, columnName);
            if (!column2.isValid(resultPanel)) {
                return;
            }
            ordering.add(RowSortOrder.asc(column2));
        }
        resultPanel.setOrdering(ordering);
        resultPanel.setFilterText("", -1);
        resultPanel.setSortViaOrderBy(true);
        resultPanel.applyFilter();
        final DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(resultPanel);
        hookup.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(hookup){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                try {
                    ResultSet resultSet;
                    PreparedStatement statement;
                    boolean exists = false;
                    int position = -1;
                    try {
                        statement = OpenDataFileDescriptor.createStatement(connection, existsQuery, dialect);
                        resultSet = statement.executeQuery();
                        exists = resultSet.next();
                        JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
                        JdbcUtil.closeStatementSafe((Statement)statement);
                    }
                    catch (Exception ex) {
                        context.reportException(ex, existsQuery);
                    }
                    if (exists) {
                        try {
                            statement = OpenDataFileDescriptor.createStatement(connection, countQuery, dialect);
                            resultSet = statement.executeQuery();
                            position = 0;
                            while (resultSet.next()) {
                                position += resultSet.getInt(1);
                            }
                            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
                            JdbcUtil.closeStatementSafe((Statement)statement);
                        }
                        catch (Exception ex) {
                            context.reportException(ex, countQuery);
                        }
                    }
                    resultPanel.showCell(resultPanel.uiRow(position + 1), resultPanel.uiColumn(0));
                }
                catch (Exception e) {
                    context.reportException(e, null);
                }
            }
        });
    }

    private QueryWithParameters buildSelectQuery(@NotNull DataGrid grid) {
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(6);
        }
        DasTable dasTable = DataGridUtil.getDatabaseTable(grid);
        List<DataConsumer.Column> columns2 = this.getColumns(grid);
        if (dasTable == null || columns2 == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)dasTable);
        List<ColumnQueryData> data = IntStream.range(0, Math.min(this.myValues.length, columns2.size())).mapToObj(idx -> new ColumnQueryData((DataConsumer.Column)columns2.get(idx), this.myValues[idx])).collect(Collectors.toList());
        DbDataSource system = DataGridUtil.getDatabaseSystem(grid);
        List<ColumnQueryData> parameters = DbImplUtil.createSelectAllQueryWithParameters(builder, dasTable, dialect, (DatabaseSystem)system, data, 1);
        return new QueryWithParameters(builder.getStatement(), (List)ContainerUtil.immutableList(parameters));
    }

    private QueryWithParameters buildCountQuery(@NotNull DataGrid grid) {
        DasTable dasTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(7);
        }
        if ((dasTable = DataGridUtil.getDatabaseTable(grid)) == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DdlBuilder builder = DbImplUtil.createSelectAllQuery(dasTable, dialect, (DatabaseSystem)DataGridUtil.getDatabaseSystem(grid));
        builder.space().keyword("WHERE").space();
        ArrayList parameters = ContainerUtil.newArrayList();
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        for (int i2 = 0; i2 < this.myColumnNames.length; ++i2) {
            String columnName = this.myColumnNames[i2];
            Object parameterValue = this.myValues[i2];
            DataConsumer.Column column2 = model.getColumn(DataGridUtil.findColumn(grid, columnName));
            if (column2 == null) {
                return null;
            }
            if (i2 > 0) {
                builder.space().keyword("OR").space();
            }
            Pair columnValuePair = Pair.create((Object)column2, (Object)parameterValue);
            builder.columnRef(columnName).space().symbol("<").space().placeholder();
            parameters.add(columnValuePair);
            DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
            if (dasColumn != null && !dasColumn.isNotNull()) {
                builder.space().keyword("OR").space().columnRef(columnName).space().keywords("IS", "NULL");
            }
            for (int j = 0; j < i2; ++j) {
                builder.space().keyword("AND").space();
                int placeholdersCount = DbImplUtil.composeWhereItemWithParameters(builder, column2, parameterValue == null ? ThreeState.YES : ThreeState.NO, null, dialect);
                for (int k = 0; k < placeholdersCount; ++k) {
                    parameters.add(columnValuePair);
                }
            }
        }
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(grid);
        String sql = DbImplUtil.createSelectCountQuery(this.getProject(), dialect, builder.getStatement(), dataSource);
        return sql != null ? new QueryWithParameters(sql, ContainerUtil.immutableList((List)parameters)) : null;
    }

    @Nullable
    private List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        GridModel model;
        List columns2;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(8);
        }
        return (columns2 = ContainerUtil.mapNotNull((Object[])this.myColumnNames, arg_0 -> OpenDataFileDescriptor.lambda$getColumns$1(model = grid.getDataModel(DataAccessType.DATABASE_DATA), grid, arg_0))).size() == this.myColumnNames.length ? columns2 : null;
    }

    @NotNull
    private static PreparedStatement createStatement(@NotNull DatabaseConnection connection, @NotNull QueryWithParameters queryWithParameters, @NotNull DatabaseDialectEx dialect) throws Exception {
        if (connection == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(9);
        }
        if (queryWithParameters == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(11);
        }
        PreparedStatement statement = connection.prepareStatement(queryWithParameters.sql);
        ImmutableList<ColumnQueryData> datas = queryWithParameters.data;
        for (int i2 = 0; i2 < datas.size(); ++i2) {
            ColumnQueryData data = (ColumnQueryData)datas.get(i2);
            DbImplUtil.setStatementParameter(statement, data, data.getObject(), dialect, true, i2 + 1);
        }
        PreparedStatement preparedStatement = statement;
        if (preparedStatement == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(12);
        }
        return preparedStatement;
    }

    private static /* synthetic */ DataConsumer.Column lambda$getColumns$1(GridModel model, @NotNull DataGrid grid, String columnName) {
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(13);
        }
        return model.getColumn(DataGridUtil.findColumn(grid, columnName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryWithParameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSelectedOnly";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "navigateToFirstMatched";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildSelectQuery";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildCountQuery";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getColumns$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QueryWithParameters {
        public final String sql;
        public final ImmutableList<ColumnQueryData> data;

        private QueryWithParameters(@NotNull String sql, @NotNull List<ColumnQueryData> data) {
            if (sql == null) {
                QueryWithParameters.$$$reportNull$$$0(0);
            }
            if (data == null) {
                QueryWithParameters.$$$reportNull$$$0(1);
            }
            this.sql = sql;
            this.data = ContainerUtil.immutableList(data);
        }

        private QueryWithParameters(@NotNull String sql, @NotNull ImmutableList<Pair<DataConsumer.Column, Object>> pairs2) {
            if (sql == null) {
                QueryWithParameters.$$$reportNull$$$0(2);
            }
            if (pairs2 == null) {
                QueryWithParameters.$$$reportNull$$$0(3);
            }
            this(sql, (List<ColumnQueryData>)QueryWithParameters.convert(pairs2));
        }

        @NotNull
        private static ImmutableList<ColumnQueryData> convert(@NotNull List<Pair<DataConsumer.Column, Object>> pairs2) {
            if (pairs2 == null) {
                QueryWithParameters.$$$reportNull$$$0(4);
            }
            List data = ContainerUtil.map(pairs2, pair -> {
                DataConsumer.Column first = (DataConsumer.Column)pair.getFirst();
                Object second = pair.getSecond();
                return new ColumnQueryData(first, second);
            });
            ImmutableList immutableList = ContainerUtil.immutableList((List)data);
            if (immutableList == null) {
                QueryWithParameters.$$$reportNull$$$0(5);
            }
            return immutableList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

