/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExtractionHelper {
    @NotNull
    public CharOut createOut(@NotNull String var1, @NotNull DataExtractor var2) throws IOException;

    public boolean chooseFile(@NotNull DataExtractor var1, Project var2, String var3, boolean var4);

    public boolean isSingleFileMode();

    public void release(@NotNull DataExtractor var1) throws IOException;

    public void after(@NotNull Project var1, @NotNull DumpHandler.DumpInfo var2) throws IOException;

    @NotNull
    public String getTitleFormatString();

    @Nullable
    default public DataExtractorFactory getExtractorFactory(@NotNull DataContext context, @NotNull Project project) {
        if (context == null) {
            ExtractionHelper.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExtractionHelper.$$$reportNull$$$0(1);
        }
        return DataExtractorProperties.getCurrentExtractorFactory((Project)CommonDataKeys.PROJECT.getData(context));
    }

    public static void errorNotification(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) {
        String summary;
        if (project == null) {
            ExtractionHelper.$$$reportNull$$$0(2);
        }
        if (info == null) {
            ExtractionHelper.$$$reportNull$$$0(3);
        }
        if ((summary = info.getErrorSummary()).isEmpty()) {
            return;
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(summary, NotificationType.ERROR).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dump/ExtractionHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtractorFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "errorNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ClipboardExtractionHelper
    implements ExtractionHelper {
        private CharOut myOut;

        @Override
        @NotNull
        public CharOut createOut(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(0);
            }
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(1);
            }
            CharOut charOut = this.myOut = CharOut.Util.newSink();
            if (charOut == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(2);
            }
            return charOut;
        }

        @Override
        public boolean chooseFile(@NotNull DataExtractor extractor, Project project, String name, boolean directory) {
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public boolean isSingleFileMode() {
            return false;
        }

        @Override
        public void release(@NotNull DataExtractor extractor) {
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(4);
            }
            String data = this.myOut.toString();
            this.myOut = null;
            boolean htmlNeeded = extractor.getFileExtension().contains("htm");
            Object content = htmlNeeded ? new TextTransferable(data) : new StringSelection(data);
            UIUtil.invokeLaterIfNeeded(() -> ClipboardExtractionHelper.lambda$release$0((Transferable)content));
        }

        @Override
        public void after(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) {
            if (project == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(5);
            }
            if (info == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(6);
            }
            ExtractionHelper.errorNotification(project, info);
        }

        @Override
        @NotNull
        public String getTitleFormatString() {
            if ("Copy %s to clipboard" == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(7);
            }
            return "Copy %s to clipboard";
        }

        private static /* synthetic */ void lambda$release$0(Transferable content) {
            CopyPasteManager.getInstance().setContents(content);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOut";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleFormatString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createOut";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "release";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "after";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FileExtractionHelper
    implements ExtractionHelper {
        private BufferedWriter myWriter;
        private boolean mySingleFile;
        private int myFileCount;
        protected File myFile;

        @Override
        @NotNull
        public CharOut createOut(@NotNull String name, @NotNull DataExtractor extractor) throws IOException {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(0);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(1);
            }
            File fileToWrite = this.createFileToWrite(name, extractor);
            this.myWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWrite), CharsetToolkit.UTF8_CHARSET));
            ++this.myFileCount;
            CharOut charOut = CharOut.Util.newSink(this.myWriter);
            if (charOut == null) {
                FileExtractionHelper.$$$reportNull$$$0(2);
            }
            return charOut;
        }

        private File createFileToWrite(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(3);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(4);
            }
            if (this.myFile.isFile()) {
                return this.myFile;
            }
            return this.findFile(name, extractor);
        }

        private File findFile(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(5);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(6);
            }
            File result2 = this.createFile(name, extractor, null);
            int index2 = 1;
            while (!DataExtractorProperties.isOverwriteExistingFiles() && result2.exists()) {
                result2 = this.createFile(name, extractor, index2++);
            }
            return result2;
        }

        private File createFile(@NotNull String name, @NotNull DataExtractor extractor, @Nullable Integer index2) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(7);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(8);
            }
            return new File(this.myFile, FileUtil.sanitizeFileName((String)name) + (index2 == null ? "" : "_" + index2) + "." + extractor.getFileExtension());
        }

        @Override
        public boolean isSingleFileMode() {
            return this.mySingleFile;
        }

        @Override
        public void release(@NotNull DataExtractor extractor) throws IOException {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(9);
            }
            this.closeWriter();
        }

        @Override
        public void after(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) throws IOException {
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(10);
            }
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(11);
            }
            if (this.mySingleFile) {
                this.closeWriter();
            }
            if (this.myFile == null) {
                return;
            }
            this.notification(project, info);
            ExtractionHelper.errorNotification(project, info);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }

        private void notification(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) {
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(12);
            }
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(13);
            }
            String title = info.getTitle();
            long rowCount = info.getRowCount();
            String producerName = info.getProducerName();
            String size = FileExtractionHelper.getDumpedSizeText(info, rowCount);
            String fromToPart = producerName == null ? "to" : "from " + producerName + " to";
            String directoryPart = this.myFile.isFile() ? "" : " " + this.myFileCount + " files in";
            DbUIUtil.createFileLinkNotification(project, title, size + fromToPart + directoryPart, !info.getErrorSummary().isEmpty() ? NotificationType.ERROR : NotificationType.INFORMATION, this.myFile.getPath()).notify(project);
        }

        @NotNull
        private static String getDumpedSizeText(@NotNull DumpHandler.DumpInfo info, long rowCount) {
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(14);
            }
            String sourceName = info.getSourceName();
            int sourcesCount = info.getSourcesCount();
            boolean needSources = sourceName != null && sourcesCount > 1;
            String rowCountStr = rowCount + " " + StringUtil.pluralize((String)"row", (int)(rowCount == 1L ? 1 : 2));
            String sourcesAndRows = needSources ? sourcesCount + " " + StringUtil.pluralize((String)sourceName, (int)sourcesCount) + " (" + rowCountStr + ")" : rowCountStr;
            String string = sourcesAndRows + " saved ";
            if (string == null) {
                FileExtractionHelper.$$$reportNull$$$0(15);
            }
            return string;
        }

        @Override
        @NotNull
        public String getTitleFormatString() {
            if ("Save %s to file" == null) {
                FileExtractionHelper.$$$reportNull$$$0(16);
            }
            return "Save %s to file";
        }

        @Override
        public boolean chooseFile(@NotNull DataExtractor extractor, @NotNull Project project, @NotNull String name, boolean directory) {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(17);
            }
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(18);
            }
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(19);
            }
            return this.chooseFileToDumpTo(extractor.getFileExtension(), project, name, directory);
        }

        protected boolean chooseFileToDumpTo(@NotNull String fileExtension, @NotNull Project project, @NotNull String targetName, boolean directory) {
            String defaultFileName;
            if (fileExtension == null) {
                FileExtractionHelper.$$$reportNull$$$0(20);
            }
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(21);
            }
            if (targetName == null) {
                FileExtractionHelper.$$$reportNull$$$0(22);
            }
            if (directory && !DataExtractorProperties.isSingleFile()) {
                return this.chooseMultiple(project);
            }
            this.mySingleFile = directory;
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Data To File", "Save all table data to file", new String[0]);
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            VirtualFileWrapper wrapper = dialog.save(null, defaultFileName = FileUtil.sanitizeFileName((String)targetName) + "." + fileExtension);
            if (wrapper == null) {
                return false;
            }
            VirtualFile virtualFile = wrapper.getVirtualFile(true);
            if (virtualFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile})) {
                String message = "Cannot write file: " + wrapper.getFile().getPath();
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(message, MessageType.WARNING).notify(project);
                return false;
            }
            this.myFile = wrapper.getFile();
            return true;
        }

        private boolean chooseMultiple(@NotNull Project project) {
            FileChooserDescriptor descriptor;
            VirtualFile file;
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(23);
            }
            this.myFile = (file = FileChooser.chooseFile((FileChooserDescriptor)(descriptor = new FileChooserDescriptor(true, true, false, false, false, false)), (Project)project, null)) == null ? null : new File(file.getPath());
            this.mySingleFile = this.myFile != null && this.myFile.isFile();
            return this.myFile != null;
        }

        private void closeWriter() throws IOException {
            if (this.myWriter == null) {
                return;
            }
            try {
                this.myWriter.close();
            }
            finally {
                this.myWriter = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 2: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper";
                    break;
                }
                case 10: 
                case 12: 
                case 18: 
                case 21: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileExtension";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOut";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDumpedSizeText";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleFormatString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createOut";
                    break;
                }
                case 2: 
                case 15: 
                case 16: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileToWrite";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findFile";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFile";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "release";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "after";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "notification";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getDumpedSizeText";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseFile";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseFileToDumpTo";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseMultiple";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

