/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.IdentityDataProducer;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dump.DumpRequest;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DumpHandler<T> {
    private static final int MAX_SYMBOLS = 40;
    protected final Project myProject;
    protected final JBIterable<T> mySources;
    protected final String myTitle;
    protected final ExtractionHelper myManager;
    protected ModelIndexSet<DataConsumer.Column> mySelectedColumns;
    protected CharOut myOutput;
    protected DatabaseDialectEx myDialect;
    protected String myQueryText;
    protected int myResultSetIndex;
    private final ErrorHandler myHandler;
    private long myLength;
    private int myRowsCount;
    private int myProcessedCount;

    protected DumpHandler(@NotNull Project project, @NotNull JBIterable<T> sources, @NotNull ExtractionHelper manager, @NotNull String displayName) {
        if (project == null) {
            DumpHandler.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            DumpHandler.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DumpHandler.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            DumpHandler.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myManager = manager;
        this.mySources = sources;
        this.myTitle = String.format(this.myManager.getTitleFormatString(), displayName);
        this.myHandler = new ErrorHandler();
    }

    @NotNull
    protected abstract DatabaseDialectEx getDialect(@NotNull T var1);

    protected abstract int getResultSetIndex(@NotNull T var1);

    @Nullable
    protected abstract String getQueryText(@NotNull T var1);

    @Nullable
    protected abstract ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull T var1);

    @Nullable
    protected abstract String getName(@NotNull T var1);

    @Nullable
    protected abstract AsyncPromise<Void> run(@NotNull T var1, @NotNull DataExtractor var2, int var3);

    @Nullable
    protected abstract DatabaseSystem getDatabaseSystem();

    @Nullable
    protected abstract String getProducerName();

    @Nullable
    protected abstract String getSourceName();

    @NotNull
    protected NotNullFunction<DataExtractor, DataRequest> newSimpleRunner(@NotNull DataProducer producer, DataRequest.Owner owner) {
        if (producer == null) {
            DumpHandler.$$$reportNull$$$0(4);
        }
        NotNullFunction notNullFunction = extractor -> {
            if (producer == null) {
                DumpHandler.$$$reportNull$$$0(21);
            }
            DataRequest.TxMarker txMarker = owner instanceof DataRequest.OwnerEx ? ((DataRequest.OwnerEx)owner).getCurrentTx() : DataRequest.NONE;
            DataRequest request = this.createDumpRequest(owner, txMarker, (DataExtractor)extractor, null);
            producer.processRequest(request);
            return request;
        };
        if (notNullFunction == null) {
            DumpHandler.$$$reportNull$$$0(5);
        }
        return notNullFunction;
    }

    protected final boolean isSingleSource() {
        return this.mySources.skip(1).isEmpty();
    }

    private void processError(@Nullable Throwable th) {
        this.myHandler.addError(null, th);
    }

    public void performDump(@NotNull DataContext context) {
        if (context == null) {
            DumpHandler.$$$reportNull$$$0(6);
        }
        String defaultName = this.getName(ObjectUtils.assertNotNull((Object)this.mySources.first()));
        DataExtractorFactory factory = this.myManager.getExtractorFactory(context, this.myProject);
        if (defaultName == null || factory == null) {
            return;
        }
        DataExtractor extensionExtractor = factory.createExtractor(context);
        if (extensionExtractor == null || !this.myManager.chooseFile(extensionExtractor, this.myProject, defaultName, !this.isSingleSource())) {
            return;
        }
        ProgressManager.getInstance().run((Task)this.buildTask(factory, context));
    }

    @NotNull
    public Task.Backgroundable buildTask(@NotNull DataExtractorFactory factory, @NotNull DataContext context) {
        if (factory == null) {
            DumpHandler.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DumpHandler.$$$reportNull$$$0(8);
        }
        final List pairs2 = this.mySources.map(s -> {
            if (factory == null) {
                DumpHandler.$$$reportNull$$$0(19);
            }
            if (context == null) {
                DumpHandler.$$$reportNull$$$0(20);
            }
            return Pair.create((Object)s, (Object)factory.createExtractor(this.createContext(context, s)));
        }).toList();
        Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, this.myTitle){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Initializing output...");
                indicator.setIndeterminate(true);
                try {
                    for (Pair p : pairs2) {
                        indicator.checkCanceled();
                        if (p.second == null) continue;
                        DumpHandler.this.processSource(p.first, (DataExtractor)p.second, indicator);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    DumpHandler.this.dumpFinished();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dump/DumpHandler$1", "run"));
            }
        };
        if (backgroundable == null) {
            DumpHandler.$$$reportNull$$$0(9);
        }
        return backgroundable;
    }

    @NotNull
    protected DumpDataContext createContext(@NotNull DataContext context, T s) {
        if (context == null) {
            DumpHandler.$$$reportNull$$$0(10);
        }
        DumpDataContext dumpDataContext = new DumpDataContext(context, s);
        if (dumpDataContext == null) {
            DumpHandler.$$$reportNull$$$0(11);
        }
        return dumpDataContext;
    }

    private void dumpFinished() {
        try {
            DatabaseSystem system = this.getDatabaseSystem();
            DumpInfo info = new DumpInfo(system == null ? "Data Dump" : system.getName(), this.myHandler.getSummary(), this.getSourceName(), this.getProducerName(), this.myRowsCount, this.myProcessedCount);
            this.myManager.after(this.myProject, info);
        }
        catch (Exception e) {
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Data Dump", e.getMessage(), NotificationType.ERROR, null).notify(this.myProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSource(@NotNull T source, @NotNull DataExtractor extractor, @NotNull ProgressIndicator indicator) {
        if (source == null) {
            DumpHandler.$$$reportNull$$$0(12);
        }
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            DumpHandler.$$$reportNull$$$0(14);
        }
        try {
            AsyncFutureResult result2 = AsyncFutureFactory.getInstance().createAsyncFutureResult();
            String name = this.getName(source);
            this.myDialect = this.getDialect(source);
            this.myResultSetIndex = this.getResultSetIndex(source);
            this.mySelectedColumns = this.getSelectedColumns(source);
            this.myQueryText = this.getQueryText(source);
            if (name == null || this.myQueryText == null) {
                return;
            }
            this.refreshOut(name, extractor);
            indicator.setText("Running query...");
            AsyncPromise<Void> promise = this.run(source, extractor, this.myResultSetIndex);
            if (promise == null) {
                return;
            }
            promise.processed(o -> result2.set((Object)true));
            result2.get();
            ++this.myProcessedCount;
        }
        catch (Exception ex) {
            this.processError(ex);
        }
        finally {
            this.sourceDumped(extractor);
        }
    }

    private void refreshOut(@NotNull String name, @NotNull DataExtractor extractor) throws Exception {
        if (name == null) {
            DumpHandler.$$$reportNull$$$0(15);
        }
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(16);
        }
        if (this.myManager.isSingleFileMode() && this.myOutput != null) {
            if (this.myOutput.length() > this.myLength) {
                this.myOutput.append("\n");
            }
            this.myLength = this.myOutput.length();
            return;
        }
        this.myOutput = this.myManager.createOut(name, extractor);
    }

    private void sourceDumped(@NotNull DataExtractor extractor) {
        if (extractor == null) {
            DumpHandler.$$$reportNull$$$0(17);
        }
        if (this.myManager.isSingleFileMode()) {
            return;
        }
        if (this.myOutput != null) {
            try {
                this.myManager.release(extractor);
            }
            catch (Exception ex) {
                this.processError(ex);
            }
            finally {
                this.myOutput = null;
            }
        }
    }

    @NotNull
    DataRequest createDumpRequest(DataRequest.Owner owner, DataRequest.TxMarker txMarker, DataExtractor extractor, @Nullable String name) {
        MyRequest myRequest = new MyRequest(owner, txMarker, this.myQueryText, DataRequest.newConstraints(0, -1, this.myResultSetIndex), this.mySelectedColumns, extractor, this.myDialect, (CharOut)ObjectUtils.assertNotNull((Object)this.myOutput), name);
        if (myRequest == null) {
            DumpHandler.$$$reportNull$$$0(18);
        }
        return myRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dump/DumpHandler";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dump/DumpHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newSimpleRunner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTask";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDumpRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newSimpleRunner";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performDump";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processSource";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "refreshOut";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sourceDumped";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildTask$1";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newSimpleRunner$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DumpInfo {
        private final String myProducerName;
        private final String myErrorSummary;
        private final String mySourceName;
        private final String myTitle;
        private final long myRowCount;
        private final int mySourcesCount;

        /*
         * WARNING - void declaration
         */
        DumpInfo(@NotNull String title, @NotNull String errorSummary, @Nullable String sourceName, @Nullable String producerName, long rowCount, int n) {
            void sourcesCount;
            if (title == null) {
                DumpInfo.$$$reportNull$$$0(0);
            }
            if (errorSummary == null) {
                DumpInfo.$$$reportNull$$$0(1);
            }
            this.mySourceName = sourceName;
            this.myTitle = title;
            this.myRowCount = rowCount;
            this.myProducerName = producerName;
            this.myErrorSummary = errorSummary;
            this.mySourcesCount = sourcesCount;
        }

        public long getRowCount() {
            return this.myRowCount;
        }

        @NotNull
        public String getErrorSummary() {
            String string = this.myErrorSummary;
            if (string == null) {
                DumpInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public String getProducerName() {
            return this.myProducerName;
        }

        @Nullable
        public String getSourceName() {
            return this.mySourceName;
        }

        public int getSourcesCount() {
            return this.mySourcesCount;
        }

        @NotNull
        public String getTitle() {
            String string = this.myTitle;
            if (string == null) {
                DumpInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorSummary";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$DumpInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$DumpInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorSummary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DumpDataContext
    implements DataContext {
        private final DataContext myParent;
        private final Object myElement;

        DumpDataContext(@NotNull DataContext parent, @NotNull Object element) {
            if (parent == null) {
                DumpDataContext.$$$reportNull$$$0(0);
            }
            if (element == null) {
                DumpDataContext.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myElement = element;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (this.myElement instanceof PsiElement && CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return this.myElement;
            }
            return this.myParent.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dump/DumpHandler$DumpDataContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GridHandler
    extends DumpHandler<DataGrid> {
        public GridHandler(@NotNull Project project, @NotNull DataGrid target, @NotNull ExtractionHelper manager) {
            if (project == null) {
                GridHandler.$$$reportNull$$$0(0);
            }
            if (target == null) {
                GridHandler.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                GridHandler.$$$reportNull$$$0(2);
            }
            super(project, JBIterable.of((Object)target), manager, target.getDisplayName());
        }

        @Override
        @NotNull
        protected DatabaseDialectEx getDialect(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(3);
            }
            DatabaseDialectEx databaseDialectEx = DataGridUtil.getDatabaseDialect(source);
            if (databaseDialectEx == null) {
                GridHandler.$$$reportNull$$$0(4);
            }
            return databaseDialectEx;
        }

        @Override
        @Nullable
        protected String getName(@NotNull DataGrid target) {
            String query;
            if (target == null) {
                GridHandler.$$$reportNull$$$0(5);
            }
            if ((query = this.getQueryText(target)) == null) {
                return null;
            }
            return query.substring(0, Math.min(40, query.length()));
        }

        @Override
        protected int getResultSetIndex(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(6);
            }
            return DataGridUtil.getResultSetIndex(source);
        }

        @Override
        @Nullable
        protected String getQueryText(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(7);
            }
            DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(source);
            VirtualFile file = DataGridUtil.getVirtualFile(source);
            return hookUp != null ? hookUp.getUnlimitedQueryText() : (file != null ? file.getName() : null);
        }

        @Override
        @Nullable
        protected String getProducerName() {
            DataGrid item = (DataGrid)this.mySources.first();
            VirtualFile file = DataGridUtil.getVirtualFile((DataGrid)ObjectUtils.assertNotNull((Object)item));
            return file != null ? file.getName() : DataGridUtil.getResultSetName(this.myProject, (DataGrid)ObjectUtils.assertNotNull((Object)item));
        }

        @Override
        @Nullable
        protected String getSourceName() {
            return null;
        }

        @Override
        @Nullable
        protected DatabaseSystem getDatabaseSystem() {
            DataGrid item = (DataGrid)this.mySources.first();
            return DataGridUtil.getDatabaseSystem(item);
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull DataGrid source) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(8);
            }
            return source.getVisibleColumns();
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull DataGrid source, @NotNull DataExtractor extractor, int resultSetIndex) {
            if (source == null) {
                GridHandler.$$$reportNull$$$0(9);
            }
            if (extractor == null) {
                GridHandler.$$$reportNull$$$0(10);
            }
            DataProducer producer = GridHandler.getProducer(source, resultSetIndex);
            DataRequest.Owner owner = GridHandler.getOwner(source);
            return producer != null ? ((DataRequest)this.newSimpleRunner(producer, owner).fun((Object)extractor)).getPromise() : null;
        }

        @Nullable
        private static DataProducer getProducer(@NotNull DataGrid grid, int myResultSetIndex) {
            if (grid == null) {
                GridHandler.$$$reportNull$$$0(11);
            }
            GridPagingModel pageModel = grid.getDataHookup().getPageModel();
            DataBusGridDataHookUp hookUp = DataGridUtil.getDataBusHookUp(grid);
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            return pageModel.isFirstPage() && pageModel.isLastPage() ? new IdentityDataProducer(new DataConsumer.Composite(new DataConsumer[0]), model.getColumns(), ContainerUtil.newArrayList(model.getRows()), myResultSetIndex) : (hookUp != null ? hookUp.getMessageBus().getDataProducer() : null);
        }

        @NotNull
        private static DataRequest.Owner getOwner(@NotNull DataGrid grid) {
            GridPagingModel pageModel;
            if (grid == null) {
                GridHandler.$$$reportNull$$$0(12);
            }
            DataRequest.Owner owner = (pageModel = grid.getDataHookup().getPageModel()).isFirstPage() && pageModel.isLastPage() || DataGridUtil.getDataBusHookUp(grid) == null ? DataRequest.newOwner() : DataGridUtil.getDataBusHookUp(grid);
            if (owner == null) {
                GridHandler.$$$reportNull$$$0(13);
            }
            return owner;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$GridHandler";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$GridHandler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDialect";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDialect";
                    break;
                }
                case 4: 
                case 13: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultSetIndex";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueryText";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedColumns";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getProducer";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getOwner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConsoleHandler
    extends DumpHandler<String> {
        private final JdbcConsole myConsole;

        public ConsoleHandler(@NotNull Project project, @NotNull JBIterable<String> target, JdbcConsole console, @NotNull ExtractionHelper manager) {
            if (project == null) {
                ConsoleHandler.$$$reportNull$$$0(0);
            }
            if (target == null) {
                ConsoleHandler.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                ConsoleHandler.$$$reportNull$$$0(2);
            }
            super(project, target, manager, console.getDisplayName());
            this.myConsole = console;
        }

        @Override
        @NotNull
        protected DatabaseDialectEx getDialect(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(3);
            }
            DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myConsole.getDataSource()), (Object)GenericDialect.INSTANCE);
            if (databaseDialectEx == null) {
                ConsoleHandler.$$$reportNull$$$0(4);
            }
            return databaseDialectEx;
        }

        @Override
        protected int getResultSetIndex(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(5);
            }
            return 1;
        }

        @Override
        @Nullable
        protected String getName(@NotNull String target) {
            if (target == null) {
                ConsoleHandler.$$$reportNull$$$0(6);
            }
            return target.substring(0, Math.min(40, target.length()));
        }

        @Override
        @Nullable
        protected String getQueryText(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(7);
            }
            return source;
        }

        @Override
        @NotNull
        protected DumpDataContext createContext(@NotNull DataContext context, String s) {
            if (context == null) {
                ConsoleHandler.$$$reportNull$$$0(8);
            }
            DumpDataContext dumpDataContext = new DumpDataContext(context, s){

                @Override
                @Nullable
                public Object getData(String dataId) {
                    return CommonDataKeys.PSI_ELEMENT.is(dataId) ? null : super.getData(dataId);
                }
            };
            if (dumpDataContext == null) {
                ConsoleHandler.$$$reportNull$$$0(9);
            }
            return dumpDataContext;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull String source) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(10);
            }
            return null;
        }

        @Override
        @Nullable
        protected DatabaseSystem getDatabaseSystem() {
            return this.myConsole.getDataSource();
        }

        @Override
        @Nullable
        protected String getProducerName() {
            return null;
        }

        @Override
        @Nullable
        protected String getSourceName() {
            return "query result";
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull String source, @NotNull DataExtractor extractor, int resultSetIndex) {
            if (source == null) {
                ConsoleHandler.$$$reportNull$$$0(11);
            }
            if (extractor == null) {
                ConsoleHandler.$$$reportNull$$$0(12);
            }
            return ((DataRequest)this.newSimpleRunner(this.myConsole.getMessageBus().getDataProducer(), this.myConsole).fun((Object)extractor)).getPromise();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$ConsoleHandler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$ConsoleHandler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDialect";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDialect";
                    break;
                }
                case 4: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultSetIndex";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueryText";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createContext";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedColumns";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DatabaseViewHandler
    extends DumpHandler<DbTable> {
        public DatabaseViewHandler(@NotNull Project project, @NotNull JBIterable<DbTable> target, @NotNull ExtractionHelper manager) {
            if (project == null) {
                DatabaseViewHandler.$$$reportNull$$$0(0);
            }
            if (target == null) {
                DatabaseViewHandler.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                DatabaseViewHandler.$$$reportNull$$$0(2);
            }
            super(project, target, manager, DatabaseViewHandler.getName(target));
        }

        @NotNull
        private static String getName(@NotNull JBIterable<DbTable> target) {
            if (target == null) {
                DatabaseViewHandler.$$$reportNull$$$0(3);
            }
            String string = target.skip(1).isEmpty() ? ((DbTable)ObjectUtils.assertNotNull((Object)target.first())).getName() : "tables";
            if (string == null) {
                DatabaseViewHandler.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        protected DatabaseDialectEx getDialect(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(5);
            }
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((DbElement)source);
            if (databaseDialectEx == null) {
                DatabaseViewHandler.$$$reportNull$$$0(6);
            }
            return databaseDialectEx;
        }

        @Override
        protected int getResultSetIndex(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(7);
            }
            return 1;
        }

        @Override
        @NotNull
        protected String getName(@NotNull DbTable target) {
            if (target == null) {
                DatabaseViewHandler.$$$reportNull$$$0(8);
            }
            String string = QNameUtil.getQualifiedName((DbElement)target);
            if (string == null) {
                DatabaseViewHandler.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getQueryText(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(10);
            }
            String string = DbImplUtil.createSelectAllQuery((DasTable)source, this.getDialect(source), (DatabaseSystem)source.getDataSource()).getStatement();
            if (string == null) {
                DatabaseViewHandler.$$$reportNull$$$0(11);
            }
            return string;
        }

        @Override
        @Nullable
        protected ModelIndexSet<DataConsumer.Column> getSelectedColumns(@NotNull DbTable source) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(12);
            }
            return null;
        }

        @Override
        @Nullable
        protected AsyncPromise<Void> run(@NotNull DbTable source, @NotNull DataExtractor extractor, int resultSetIndex) {
            if (source == null) {
                DatabaseViewHandler.$$$reportNull$$$0(13);
            }
            if (extractor == null) {
                DatabaseViewHandler.$$$reportNull$$$0(14);
            }
            return ((DataRequest)this.newEngineRunner(source).fun((Object)extractor)).getPromise();
        }

        @Override
        @Nullable
        protected DatabaseSystem getDatabaseSystem() {
            JBIterable uniqueSources = this.mySources.transform(DbElement::getDataSource).unique();
            return uniqueSources.skip(1).isEmpty() ? (DatabaseSystem)ObjectUtils.assertNotNull((Object)uniqueSources.first()) : null;
        }

        @Override
        @Nullable
        protected String getProducerName() {
            return this.isSingleSource() ? ((DbTable)ObjectUtils.assertNotNull((Object)this.mySources.first())).getName() : null;
        }

        @Override
        @Nullable
        protected String getSourceName() {
            return "table";
        }

        @NotNull
        NotNullFunction<DataExtractor, DataRequest> newEngineRunner(@NotNull DbTable table) {
            if (table == null) {
                DatabaseViewHandler.$$$reportNull$$$0(15);
            }
            NotNullFunction notNullFunction = extractor -> {
                DataRequest schemaSwitchRequest;
                if (table == null) {
                    DatabaseViewHandler.$$$reportNull$$$0(18);
                }
                LocalDataSource dataSource = DbImplUtil.getLocalDataSource((DatabaseSystem)table.getDataSource());
                DataRequest.OwnerEx owner = DataRequest.newOwnerEx(this.myProject);
                JdbcEngine engine = new JdbcEngine(this.myProject, DataBus.shortCircuit(owner.getMessageBus()), dataSource, null);
                Disposer.register((Disposable)owner, (Disposable)engine);
                DataRequest request = this.createDumpRequest(owner, DataRequest.AUTO_COMMIT, (DataExtractor)extractor, table.getName());
                request.getPromise().processed(v -> Disposer.dispose((Disposable)owner));
                DasNamespace namespace = DbImplUtil.getSearchPathObjectForSwitch((DbElement)table);
                SearchPath searchPath = ObjectPaths.searchPathOf((DasObject)namespace);
                DataRequest dataRequest = schemaSwitchRequest = searchPath == null ? null : DataRequest.newSchemaSwitchRequest(owner, searchPath, false);
                if (schemaSwitchRequest != null) {
                    schemaSwitchRequest.getPromise().processed(v -> owner.getMessageBus().getDataProducer().processRequest(request));
                }
                owner.getMessageBus().getDataProducer().processRequest(schemaSwitchRequest == null ? request : schemaSwitchRequest);
                return request;
            };
            if (notNullFunction == null) {
                DatabaseViewHandler.$$$reportNull$$$0(16);
            }
            return notNullFunction;
        }

        @Override
        @NotNull
        DataRequest createDumpRequest(DataRequest.Owner owner, DataRequest.TxMarker txMarker, DataExtractor extractor, String name) {
            MyRequest myRequest = new MyRequest(owner, txMarker, this.myQueryText, DataRequest.newConstraints(0, -1, this.myResultSetIndex), this.mySelectedColumns, extractor, this.myDialect, (CharOut)ObjectUtils.assertNotNull((Object)this.myOutput), name){

                @Override
                public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (rows == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ObjectFormatter.convertRows(rows, ContainerUtil.list((Object[])this.myColumns));
                    super.addRows(context, rows);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "rows";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dump/DumpHandler$DatabaseViewHandler$1";
                    objectArray[2] = "addRows";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (myRequest == null) {
                DatabaseViewHandler.$$$reportNull$$$0(17);
            }
            return myRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/DumpHandler$DatabaseViewHandler";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/DumpHandler$DatabaseViewHandler";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDialect";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryText";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newEngineRunner";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDumpRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 16: 
                case 17: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDialect";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultSetIndex";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getQueryText";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedColumns";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "newEngineRunner";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$newEngineRunner$2";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class MyRequest
    extends DumpRequest {
        protected MyRequest(@NotNull DataRequest.Owner owner, @NotNull DataRequest.TxMarker txMarker, @NotNull String query, @Nullable DataRequest.Constraints constraints, @NotNull ModelIndexSet<DataConsumer.Column> columns2, @NotNull DataExtractor extractor, @NotNull DatabaseDialectEx dialect, @Nullable CharOut output, String name) {
            if (owner == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (txMarker == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (query == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (constraints == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            if (extractor == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            if (dialect == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
            if (output == null) {
                MyRequest.$$$reportNull$$$0(6);
            }
            super(owner, txMarker, query, constraints, columns2, extractor, dialect, output, name);
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
            if (context == null) {
                MyRequest.$$$reportNull$$$0(7);
            }
            if (rows == null) {
                MyRequest.$$$reportNull$$$0(8);
            }
            super.addRows(context, rows);
            DumpHandler.this.myRowsCount = DumpHandler.this.myRowsCount + rows.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "txMarker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dump/DumpHandler$MyRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

