/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.vfs.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDataPreviewComponent
extends DataPreviewComponent<Object> {
    private static final int PAGE_SIZE = 500;
    private final ImportAction.ImportEditorContext myContext;
    private final LocalDataSource myProducerDataSource;
    private final SearchPath myPath;
    private final String myQueryText;

    public DatabaseDataPreviewComponent(@NotNull ImportAction.ImportEditorContext context, @NotNull LocalDataSource producerDataSource, @Nullable SearchPath path, @NotNull String queryText) {
        if (context == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(0);
        }
        if (producerDataSource == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(2);
        }
        super(context.getBuilder());
        this.myContext = context;
        this.myProducerDataSource = producerDataSource;
        this.myPath = path;
        this.myQueryText = queryText;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener listener) {
        if (listener == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(3);
        }
    }

    @Override
    @NotNull
    public CompletionStage<DataGrid> notifyChanged(@Nullable Object object) {
        if (this.getGrid() != null) {
            CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(this.getGrid());
            if (completableFuture == null) {
                DatabaseDataPreviewComponent.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CompletableFuture<DataGrid> future = new CompletableFuture<DataGrid>();
        Project project = this.myContext.getProject();
        GridDataHookUpManager instance = GridDataHookUpManager.getInstance((Project)ObjectUtils.assertNotNull((Object)project));
        SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)ObjectUtils.assertNotNull((Object)project), "Import preview");
        Disposable disposable = this.myContext.getDisposable();
        DatabaseGridDataHookUp hookUp = instance.createReadOnlyDatabaseHookUp(broker, disposable, this.myQueryText);
        JdbcEngine engine = new JdbcEngine((Project)ObjectUtils.assertNotNull((Object)project), broker, this.myProducerDataSource, null);
        Disposer.register((Disposable)disposable, (Disposable)engine);
        if (this.myPath != null) {
            hookUp.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(hookUp, this.myPath, false));
        }
        DataGrid grid = DataGridUtil.createPreviewDataGrid((Project)ObjectUtils.assertNotNull((Object)project), hookUp);
        Disposer.register((Disposable)disposable, (Disposable)grid);
        DataGridRequestSource source = new DataGridRequestSource(grid);
        hookUp.addRequestListener(new MyRequestListener(future, disposable, grid), disposable);
        hookUp.getPageModel().setPageSize(500);
        hookUp.getLoader().loadFirstPage(GridRequestSource.create(grid, (Object)source));
        this.setGrid(grid);
        CompletableFuture<DataGrid> completableFuture = future;
        if (completableFuture == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            DatabaseDataPreviewComponent.$$$reportNull$$$0(6);
        }
        return observer instanceof DatabaseTableEditorComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private final CompletableFuture<DataGrid> myFuture;
        private final Disposable myDisposable;
        private final DataGrid myGrid;

        private MyRequestListener(@NotNull CompletableFuture<DataGrid> future, @NotNull Disposable disposable, @NotNull DataGrid grid) {
            if (future == null) {
                MyRequestListener.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyRequestListener.$$$reportNull$$$0(1);
            }
            if (grid == null) {
                MyRequestListener.$$$reportNull$$$0(2);
            }
            this.myFuture = future;
            this.myDisposable = disposable;
            this.myGrid = grid;
        }

        @Override
        public void error(@NotNull GridRequestSource source, @Nullable String message, @Nullable Throwable th) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(3);
            }
            this.complete();
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(4);
            }
            this.complete();
        }

        private void complete() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)this.myDisposable)) {
                    this.myFuture.complete(this.myGrid);
                }
            }, ModalityState.current());
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
            if (source == null) {
                MyRequestListener.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

