/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ReaderTask;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImporterGenerator {
    private final Thread myReaderThread;
    private final ReaderTask myReaderTask;
    private final LinkedTransferQueue<ReaderTask.Result> myTransferQueue;
    private final ImportInfo myInfo;
    private final ImportErrorHandler myHandler;
    private boolean myStopped;

    ImporterGenerator(@NotNull ImportInfo info, @NotNull ImportErrorHandler handler, @NotNull ReaderTask.Input input) {
        if (info == null) {
            ImporterGenerator.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            ImporterGenerator.$$$reportNull$$$0(1);
        }
        if (input == null) {
            ImporterGenerator.$$$reportNull$$$0(2);
        }
        this.myInfo = info;
        this.myHandler = handler;
        this.myTransferQueue = new LinkedTransferQueue();
        this.myReaderTask = new ReaderTask(input, this.myTransferQueue);
        this.myReaderThread = new Thread((Runnable)this.myReaderTask, "Import data reader");
    }

    @Nullable
    ReaderTask.Importer generate() {
        if (this.myStopped) {
            return null;
        }
        ReaderTask.Result result2 = this.receiveParameters();
        if (result2 == ReaderTask.Result.POISON) {
            this.myStopped = true;
            return null;
        }
        return result2.prepare(this.myInfo);
    }

    void stop() {
        this.myReaderTask.stop();
        this.myReaderThread.interrupt();
        this.myHandler.stop();
    }

    void start() {
        this.myReaderThread.start();
        this.myHandler.start();
    }

    @Nullable
    String getError() {
        return this.myReaderTask.getError();
    }

    @NotNull
    private ReaderTask.Result receiveParameters() {
        ReaderTask.Result result2;
        try {
            result2 = this.myTransferQueue.take();
        }
        catch (InterruptedException e) {
            ReaderTask.Result result3 = ReaderTask.Result.POISON;
            if (result3 == null) {
                ImporterGenerator.$$$reportNull$$$0(4);
            }
            return result3;
        }
        if (result2 == null) {
            ImporterGenerator.$$$reportNull$$$0(3);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImporterGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImporterGenerator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "receiveParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

