/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DatabaseTableInput
implements ReaderTask.Input {
    private static final String CONNECTION_ERROR = "Can't open database connection";
    private static final String COUNT_THREAD = "Select count thread";
    private static final int ROWS = 2000;
    private final DbDataSource myDbDataSource;
    private final LocalDataSource myDataSource;
    private final SearchPath myPath;
    private final String myQueryText;
    private final Project myProject;
    private final DatabaseDialectEx myDialect;
    private final Rdbms myRdbms;
    private long myLinesCount;
    private boolean myDataRead;
    private GuardedRef<DatabaseConnection> myConnection;
    private ResultSet myResultSet;
    private List<DataConsumer.Column> myDescriptors;
    private Statement myStatement;

    public DatabaseTableInput(@NotNull DbDataSource dbDataSource, @NotNull LocalDataSource source, @Nullable SearchPath path, @NotNull String queryText, @NotNull Project project) {
        if (dbDataSource == null) {
            DatabaseTableInput.$$$reportNull$$$0(0);
        }
        if (source == null) {
            DatabaseTableInput.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            DatabaseTableInput.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DatabaseTableInput.$$$reportNull$$$0(3);
        }
        this.myDbDataSource = dbDataSource;
        this.myDataSource = source;
        this.myPath = path;
        this.myQueryText = queryText;
        this.myProject = project;
        this.myDialect = DbImplUtil.getDatabaseDialect(source);
        this.myRdbms = DbImplUtil.getRdbms(this.myDialect);
    }

    @Override
    @NotNull
    public ImportIndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder adder, @NotNull ImportInfo info) {
        if (indicator == null) {
            DatabaseTableInput.$$$reportNull$$$0(4);
        }
        if (adder == null) {
            DatabaseTableInput.$$$reportNull$$$0(5);
        }
        if (info == null) {
            DatabaseTableInput.$$$reportNull$$$0(6);
        }
        ImportIndicatorUpdater importIndicatorUpdater = new ImportIndicatorUpdater(indicator, adder, info){

            @Override
            @Nullable
            public String calculateSpeed(long timeSpent) {
                long speed = Math.round(this.myCurrentSize / (double)timeSpent);
                return speed == 0L ? null : String.format("%s %s/s", speed, ImportUtil.pluralizeRows(speed));
            }
        };
        if (importIndicatorUpdater == null) {
            DatabaseTableInput.$$$reportNull$$$0(7);
        }
        return importIndicatorUpdater;
    }

    @Override
    @Nullable
    public ReaderTask.Result read() throws Exception {
        if (this.myDataRead) {
            return null;
        }
        this.init();
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)this.myResultSet, RemoteResultSet.class);
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(this.myRdbms, Calendar.getInstance(), 2000, Integer.MAX_VALUE, false);
        List objects = (List)RemoteUtil.handleRemoteResult((Object)remoteResultSet.getObjects(options), List.class, (Object)this);
        this.myDataRead = objects.size() < 2000;
        DatabaseTableInput.convertValues(objects, this.myDescriptors);
        BatchRecords records = objects.isEmpty() ? null : new BatchRecords(objects, this.myLinesCount, (double)objects.size());
        this.myLinesCount += records == null ? 0L : (long)records.getLinesCount();
        return records == null ? null : new ReaderTask.ResultImpl(records);
    }

    public static void convertValues(@NotNull List<Object[]> rows, @NotNull List<DataConsumer.Column> columns2) {
        if (rows == null) {
            DatabaseTableInput.$$$reportNull$$$0(8);
        }
        if (columns2 == null) {
            DatabaseTableInput.$$$reportNull$$$0(9);
        }
        for (Object[] row : rows) {
            for (int i2 = 0; i2 < row.length; ++i2) {
                row[i2] = ObjectFormatter.unwrap(ObjectFormatter.objectToObject(row[i2], columns2.get(i2)));
            }
        }
    }

    @Override
    public void calculateSize(@NotNull Consumer<Double> callback) {
        if (callback == null) {
            DatabaseTableInput.$$$reportNull$$$0(10);
        }
        new Thread((Runnable)new MySizeTask(callback), COUNT_THREAD).start();
    }

    private synchronized GuardedRef<DatabaseConnection> getConnection() throws Exception {
        return DatabaseConnectionManager.getInstance().build(this.myProject, this.myDataSource).setDestination(this.myPath == null ? null : this.myPath.getCurrent()).create();
    }

    private void init() throws Exception {
        if (this.myConnection != null) {
            return;
        }
        this.createConnectionIfNeeded();
        this.changeSearchPath();
        this.myStatement = this.myConnection.get().createStatement();
        this.myResultSet = this.myStatement.executeQuery(this.myQueryText);
        this.myDescriptors = ContainerUtil.list((Object[])JdbcEngine.getColumnDescriptors(this.myResultSet, this.myDialect));
    }

    private void changeSearchPath() throws SQLException {
        if (this.myPath == null || !DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
            return;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(this.myDataSource);
        String searchPathSql = DbImplUtil.getSearchPathSql(this.myPath, this.myDataSource, dialect);
        if (searchPathSql == null) {
            return;
        }
        try (Statement statement = this.myConnection.get().createStatement();){
            statement.execute(searchPathSql);
        }
    }

    private void createConnectionIfNeeded() throws Exception {
        if (this.myConnection != null) {
            return;
        }
        this.myConnection = this.getConnection();
        if (this.myConnection == null) {
            throw new IllegalStateException(CONNECTION_ERROR);
        }
    }

    @Override
    public void close() {
        JdbcUtil.closeResultSetSafe((ResultSet)this.myResultSet);
        JdbcUtil.closeStatementSafe((Statement)this.myStatement);
        this.myConnection.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DatabaseTableInput";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DatabaseTableInput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicatorUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndicatorUpdater";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySizeTask
    implements Runnable {
        private final Consumer<Double> myCallback;

        private MySizeTask(Consumer<Double> callback) {
            if (callback == null) {
                MySizeTask.$$$reportNull$$$0(0);
            }
            this.myCallback = callback;
        }

        @Override
        public void run() {
            try (GuardedRef connection = DatabaseTableInput.this.getConnection();){
                if (connection == null) {
                    return;
                }
                String alias = DbImplUtil.findFreeAlias(DatabaseTableInput.this.myProject, DatabaseTableInput.this.myDialect, DatabaseTableInput.this.myQueryText, "t");
                String query = DbImplUtil.createSelectCountQuery(DatabaseTableInput.this.myProject, DatabaseTableInput.this.myDialect, DatabaseTableInput.this.myQueryText, DatabaseTableInput.this.myDbDataSource, alias);
                if (query == null) {
                    return;
                }
                long count2 = DbImplUtil.getCount((DatabaseConnection)connection.get(), query);
                this.myCallback.consume((Object)count2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/dbimport/DatabaseTableInput$MySizeTask", "<init>"));
        }
    }
}

